/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.propertyholder.PVAcceptAll;
import oracle.dbtools.crest.model.propertyholder.PVAcceptNone;
import oracle.dbtools.crest.model.propertyholder.PVClass;
import oracle.dbtools.crest.model.propertyholder.PropertyVerifier;
import oracle.dbtools.crest.model.propertyholder.PropertyWrapper;

public class PropertyHolder {
    private static final String[] PROTO_STRING_ARRAY = new String[0];
    private Map keyMap = new TreeMap();
    private MapEntry nullEntry = new MapEntry();
    private boolean allowStructureChange = this.initialize();
    private List children = null;
    private String name = "unnamed object";

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void addChild(PropertyHolder child) {
        this.getChildList().add(child);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    protected List getChildList() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public int getNumberOfChildren() {
        if (this.hasChildren()) {
            return this.getChildList().size();
        }
        return 0;
    }

    public int getIndexFor(PropertyHolder child) {
        if (this.hasChildren()) {
            return this.getChildList().indexOf(child);
        }
        return -1;
    }

    public PropertyHolder getChild(int index) {
        if (this.hasChildren()) {
            return (PropertyHolder)this.getChildList().get(index);
        }
        return null;
    }

    public Iterator iteratorDirectChildren() {
        if (this.hasChildren()) {
            return this.getChildList().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected boolean initialize() {
        return true;
    }

    public Object getValue(String name) {
        return this.getEntry(name).getValue();
    }

    public boolean setValue(String name, Object value) {
        return this.getEntry(name).setValue(value);
    }

    public String getErrorFor(String name, Object rejectedValue) {
        return this.getEntry(name).getPropertyVerifier().getErrorMessage(rejectedValue);
    }

    private MapEntry getEntry(String name) {
        MapEntry entry = (MapEntry)this.keyMap.get(name);
        if (entry == null) {
            return this.nullEntry;
        }
        return entry;
    }

    public String[] getPropertyNamesArray() {
        return this.keyMap.keySet().toArray(PROTO_STRING_ARRAY);
    }

    public void addProperty(String propertyName, Object initialValue, Class propertyClass) {
        if (this.allowStructureChange) {
            this.keyMap.put(propertyName, new MapEntryReadWrite(new PVClass(propertyClass), initialValue, propertyClass));
        }
    }

    public void addProperty(String propertyName, PropertyVerifier verifier, Object initialValue, Class propertyClass) {
        if (this.allowStructureChange) {
            this.keyMap.put(propertyName, new MapEntryReadWrite(verifier, initialValue, propertyClass));
        }
    }

    public void addProperty(String propertyName, PropertyVerifier verifier, PropertyWrapper wrapper, Class propertyClass) {
        if (this.allowStructureChange) {
            this.keyMap.put(propertyName, new MapEntryWrapped(verifier, wrapper, propertyClass));
        }
    }

    public void addProperty(String propertyName, PropertyWrapper wrapper, Class propertyClass) {
        if (this.allowStructureChange) {
            this.keyMap.put(propertyName, new MapEntryWrapped(wrapper.getPropertyVerifier(), wrapper, propertyClass));
        }
    }

    static class MapEntryWrapped
    extends MapEntryVerified {
        private PropertyWrapper wrapper;

        private MapEntryWrapped(PropertyVerifier verifier, PropertyWrapper wrapper, Class propertyClass) {
            super(verifier, propertyClass);
            this.wrapper = wrapper;
        }

        @Override
        public boolean setValue(Object newValue) {
            if (this.acceptValue(newValue)) {
                return this.wrapper.setValue(newValue);
            }
            return false;
        }

        @Override
        public Object getValue() {
            return this.wrapper.getValue();
        }

        @Override
        public PropertyWrapper getPropertyWrapper() {
            return this.wrapper;
        }
    }

    static class MapEntryReadWrite
    extends MapEntryVerified {
        private Object value;

        private MapEntryReadWrite(PropertyVerifier verifier, Object value, Class propertyClass) {
            super(verifier, propertyClass);
            this.value = value;
        }

        @Override
        public boolean setValue(Object newValue) {
            if (this.acceptValue(newValue)) {
                this.value = newValue;
                return true;
            }
            return false;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    static abstract class MapEntryVerified
    extends MapEntry {
        private PropertyVerifier verifier;
        private Class propertyClass;

        private MapEntryVerified(PropertyVerifier verifier, Class propertyClass) {
            this.verifier = verifier;
            this.propertyClass = propertyClass;
        }

        @Override
        public boolean acceptValue(Object value) {
            return this.verifier.accept(value);
        }

        @Override
        public Class getPropertyClass() {
            return this.propertyClass;
        }

        @Override
        public PropertyVerifier getPropertyVerifier() {
            if (this.verifier == null) {
                return PVAcceptAll.getInstance();
            }
            return this.verifier;
        }
    }

    static class MapEntry
    implements PropertyWrapper {
        private static PropertyVerifier nullverifier = PVAcceptNone.createInstance("Non existant property");

        MapEntry() {
        }

        @Override
        public boolean setValue(Object newValue) {
            return false;
        }

        @Override
        public Object getValue() {
            return null;
        }

        public boolean acceptValue(Object value) {
            return false;
        }

        public Class getPropertyClass() {
            return Object.class;
        }

        @Override
        public boolean hasChoices() {
            return false;
        }

        @Override
        public Object[] getChoices() {
            return null;
        }

        public PropertyWrapper getPropertyWrapper() {
            return this;
        }

        @Override
        public PropertyVerifier getPropertyVerifier() {
            return nullverifier;
        }
    }
}

