/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.util.string.StringUtilities;

public class JSONToSchedulerObject {
    public static final String EMPTY_STR = "";

    public static void main(String[] args) {
        String json1 = "{\r\n\"owner\":\"SCHED_DEMO_USER\",\r\n\"job_name\":\"RAND_EXEC_HOUR0_20_40\",\r\n\"job_style\":\"REGULAR\",\r\n\"program_owner\":\"SCHED_DEMO_USER\",\r\n\"program_name\":\"RANDOM_EXEC_TIME\",\r\n\"schedule_type\":\"CALENDAR\",\r\n\"start_date\":\"2021-09-09T09:32:05Z\",\r\n\"repeat_interval\":\"freq=hourly;byminute=0,20,40\",\r\n\"job_class\":\"DEFAULT_JOB_CLASS\",\r\n\"enabled\":\"TRUE\",\r\n\"auto_drop\":\"FALSE\",\r\n\"job_priority\":\"3\",\r\n\"store_output\":\"TRUE\",\r\n\"stop_on_window_close\":\"FALSE\",\r\n\"instance_stickiness\":\"TRUE\",\r\n\"nls_env\":\"NLS_LANGUAGE=&apos;AMERICAN&apos; NLS_TERRITORY=&apos;AMERICA&apos; NLS_CURRENCY=&apos;$&apos; NLS_ISO_CURRENCY=&apos;AMERICA&apos; NLS_NUMERIC_CHARACTERS=&apos;.,&apos; NLS_CALENDAR=&apos;GREGORIAN&apos; NLS_DATE_FORMAT=&apos;DD-MON-RR&apos; NLS_DATE_LANGUAGE=&apos;AMERICAN&apos; NLS_SORT=&apos;BINARY&apos; NLS_TIME_FORMAT=&apos;HH.MI.SSXFF AM&apos; NLS_TIMESTAMP_FORMAT=&apos;DD-MON-RR HH.MI.SSXFF AM&apos; NLS_TIME_TZ_FORMAT=&apos;HH.MI.SSXFF AM TZR&apos; NLS_TIMESTAMP_TZ_FORMAT=&apos;DD-MON-RR HH.MI.SSXFF AM TZR&apos; NLS_DUAL_CURRENCY=&apos;$&apos; NLS_COMP=&apos;BINARY&apos; NLS_LENGTH_SEMANTICS=&apos;BYTE&apos; NLS_NCHAR_CONV_EXCP=&apos;FALSE&apos;\",\r\n\"allow_runs_in_restricted_mode\":\"FALSE\",\r\n\"comments\":\"starting hourly on minute 0,20,40\",\r\n\"restartable\":\"FALSE\",\r\n\"has_constraints\":\"FALSE\",\r\n\"fail_on_script_error\":\"FALSE\",\r\n\"parallel_instances\":\"FALSE\"\r\n}";
        String nls = "NLS_LANGUAGE='AMERICAN' NLS_TERRITORY='AMERICA' NLS_CURRENCY='$' NLS_ISO_CURRENCY='AMERICA' NLS_NUMERIC_CHARACTERS='.,' NLS_CALENDAR='GREGORIAN' NLS_DATE_FORMAT='DD-MON-RR' NLS_DATE_LANGUAGE='AMERICAN' NLS_SORT='BINARY' NLS_TIME_FORMAT='HH.MI.SSXFF AM' NLS_TIMESTAMP_FORMAT='DD-MON-RR HH.MI.SSXFF AM' NLS_TIME_TZ_FORMAT='HH.MI.SSXFF AM TZR' NLS_TIMESTAMP_TZ_FORMAT='DD-MON-RR HH.MI.SSXFF AM TZR' NLS_DUAL_CURRENCY='$' NLS_COMP='BINARY' NLS_LENGTH_SEMANTICS='BYTE' NLS_NCHAR_CONV_EXCP='FALSE'";
        String enc = StringUtilities.encodeAttributeValueJSON(nls);
        System.out.println(enc);
        System.out.println(StringUtilities.decodeAttributeValueJSON(enc));
    }

    public void transformToObject(SchedulerObject object, InputStream stream) {
        JsonObject jdoc = null;
        try {
            jdoc = Json.createReader((InputStream)stream).readObject();
            this.processProperties(object, jdoc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void transformToObject(SchedulerObject object, String json) {
        JsonObject jdoc = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
            jdoc = Json.createReader((InputStream)stream).readObject();
            this.processProperties(object, jdoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processProperties(SchedulerObject obj, JsonObject pmElement) {
        try {
            if (pmElement != null) {
                for (Map.Entry entry : pmElement.entrySet()) {
                    String name = (String)entry.getKey();
                    JsonValue val = (JsonValue)entry.getValue();
                    JsonValue.ValueType type = val.getValueType();
                    if (JsonValue.NULL.equals(val)) {
                        obj.setProperty(StringUtilities.decodeAttributeValueJSON(name), null);
                        continue;
                    }
                    if (type.equals((Object)JsonValue.ValueType.ARRAY) && val instanceof JsonArray) {
                        this.processArray(obj, name, (JsonArray)val);
                        continue;
                    }
                    String evalue = JSONToSchedulerObject.getString(val);
                    if (name == null || evalue == null || EMPTY_STR.equals(name)) continue;
                    obj.setProperty(StringUtilities.decodeAttributeValueJSON(name), StringUtilities.decodeAttributeValueJSON(evalue));
                }
                obj.validate();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void processArray(SchedulerObject obj, String name, JsonArray jarr) {
        jarr.forEach(arrval -> {
            if (arrval instanceof JsonObject) {
                SchedulerObject so = obj.createObjectForCollection(name);
                if (so != null) {
                    this.processProperties(so, (JsonObject)arrval);
                    obj.addObject(name, so);
                }
            } else {
                obj.addJSONValue(name, (JsonValue)arrval);
            }
        });
    }

    public static String getString(JsonObject object, String key) {
        JsonString js = object.getJsonString(key);
        if (js != null) {
            return JSONToSchedulerObject.getString((JsonValue)js);
        }
        return null;
    }

    public static String getDecodedString(JsonObject object, String key) {
        JsonValue js = (JsonValue)object.get((Object)key);
        if (js != null && js instanceof JsonString) {
            String value = JSONToSchedulerObject.getString(js);
            if (value != null && !value.isEmpty()) {
                value = StringUtilities.decodeAttributeValueJSON(value);
            }
            return value;
        }
        if (!(js instanceof JsonObject)) {
            return JSONToSchedulerObject.getString(js);
        }
        return null;
    }

    public static String getString(JsonValue value) {
        String res = EMPTY_STR;
        res = value.toString();
        if (res.equals("\"\"")) {
            res = EMPTY_STR;
        } else if (res.startsWith("\"") && res.endsWith("\"")) {
            res = res.substring(1, res.length() - 1);
        }
        return res;
    }

    public static List<Map<String, String>> getArrayAsListOfMaps(JsonArray array) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (array.size() > 0) {
            for (JsonValue value : array) {
                if (!(value instanceof JsonObject)) continue;
                TreeMap<String, String> map = new TreeMap<String, String>();
                for (Map.Entry entry : ((JsonObject)value).entrySet()) {
                    String name = (String)entry.getKey();
                    String evalue = JSONToSchedulerObject.getString((JsonValue)entry.getValue());
                    map.put(StringUtilities.decodeAttributeValueJSON(name), StringUtilities.decodeAttributeValueJSON(evalue));
                }
                list.add(map);
            }
        }
        return list;
    }

    public static void processArrayToListOfMaps(JsonArray array, List<Map<String, String>> list) {
        if (array.size() > 0) {
            for (JsonValue value : array) {
                if (!(value instanceof JsonObject)) continue;
                TreeMap<String, String> map = new TreeMap<String, String>();
                for (Map.Entry entry : ((JsonObject)value).entrySet()) {
                    String name = (String)entry.getKey();
                    String evalue = JSONToSchedulerObject.getString((JsonValue)entry.getValue());
                    map.put(StringUtilities.decodeAttributeValueJSON(name), StringUtilities.decodeAttributeValueJSON(evalue));
                }
                list.add(map);
            }
        }
    }
}

