/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oracle.dbtools.crest.model.scheduling.Positioned;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerJobClass
extends SchedulerObject {
    List<SchedulerArgument> arguments = new ArrayList<SchedulerArgument>();
    public static Comparator<Positioned> POSITION_COMPARATOR = Comparator.comparing(Positioned::getPosition);
    public static String ARGUMENTS = "arguments";

    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("JOB_CLASS_NAME");
        this.propsList.add("RESOURCE_CONSUMER_GROUP");
        this.propsList.add("SERVICE");
        this.propsList.add("LOGGING_LEVEL");
        this.propsList.add("LOG_HISTORY");
        this.propsList.add("COMMENTS");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("JOB_CLASS_NAME", "VARCHAR2");
        this.dataTypes.put("RESOURCE_CONSUMER_GROUP", "VARCHAR2");
        this.dataTypes.put("SERVICE", "VARCHAR2");
        this.dataTypes.put("LOGGING_LEVEL", "NUMBER");
        this.dataTypes.put("LOG_HISTORY", "NUMBER");
        this.dataTypes.put("COMMENTS", "VARCHAR2");
    }

    @Override
    public String getName() {
        return this.getProperty("JOB_CLASS_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String name = this.getName();
        return name != null && !name.isEmpty();
    }

    public List<SchedulerArgument> getArguments() {
        return this.arguments;
    }

    public void convertLoggingLevel() {
        String nval;
        String val = this.getProperty("LOGGING_LEVEL");
        if (val != null && !val.isEmpty() && !val.toUpperCase().startsWith(SchedulerJob.DBMS_SCHEDULER_LOGGING_PREFIX) && (nval = SchedulerJob.LOGIING_MAP.get(val)) != null) {
            this.setProperty("LOGGING_LEVEL", nval);
        }
    }

    @Override
    public void validate() {
        this.convertLoggingLevel();
    }
}

