/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.JsonValue;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.scheduling.ReservedWordsOracle;
import oracle.dbtools.crest.model.scheduling.SchedulerConstants;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class SchedulerObject
implements PropertyMap,
SchedulerConstants {
    private Map<String, Object> properties = new TreeMap<String, Object>();
    protected List<String> propsList = new ArrayList<String>();
    protected Map<String, String> dataTypes = new HashMap<String, String>();
    protected Map<String, String> defaults = new HashMap<String, String>();
    protected Map<String, String> excludeFromCompare = new HashMap<String, String>();
    protected Map<String, String> names = new HashMap<String, String>();
    protected Map<String, String> caseInsensitive = new HashMap<String, String>();

    public SchedulerObject() {
        this.initPropsList();
        this.initDataTypes();
        this.initdefaults();
        this.initNames();
        this.initCaseInsensitive();
    }

    @Override
    public void setProperty(String key, String value) {
        if (key != null) {
            if (value == null) {
                this.properties.remove(key);
            } else {
                this.properties.put(key, value);
            }
        }
    }

    @Override
    public String getProperty(String key) {
        if (key != null) {
            String value = (String)this.properties.get(key);
            if (value == null) {
                value = (String)this.properties.get(key.toLowerCase());
            }
            if (value == null) {
                value = (String)this.properties.get(key.toUpperCase());
            }
            return value;
        }
        return null;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean hasProperty(String key, String value) {
        return this.properties.containsKey(key) && (this.getProperty(key) == null && value == null || value != null && value.equals(this.getProperty(key)));
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public Collection getPropertyNamesCollection() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public static void main(String[] args) {
    }

    public List<String> getPropsList() {
        return this.propsList;
    }

    public void initPropsList() {
    }

    public void initDataTypes() {
    }

    public void initdefaults() {
    }

    public void initNames() {
        this.names.put("OWNER", "OWNER");
        this.names.put("JOB_NAME", "JOB_NAME");
        this.names.put("PROGRAM_OWNER", "PROGRAM_OWNER");
        this.names.put("PROGRAM_NAME", "PROGRAM_NAME");
        this.names.put("JOB_ACTION", "JOB_ACTION");
        this.names.put("SCHEDULE_OWNER", "SCHEDULE_OWNER");
        this.names.put("SCHEDULE_NAME", "SCHEDULE_NAME");
        this.names.put("EVENT_QUEUE_OWNER", "EVENT_QUEUE_OWNER");
        this.names.put("EVENT_QUEUE_NAME", "EVENT_QUEUE_NAME");
        this.names.put("EVENT_QUEUE_AGENT", "EVENT_QUEUE_AGENT");
        this.names.put("FILE_WATCHER_OWNER", "FILE_WATCHER_OWNER");
        this.names.put("FILE_WATCHER_NAME", "FILE_WATCHER_NAME");
        this.names.put("JOB_CLASS", "JOB_CLASS");
        this.names.put("DESTINATION_OWNER", "DESTINATION_OWNER");
        this.names.put("DESTINATION", "DESTINATION");
        this.names.put("CREDENTIAL_OWNER", "CREDENTIAL_OWNER");
        this.names.put("CREDENTIAL_NAME", "CREDENTIAL_NAME");
        this.names.put("CONNECT_CREDENTIAL_OWNER", "CONNECT_CREDENTIAL_OWNER");
        this.names.put("CONNECT_CREDENTIAL_NAME", "CONNECT_CREDENTIAL_NAME");
    }

    public void initCaseInsensitive() {
        this.caseInsensitive.put("START_DATE", "START_DATE");
        this.caseInsensitive.put("END_DATE", "END_DATE");
        this.caseInsensitive.put("JOB_ACTION", "JOB_ACTION");
        this.caseInsensitive.put("PROGRAM_ACTION", "PROGRAM_ACTION");
        this.caseInsensitive.put("REPEAT_INTERVAL", "REPEAT_INTERVAL");
    }

    public String toString() {
        return this.toJSONString();
    }

    public String toJSONString() {
        return this.toJSONString(true);
    }

    public String toJSONString(boolean excludeNulls) {
        Object res = "{";
        boolean first = true;
        for (String prop : this.propsList) {
            String value = this.getProperty(prop);
            if (value == null) {
                if (excludeNulls) continue;
                if (!first) {
                    res = (String)res + ",";
                } else {
                    first = false;
                }
                res = (String)res + "\n\"" + prop.toLowerCase() + "\":";
                res = (String)res + "null";
                continue;
            }
            if (!first) {
                res = (String)res + ",";
            } else {
                first = false;
            }
            res = (String)res + "\n\"" + prop.toLowerCase() + "\":";
            res = (String)res + "\"" + StringUtilities.encodeAttributeValueJSON(value) + "\"";
        }
        for (CollectionDescriptor cd : this.getCollectionDescriptors()) {
            List list = cd.coll.getCollection();
            String name = cd.name;
            if (name == null || name.isEmpty() || list == null || list.size() <= 0) continue;
            if (!first) {
                res = (String)res + ",";
            } else {
                first = false;
            }
            res = (String)res + "\n\"" + name + "\":[\n";
            boolean ofirst = true;
            for (Object obj : list) {
                if (!ofirst) {
                    res = (String)res + ",";
                } else {
                    ofirst = false;
                }
                if (obj instanceof SchedulerObject) {
                    res = (String)res + ((SchedulerObject)obj).toJSONString(excludeNulls);
                    continue;
                }
                res = (String)res + "\"" + obj.toString() + "\"";
            }
            res = (String)res + "\n]";
        }
        res = (String)res + "\n}";
        return res;
    }

    public static boolean isValidName(String name) {
        return !SchedulerObject.startsWithNumber(name) && !StorageDesign.hasForbiddenCharsOracle(name) && name.indexOf(95) != 0 && name.indexOf(36) != 0 && name.indexOf(35) != 0 && name.indexOf(64) <= -1 && !ReservedWordsOracle.isReservedWord(name);
    }

    public static boolean startsWithNumber(String name) {
        String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        for (int i = 0; i < NUMBERS.length; ++i) {
            if (!name.startsWith(NUMBERS[i])) continue;
            return true;
        }
        return false;
    }

    public static String getFormatedSimpleName(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            return name;
        }
        if (!SchedulerObject.isValidName(name)) {
            return "\"" + name + "\"";
        }
        return name;
    }

    public String getOwner() {
        return this.getProperty("OWNER");
    }

    public abstract String getName();

    public String getDefaultValue(String propName) {
        return this.defaults.get(propName);
    }

    public String getNameFormatted() {
        String name = this.getName();
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getOwner();
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerObject.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerObject.getFormatedSimpleName(name);
            return res;
        }
        return null;
    }

    public String getPropertyDataType(String propName) {
        String type = this.dataTypes.get(propName);
        if (type == null && (type = this.dataTypes.get(propName.toUpperCase())) == null) {
            type = "";
        }
        return type;
    }

    public abstract boolean isMinimumDefined();

    public void copyProperties(SchedulerObject target) {
        for (String prop : this.getPropsList()) {
            target.setProperty(prop, this.getProperty(prop));
        }
    }

    public List<CollectionDescriptor> getCollectionDescriptors() {
        return Collections.EMPTY_LIST;
    }

    public boolean isNullOrEmpty(String propName) {
        String val = this.getProperty(propName);
        if (val == null) {
            return true;
        }
        return val.isEmpty();
    }

    public SchedulerObject createObjectForCollection(String collName) {
        return null;
    }

    public void addObject(String collName, SchedulerObject obj) {
    }

    public void addJSONValue(String collName, JsonValue value) {
    }

    public void validate() {
    }

    public String getFormattedName(String propOwner, String propName) {
        String name = this.getProperty(propName);
        if (name != null && !name.isEmpty()) {
            name = SchedulerObject.getFormatedSimpleName(name);
            Object res = "";
            String owner = this.getProperty(propOwner);
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerObject.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + name;
            return res;
        }
        return null;
    }

    public boolean isPropertyExcludeFromCompare(String name) {
        return this.excludeFromCompare.get(name) != null;
    }

    public boolean isNameProperty(String propertyName) {
        if (propertyName != null) {
            return this.names.get(propertyName.toUpperCase()) != null;
        }
        return false;
    }

    public boolean isCaseInsensitive(String propName) {
        String val = this.caseInsensitive.get(propName);
        if (val != null) {
            return true;
        }
        val = this.caseInsensitive.get(propName.toUpperCase());
        return this.caseInsensitive.get(propName.toLowerCase()) != null;
    }

    public String getCredentialNameFormatted() {
        String name = this.getProperty("CREDENTIAL_NAME");
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getProperty("CREDENTIAL_OWNER");
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerObject.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerObject.getFormatedSimpleName(name);
            return res;
        }
        return null;
    }

    public String getDestinationNameFormatted() {
        String name = this.getProperty("DESTINATION");
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getProperty("DESTINATION_OWNER");
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerObject.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerObject.getFormatedSimpleName(name);
            return res;
        }
        return null;
    }

    public static class CollectionDescriptor {
        public String name;
        public CollectionMethod coll;
    }

    public static interface CollectionMethod {
        public List getCollection();
    }
}

