/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerSchedule
extends SchedulerObject {
    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("SCHEDULE_NAME");
        this.propsList.add("SCHEDULE_TYPE");
        this.propsList.add("START_DATE");
        this.propsList.add("REPEAT_INTERVAL");
        this.propsList.add("EVENT_QUEUE_OWNER");
        this.propsList.add("EVENT_QUEUE_NAME");
        this.propsList.add("EVENT_QUEUE_AGENT");
        this.propsList.add("EVENT_CONDITION");
        this.propsList.add("FILE_WATCHER_OWNER");
        this.propsList.add("FILE_WATCHER_NAME");
        this.propsList.add("END_DATE");
        this.propsList.add("COMMENTS");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("SCHEDULE_NAME", "VARCHAR2");
        this.dataTypes.put("SCHEDULE_TYPE", "VARCHAR2");
        this.dataTypes.put("START_DATE", "TIMESTAMP(6) WITH TIME ZONE");
        this.dataTypes.put("REPEAT_INTERVAL", "VARCHAR2");
        this.dataTypes.put("EVENT_QUEUE_OWNER", "VARCHAR2");
        this.dataTypes.put("EVENT_QUEUE_NAME", "VARCHAR2");
        this.dataTypes.put("EVENT_QUEUE_AGENT", "VARCHAR2");
        this.dataTypes.put("EVENT_CONDITION", "VARCHAR2");
        this.dataTypes.put("FILE_WATCHER_OWNER", "VARCHAR2");
        this.dataTypes.put("FILE_WATCHER_NAME", "VARCHAR2");
        this.dataTypes.put("END_DATE", "TIMESTAMP(6) WITH TIME ZONE");
        this.dataTypes.put("COMMENTS", "VARCHAR2");
    }

    @Override
    public String getName() {
        return this.getProperty("SCHEDULE_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        String value = this.getProperty("REPEAT_INTERVAL");
        if (value != null && !value.isEmpty()) {
            return true;
        }
        value = this.getProperty("EVENT_CONDITION");
        if (value != null && !value.isEmpty() && (value = this.getProperty("EVENT_QUEUE_NAME")) != null && !value.isEmpty()) {
            return true;
        }
        value = this.getProperty("FILE_WATCHER_NAME");
        return value != null && !value.isEmpty();
    }

    public String getFormatedEventQueueName() {
        return this.getFormattedName("EVENT_QUEUE_OWNER", "EVENT_QUEUE_NAME");
    }

    public String getFormatedFileWatcherName() {
        return this.getFormattedName("FILE_WATCHER_OWNER", "FILE_WATCHER_NAME");
    }

    public boolean isEventSchedule() {
        return this.getFormatedFileWatcherName() != null || this.getFormatedEventQueueName() != null;
    }

    public String getEventQueueSpecNameFormatted() {
        String name = this.getProperty("EVENT_QUEUE_NAME");
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getProperty("EVENT_QUEUE_OWNER");
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerSchedule.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerSchedule.getFormatedSimpleName(name);
            String agent = this.getProperty("EVENT_QUEUE_AGENT");
            if (agent != null && !agent.isEmpty()) {
                res = (String)res + "," + SchedulerSchedule.getFormatedSimpleName(agent);
            }
            return res;
        }
        return null;
    }

    @Override
    public void validate() {
        String name;
        String type = this.getProperty("SCHEDULE_TYPE");
        if (type != null && "FILE_WATCHER".equalsIgnoreCase(type) && (name = this.getEventQueueSpecNameFormatted()) != null && !name.isEmpty()) {
            this.removeProperty("EVENT_QUEUE_OWNER");
            this.removeProperty("EVENT_QUEUE_NAME");
            this.removeProperty("EVENT_QUEUE_AGENT");
        }
    }
}

