/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.json.JsonString;
import javax.json.JsonValue;
import oracle.dbtools.crest.model.scheduling.JSONToSchedulerObject;
import oracle.dbtools.crest.model.scheduling.Positioned;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerWindowGroup
extends SchedulerObject {
    List<String> windows = new ArrayList<String>();
    public static Comparator<Positioned> POSITION_COMPARATOR = Comparator.comparing(Positioned::getPosition);
    public static String WINDOWS = "windows";

    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("WINDOW_GROUP_NAME");
        this.propsList.add("ENABLED");
        this.propsList.add("NUMBER_OF_WINDOWS");
        this.propsList.add("COMMENTS");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("WINDOW_GROUP_NAME", "VARCHAR2");
        this.dataTypes.put("ENABLED", "VARCHAR2");
        this.dataTypes.put("NUMBER_OF_WINDOWS", "NUMBER");
        this.dataTypes.put("COMMENTS", "VARCHAR2");
    }

    @Override
    public String getName() {
        return this.getProperty("WINDOW_GROUP_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String name = this.getName();
        return name != null && !name.isEmpty();
    }

    public List<String> getWindows() {
        return this.windows;
    }

    public List<String> getSortedWindows() {
        try {
            Collections.sort(this.windows, String.CASE_INSENSITIVE_ORDER);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.windows;
    }

    public int getNumberOfWindows() {
        String num = this.getProperty("NUMBER_OF_WINDOWS");
        if (num != null && !num.isEmpty()) {
            try {
                return Integer.parseInt(num);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public List<SchedulerObject.CollectionDescriptor> getCollectionDescriptors() {
        if (this.windows.size() > 0) {
            ArrayList<SchedulerObject.CollectionDescriptor> list = new ArrayList<SchedulerObject.CollectionDescriptor>();
            SchedulerObject.CollectionDescriptor cd = new SchedulerObject.CollectionDescriptor();
            cd.name = WINDOWS;
            cd.coll = this::getSortedWindows;
            list.add(cd);
            return list;
        }
        return super.getCollectionDescriptors();
    }

    @Override
    public void addJSONValue(String collName, JsonValue value) {
        if (value instanceof JsonString) {
            this.windows.add(JSONToSchedulerObject.getString(value));
        } else {
            super.addJSONValue(collName, value);
        }
    }

    public void addWindow(String name) {
        if (name != null && !name.isEmpty() && !this.windows.contains(name)) {
            this.windows.add(name);
        }
    }
}

