/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.replay;

import java.lang.reflect.Constructor;
import oracle.express.olapi.replay.DefinitionHandler;
import oracle.express.olapi.replay.ElementFactory;
import oracle.express.olapi.replay.InvalidSourceNodeException;
import oracle.express.olapi.replay.NestedNodeContextException;
import oracle.express.olapi.replay.NodeContext;
import oracle.express.olapi.replay.Providers;
import oracle.express.olapi.replay.SourceCache;
import oracle.express.olapi.replay.SourceHandler;
import oracle.express.olapi.replay.SourceNodeNotFoundException;
import oracle.express.olapi.replay.XMLNodeHandler;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.Source;

class BaseElementFactory
extends ElementFactory {
    private SourceCache cache = new SourceCache();

    BaseElementFactory(Providers providers) {
        super(providers);
    }

    @Override
    protected XMLNodeHandler initHandlers() {
        SourceHandler sourceHandler = null;
        sourceHandler = new RefHandler(sourceHandler);
        sourceHandler = new DefinitionHandler(sourceHandler, this.getProviders(), this.cache);
        sourceHandler = new EmptySourceHandler(sourceHandler);
        sourceHandler = new VoidSourceHandler(sourceHandler);
        sourceHandler = new FundamentalHandler(sourceHandler);
        sourceHandler = new DataHandler(sourceHandler);
        return sourceHandler;
    }

    class DataHandler
    extends SourceHandler {
        public DataHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        @Override
        protected String getType() {
            return "Data";
        }

        @Override
        protected Object doHandle(NodeContext nodeContext) throws InvalidSourceNodeException {
            try {
                String string = nodeContext.getAttributeByName("class");
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                String string2 = nodeContext.getText();
                Object obj = constructor.newInstance(string2);
                return obj;
            }
            catch (Exception exception) {
                throw new InvalidSourceNodeException(this.getClass(), nodeContext, exception);
            }
        }
    }

    private class FundamentalHandler
    extends SourceHandler {
        private FundamentalMetadataProvider fmdp;

        public FundamentalHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
            this.fmdp = null;
            this.fmdp = BaseElementFactory.this.getProviders().getFundamentalMetadataProvider();
        }

        @Override
        protected String getType() {
            return "Fundamental";
        }

        @Override
        protected Object doHandle(NodeContext nodeContext) throws SourceNodeNotFoundException {
            Source source = null;
            String string = nodeContext.find("FundamentalType").getText() + "!" + nodeContext.find("FundamentalName").getText();
            source = this.fmdp.getMetadataObject(string).getSource();
            return source;
        }
    }

    private class VoidSourceHandler
    extends SourceHandler {
        private Source voidSource;

        public VoidSourceHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
            this.voidSource = null;
            this.voidSource = BaseElementFactory.this.getProviders().getFundamentalMetadataProvider().getVoidDataType().getSource();
        }

        @Override
        protected String getType() {
            return "Voidsource";
        }

        @Override
        protected Object doHandle(NodeContext nodeContext) {
            return this.voidSource;
        }
    }

    private class EmptySourceHandler
    extends SourceHandler {
        private Source emptySource;

        public EmptySourceHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
            this.emptySource = null;
            this.emptySource = BaseElementFactory.this.getProviders().getFundamentalMetadataProvider().getEmptyDataType().getSource();
        }

        @Override
        protected String getType() {
            return "Emptysource";
        }

        @Override
        protected Object doHandle(NodeContext nodeContext) {
            return this.emptySource;
        }
    }

    class RefHandler
    extends SourceHandler {
        public RefHandler(XMLNodeHandler xMLNodeHandler) {
            super(xMLNodeHandler);
        }

        @Override
        protected String getType() {
            return "Ref";
        }

        @Override
        public Object doHandle(NodeContext nodeContext) throws NestedNodeContextException {
            Object object = null;
            object = BaseElementFactory.this.cache.get(nodeContext.getID());
            if (object == null) {
                object = nodeContext.findDefinition().create();
            }
            return object;
        }
    }
}

