/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mdm;

import java.util.List;
import oracle.express.mdm.MetadataNotFoundException;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.DuplicateMetadataIDException;
import oracle.olapi.metadata.MetadataObject;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mapping.MemberListMap;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmBaseAttribute;
import oracle.olapi.metadata.mdm.MdmDescriptionType;
import oracle.olapi.metadata.mdm.MdmHierarchyLevel;
import oracle.olapi.metadata.mdm.MdmMemberListMapOwner;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mdm.MdmQueryColumn;
import oracle.olapi.metadata.mdm.MdmSource;
import oracle.olapi.metadata.mdm.MdmSubDimension;
import oracle.olapi.metadata.mdm.MdmXMLTags;
import oracle.olapi.syntax.OrderByClause;
import oracle.olapi.syntax.parser.Identifier;

public abstract class MdmDimension
extends MdmSource {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{MdmXMLTags.DIMENSION_CARDINALITY, MdmXMLTags.PLURAL_DESCRIPTION, MdmXMLTags.SHORT_PLURAL_DESCRIPTION, MdmXMLTags.SHORT_VALUE_DESC, MdmXMLTags.VALUE_DESC, MdmXMLTags.CUSTOM_ORDER};

    public MdmDimension(String string, String string2, short s, BaseMetadataProvider baseMetadataProvider, BaseMetadataObject baseMetadataObject) {
        super(string, string2, s, baseMetadataProvider, baseMetadataObject);
    }

    MdmDimension(MdmMetadataProvider mdmMetadataProvider) {
        super(mdmMetadataProvider);
    }

    final void populateAttributeColumnList(List<MdmQueryColumn> list) {
        List list2 = this.getAttributes();
        if (null == list2) {
            return;
        }
        for (MdmAttribute mdmAttribute : list2) {
            if (!(mdmAttribute instanceof MdmBaseAttribute)) continue;
            list.add(((MdmBaseAttribute)mdmAttribute).getETAttributeColumn());
        }
    }

    public abstract MdmDimension getEnclosingDimension();

    abstract void addAttribute(MdmAttribute var1);

    final MdmQueryColumn getAttributeColumn(String string) {
        List list = this.getAttributes();
        if (null == list) {
            return null;
        }
        for (MdmAttribute mdmAttribute : list) {
            MdmBaseAttribute mdmBaseAttribute;
            if (!(mdmAttribute instanceof MdmBaseAttribute) || !(mdmBaseAttribute = (MdmBaseAttribute)mdmAttribute).getETAttributeColumn().getName().equals(string)) continue;
            return mdmBaseAttribute.getETAttributeColumn();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemberListMap findOrCreateMemberListMap(String string) {
        MemberListMap memberListMap = null;
        MetadataObject metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
        if (null == metadataObject) {
            MdmMetadataProvider mdmMetadataProvider = this.getMetadataProvider();
            synchronized (mdmMetadataProvider) {
                metadataObject = this.getMetadataProvider().fetchMetadataObject(string);
                if (null == metadataObject) {
                    memberListMap = new MemberListMap(string, 0, (MdmMemberListMapOwner)((Object)this));
                    ((MdmMemberListMapOwner)((Object)this)).setMemberListMap(memberListMap);
                    return memberListMap;
                }
            }
        }
        if (metadataObject instanceof MemberListMap) {
            memberListMap = (MemberListMap)metadataObject;
            ((MdmMemberListMapOwner)((Object)this)).setMemberListMap(memberListMap);
        } else if (null != metadataObject) {
            throw new DuplicateMetadataIDException(metadataObject.getID());
        }
        return memberListMap;
    }

    public abstract List getAttributes();

    public final MdmPrimaryDimension getPrimaryDimension() {
        return this.getPrimaryDimension((short)0);
    }

    public abstract MdmPrimaryDimension getPrimaryDimension(short var1);

    public String getPluralDescription() throws MetadataNotFoundException {
        if (this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) && this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            MdmDescriptionType mdmDescriptionType = MdmDescriptionType.getPluralNameDescriptionType();
            return this.getDescription(mdmDescriptionType);
        }
        return this.getPropertyStringValue(MdmXMLTags.PLURAL_DESCRIPTION);
    }

    public String getShortPluralDescription() throws MetadataNotFoundException {
        if (this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) && this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            MdmDescriptionType mdmDescriptionType = MdmDescriptionType.getShortPluralNameDescriptionType();
            return this.getDescription(mdmDescriptionType);
        }
        return this.getPropertyStringValue(MdmXMLTags.SHORT_PLURAL_DESCRIPTION);
    }

    public int getCardinality() throws MetadataNotFoundException {
        return this.getPropertyIntegerValue(MdmXMLTags.DIMENSION_CARDINALITY, -1);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    public void setPluralDescription(String string) {
        if (this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) && this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            MdmDescriptionType mdmDescriptionType = MdmDescriptionType.getPluralNameDescriptionType();
            this.setDescription(mdmDescriptionType, string);
        } else {
            this.setPropertyStringValue(MdmXMLTags.PLURAL_DESCRIPTION, string);
        }
    }

    public void setShortPluralDescription(String string) {
        if (this.isServerVersionLaterThan(new int[]{11, 0, 0, 0}) && this.getMetadataProvider().getDataProvider().read11gMetadata()) {
            MdmDescriptionType mdmDescriptionType = MdmDescriptionType.getShortPluralNameDescriptionType();
            this.setDescription(mdmDescriptionType, string);
        } else {
            this.setPropertyStringValue(MdmXMLTags.SHORT_PLURAL_DESCRIPTION, string);
        }
    }

    public void setCardinality(int n) {
        this.setPropertyIntegerValue(MdmXMLTags.DIMENSION_CARDINALITY, n);
    }

    public abstract void removeAttribute(MdmAttribute var1);

    public final OrderByClause getCustomOrder() {
        return (OrderByClause)this.getPropertyObjectValue(MdmXMLTags.CUSTOM_ORDER);
    }

    public final void setCustomOrder(OrderByClause orderByClause) {
        this.setPropertyObjectValue(MdmXMLTags.CUSTOM_ORDER, orderByClause);
    }

    public static XMLTag classGetContainedByPropertyTag() {
        return MdmXMLTags.CONTAINER_PRIMARY_DIM;
    }

    public static Class getSubClassForID(Identifier identifier) {
        boolean bl = false;
        int n = identifier.getNumComponents(bl);
        Class clazz = null;
        if (2 == n) {
            clazz = MdmPrimaryDimension.class;
        } else if (3 == n) {
            clazz = MdmSubDimension.class;
        } else if (4 == n) {
            clazz = MdmHierarchyLevel.class;
        }
        return clazz;
    }
}

