/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.hive;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.hive.HiveBasicPanel;
import oracle.ide.util.ResourceUtils;

public class HiveConnectionPanel
extends IConnectionPanel {
    private static final long serialVersionUID = 1L;
    private JPanel _panel;
    private HiveBasicPanel _hiveBasicPanel;
    private CardLayout _layout;
    public static final String HOST = "localhost";
    public static final String PORT = "10000";

    public HiveConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this._hiveBasicPanel = new HiveBasicPanel();
        this._hiveBasicPanel.setDefaultPrompts();
        this._layout = new CardLayout(0, 0);
        this._panel = new JPanel(this._layout);
        this._panel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, null, (String)ConnectionDialogArb.getString((String)"CONNECTION_TYPE"));
        this._panel.add((Component)this._hiveBasicPanel, "Center");
        this.add(this._panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    protected Properties getInput(Properties properties) {
        properties.setProperty("subtype", "Hive");
        properties.setProperty("RaptorConnectionType", "Hive");
        properties.setProperty("NoPasswordConnection", Boolean.TRUE.toString());
        this._hiveBasicPanel.generateProperties(properties);
        return properties;
    }

    public void clear() {
        this._hiveBasicPanel.clear();
    }

    public void updatePrompts(final Properties properties) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    properties.setProperty("ConnName", HiveConnectionPanel.this.getConnectionName());
                    try {
                        HiveConnectionPanel.this._hiveBasicPanel.updatePrompts(properties);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeAndWait(runnable);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getDriver() {
        return this._hiveBasicPanel.getSelectedDriver();
    }

    public String[] getSupportedDrivers() {
        return this._hiveBasicPanel.getSupportedDrivers();
    }

    public void setDefaultPrompts() {
        this._hiveBasicPanel.setDefaultPrompts();
    }

    public String getConnectionType() {
        return "Hive";
    }
}

