/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.thirdparty.jdbc.JDBCBasicPanel;

public class JdbcRealConnectionRecognizer
implements ConnectionRecognizer {
    public static String getURL(Connection connection) {
        String string = null;
        try {
            if (Class.forName("java.sql.Connection").isInstance(connection)) {
                string = connection.getMetaData().getURL();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(JDBCBasicPanel.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    public ConnectionInfo createConnectionInfo(String string, Connection connection) {
        ConnectionInfo connectionInfo = null;
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = connection.getMetaData();
            Version version = RaptorVersionTracker.getDbVersion((Connection)connection);
            String string2 = JdbcRealConnectionRecognizer.getURL(connection);
            if (string2 != null && string2.indexOf("Microsoft Access") == -1) {
                connectionInfo = new ConnectionInfo(string, connection, version, "JDBC", null, databaseMetaData.getUserName());
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(JDBCBasicPanel.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return connectionInfo;
    }
}

