/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sybase;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.DefaultAuthenticationPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.thirdparty.sybase.Messages;
import oracle.dbtools.thirdparty.sybase.SybaseConnectionPanel;
import oracle.dbtools.thirdparty.sybase.SybaseExplorerResource;
import oracle.ide.util.ResourceUtils;

public class SybaseAuthenticationPanel
extends DefaultAuthenticationPanel {
    private JTextField fldDomain = new JTextField();
    private JCheckBox chkDefaultPwd = new JCheckBox();
    private JCheckBox chkWinAuth = new JCheckBox();

    protected JComponent createUI() {
        int n;
        Serializable serializable;
        JComponent jComponent = super.createUI();
        JLabel jLabel = new JLabel();
        if (!SybaseConnectionPanel.OS_WINDOWS) {
            serializable = ((GridBagLayout)jComponent.getLayout()).getConstraints(this.tfdUser);
            n = ((GridBagConstraints)serializable).gridx + 1;
            int n2 = ((GridBagConstraints)serializable).gridy;
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.fldDomain, (String)SybaseExplorerResource.getString("DOMAIN_NAME"));
            jLabel.setVisible(false);
            this.fldDomain.setVisible(false);
            jComponent.add((Component)jLabel, LayoutControl.GBC.gbc((int)n++, (int)n2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2CONTROL_COMP));
            jComponent.add((Component)this.fldDomain, LayoutControl.GBC.gbc((int)n, (int)n2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        }
        serializable = LayoutControl.GBC.createPanel();
        ResourceUtils.resButton((AbstractButton)this.chkDefaultPwd, (String)Messages.getString("BasicPanel.0"));
        this.chkDefaultPwd.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.tfdPassword.setEnabled(false);
                this.chkSavePassword.setEnabled(false);
            } else {
                this.tfdPassword.setEnabled(true);
                this.chkSavePassword.setEnabled(true);
            }
        });
        ((Container)serializable).add(this.chkDefaultPwd, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        ResourceUtils.resButton((AbstractButton)this.chkWinAuth, (String)SybaseExplorerResource.getString("WINDOWS_AUTHENTICATION"));
        this.chkWinAuth.addItemListener(itemEvent -> {
            boolean bl;
            boolean bl2 = bl = itemEvent.getStateChange() == 1;
            if (bl) {
                if (SybaseConnectionPanel.OS_WINDOWS) {
                    this.tfdUser.setEnabled(false);
                    this.tfdPassword.setEnabled(false);
                    this.chkSavePassword.setEnabled(false);
                    this.chkDefaultPwd.setEnabled(false);
                } else {
                    this.fldDomain.setVisible(true);
                    jLabel.setVisible(true);
                }
            } else if (SybaseConnectionPanel.OS_WINDOWS) {
                this.tfdUser.setEnabled(true);
                this.chkDefaultPwd.setEnabled(true);
                boolean bl3 = this.chkDefaultPwd.isSelected();
                this.tfdPassword.setEnabled(!bl3);
                this.chkSavePassword.setEnabled(!bl3);
            } else {
                this.fldDomain.setVisible(false);
                jLabel.setVisible(false);
            }
        });
        ((Container)serializable).add(this.chkWinAuth, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        ((Container)serializable).add(Box.createGlue(), LayoutControl.GBC.gbc((int)2, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        n = ((GridBagLayout)jComponent.getLayout()).getConstraints((Component)this.tfdPassword).gridy;
        jComponent.add((Component)serializable, LayoutControl.GBC.gbc((int)0, (int)(n + 1), (int)4, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        return jComponent;
    }

    public void initializeToDefaults() {
        super.initializeToDefaults();
        this.chkDefaultPwd.setSelected(false);
        this.chkWinAuth.setSelected(false);
        this.fldDomain.setText("");
    }

    public Properties getConnectionDetails() {
        Properties properties = super.getConnectionDetails();
        if (this.chkDefaultPwd.isSelected()) {
            properties.put(this.getDefaultPasswordKey(), Boolean.TRUE.toString());
            properties.setProperty("password", "");
            properties.setProperty("NoPasswordConnection", Boolean.FALSE.toString());
        } else {
            properties.put(this.getDefaultPasswordKey(), Boolean.FALSE.toString());
            properties.setProperty("NoPasswordConnection", Boolean.TRUE.toString());
        }
        if (this.chkWinAuth.isSelected()) {
            if (SybaseConnectionPanel.OS_WINDOWS) {
                properties.put("user", "");
                properties.put("password", "");
                properties.put(this.getDomainKey(), "");
            } else {
                properties.put(this.getDomainKey(), this.fldDomain.getText());
            }
            properties.put(this.getAuthenticationKey(), Boolean.TRUE.toString());
        }
        return properties;
    }

    protected String getAuthenticationKey() {
        return SybaseConnectionPanel.SYBASE_WINDOWS_AUTHENTICATION;
    }

    protected String getDomainKey() {
        return SybaseConnectionPanel.SYBASE_DOMAIN;
    }

    protected String getDefaultPasswordKey() {
        return SybaseConnectionPanel.SYBASE_DEFAULT_PASSWORD;
    }

    public void setConnectionDetails(Properties properties) {
        super.setConnectionDetails(properties);
        boolean bl = Boolean.parseBoolean(properties.getProperty(this.getAuthenticationKey(), "false"));
        this.chkWinAuth.setSelected(bl);
        boolean bl2 = Boolean.parseBoolean(properties.getProperty(this.getDefaultPasswordKey(), "false"));
        this.chkDefaultPwd.setSelected(bl2);
        this.fldDomain.setText(properties.getProperty(this.getDomainKey(), ""));
    }

    public void clear() {
        super.clear();
        this.chkDefaultPwd.setSelected(false);
        this.chkWinAuth.setSelected(false);
        this.fldDomain.setText("");
    }
}

