/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.technology;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import oracle.ide.ExtensionRegistry;
import oracle.ide.IdeCore;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScopeManager;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.ExtensionLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.technology.TechnologyProjectDataHandler;
import oracle.jdevimpl.technology.TechnologyScopeDetectorByNodeRecognizer;

public class TechnologyScanAction {
    private static Path contextPath;

    public void usage() {
        System.out.println();
        System.out.println("JDeveloper Technology Scan Action");
        System.out.println("  Scans and reports the technologies implied by project content.");
        System.out.println();
        System.out.println("  The technologies associated with each extension that registers a project node");
        System.out.println("  type or library are reported. By default, the result matches the technology");
        System.out.println("  detector used by the technology migrater and by the Resolve action in Project");
        System.out.println("  Settings | Features. If the -all option is given, the technologies of the");
        System.out.println("  dependencies of the registering extensions are also reported.");
        System.out.println();
        System.out.println("Usage");
        System.out.println("  ojrun parameter-or-option...");
        System.out.println();
        System.out.println("Parameters");
        System.out.println("  workspace    Path to a JDeveloper workspace");
        System.out.println("  project      Path to a JDeveloper project");
        System.out.println("  node         Path to a JDeveloper project node");
        System.out.println("  library      Name of a JDeveloper project library (in quotes)");
        System.out.println();
        System.out.println("  Projects require that only one workspace (containing the project) be given.");
        System.out.println("  Nodes require that only one project (containing the node) be given.");
        System.out.println("  Libraries require that only one project (containing the library) be given.");
        System.out.println();
        System.out.println("Options");
        System.out.println("  -all         Report technologies from dependencies of registering extensions");
        System.out.println("  -base path   Base directory path to strip from paths in output");
        System.out.println("  -changes     Print changes versus technologies recorded in project");
        System.out.println("  -empty       Report nodes and libraries with no associated technologies");
        System.out.println("  -output path Output directory, default is \"$PWD/technology-scan\"");
        System.out.println("  -quiet       Suppress progress messages");
        System.out.println("  -skip id,... Do NOT report technologies with the specified ids");
        System.out.println("  -verify      Verify new scanner against old scanner");
        System.out.println();
        System.out.println("Output is written to the output directory. For each project, up to two files may");
        System.out.println("be written: if any nodes of the project are reportable, a CSV file listing the");
        System.out.println("nodes and technologies is written; similarly, if any libraries of the project");
        System.out.println("are reportable, a CSV file listing the libraries and technologies is written.");
        System.out.println("The file names will be of the form x_y_z.csv, where x is workspace name, y is");
        System.out.println("project name, and z is either \"nodes\" or \"libraries\". (Before any files are");
        System.out.println("written, any files in the output directory matching *_*_nodes.csv or ");
        System.out.println("*_*_libraries.csv are deleted.)");
        System.out.println();
    }

    /*
     * WARNING - void declaration
     */
    public void execute(List<String> arguments) throws Exception {
        Serializable projectLibraries;
        Object workspaceName;
        if (arguments.isEmpty() || "-help".equals(arguments.get(0)) || "--help".equals(arguments.get(0))) {
            this.usage();
            System.exit(0);
        }
        ArrayList<Path> workspacePaths = new ArrayList<Path>();
        ArrayList<Path> projectPaths = new ArrayList<Path>();
        ArrayList<Path> nodePaths = new ArrayList<Path>();
        ArrayList<String> libraryNames = new ArrayList<String>();
        boolean all = false;
        Path base = null;
        boolean changes = false;
        boolean empty = false;
        Path output = null;
        boolean quiet = false;
        TreeSet<String> skipIds = new TreeSet<String>();
        boolean verify = false;
        for (int i = 0; i < arguments.size(); ++i) {
            Path path;
            String argument = arguments.get(i);
            if (argument.length() > 2 && argument.charAt(0) == '\"' && argument.charAt(argument.length() - 1) == '\"') {
                argument = argument.substring(1, argument.length() - 1);
            }
            if (argument.equals("-all")) {
                all = true;
                continue;
            }
            if (argument.equals("-base")) {
                if (++i == arguments.size()) {
                    System.err.println("-base requires an argument");
                    System.exit(1);
                }
                if (Files.exists(base = TechnologyScanAction.resolve(argument = arguments.get(i)), new LinkOption[0])) {
                    if (!Files.isRegularFile(base, new LinkOption[0])) continue;
                    base = base.getParent();
                    continue;
                }
                System.err.println("Base directory not found: " + argument);
                System.exit(1);
                continue;
            }
            if (argument.equals("-changes")) {
                changes = true;
                continue;
            }
            if (argument.equals("-empty")) {
                empty = true;
                continue;
            }
            if (argument.equals("-output")) {
                if (++i == arguments.size()) {
                    System.err.println("-output requires an argument");
                    System.exit(1);
                }
                output = TechnologyScanAction.resolve(arguments.get(i));
                continue;
            }
            if (argument.equals("-skip")) {
                if (++i == arguments.size()) {
                    System.err.println("-skip requires an argument");
                    System.exit(1);
                }
                TechnologyRegistry technologyRegistry = TechnologyRegistry.getInstance();
                for (String id : arguments.get(i).split("\\s*,\\s*")) {
                    if (technologyRegistry.getTechId(id) == null) {
                        System.err.println("Technology " + id + " is not registered");
                        System.exit(1);
                    }
                    skipIds.add(id);
                }
                continue;
            }
            if (argument.equals("-quiet")) {
                quiet = true;
                continue;
            }
            if (argument.equals("-verify")) {
                verify = true;
                continue;
            }
            if (argument.endsWith(".jws")) {
                path = TechnologyScanAction.resolve(argument);
                if (Files.exists(path, new LinkOption[0])) {
                    workspacePaths.add(path);
                    continue;
                }
                System.err.println("Workspace not found: " + argument);
                System.exit(1);
                continue;
            }
            if (argument.endsWith(".jpr")) {
                path = TechnologyScanAction.resolve(argument);
                if (Files.exists(path, new LinkOption[0])) {
                    projectPaths.add(path);
                    continue;
                }
                System.err.println("Project not found: " + argument);
                System.exit(1);
                continue;
            }
            path = TechnologyScanAction.resolve(argument);
            if (Files.exists(path, new LinkOption[0])) {
                nodePaths.add(path);
                continue;
            }
            JLibraryManager.getInstance();
            if (JLibraryManager.findLibrary((Object)argument) != null) {
                libraryNames.add(argument);
                continue;
            }
            if (IdeCore.isFrameworkCommandLineOption((String)argument)) continue;
            System.err.println("Unknown argument \"" + argument + '\"');
            System.exit(1);
        }
        if (workspacePaths.size() == 0) {
            System.err.println("No workspace specified");
            System.exit(1);
        } else if (workspacePaths.size() > 1 && !projectPaths.isEmpty()) {
            System.err.println("Projects not allowed when multiple workspaces specified");
            System.exit(1);
        } else if (projectPaths.size() != 1 && !nodePaths.isEmpty()) {
            System.err.println("Nodes not allowed when " + (projectPaths.isEmpty() ? "no" : "multiple") + " projects specified");
            System.exit(1);
        } else if (projectPaths.size() != 1 && !libraryNames.isEmpty()) {
            System.err.println("Libraries not allowed when " + (projectPaths.isEmpty() ? "no" : "multiple") + " projects specified");
            System.exit(1);
        } else if (!(!changes || nodePaths.isEmpty() && libraryNames.isEmpty())) {
            System.err.println("-changes not allowed when nodes or libraries are specified");
            System.exit(1);
        }
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        TechnologyRegistry technologyRegistry = TechnologyRegistry.getInstance();
        FeatureRegistry featureRegistry = extensionRegistry.getFeatureRegistry();
        HashMap<String, Set<String>> extensionTechnologies = new HashMap<String, Set<String>>();
        TechnologyScopeDetectorByNodeRecognizer detector = (TechnologyScopeDetectorByNodeRecognizer)TechnologyScopeManager.getTechnologyScopeManager().getDetector();
        boolean detectorEquivalent = !all && nodePaths.isEmpty() && libraryNames.isEmpty();
        switch (skipIds.size()) {
            case 0: {
                TechnologyScanAction.verbose(quiet, "All technologies will be reported");
                break;
            }
            case 1: {
                TechnologyScanAction.verbose(quiet, "The \"" + (String)skipIds.iterator().next() + " technology will NOT be reported");
                break;
            }
            default: {
                StringBuilder builder = new StringBuilder(128);
                builder.append("The following ").append(skipIds.size()).append(" technologies will NOT be reported: ");
                Iterator i = skipIds.iterator();
                builder.append((String)i.next());
                do {
                    builder.append(", ").append((String)i.next());
                } while (i.hasNext());
                TechnologyScanAction.verbose(quiet, builder.toString());
            }
        }
        ArrayList<WorkspaceData> workspaces = new ArrayList<WorkspaceData>();
        for (Path path : workspacePaths) {
            workspaces.add(new WorkspaceData(path));
        }
        for (WorkspaceData workspaceData : workspaces) {
            System.out.println("Scanning workspace " + TechnologyScanAction.relativize(workspaceData.getPath(), base));
            Workspace workspace = workspaceData.getWorkspace();
            if (projectPaths.isEmpty()) {
                for (Project project : workspace.projects()) {
                    workspaceData.addProject(Paths.get(URLFileSystem.getPlatformPathName((URL)project.getURL()), new String[0]));
                }
            } else {
                for (Path path : projectPaths) {
                    Project project = (Project)NodeFactory.findOrCreate(Project.class, (URL)path.toUri().toURL());
                    if (!workspace.containsChild((Element)project)) {
                        System.err.println("Workspace does not contain project " + path);
                        System.exit(1);
                    }
                    workspaceData.addProject(path);
                }
            }
            workspaceName = workspaceData.getPath().getFileName().toString();
            for (ProjectData projectData : workspaceData.getProjects()) {
                void var31_40;
                String extensionId;
                Iterator nodeIterator;
                TechnologyScanAction.verbose(quiet, "Scanning project " + TechnologyScanAction.relativize(projectData.getPath(), base) + " of " + (String)workspaceName);
                Project project = projectData.getProject();
                TreeSet<String> gatheredIds = new TreeSet<String>();
                if (nodePaths.isEmpty()) {
                    nodeIterator = project.getChildren();
                } else {
                    ArrayList<Node> nodes = new ArrayList<Node>();
                    for (Path path : nodePaths) {
                        Node node = NodeFactory.findOrCreateOrFail((URL)path.toUri().toURL());
                        if (!project.containsChild((Element)node)) {
                            System.err.println("Project does not contain node " + path);
                            System.exit(1);
                        }
                        nodes.add(node);
                    }
                    nodeIterator = nodes.iterator();
                }
                while (nodeIterator.hasNext()) {
                    void var32_61;
                    Object child = nodeIterator.next();
                    if (!(child instanceof Node)) continue;
                    URL uRL = ((Node)child).getURL();
                    if (all) {
                        ClassLoader loader = Recognizer.recognizeURLAsMeta((URL)uRL).getClassLoader();
                        Extension extension = ExtensionRegistry.getExtensionRegistry().findExtensionByClassLoader(loader);
                        if (extension == null) continue;
                        extensionId = extension.getID();
                        Set<String> set = this.getTechnologies(extension, extensionId, technologyRegistry, featureRegistry, extensionTechnologies);
                        TreeSet<String> detectorIds = new TreeSet<String>(detector.detectTechnologyScopeIdsOfURL(project, uRL));
                        detectorIds.removeAll(set);
                        if (!detectorIds.isEmpty()) {
                            System.out.println("Detector adds " + detectorIds + " to " + TechnologyScanAction.relativize(Paths.get(URLFileSystem.getPlatformPathName((URL)uRL), new String[0]), base));
                        }
                    } else {
                        Collection<String> collection = detector.detectTechnologyScopeIdsOfURL(project, uRL);
                    }
                    var32_61.removeAll(skipIds);
                    projectData.addNode(Paths.get(URLFileSystem.getPlatformPathName((URL)uRL), new String[0]), (Collection<String>)var32_61);
                    gatheredIds.addAll((Collection<String>)var32_61);
                }
                projectLibraries = new TreeMap();
                for (JLibrary library : JProjectLibraries.getInstance((PropertyStorage)project).getLibraries()) {
                    projectLibraries.put(library.getName(), library);
                }
                if (libraryNames.isEmpty()) {
                    Iterator iterator = projectLibraries.values().iterator();
                } else {
                    ArrayList<JLibrary> arrayList = new ArrayList<JLibrary>();
                    for (String name : libraryNames) {
                        JLibrary library = (JLibrary)projectLibraries.get(name);
                        if (library == null) {
                            System.err.println("Project does not contain library " + name);
                            System.exit(1);
                        }
                        arrayList.add(library);
                    }
                    Iterator iterator = arrayList.iterator();
                }
                while (var31_40.hasNext()) {
                    Collection<String> ids;
                    JLibrary jLibrary = (JLibrary)var31_40.next();
                    if (all) {
                        ExtensionLibrary extensionLibrary;
                        if (!(jLibrary instanceof ExtensionLibrary) || !(extensionLibrary = (ExtensionLibrary)jLibrary).getForceExtensionInitialization()) continue;
                        extensionId = extensionLibrary.getProviderExtensionId();
                        Extension extension = extensionRegistry.findExtension(extensionId);
                        ids = this.getTechnologies(extension, extensionId, technologyRegistry, featureRegistry, extensionTechnologies);
                        TreeSet<String> detectorIds = new TreeSet<String>(detector.detectTechnologyScopeIdsOfLibrary(project, jLibrary));
                        detectorIds.removeAll(ids);
                        if (!detectorIds.isEmpty()) {
                            System.out.println("Detector adds " + detectorIds + " to \"" + jLibrary.getName() + '\"');
                        }
                    } else {
                        ids = detector.detectTechnologyScopeIdsOfLibrary(project, jLibrary);
                    }
                    ids.removeAll(skipIds);
                    projectData.addLibrary(jLibrary.getName(), ids);
                    gatheredIds.addAll(ids);
                }
                if (detectorEquivalent && verify) {
                    TreeSet<String> treeSet = new TreeSet<String>(detector.detectTechnologyScopeIds(workspace, project));
                    treeSet.removeAll(skipIds);
                    projectData.setDetectedIds(treeSet);
                    assert (treeSet.equals(gatheredIds));
                }
                if (changes) {
                    projectData.setGatheredIds(gatheredIds);
                    TreeSet<String> treeSet = new TreeSet<String>();
                    HashStructure hashStructure = project.getSharedPropertiesOnly();
                    HashStructure hookHashStructure = hashStructure.getHashStructure("oracle.ide.model.TechnologyScopeConfiguration");
                    if (hookHashStructure != null) {
                        TechnologyProjectDataHandler handler = new TechnologyProjectDataHandler();
                        treeSet.addAll(handler.getTechnologiesFromProject(hookHashStructure));
                    }
                    projectData.setStoredIds(treeSet);
                }
                project.close();
            }
            workspace.close();
            TechnologyScanAction.verbose(quiet, "Completed scanning workspace " + TechnologyScanAction.relativize(workspaceData.getPath(), base));
        }
        if (output == null) {
            output = TechnologyScanAction.resolve("feature-scan");
        }
        int outputCount = 0;
        if (!Files.isDirectory(output, new LinkOption[0])) {
            Files.createDirectory(output, new FileAttribute[0]);
        } else {
            Matcher matcher = Pattern.compile(".+_.+_(nodes|libraries).csv").matcher("");
            DirectoryStream<Path> files = Files.newDirectoryStream(output, p -> matcher.reset(p.getFileName().toString()).matches());
            workspaceName = null;
            try {
                for (Path path : files) {
                    Files.delete(path);
                }
            }
            catch (Throwable throwable) {
                workspaceName = throwable;
                throw throwable;
            }
            finally {
                if (files != null) {
                    if (workspaceName != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)workspaceName).addSuppressed(throwable);
                        }
                    } else {
                        files.close();
                    }
                }
            }
        }
        for (WorkspaceData workspaceData : workspaces) {
            String workspaceRelativePath = TechnologyScanAction.relativize(workspaceData.getPath(), base);
            for (ProjectData projectData : workspaceData.getProjects()) {
                Set<String> ids;
                BufferedWriter writer;
                String projectRelativePath = TechnologyScanAction.relativize(projectData.getPath(), base);
                if (projectData.hasNodes()) {
                    Path nodesPath = output.resolve(workspaceData.getName() + '_' + projectData.getName() + "_nodes.csv");
                    writer = Files.newBufferedWriter(nodesPath, new OpenOption[0]);
                    projectLibraries = null;
                    try {
                        writer.write("workspace,project,node,technology");
                        writer.newLine();
                        for (Map.Entry<Path, Set<String>> entry : projectData.getNodes()) {
                            String nodePath = TechnologyScanAction.relativize(entry.getKey(), base);
                            ids = entry.getValue();
                            if (ids.isEmpty() && empty) {
                                ids = Collections.singleton("");
                            }
                            for (String id : ids) {
                                writer.write(workspaceRelativePath);
                                writer.write(44);
                                writer.write(projectRelativePath);
                                writer.write(44);
                                writer.write(nodePath);
                                writer.write(44);
                                writer.write(id);
                                writer.newLine();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        projectLibraries = throwable;
                        throw throwable;
                    }
                    finally {
                        if (writer != null) {
                            if (projectLibraries != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)projectLibraries).addSuppressed(throwable);
                                }
                            } else {
                                writer.close();
                            }
                        }
                    }
                    ++outputCount;
                }
                if (!projectData.hasLibraries()) continue;
                Path librariesPath = output.resolve(workspaceData.getName() + '_' + projectData.getName() + "_libraries.csv");
                writer = Files.newBufferedWriter(librariesPath, new OpenOption[0]);
                projectLibraries = null;
                try {
                    writer.write("workspace,project,library,technology");
                    writer.newLine();
                    for (Map.Entry<String, Set<String>> entry : projectData.getLibraries()) {
                        String libraryName = entry.getKey();
                        ids = entry.getValue();
                        if (ids.isEmpty() && empty) {
                            ids = Collections.singleton("");
                        }
                        for (String id : ids) {
                            writer.write(workspaceRelativePath);
                            writer.write(44);
                            writer.write(projectRelativePath);
                            writer.write(44);
                            writer.write(34);
                            writer.write(libraryName.replace(',', ';'));
                            writer.write(34);
                            writer.write(44);
                            writer.write(id);
                            writer.newLine();
                        }
                    }
                }
                catch (Throwable throwable) {
                    projectLibraries = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (projectLibraries != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)projectLibraries).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
                ++outputCount;
            }
        }
        TechnologyScanAction.verbose(quiet, "Wrote " + outputCount + " file" + (outputCount != 1 ? "s" : "") + " to " + output);
        if (changes) {
            for (WorkspaceData workspaceData : workspaces) {
                boolean workspace = workspaces.size() > 1;
                for (ProjectData projectData : workspaceData.getProjects()) {
                    String projectName = projectData.getName();
                    Set<String> storedIds = projectData.getStoredIds();
                    Set<String> detectedIds = projectData.getGatheredIds();
                    TreeSet<String> removed = new TreeSet<String>(storedIds);
                    removed.removeAll(detectedIds);
                    TreeSet<String> treeSet = new TreeSet<String>(detectedIds);
                    treeSet.removeAll(storedIds);
                    if (removed.isEmpty() && treeSet.isEmpty()) continue;
                    StringBuilder stringBuilder = new StringBuilder("Resolve of ");
                    stringBuilder.append(projectName).append(".jpr");
                    if (workspace) {
                        stringBuilder.append(" of ");
                        stringBuilder.append(workspaceData.getName()).append(".jws");
                    }
                    stringBuilder.append(" would");
                    if (!removed.isEmpty()) {
                        stringBuilder.append(" remove ").append(this.trim(removed));
                    }
                    if (!removed.isEmpty() && !treeSet.isEmpty()) {
                        stringBuilder.append(" and");
                    }
                    if (!treeSet.isEmpty()) {
                        stringBuilder.append(" add ").append(this.trim(treeSet));
                    }
                    System.out.println(stringBuilder);
                }
            }
        }
        System.exit(0);
    }

    private String trim(Object object) {
        String string = object.toString();
        if (string.length() < 2) {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    private Set<String> getTechnologies(Extension extension, String extensionId, TechnologyRegistry technologyRegistry, FeatureRegistry featureRegistry, Map<String, Set<String>> extensionTechnologies) {
        Set<String> ids = extensionTechnologies.get(extensionId);
        if (ids != null) {
            return ids;
        }
        ids = new TreeSet<String>(this.getTechnologyIds(technologyRegistry, featureRegistry, extensionId));
        assert (ids.size() <= 1);
        for (ExtensionDependency dependency : extension.getDependencies()) {
            ids.addAll(this.getTechnologyIds(technologyRegistry, featureRegistry, dependency.getID()));
        }
        extensionTechnologies.put(extensionId, ids);
        return ids;
    }

    private Collection<String> getTechnologyIds(TechnologyRegistry technologyRegistry, FeatureRegistry featureRegistry, String extensionId) {
        Feature feature = featureRegistry.getFeatureForExtension(extensionId);
        if (feature != null) {
            return technologyRegistry.getTechnologiesOfFeature(feature);
        }
        return technologyRegistry.getTechnologiesOfExtension(extensionId);
    }

    private static Path resolve(String string) throws Exception {
        Path file = Paths.get(string, new String[0]);
        if (!file.isAbsolute()) {
            file = TechnologyScanAction.contextPath().resolve(file);
        }
        return file.normalize();
    }

    private static String relativize(Path path, Path base) {
        if (base == null) {
            return path.toString();
        }
        return base.relativize(path).toString();
    }

    private static void verbose(boolean quiet, String message) {
        if (!quiet) {
            System.out.println(message);
        }
    }

    private static Path contextPath() {
        if (contextPath != null) {
            return contextPath;
        }
        String directory = System.getProperty("ide.startingcwd");
        if (directory == null) {
            directory = System.getProperty("user.dir");
        }
        if (directory.startsWith("\"") && directory.endsWith("\"")) {
            directory = directory.substring(1, directory.length() - 1);
        }
        contextPath = Paths.get(directory, new String[0]);
        return contextPath;
    }

    private static class ProjectData {
        private final Path path;
        private final Map<Path, Set<String>> nodes = new LinkedHashMap<Path, Set<String>>();
        private final Map<String, Set<String>> libraries = new LinkedHashMap<String, Set<String>>();
        private Set<String> storedIds;
        private Set<String> detectedIds;
        private Set<String> gatheredIds;

        public ProjectData(Path path) {
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public String getName() {
            String name = this.getPath().getFileName().toString();
            return name.substring(0, name.length() - 4);
        }

        public Project getProject() throws MalformedURLException, InstantiationException, IllegalAccessException {
            return (Project)NodeFactory.findOrCreate(Project.class, (URL)this.path.toUri().toURL());
        }

        public void addNode(Path node, Collection<String> ids) {
            this.nodes.computeIfAbsent(node, v -> new TreeSet()).addAll(ids);
        }

        public boolean hasNodes() {
            return !this.nodes.isEmpty();
        }

        public Iterable<Map.Entry<Path, Set<String>>> getNodes() {
            return this.nodes.entrySet();
        }

        public void addLibrary(String library, Collection<String> ids) {
            this.libraries.computeIfAbsent(library, v -> new TreeSet()).addAll(ids);
        }

        public boolean hasLibraries() {
            return !this.libraries.isEmpty();
        }

        public Iterable<Map.Entry<String, Set<String>>> getLibraries() {
            return this.libraries.entrySet();
        }

        public Set<String> getStoredIds() {
            return this.storedIds;
        }

        public void setStoredIds(Set<String> storedIds) {
            this.storedIds = storedIds;
        }

        public Set<String> getDetectedIds() {
            return this.detectedIds;
        }

        public void setDetectedIds(Set<String> detectedIds) {
            this.detectedIds = detectedIds;
        }

        public Set<String> getGatheredIds() {
            return this.gatheredIds;
        }

        public void setGatheredIds(Set<String> gatheredIds) {
            this.gatheredIds = gatheredIds;
        }
    }

    private static class WorkspaceData {
        private final Path path;
        private final Map<Path, ProjectData> projects = new LinkedHashMap<Path, ProjectData>();

        public WorkspaceData(Path workspace) {
            this.path = workspace;
        }

        public Path getPath() {
            return this.path;
        }

        public String getName() {
            String name = this.getPath().getFileName().toString();
            return name.substring(0, name.length() - 4);
        }

        public Workspace getWorkspace() throws MalformedURLException, InstantiationException, IllegalAccessException {
            return (Workspace)NodeFactory.findOrCreate(Workspace.class, (URL)this.path.toUri().toURL());
        }

        public void addProject(Path project) {
            this.projects.computeIfAbsent(project, p -> new ProjectData(project));
        }

        public Iterable<ProjectData> getProjects() {
            return this.projects.values();
        }
    }
}

