/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.axischart.internal;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import oracle.charts.axischart.internal.AxisUtil;
import oracle.charts.axischart.internal.ChartDescription;
import oracle.charts.axischart.internal.LabelUtil;
import oracle.charts.types.StringAxisDesc;
import oracle.viz.util.svg.SVGChartGraphics;

public final class StringLabel {
    private static final int LABEL_CENTER_PERIOD = 3;
    private static final int LABEL_TIMESTAMP_ALIGN = 4;
    private static final int LABEL_FIRSTCHAR_PERIOD = 5;
    private static final int LABEL_FIRSTCHAR_TIMESTAMP = 6;

    public static double getRotatedTextHeight(Graphics2D g2, ChartDescription Ch, FontMetrics SLFontmet, StringAxisDesc sd) {
        double rotation = sd.getTextRotation();
        double maxRotatedTextHeight = 0.0;
        if (rotation != 0.0) {
            double rotationRad = Math.toRadians(rotation);
            int maxLabelWidth = StringLabel.getMaxLabelWidth(g2, Ch, SLFontmet, sd);
            maxRotatedTextHeight = (double)maxLabelWidth * Math.sin(rotationRad);
        }
        return maxRotatedTextHeight;
    }

    public static double getRotatedTextWidthLastLabel(Graphics2D g2, ChartDescription Ch, FontMetrics SLFontmet, StringAxisDesc sd) {
        double rotation = sd.getTextRotation();
        double rotatedTextWidth = 0.0;
        double rotationRad = Math.toRadians(rotation);
        int labelWidth = LabelUtil.getStringLabelWidth(Ch.XStringLabel[Ch.labelXCount - 1], sd, g2.getFontRenderContext(), SLFontmet);
        rotatedTextWidth = (double)labelWidth * Math.cos(rotationRad);
        return rotatedTextWidth;
    }

    public static int getMaxLabelWidth(Graphics2D g2, ChartDescription Ch, FontMetrics SLFontmet, StringAxisDesc sd) {
        int maxLabelWidth = 0;
        int k = 0;
        while (k < Ch.labelXCount) {
            int labelWidth = LabelUtil.getStringLabelWidth(Ch.XStringLabel[k], sd, g2.getFontRenderContext(), SLFontmet);
            if (maxLabelWidth < labelWidth) {
                maxLabelWidth = labelWidth;
            }
            ++k;
        }
        return maxLabelWidth;
    }

    public static void paintXStringLabels(Graphics2D g2, SVGChartGraphics svgG, ChartDescription Ch, int plotWidth, int[] xval_int, FontMetrics SLFontmet, StringAxisDesc sd, double x_coordinate_spread) {
        boolean test = false;
        if (test) {
            System.out.println("*** paintXStringLabels *** " + Ch.labelXCount);
        }
        int delta = 0;
        double textRotation = sd.getTextRotation();
        double textRotationRad = Math.toRadians(textRotation);
        double textRotationSinAdjust = 6.0 * Math.sin(textRotationRad);
        AffineTransform oldTransform = null;
        oldTransform = g2.getTransform();
        Shape s = null;
        int label_justify = 4;
        int xpos = 0;
        if (Ch.containsIntervalGraphic) {
            label_justify = 3;
        }
        if (Ch.containsIntervalGraphic && textRotation != 0.0) {
            label_justify = 5;
        }
        if (!Ch.containsIntervalGraphic && textRotation != 0.0) {
            label_justify = 6;
        }
        FontRenderContext frc = g2.getFontRenderContext();
        if (sd.getTextAttributes() == null) {
            g2.setFont(sd.getFont());
            g2.setColor(sd.getColor());
        }
        int k = 0;
        while (k < Ch.labelXCount) {
            String labelString = Ch.XStringLabel[k];
            int end_index = k + 1;
            int start_index = k;
            if (test) {
                System.out.println("paintXLabels: " + labelString + " [" + start_index + "," + end_index + "]");
            }
            int xIntervalWidth = AxisUtil.getLabelWidth(xval_int, start_index, end_index, Ch.XAxisCount, Ch.border_left, plotWidth, x_coordinate_spread);
            if (test) {
                System.out.println("paintXStringLabels: xIntervalWidth " + xIntervalWidth);
            }
            int labelWidth = LabelUtil.getStringLabelWidth(labelString, sd, frc, SLFontmet);
            int labelHeight = LabelUtil.getStringLabelHeight(labelString, sd, frc, SLFontmet);
            switch (label_justify) {
                case 4: {
                    if (test) {
                        System.out.println(" *** LABEL_TIMESTAMP_ALIGN ");
                    }
                    delta = -(labelWidth / 2);
                    break;
                }
                case 6: {
                    delta = -(labelHeight / 3);
                    break;
                }
                case 3: {
                    delta = xIntervalWidth > labelWidth ? (xIntervalWidth - labelWidth) / 2 : 0;
                    if (!test) break;
                    System.out.println(" *** LABEL_CENTER_PERIOD " + delta);
                    break;
                }
                case 5: {
                    delta = xIntervalWidth > labelHeight ? (xIntervalWidth - labelHeight) / 2 : xIntervalWidth / 2;
                }
            }
            xpos = xval_int[start_index] + delta;
            if (Ch.labelXCount == 1 && !Ch.containsIntervalGraphic) {
                xpos = Ch.border_left;
            }
            if (svgG.getEnableSVG() && Ch.svgXLinksStringLabel != null && Ch.svgXLinksStringLabel.getHRef().length > k) {
                svgG.setStartATagLink(Ch.svgXLinksStringLabel.getHRef()[k]);
            }
            AttributedString attrStr = LabelUtil.getStringLabelAttributedString(labelString, sd);
            int ypos = Ch.displayHeight - Ch.border_bottom + labelHeight;
            if (textRotation != 0.0) {
                AffineTransform rotateTransform = AffineTransform.getRotateInstance(textRotationRad, xpos, ypos -= (int)Math.round(textRotationSinAdjust));
                g2.transform(rotateTransform);
            }
            TextLayout layout = null;
            if (attrStr != null) {
                layout = new TextLayout(attrStr.getIterator(), frc);
                layout.draw(g2, xpos, ypos);
            } else {
                g2.drawString(labelString, xpos, ypos);
            }
            if (textRotation != 0.0) {
                if (attrStr != null) {
                    Rectangle2D bounds = layout.getBounds();
                    bounds.setRect(bounds.getX() + (double)xpos, bounds.getY() + (double)ypos, bounds.getWidth(), bounds.getHeight());
                    s = g2.getTransform().createTransformedShape(bounds);
                } else {
                    Rectangle2D.Double r = new Rectangle2D.Double(xpos, ypos - 2 * labelHeight / 3, labelWidth, labelHeight);
                    s = g2.getTransform().createTransformedShape(r);
                }
                g2.setTransform(oldTransform);
            }
            if (svgG.getEnableSVG() && Ch.svgXLinksStringLabel != null && Ch.svgXLinksStringLabel.getHRef().length > k) {
                svgG.setEndATag();
            }
            if (Ch.genImageMapCoords) {
                if (textRotation == 0.0) {
                    int xCorner0 = xpos;
                    int xCorner1 = xpos + labelWidth;
                    int yCorner0 = Ch.displayHeight - Ch.border_bottom;
                    int yCorner1 = Ch.displayHeight - Ch.border_bottom + labelHeight;
                    Ch.imageMapCoords[k] = new int[4];
                    Ch.imageMapCoords[k][0] = xCorner0;
                    Ch.imageMapCoords[k][1] = yCorner0;
                    Ch.imageMapCoords[k][2] = xCorner1;
                    Ch.imageMapCoords[k][3] = yCorner1;
                } else {
                    Ch.imageMapShape = 2;
                    Ch.imageMapCoords[k] = StringLabel.getPathCoords(g2, s);
                }
            }
            ++k;
        }
    }

    private static int getPathCount(PathIterator p) {
        int count = 0;
        float[] coords = new float[6];
        while (!p.isDone()) {
            int segmentType = p.currentSegment(coords);
            switch (segmentType) {
                case 0: {
                    count += 2;
                    break;
                }
                case 1: {
                    count += 2;
                }
            }
            p.next();
        }
        return count;
    }

    private static int[] getPathCoords(Graphics2D g2, Shape s) {
        PathIterator p = s.getPathIterator(g2.getTransform());
        int count = StringLabel.getPathCount(p);
        int[] points = new int[count];
        p = s.getPathIterator(g2.getTransform());
        float[] coords = new float[6];
        int k = 0;
        while (!p.isDone()) {
            int segmentType = p.currentSegment(coords);
            switch (segmentType) {
                case 0: 
                case 1: {
                    points[k++] = Math.round(coords[0]);
                    points[k++] = Math.round(coords[1]);
                }
            }
            p.next();
        }
        return points;
    }
}

