/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.LinkedList;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.lsp.Jsonable;
import oracle.dbtools.parser.LexerToken;

public class CompletionList
implements Jsonable {
    public LinkedList<CompletionItem> entries = new LinkedList();
    public int pos;
    public LexerToken prefix;

    public void add(CompletionItem item) {
        if ("...".equals(item.entry)) {
            this.entries.addLast(item);
            return;
        }
        int index = 0;
        for (CompletionItem cmp : this.entries) {
            ++index;
            if (cmp.entry.equals(item.entry)) {
                return;
            }
            if (this.prefix == null || !item.entry.toLowerCase().startsWith(this.prefix.content.toLowerCase()) || cmp.entry.toLowerCase().startsWith(this.prefix.content.toLowerCase())) continue;
            --index;
            break;
        }
        this.entries.add(index, item);
    }

    public String toString() {
        return this.entries.toString() + "\npos=" + this.pos + "\nprefix=" + (this.prefix == null ? "null" : this.prefix.content);
    }

    public int size() {
        return this.entries.size();
    }

    public CompletionItem first() {
        return this.entries.get(0);
    }

    @Override
    public String toJson() {
        StringBuilder ret = new StringBuilder("[");
        int pos = 0;
        for (CompletionItem entry : this.entries) {
            if (0 < pos++) {
                ret.append(',');
            }
            ret.append(entry.toJson());
        }
        ret.append("]");
        return ret.toString();
    }
}

