/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import oracle.dbtools.app.Rewrite;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class Obfuscator
extends Rewrite {
    private int varCnt = 0;
    private int changeCnt = 0;
    static SecretKey desKey = null;
    static Cipher desCipher = null;
    static final String path = "/oracle/dbtools/app/";
    static SqlProgram programInstance;

    public Obfuscator(Set<String> fileExtensions) {
        super(fileExtensions);
    }

    private static String rename(String input) {
        try {
            desCipher.init(1, desKey);
            byte[] cleartext = input.getBytes();
            byte[] ciphertext = desCipher.doFinal(cleartext);
            Object output64 = Base64.getEncoder().encodeToString(ciphertext);
            if (30 < ((String)output64).length()) {
                char last = ((String)output64).charAt(((String)output64).length() - 1);
                output64 = last + ((String)output64).substring(1, 30);
            }
            return "\"" + (String)output64 + "\"";
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(Obfuscator.class, "obfuscator_test.sql");
        List<LexerToken> src = Lexer.parse(input);
        Obfuscator o = new Obfuscator(null);
        String output = o.transform(input, src, null);
        System.out.println(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String transform(String input, List<LexerToken> src, LazyNode notUsed) {
        try {
            if (programInstance == null) {
                programInstance = new SqlProgram(Service.readFile(Obfuscator.class, "/oracle/dbtools/app/vars.prg"));
                Program.debug = false;
            }
            Map<String, MaterializedPredicate> predicateVectors = programInstance.run(input, null);
            TreeMap<Long, String> substitutions = new TreeMap<Long, String>();
            MaterializedPredicate symbols = predicateVectors.get("\"var entry in scope\"");
            this.changeCnt += symbols.cardinality();
            HashMap<String, String> renamed = new HashMap<String, String>();
            for (Tuple tuple : symbols.getTuples()) {
                ParseNode scope = symbols.getAttribute(tuple, "scope");
                ParseNode entry = symbols.getAttribute(tuple, "entry");
                LexerToken t = src.get(entry.from);
                String scopedName = t.content + scope.from + "," + scope.to;
                String obfuscatedName = Obfuscator.rename(scopedName);
                renamed.put(t.content.toLowerCase(), obfuscatedName);
                substitutions.put(Service.lPair(t.begin, t.end), obfuscatedName);
            }
            this.varCnt += renamed.size();
            List<LexerToken> fullSrc = LexerToken.parse(input, true);
            for (LexerToken t : fullSrc) {
                if (t.type != Token.MACRO_SKIP) continue;
                this.addMore(substitutions, t, renamed);
            }
            StringBuilder stringBuilder = new StringBuilder();
            int priorLexPos = 0;
            Iterator iterator = substitutions.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    stringBuilder.append(input.substring(priorLexPos));
                    return stringBuilder.toString();
                }
                long xy = (Long)iterator.next();
                int x = Service.lX(xy);
                int y = Service.lY(xy);
                String newName = (String)substitutions.get(xy);
                stringBuilder.append(input.substring(priorLexPos, x));
                priorLexPos = y;
                stringBuilder.append(newName);
            }
        }
        catch (SyntaxError e) {
            throw e;
        }
        catch (AssertionError e) {
            System.err.println(((Throwable)((Object)e)).getMessage());
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addMore(Map<Long, String> substitutions, LexerToken macroT, HashMap<String, String> renamed) {
        String code = macroT.content;
        if (code.length() < "$ELSIF".length()) {
            return;
        }
        if ("$ELSIF".equalsIgnoreCase(code.substring(0, "$ELSIF".length()))) {
            code = code.substring("$ELSIF".length());
        } else if ("$ELSE".equalsIgnoreCase(code.substring(0, "$ELSE".length()))) {
            code = code.substring("$ELSE".length());
        }
        List<LexerToken> src = LexerToken.parse(code);
        for (LexerToken t : src) {
            String newName = renamed.get(t.content.toLowerCase());
            if (newName == null) continue;
            substitutions.put(Service.lPair(macroT.content.length() - code.length() + macroT.begin + t.begin, macroT.content.length() - code.length() + macroT.begin + t.end), newName);
        }
    }

    @Override
    protected String found() {
        return "found " + this.varCnt + " symbols, ";
    }

    @Override
    protected String changed() {
        return "obfuscated " + this.changeCnt + " instances";
    }

    static {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("DES");
            desKey = keygen.generateKey();
            desCipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        }
        catch (Exception exception) {
            // empty catch block
        }
        programInstance = null;
    }
}

