/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.script.ScriptException;
import oracle.dbtools.app.Completer;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.app.CompletionList;
import oracle.dbtools.app.JSCompleter;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RecognizedRule;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.mysql.MysqlEarley;
import oracle.dbtools.parser.plsql.BasicTabCol;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.scripting.GlobalMap;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Messages;
import oracle.dbtools.util.Service;

public class SqlCompleter
extends Completer {
    public String lastFunctionCallName;
    protected static final String color32 = "\u001b[32m";
    protected static final String color1 = "\u001b[1m";
    protected static final String color0 = "\u001b[0m";
    Earley earley = null;
    public int editorOffset = -1;
    static IProgram programInstance = null;
    Dialect dialect = null;
    private Connection _conn = null;
    public static long thresholdWeightFactor = 133640L;
    public static int maxKeywordSuggestions = 10;
    public static int maxRuleSuggestions = 3;
    static final String missingId = "MISSING_ID";
    public static boolean reportedNoJSEngineAvailable = false;
    public static int maxUsers = 20;
    public static int maxObjects = 50;
    static final String MySQL = "MySQL";

    public static void main(String[] args) throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/xe", "hr", "hr");
        SqlCompleter c = new SqlCompleter(conn);
        String input = Service.readFile(SqlCompleter.class, "example.sql");
        int pos = input.indexOf("!");
        pos = 100;
        input = input.replace("!", "");
        System.out.println("pos=" + pos);
        CompletionList candidates = c.complete(input, pos);
        System.out.println("offset=" + c.editorOffset);
        System.out.println(candidates.toString());
    }

    public SqlCompleter(Connection conn) {
        this._conn = conn;
    }

    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    public Set<Long> predict(int pos, Matrix matrix) {
        return this.earley.predict(pos, matrix);
    }

    String condition() {
        if (this.dialect == Dialect.MySQL) {
            return "predicate";
        }
        return "condition";
    }

    String cmp_op() {
        if (this.dialect == Dialect.MySQL) {
            return "comparisonOperator";
        }
        return "cmp_op";
    }

    String paren_expr_list() {
        if (this.dialect == Dialect.MySQL) {
            return "functionCall";
        }
        return "paren_expr_list";
    }

    String expr() {
        if (this.dialect == Dialect.MySQL) {
            return "expression";
        }
        return "expr";
    }

    String stmt() {
        if (this.dialect == Dialect.MySQL) {
            return "procedureSqlStatement";
        }
        return "stmt";
    }

    String table_reference() {
        if (this.dialect == Dialect.MySQL) {
            return "tableSource";
        }
        return "table_reference";
    }

    String dml_table_expression_clause() {
        if (this.dialect == Dialect.MySQL) {
            return "tableSource";
        }
        return "dml_table_expression_clause";
    }

    String column() {
        if (this.dialect == Dialect.MySQL) {
            return "fullColumnName";
        }
        return "column";
    }

    public List<RecognizedRule> topRuleSuggestions(SyntaxError err, LexerToken prefix, List<LexerToken> src) {
        int N = 100;
        List<RecognizedRule> tmp = err.topNrules(100, false, prefix == null ? null : prefix.content);
        long cutWeight = -1L;
        LinkedList<RecognizedRule> ret = new LinkedList<RecognizedRule>();
        int i = 0;
        for (RecognizedRule rr : tmp) {
            if (cutWeight == -1L) {
                cutWeight = rr.weight / thresholdWeightFactor;
            }
            if (rr.weight < cutWeight || maxKeywordSuggestions <= i) break;
            if (!rr.isKeyword()) continue;
            ret.add(rr);
            ++i;
        }
        cutWeight = -1L;
        i = 0;
        for (RecognizedRule rr : tmp) {
            if (cutWeight == -1L) {
                cutWeight = rr.weight / thresholdWeightFactor;
            }
            if (rr.weight < cutWeight || maxRuleSuggestions <= i) break;
            if (ret.contains(rr)) continue;
            rr.head = this.sugarcoatSymbol(rr.head);
            rr.rhs[0] = this.sugarcoatSymbol(rr.rhs[0]);
            ret.add(rr);
            ++i;
        }
        return ret;
    }

    public Set<String> topKWsuggestions(Set<Long> suggestions, LexerToken prefix) {
        TreeMap<Long, Integer> topN = new TreeMap<Long, Integer>();
        int N = 7;
        for (long entry : suggestions) {
            String string;
            String sym;
            Object prefixKW = "'";
            if (prefix != null) {
                prefixKW = "'" + prefix.content;
            }
            if (!(sym = this.earley.allSymbols[Service.lX(entry)]).startsWith(((String)prefixKW).toUpperCase()) || sym.length() < 4 && !"'*'".equals(sym) && !"'-'".equals(sym) || (string = this.earley.allSymbols[Service.lY(entry)]).endsWith("]\"") && 2 + sym.length() < string.length()) continue;
            long minVar = -1L;
            int minVal = Integer.MAX_VALUE;
            Iterator iterator = topN.keySet().iterator();
            while (iterator.hasNext()) {
                long s = (Long)iterator.next();
                int tmp = (Integer)topN.get(s);
                if (tmp >= minVal) continue;
                minVar = s;
                minVal = tmp;
            }
            long suggestedVar = entry;
            Integer suggestedVal = HarvestDoc.getFrequencies().get(entry);
            if (suggestedVal == null) {
                suggestedVal = 0;
            }
            if (topN.size() == 7) {
                if (suggestedVal == null || minVal >= suggestedVal) continue;
                topN.remove(minVar);
                topN.put(suggestedVar, suggestedVal);
                continue;
            }
            topN.put(suggestedVar, suggestedVal);
        }
        ArrayList myList = new ArrayList();
        for (Map.Entry e : topN.entrySet()) {
            myList.add(e);
        }
        Collections.sort(myList, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry a, Map.Entry b) {
                return ((Integer)b.getValue()).compareTo((Integer)a.getValue());
            }
        });
        int div = 0;
        if (prefix != null) {
            div = prefix.content.length();
        }
        TreeSet<String> ret = new TreeSet<String>();
        int i = 0;
        for (Map.Entry entry : myList) {
            if (7 < i) break;
            String sugg = this.earley.allSymbols[Service.lX((Long)entry.getKey())];
            sugg = sugg.substring(1, sugg.length() - 1);
            if ("true".equals(HiddenParameters.parameters.get("coloredComplete"))) {
                String pre = sugg.substring(0, div);
                String post = sugg.substring(div);
                ret.add(color0 + pre + color32 + post + color0);
            } else {
                ret.add(sugg);
            }
            ++i;
        }
        return ret;
    }

    public String sugarcoatSymbol(String s) {
        if (s.startsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        int pos = s.indexOf(91);
        if (0 < pos) {
            return s.substring(0, pos);
        }
        return s;
    }

    private void printRules(Collection<RecognizedRule> rules, String symbol) {
        int i = -1;
        for (RecognizedRule r : rules) {
            ++i;
            if (!r.head.contains(symbol)) continue;
            System.out.println("i=" + i + "    " + r.toString() + " , weight=" + r.weight);
        }
    }

    private Set<RecognizedRule> inline(Collection<RecognizedRule> input, Matrix matrix, List<LexerToken> src) {
        TreeSet<RecognizedRule> ret = new TreeSet<RecognizedRule>();
        for (RecognizedRule rr : input) {
            ret.addAll(this.inlineRecognized(rr, matrix, src));
            ret.addAll(this.inlineAtPos(rr, matrix, src));
        }
        return ret;
    }

    private List<RecognizedRule> inlineRecognized(RecognizedRule input, Matrix matrix, List<LexerToken> src) {
        LinkedList<RecognizedRule> ret = new LinkedList<RecognizedRule>();
        if (input.X == input.Y) {
            return ret;
        }
        Parser.EarleyCell cell = matrix.get(input.X, input.Y);
        ParseNode node = this.earley.treeForACell(src, matrix, cell, input.X, input.Y);
        LinkedList<String> rhs = node.flatten();
        ret.add(new RecognizedRule(input, rhs.toArray(new String[0]), null));
        return ret;
    }

    private List<RecognizedRule> inlineAtPos(RecognizedRule input, Matrix matrix, List<LexerToken> src) {
        LinkedList<RecognizedRule> ret = new LinkedList<RecognizedRule>();
        String symbol = input.rhs[input.pos];
        if ("...".equals(symbol)) {
            return ret;
        }
        int code = (Integer)SqlEarley.getInstance().symbolIndexes.get(symbol);
        Map<Integer, DocURL> railroads = HarvestDoc.getRailroads();
        DocURL tdoc = railroads.get(code);
        if (!(tdoc != null || symbol.charAt(0) == '\'' || "identifier".equals(symbol) || "digits".equals(symbol) || "boolean".equals(symbol) || "path".equals(symbol) || "url".equals(symbol))) {
            Parser.Tuple[] tuples = SqlEarley.getInstance().rules;
            for (int i = 0; i < tuples.length; ++i) {
                Parser.Tuple candidate = tuples[i];
                if (candidate.head != code) continue;
                ret.add(new RecognizedRule(input, input.pos, candidate.rhs, candidate.head));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public CompletionList complete(String input, int pos) {
        CompletionList completionList;
        if (((String)input).length() < pos) {
            pos = ((String)input).length();
        }
        if (this.dialect == null) {
            try {
                Connection conn = this.getConnection();
                String vendor = conn.getMetaData().getDatabaseProductName();
                this.dialect = MySQL.equals(vendor) ? Dialect.MySQL : Dialect.ORACLE;
            }
            catch (Throwable conn) {
                // empty catch block
            }
        }
        CompletionList ret = new CompletionList();
        this.earley = SqlEarley.partialRecognizer();
        if (this.dialect == Dialect.MySQL) {
            try {
                this.earley = new MysqlEarley();
            }
            catch (Throwable vendor) {
                // empty catch block
            }
        }
        if (this.dialect != Dialect.MySQL) {
            try {
                for (CompletionItem c : new JSCompleter(this.earley).complete((String)input, pos)) {
                    ret.add(c);
                }
            }
            catch (Throwable vendor) {
                // empty catch block
            }
        }
        try {
            Object pkg;
            String prefix;
            Object dot;
            Iterator<Long> predictions;
            SyntaxError error;
            List<LexerToken> src;
            int lexOptions = 55;
            if (this.dialect == Dialect.MySQL) {
                lexOptions = 311;
            }
            if (0 == (src = Lexer.parse((String)input, false, lexOptions)).size()) {
                CompletionList completionList2 = ret;
                return completionList2;
            }
            LexerToken tmp = LexerToken.getTokenAtCharOffset(src, pos);
            if (tmp.posInsideLiteral(pos)) {
                CompletionList completionList3 = ret;
                return completionList3;
            }
            Matrix matrix = new Matrix(this.earley);
            this.earley.parse(src, matrix);
            String[] toRecognize = new String[]{"sql_statements", "select", "insert", "update", "delete", "merge"};
            if (this.dialect == Dialect.MySQL) {
                toRecognize = new String[]{"sqlStatements"};
            }
            if ((error = SyntaxError.checkSyntax((String)input, toRecognize, src, this.earley, matrix, "^^^", "SyntaxError_DetailedMessage")) != null) {
                int select = -1;
                int from = -1;
                for (LexerToken t : src) {
                    if ("select".equalsIgnoreCase(t.content) && t.end < pos) {
                        select = t.end;
                    }
                    if (0 > select || !"from".equalsIgnoreCase(t.content)) continue;
                    if (pos < t.begin) {
                        from = t.begin;
                        break;
                    }
                    select = -1;
                }
                if (0 <= select && 0 <= from) {
                    input = ((String)input).substring(0, select) + " * " + ((String)input).substring(from);
                    src = Lexer.parse((String)input, false, lexOptions);
                    pos = select + 1;
                } else {
                    this.editorOffset = LexerToken.char2lex(src, pos);
                    LexerToken cur = null;
                    if (this.editorOffset < src.size()) {
                        cur = src.get(this.editorOffset);
                    }
                    Set<Long> predicted = this.predict(this.editorOffset, matrix);
                    predictions = new TreeSet<String>();
                    for (long key : predicted) {
                        predictions.add((Long)((Object)this.earley.allSymbols[Service.lX(key)]));
                    }
                    TreeSet<String> predictions1 = new TreeSet<String>();
                    if (this.editorOffset + 1 < src.size()) {
                        for (long key : this.predict(this.editorOffset + 1, matrix)) {
                            predictions1.add(this.earley.allSymbols[Service.lX(key)]);
                        }
                    }
                    if (predictions1.contains("';'")) {
                        String extra = "; ";
                        input = ((String)input).substring(0, pos) + extra + ((String)input).substring(pos);
                        src = Lexer.parse((String)input, false, lexOptions);
                    } else if (predictions.contains(this.condition()) || predictions.contains(this.cmp_op())) {
                        Object extra = "=1 ";
                        if (cur == null || pos < cur.begin || cur.end < pos || ".".equals(cur.content)) {
                            extra = " MISSING_ID" + (String)extra;
                        }
                        input = ((String)input).substring(0, pos) + (String)extra + ((String)input).substring(pos);
                        src = Lexer.parse((String)input, false, lexOptions);
                    } else if (predictions.contains("identifier") && (cur == null || !cur.incomplete())) {
                        String extra = " MISSING_ID";
                        if (2 < this.editorOffset) {
                            Set<Long> predicted2 = this.predict(this.editorOffset - 2, matrix);
                            TreeSet<String> predictions2 = new TreeSet<String>();
                            Iterator<Object> iterator = predicted2.iterator();
                            while (iterator.hasNext()) {
                                long key = iterator.next();
                                predictions2.add(this.earley.allSymbols[Service.lX(key)]);
                            }
                            if (predictions2.contains(this.condition()) || predictions2.contains(this.cmp_op())) {
                                extra = " MISSING_ID=1 ";
                            }
                        }
                        input = ((String)input).substring(0, pos) + extra + " " + ((String)input).substring(pos);
                        src = Lexer.parse((String)input, false, lexOptions);
                    } else if (predictions.contains(this.paren_expr_list())) {
                        String extra = ");";
                        input = ((String)input).substring(0, pos) + extra + ((String)input).substring(pos);
                        src = Lexer.parse((String)input, false, lexOptions);
                    }
                }
            }
            Parsed target = new Parsed((String)input, src, this.earley, (String)null);
            this.editorOffset = LexerToken.char2lex(src, pos);
            if (this.editorOffset < src.size() && src.get((int)this.editorOffset).begin < pos && pos <= src.get((int)this.editorOffset).end) {
                ret.prefix = src.get(this.editorOffset);
            }
            if (!(ret.prefix == null || ret.prefix.type != Token.OPERATION || ret.prefix.content.equals(":") || ret.prefix.content.equals("!") || ret.prefix.content.equals("^"))) {
                ret.prefix = null;
                ++this.editorOffset;
            }
            if ("*".equals(ret.prefix)) {
                ret.prefix = null;
                --this.editorOffset;
            }
            if (4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("desc") || 3 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 3).equalsIgnoreCase("ddl") || 4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("info") || 4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("ctas")) {
                String pref = "";
                if (ret.prefix != null) {
                    pref = ret.prefix.content;
                    if (pos < ret.prefix.end) {
                        pref = pref.substring(0, pos - ret.prefix.begin);
                    }
                }
                String owner = null;
                String obj = pref;
                if (2 < src.size() && ".".equals(src.get((int)2).content)) {
                    owner = src.get((int)1).content.toUpperCase();
                }
                for (CompletionItem sugg : this.queryObjects(owner, obj.toUpperCase(), "")) {
                    ret.add(sugg);
                }
                ret.pos = pos - pref.length();
                predictions = ret;
                return predictions;
            }
            int div = 0;
            if (ret.prefix != null) {
                div = ret.prefix.content.length();
            }
            Set<Long> predicted = this.predict(this.editorOffset, target.getMatrix());
            TreeSet<String> predictions2 = new TreeSet<String>();
            for (long key : predicted) {
                predictions2.add(this.earley.allSymbols[Service.lX(key)]);
            }
            HashMap<String, String> alias2table = new HashMap<String, String>();
            Map<String, MaterializedPredicate> output = null;
            if (predictions2.contains(this.expr()) || predictions2.contains("identifier") && predictions2.contains(this.stmt())) {
                if (output == null) {
                    output = this.getProgram(this.earley).eval(target, this);
                }
                MaterializedPredicate vars = (MaterializedPredicate)output.get("localVars");
                for (Tuple t : vars.getTuples()) {
                    ParseNode id = vars.getAttribute(t, "id");
                    String name = src.get((int)id.from).content;
                    ret.add(new CompletionItem(name, CompletionItem.Type.COLUMN));
                }
            }
            if (!predictions2.contains(this.table_reference()) && !predictions2.contains(this.dml_table_expression_clause())) {
                MaterializedPredicate connect;
                Iterator<Tuple> predicted2;
                if (output == null) {
                    output = this.getProgram(this.earley).eval(target, this);
                }
                if (this.dialect != Dialect.MySQL && (predicted2 = (connect = output.get("connect")).getTuples().iterator()).hasNext()) {
                    Tuple t;
                    t = predicted2.next();
                    ParseNode command = connect.getAttribute(t, "command");
                    String pref = src.get((int)(command.from + 1)).content;
                    if (missingId.equals(pref)) {
                        pref = "";
                    }
                    for (String sugg : NetEntries.getMatching(pref)) {
                        ret.add(new CompletionItem(sugg, CompletionItem.Type.TURLNET));
                    }
                    CompletionList completionList4 = ret;
                    return completionList4;
                }
                MaterializedPredicate tanqb = output.get("\"table_alias in widest qb\"");
                for (Tuple t : tanqb.getTuples()) {
                    ParseNode tst;
                    String tableExpr;
                    ParseNode table = tanqb.getAttribute(t, "table");
                    ParseNode alias = tanqb.getAttribute(t, "alias");
                    if (table.from + 1 == table.to && alias.from + 1 == alias.to) {
                        alias2table.put(src.get((int)alias.from).content.toUpperCase(), src.get((int)table.from).content.toUpperCase());
                    }
                    String _alias = "'" + src.get((int)alias.from).content.toUpperCase() + "'";
                    List<LexerToken> _src = src.subList(0, alias.from);
                    Matrix _matrix = new Matrix(this.earley);
                    this.earley.parse(_src, _matrix);
                    Set<Long> _predicted = this.predict(alias.from, _matrix);
                    TreeSet<String> _predictions = new TreeSet<String>();
                    for (long key : _predicted) {
                        _predictions.add(this.earley.allSymbols[Service.lX(key)]);
                    }
                    if (_predictions.contains(_alias)) {
                        alias = table;
                    }
                    int begin = src.get((int)table.from).begin;
                    int end = src.get((int)(table.to - 1)).end;
                    String owner = null;
                    String tab = null;
                    if (ret.prefix != null) {
                        tab = ret.prefix.content;
                        if (pos < ret.prefix.end) {
                            tab = tab.substring(0, pos - ret.prefix.begin);
                        }
                    }
                    if (0 < (tableExpr = target.getInput().substring(begin, end)).indexOf(46)) {
                        owner = tableExpr.substring(0, tableExpr.indexOf(46));
                        tab = tableExpr.substring(tableExpr.indexOf(46) + 1);
                    } else {
                        owner = null;
                        tab = tableExpr;
                    }
                    if (table == alias && table.to < src.size() && ".".equals(src.get((int)table.to).content)) {
                        owner = tableExpr;
                        tab = "";
                        ret.prefix = null;
                    }
                    tab = tab.trim();
                    String aliased = src.get((int)alias.from).content + ".";
                    TreeSet<String> predictions22 = new TreeSet<String>();
                    if (predictions2.contains("identifier") && 1 < this.editorOffset) {
                        Set<Long> predicted22 = this.predict(this.editorOffset - 2, target.getMatrix());
                        for (long key : predicted22) {
                            predictions22.add(this.earley.allSymbols[Service.lX(key)]);
                        }
                    }
                    if (predictions2.contains(this.column()) || predictions22.contains(this.column())) {
                        String prefix2 = null;
                        if (ret.prefix != null) {
                            if (alias == table) {
                                prefix2 = ret.prefix.content;
                            }
                            if (0 < this.editorOffset && ".".equals(src.get((int)(this.editorOffset - 1)).content)) {
                                prefix2 = ret.prefix.content;
                            }
                        }
                        boolean isJoin = false;
                        for (LexerToken lexerToken : target.getSrc()) {
                            if (!"JOIN".equalsIgnoreCase(lexerToken.content)) continue;
                            isJoin = true;
                            break;
                        }
                        for (String string : this.queryColumns(owner, tab, prefix2)) {
                            void var30_77;
                            if (1 < tanqb.cardinality() || isJoin) {
                                String string2 = aliased + string;
                                div += aliased.length();
                            }
                            ret.add(new CompletionItem((String)var30_77, CompletionItem.Type.COLUMN));
                        }
                        if (prefix2 != null) {
                            for (CompletionItem completionItem : this.queryObjects(null, prefix2.toUpperCase(), "object_type in ('SEQUENCE') and")) {
                                ret.add(completionItem);
                            }
                        }
                        Map<String, ParseNode> inlineViews = BasicTabCol.getInlineViewNodes(target.getRoot(), target.getSrc());
                        block34: for (String key : inlineViews.keySet()) {
                            ParseNode candidate = inlineViews.get(key);
                            if (candidate == null) {
                                candidate = inlineViews.get("inline subquery");
                            }
                            ParseNode inlineViewSelectList = BasicTabCol.getSelectList(candidate);
                            ArrayList<BasicTabCol.Column> inlineViewColumns = BasicTabCol.extractColumns(inlineViewSelectList, target.getSrc(), false, false);
                            for (int i = 0; i < inlineViewColumns.size(); ++i) {
                                BasicTabCol.Column c = inlineViewColumns.get(i);
                                String colName = c.alias;
                                if (colName == null) {
                                    ParseNode cExpr = c.colExpr;
                                    if (cExpr == null || cExpr.to - cExpr.from != 3 && cExpr.to - cExpr.from != 1) continue block34;
                                    colName = target.getSrc().get((int)(cExpr.to - 1)).content;
                                }
                                ret.add(new CompletionItem(colName, CompletionItem.Type.COLUMN));
                            }
                        }
                    }
                    boolean ok = true;
                    for (String symbol : predictions2) {
                        if (!symbol.startsWith("where_clause") && !symbol.startsWith("\"fromClause[7,14)\"")) continue;
                        ok = false;
                        break;
                    }
                    if (!ok || (tst = target.getRoot().descendant(this.editorOffset, this.editorOffset, this.earley.getSymbol(this.table_reference()))) == null || tst.to > tst.from + 4) continue;
                    for (CompletionItem completionItem : this.queryObjects(owner, tab.toUpperCase(), "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                        ret.add(completionItem);
                    }
                }
            } else {
                String prefix3 = "";
                if (ret.prefix != null) {
                    prefix3 = ret.prefix.content;
                    if (pos < ret.prefix.end) {
                        prefix3 = prefix3.substring(0, pos - ret.prefix.begin);
                    }
                }
                for (CompletionItem sugg : this.queryObjects(null, prefix3, "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                    ret.add(sugg);
                }
            }
            if ((predictions2.contains("function_call") || predictions2.contains("decl_id")) && 2 <= this.editorOffset && ".".equals(dot = src.get((int)(this.editorOffset - 1)).content)) {
                String pkg2 = src.get((int)(this.editorOffset - 2)).content;
                prefix = "";
                if (ret.prefix != null) {
                    prefix = ret.prefix.content;
                    if (pos < ret.prefix.end) {
                        prefix = prefix.substring(0, pos - ret.prefix.begin);
                    }
                }
                for (CompletionItem sugg : this.queryPackageProcedures(null, pkg2, prefix)) {
                    ret.add(sugg);
                }
            }
            if (predictions2.contains(this.condition())) {
                for (CompletionItem item : this.joinConditions(ret.entries, alias2table)) {
                    ret.add(item);
                }
            }
            if (this.lastFunctionCallName != null && predictions2.contains("arg")) {
                pkg = null;
                String fun = null;
                if (0 < this.lastFunctionCallName.indexOf(46)) {
                    pkg = this.lastFunctionCallName.substring(0, this.lastFunctionCallName.indexOf(46));
                    fun = this.lastFunctionCallName.substring(this.lastFunctionCallName.indexOf(46) + 1);
                } else {
                    pkg = null;
                    fun = this.lastFunctionCallName;
                }
                prefix = "";
                if (ret.prefix != null) {
                    prefix = ret.prefix.content;
                }
                for (String sugg : this.inlineArguments(this.queryArguments((String)pkg, fun, prefix))) {
                    ret.add(new CompletionItem(sugg, CompletionItem.Type.ARGUMENT));
                }
            }
            if (ret.size() == 0) {
                for (String sugg : this.topKWsuggestions(predicted, ret.prefix)) {
                    ret.add(new CompletionItem(sugg, CompletionItem.Type.KEYWORD));
                }
            }
            if (ret.size() == 1 && 0 < ret.first().toString().indexOf(32)) {
                pkg = ret;
                return pkg;
            }
            int p = pos;
            if (ret.prefix != null) {
                p = pos - ret.prefix.content.length();
            }
            ret.pos = p;
            CompletionList completionList5 = ret;
            return completionList5;
        }
        catch (SQLRecoverableException e) {
            completionList = ret;
            return completionList;
        }
        catch (Throwable t) {
            t.printStackTrace();
            completionList = ret;
            return completionList;
        }
        finally {
            if (programInstance != null && programInstance.getEngine() == null && !reportedNoJSEngineAvailable) {
                Logger.warn(SqlCompleter.class, Messages.get("NoJSEngineAvailable"));
                reportedNoJSEngineAvailable = true;
            }
        }
    }

    public void addSuggestionItem(CompletionList ret, RecognizedRule sugg) {
        String symbol = sugg.rhs[sugg.pos];
        if (symbol.charAt(0) == '\'') {
            ret.add(new CompletionItem(symbol.substring(1, symbol.length() - 1), CompletionItem.Type.KEYWORD));
        }
    }

    private IProgram getProgram(Earley earley) throws IOException {
        if (programInstance == null) {
            String file = "completion.prg";
            if (this.dialect == Dialect.MySQL) {
                file = "completion_mysql.prg";
            }
            programInstance = new IProgram(earley, Service.readFile(SqlCompleter.class, file));
        }
        SqlCompleter.programInstance.offset = this.editorOffset;
        GlobalMap globals = programInstance.getGlobals();
        if (globals != null) {
            globals.put("editorOffset", (Object)this.editorOffset);
        }
        return programInstance;
    }

    public static String discolor(String cleaned) {
        cleaned = cleaned.replace(color0, "");
        cleaned = cleaned.replace(color1, "");
        cleaned = cleaned.replace(color32, "");
        return cleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CompletionItem> queryObjects(String Owner, String prefix, String typesClause) throws SQLException {
        String owner;
        Connection conn = this.getConnection();
        if (conn == null) {
            return new LinkedList<CompletionItem>();
        }
        if (missingId.equals(prefix)) {
            prefix = "";
        }
        String query = this.objectsDictSql(typesClause);
        if (Owner != null) {
            query = this.objectsByOwnerDictSql(typesClause);
        }
        if ((owner = Owner) != null) {
            owner = Owner.toUpperCase();
            if (this.dialect == Dialect.MySQL) {
                owner = Owner.toLowerCase();
            }
        }
        if (2 < prefix.length() && this.dialect != Dialect.MySQL) {
            query = query.replace("owner=user", "owner in ('PUBLIC','SYS',user)");
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner);
        } else if (this.dialect != Dialect.MySQL) {
            stmt.setObject(pos++, this.prefixWildcard + prefix.toUpperCase().replace("_", "\\_") + "%");
        }
        stmt.setObject(pos++, this.prefixWildcard + prefix.toUpperCase().replace("_", "\\_") + "%");
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<CompletionItem> users = new LinkedList<CompletionItem>();
            LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
            while (rs.next()) {
                String candidate = rs.getString(1);
                String type = rs.getString(2);
                if (candidate.endsWith(".")) {
                    users.add(new CompletionItem(candidate, CompletionItem.Type.USER));
                    continue;
                }
                if ("TABLE".equalsIgnoreCase(type) || "BASE TABLE".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.TABLE);
                    continue;
                }
                if ("VIEW".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.VIEW);
                    continue;
                }
                if ("SYNONYM".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.SYNONYM);
                    continue;
                }
                if ("PROCEDURE".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.PROCEDURE);
                    continue;
                }
                if ("FUNCTION".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.FUNCTION);
                    continue;
                }
                if ("PACKAGE".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.PACKAGE);
                    continue;
                }
                if ("PACKAGE BODY".equalsIgnoreCase(type)) {
                    this.addUnique(rs, ret, CompletionItem.Type.PACKAGE_BODY);
                    continue;
                }
                if ("SEQUENCE".equalsIgnoreCase(type)) {
                    this.addUnique(candidate + ".nextval", ret, CompletionItem.Type.SEQUENCE);
                    continue;
                }
                if ("INDEX".equalsIgnoreCase(type)) {
                    this.addUnique(candidate, ret, CompletionItem.Type.INDEX);
                    continue;
                }
                ret.add(new CompletionItem(candidate, CompletionItem.Type.OTHER_DB_OBJECT));
            }
            if (users.size() < maxUsers) {
                ret.addAll(users);
            }
            LinkedList<CompletionItem> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String objectsByOwnerDictSql(String typesClause) throws SQLException {
        if (this.dialect == Dialect.MySQL) {
            return "SELECT upper(table_name) object_name,\n    table_type\nFROM information_schema.tables\nWHERE table_schema = ?\nAND table_name like ? \nORDER BY table_name";
        }
        return "select object_name, object_type from all_objects \nwhere " + typesClause + " owner = :1 and object_name like :2 ESCAPE '\\' \nand rownum < " + maxObjects + " order by object_name";
    }

    public String objectsDictSql(String typesClause) throws SQLException {
        Connection conn = this.getConnection();
        if (this.dialect == Dialect.MySQL) {
            String database = conn.getCatalog();
            return "SELECT upper(table_name) object_name,\n    table_type\nFROM information_schema.tables\nWHERE table_schema = '" + database + "'\nAND table_name like ? \nORDER BY table_name";
        }
        return "select /*distinct*/ object_name, object_type from all_objects \nwhere " + typesClause + " owner=user \nand object_name like :1 ESCAPE '\\' and rownum < 50\nunion all \nselect username||'.', 'USER' from all_users where username like :2 and rownum <= " + maxUsers + " \norder by object_name";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> queryColumns(String Owner, String Table2, String prefix) throws SQLException {
        String table;
        Connection conn = this.getConnection();
        if (conn == null) {
            return new LinkedList<String>();
        }
        String owner = Owner;
        if (owner != null) {
            owner = Owner.toUpperCase();
            if (this.dialect == Dialect.MySQL) {
                owner = Owner.toLowerCase();
            }
        }
        if ((table = Table2) != null) {
            table = Table2.toUpperCase();
            if (this.dialect == Dialect.MySQL) {
                table = Table2.toLowerCase();
            }
        }
        if (missingId.equals(prefix)) {
            prefix = "";
        }
        String query = this.columnsDictSql();
        if (owner != null) {
            query = this.columnsByOwnerDictSql();
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner);
        }
        stmt.setObject(pos++, table);
        if (prefix != null && 0 < prefix.length()) {
            stmt.setObject(pos++, this.prefixWildcard + prefix.toUpperCase() + "%");
        } else {
            stmt.setObject(pos++, "%");
        }
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<String> ret = new LinkedList<String>();
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String columnsByOwnerDictSql() throws SQLException {
        Connection conn = this.getConnection();
        if (MySQL.equals(conn.getMetaData().getDatabaseProductName())) {
            return "SELECT upper(column_name) column_name\nFROM information_schema.columns\nWHERE table_schema = ? AND table_name = ? AND column_name like ? \nORDER BY column_name";
        }
        return "select column_name from all_tab_columns where owner = :1 and table_name = :2 \nand column_name like :2 and rownum < 50 order by column_name\n";
    }

    public String columnsDictSql() throws SQLException {
        Connection conn = this.getConnection();
        if (MySQL.equals(conn.getMetaData().getDatabaseProductName())) {
            String database = conn.getCatalog();
            return "SELECT upper(column_name) column_name\nFROM information_schema.columns\nWHERE table_schema = '" + database + "'\nAND table_name = ? AND column_name like ? \nORDER BY column_name";
        }
        return "select column_name from all_tab_columns where table_name = :1 and owner in ('PUBLIC','SYS',user) \nand column_name like :2 and rownum < 50 order by column_name\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CompletionItem> queryPackageProcedures(String owner, String pkg, String prefix) throws SQLException {
        Connection conn;
        if (missingId.equals(prefix)) {
            prefix = "";
        }
        String query = "select procedure_name from sys.all_procedures where object_name = :1 and owner in ('PUBLIC','SYS',user) \nand procedure_name like :2 and rownum < 50 order by procedure_name\n";
        if (owner != null) {
            query = "select column_name from sys.all_procedures where owner = :1 and object_name = :2 \nand procedure_name like :2 and rownum < 50 order by procedure_name\n";
        }
        if ((conn = this.getConnection()) == null) {
            return new LinkedList<CompletionItem>();
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner.toUpperCase());
        }
        stmt.setObject(pos++, pkg.toUpperCase());
        if (prefix != null && 0 < prefix.length()) {
            stmt.setObject(pos++, this.prefixWildcard + prefix.toUpperCase() + "%");
        } else {
            stmt.setObject(pos++, "%");
        }
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
            while (rs.next()) {
                this.addUnique(rs, ret, CompletionItem.Type.PROCEDURE);
            }
            LinkedList<CompletionItem> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> queryArguments(String pkg, String function, String prefix) throws SQLException {
        if (missingId.equals(prefix)) {
            prefix = "";
        }
        Object query = "SELECT  a.owner||'.'||a.package_name||'.'||a.object_name||'.'||a.overload object_name, \n a.argument_name||'=>'||substr(a.argument_name,1,1)||'/*'||a.data_type||' '||a.defaulted||'*/' argument, a.position position \nFROM all_arguments a \nWHERE rownum <=50 and    argument_name is not null \n";
        query = pkg != null ? (String)query + "and package_name = :1 and object_name = :2  and argument_name like :3 \norder by position \n" : (String)query + "and  object_name = :1 and owner in ('PUBLIC','SYS',user) \n and argument_name like :2 order by position";
        Connection conn = this.getConnection();
        if (conn == null) {
            return new LinkedList<String>();
        }
        PreparedStatement stmt = conn.prepareStatement((String)query);
        int pos = 1;
        if (pkg != null) {
            stmt.setObject(pos++, pkg.toUpperCase());
        }
        stmt.setObject(pos++, function.toUpperCase());
        if (prefix != null && 0 < prefix.length()) {
            stmt.setObject(pos++, this.prefixWildcard + prefix.toUpperCase() + "%");
        } else {
            stmt.setObject(pos++, "%");
        }
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<String> ret = new LinkedList<String>();
            while (rs.next()) {
                String a = rs.getString(2);
                if (ret.contains(a)) continue;
                ret.add(a);
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private List<String> inlineArguments(List<String> arguments) {
        LinkedList<String> ret = new LinkedList<String>();
        StringBuilder fullArgs = new StringBuilder();
        StringBuilder shortArgs = new StringBuilder();
        for (String arg : arguments) {
            boolean isDefault = 0 < arg.indexOf(" Y*/");
            arg = arg.replace(" Y*/", "*/");
            arg = arg.replace(" N*/", "*/");
            if (fullArgs.length() > 0) {
                fullArgs.append(",");
            }
            fullArgs.append(arg);
            if (isDefault) continue;
            if (shortArgs.length() > 0) {
                shortArgs.append(",");
            }
            shortArgs.append(arg);
        }
        if (fullArgs.length() != shortArgs.length()) {
            ret.add("/*min sig:*/" + shortArgs.toString());
            ret.add("/*full sig:*/" + fullArgs.toString());
        } else {
            ret.add(fullArgs.toString());
        }
        return ret;
    }

    private void addUnique(ResultSet rs, List<CompletionItem> ret, CompletionItem.Type type) throws SQLException {
        String candidate = rs.getString(1);
        if (!candidate.endsWith(".")) {
            candidate = Service.addDoubleQuote(candidate);
        }
        this.addUnique(candidate, ret, type);
    }

    private void addUnique(String name, List<CompletionItem> ret, CompletionItem.Type type) {
        CompletionItem item = new CompletionItem(name, type);
        if (!ret.contains(item)) {
            // empty if block
        }
        ret.add(item);
    }

    private List<CompletionItem> joinConditions(List<CompletionItem> items, Map<String, String> alias2table) {
        LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
        int cnt = 0;
        block0: for (CompletionItem first : items) {
            String firstName = first.entry;
            int fi = firstName.indexOf(46);
            if (fi <= 0 || !CompletionItem.Type.COLUMN.equals((Object)first.type)) continue;
            for (CompletionItem second : items) {
                String secondName = second.entry;
                int si = secondName.indexOf(46);
                if (si <= 0 || firstName.compareTo(secondName) <= 0 || !CompletionItem.Type.COLUMN.equals((Object)first.type) || !this.colNamesMatch(firstName, secondName, alias2table)) continue;
                ret.add(new CompletionItem(firstName + " = " + secondName, CompletionItem.Type.CONDITION));
                if (++cnt <= 50) continue;
                break block0;
            }
        }
        return ret;
    }

    private boolean colNamesMatch(String firstCol, String secondCol, Map<String, String> alias2table) {
        int fi = firstCol.indexOf(46);
        int si = secondCol.indexOf(46);
        String firstNAME = firstCol.substring(fi + 1).toUpperCase();
        String secondNAME = secondCol.substring(si + 1).toUpperCase();
        if (firstNAME == null) {
            return false;
        }
        if (firstNAME.equals(secondNAME)) {
            return true;
        }
        String firstTABLE = alias2table.get(firstCol.substring(0, fi).toUpperCase()).toUpperCase();
        String secondTABLE = alias2table.get(secondCol.substring(0, si).toUpperCase()).toUpperCase();
        return firstNAME.startsWith(firstTABLE) && secondNAME.equals(firstNAME + "_ID") || firstNAME.startsWith(firstTABLE) && secondNAME.equals(firstNAME + "_NAME") || secondNAME.startsWith(secondTABLE) && firstNAME.equals(secondNAME + "_ID") || secondNAME.startsWith(secondTABLE) && firstNAME.equals(secondNAME + "_NAME") || this.tabColNamesMatch(firstNAME, firstTABLE) && firstNAME.endsWith("_ID") && this.tabColNamesMatch(secondNAME, secondTABLE) && secondNAME.endsWith("_ID") || this.tabColNamesMatch(firstNAME, firstTABLE) && firstNAME.endsWith("_NAME") && this.tabColNamesMatch(secondNAME, secondTABLE) && secondNAME.endsWith("_NAME");
    }

    private boolean tabColNamesMatch(String column, String table) {
        if (table.length() < 5 || column.length() < 5) {
            return false;
        }
        for (int i = 0; i < table.length() - 5; ++i) {
            String tab = table.substring(i, i + 5);
            if (!column.contains(tab)) continue;
            return true;
        }
        return false;
    }

    static class IProgram
    extends Program {
        public int offset = -1;

        private IProgram(Earley earley, String programText) throws IOException {
            super(earley, null);
            try {
                this.compile(programText, this.struct);
            }
            catch (ScriptException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static enum Dialect {
        ORACLE,
        MySQL;

    }
}

