/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

public enum PlsqlException {
    ACCESS_INTO_NULL(Cause.RECORD_ASSIGNMENT),
    CASE_NOT_FOUND(Cause.CASE_WITHOUT_ELSE),
    COLLECTION_IS_NULL(Cause.COLLECTION),
    CURSOR_ALREADY_OPEN(Cause.CURSOR_OPEN),
    DUP_VAL_ON_INDEX(Cause.SQL_INSERT),
    INVALID_CURSOR(Cause.CURSOR_ANY),
    INVALID_NUMBER(Cause.CONVERSION_TO_NUMBER),
    NO_DATA_FOUND(EnumSet.of(Cause.SINGLE_ROW_SELECT, Cause.NESTED_TABLE_READ, Cause.ASSOCIATIVE_ARRAY_READ)),
    PROGRAM_ERROR(Cause.ANY),
    ROWTYPE_MISMATCH(Cause.CURSOR_ASSIGNMENT),
    STORAGE_ERROR(Cause.ANY),
    SUBSCRIPT_BEYOND_COUNT(EnumSet.of(Cause.NESTED_TABLE_READ, Cause.VARRAY_READ)),
    SUBSCRIPT_OUTSIDE_LIMIT(EnumSet.of(Cause.NESTED_TABLE_READ, Cause.VARRAY_READ)),
    SYS_INVALID_ROWID(Cause.CONVERSION_TO_ROWID),
    TOO_MANY_ROWS(Cause.SINGLE_ROW_SELECT),
    VALUE_ERROR(Cause.CONVERSION),
    ZERO_DIVIDE(Cause.DIVISION),
    TIMEOUT_ON_RESOURCE(Cause.SQL),
    NOT_LOGGED_ON(Cause.SQL),
    LOGIN_DENIED(Cause.SQL),
    SELF_IS_NULL(Cause.MEMBER_CALL),
    USERENV_COMMITSCN_ERROR(Cause.SQL),
    NO_DATA_NEEDED(Cause.SQL),
    USER_DECLARED(Cause.EXPLICIT_THROW);

    private final EnumSet<Cause> causes;
    private static final HashMap<Cause, EnumSet<PlsqlException>> exceptionsFromCause;

    Set<Cause> getCauses() {
        return this.causes;
    }

    static EnumSet<PlsqlException> exceptionsFrom(Cause cause) {
        return exceptionsFromCause.get((Object)cause);
    }

    private PlsqlException(Cause cause) {
        this.causes = EnumSet.of(cause);
    }

    private PlsqlException(EnumSet<Cause> set) {
        this.causes = set;
    }

    static {
        exceptionsFromCause = new HashMap();
        for (Cause cause : Cause.values()) {
            exceptionsFromCause.put(cause, EnumSet.noneOf(PlsqlException.class));
        }
        for (Enum enum_ : PlsqlException.values()) {
            for (Cause cause : ((PlsqlException)enum_).getCauses()) {
                EnumSet<PlsqlException> prev = exceptionsFromCause.get((Object)cause);
                prev.add((PlsqlException)enum_);
            }
        }
    }

    static enum Cause {
        ANY,
        DIVISION,
        CONVERSION,
        CONVERSION_TO_NUMBER,
        CONVERSION_TO_ROWID,
        RECORD_ASSIGNMENT,
        CASE_WITHOUT_ELSE,
        COLLECTION,
        NESTED_TABLE_READ,
        VARRAY_READ,
        ASSOCIATIVE_ARRAY_READ,
        CURSOR_OPEN,
        CURSOR_ASSIGNMENT,
        CURSOR_ANY,
        SQL,
        SQL_INSERT,
        SINGLE_ROW_SELECT,
        MEMBER_CALL,
        EXPLICIT_THROW;

    }
}

