/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.app.injection.DependencyLink;
import oracle.dbtools.app.injection.Dotted;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.SqlInjection;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.util.Service;

public class SqlInjectionTest {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_FAILURES_LETHAL = false;
    private static final boolean DEBUG_PRINT_TEST_METADATA = false;
    private static final boolean GRAPH_BASED_INJECTION = true;

    public static void main(String[] args) throws Exception {
        try {
            SqlInjectionTest.test();
        }
        catch (Exception t) {
            System.out.println();
            System.out.flush();
            throw t;
        }
    }

    /*
     * Could not resolve type clashes
     */
    public static void test() throws Exception {
        System.out.println("Graph-based injection: true");
        String input = Service.readFile(SqlInjection.class, "graphInjectionTest.sql");
        String[] tests = input.split("\\+\\+\\+\\+\\++[ \t]*");
        input = null;
        int testNum = 0;
        int testPassed = 0;
        int testWarned = 0;
        int testPassedDespiteKnownBad = 0;
        int inexactMatches = 0;
        int testFailed = 0;
        int testSkipped = 0;
        int knownBadFailures = 0;
        int unexpectedFailures = 0;
        boolean skipAllTests = false;
        for (String test : tests) {
            int endPos;
            boolean parsed;
            if (test.matches("^[ \t]*$")) continue;
            ++testNum;
            String description = null;
            boolean injection = false;
            boolean knownBad = false;
            int expectedWarnings = 0;
            boolean skipThisTest = skipAllTests;
            ArrayList expectedInjections = new ArrayList();
            int pos = 0;
            do {
                parsed = false;
                int cutPos = endPos = test.indexOf("\n", pos);
                if (test.indexOf("\r", pos) + 1 == endPos) {
                    --cutPos;
                }
                if (endPos <= pos) break;
                String line = test.substring(pos, cutPos);
                if (description == null) {
                    description = line;
                    parsed = true;
                } else if (line.length() > 1) {
                    String[] words = line.split("[ \t]+");
                    switch (words[0].toLowerCase()) {
                        case "--": {
                            parsed = true;
                            break;
                        }
                        case "injection": {
                            injection = Boolean.valueOf(words[1]);
                            parsed = true;
                            break;
                        }
                        case "dataflow": {
                            Iterator inj = new ArrayList<DependencyLink>();
                            for (int i = 1; i < words.length; ++i) {
                                String[] dep = words[i].split(":");
                                inj.add(new DependencyLink(dep[0], new Loc(new Dotted(dep[1])), new DependencyLink.LocationTuple("", Integer.parseInt(dep[1]))));
                            }
                            expectedInjections.add(inj);
                            parsed = true;
                            break;
                        }
                        case "knownbad": {
                            knownBad = true;
                            parsed = true;
                            break;
                        }
                        case "start": {
                            skipAllTests = true;
                            skipThisTest = true;
                            parsed = true;
                            break;
                        }
                        case "stop": {
                            skipAllTests = false;
                            skipThisTest = false;
                            parsed = true;
                            break;
                        }
                        case "skip": {
                            skipThisTest = true;
                            parsed = true;
                            break;
                        }
                        case "unskip": {
                            skipThisTest = false;
                            parsed = true;
                            break;
                        }
                        default: {
                            parsed = false;
                        }
                    }
                }
                pos = endPos + 1;
            } while (parsed);
            if (skipThisTest) {
                ++testSkipped;
                continue;
            }
            System.out.println("Test " + testNum + " " + description);
            test = test.substring(pos);
            List<Object> injWarnings = Collections.emptyList();
            System.out.println(">>>>> Data being passed in");
            System.out.println(test);
            System.out.println("<<<<<");
            SqlInjectionGraph sig = new SqlInjectionGraph(test, null);
            List<List<DependencyLink>> injections = sig.getInjections();
            injWarnings = sig.getWarnings();
            for (List inj : injections) {
                System.out.println("   " + inj);
            }
            ArrayList<Object> failures = new ArrayList<Object>();
            ArrayList<Object> warnings = new ArrayList<Object>();
            if (expectedWarnings != injWarnings.size()) {
                failures.add("Expected " + expectedWarnings + " warnings but got " + injWarnings.size());
            }
            warnings.addAll(injWarnings);
            HashSet<List<DependencyLink>> unmatchedActual = new HashSet<List<DependencyLink>>(injections);
            for (List exp : expectedInjections) {
                List matchedInjection = null;
                boolean exactMatch = false;
                for (List act : unmatchedActual) {
                    if (((DependencyLink)act.get(0)).equals(exp.get(0)) && ((DependencyLink)act.get(act.size() - 1)).equals(exp.get(exp.size() - 1))) {
                        matchedInjection = act;
                        unmatchedActual.remove(act);
                        exactMatch = true;
                        if (exp.size() != act.size()) {
                            exactMatch = false;
                        } else {
                            for (int j = 0; j < act.size(); ++j) {
                                if (((DependencyLink)act.get(j)).equals(exp.get(j))) continue;
                                exactMatch = false;
                                break;
                            }
                        }
                    }
                    if (matchedInjection == null) continue;
                    break;
                }
                if (matchedInjection == null) {
                    failures.add("Did not find expected injection: " + SqlInjectionTest.toString(exp));
                    continue;
                }
                if (exactMatch) continue;
                warnings.add("Expected " + SqlInjectionTest.toString(exp) + " got " + SqlInjectionTest.toString(matchedInjection));
                ++inexactMatches;
            }
            for (List inj : unmatchedActual) {
                failures.add("Unexpected injection found: " + SqlInjectionTest.toString(inj));
            }
            if (knownBad && failures.isEmpty() && !injection) {
                ++testPassedDespiteKnownBad;
                warnings.add("**** " + description + ": Passed even though flagged 'knownbad' ****");
            }
            if (injection && injections.size() == 0) {
                failures.add("Injection(s) expected and none found");
            }
            for (String failure : failures) {
                System.out.println("FAIL: " + failure);
            }
            for (String warning : warnings) {
                System.out.println("WARN: " + warning);
            }
            if (failures.isEmpty()) {
                ++testPassed;
                System.out.println("Test " + testNum + " " + description + ": passed");
            } else {
                ++testFailed;
                System.out.println("Test " + testNum + " " + description + ": FAILED");
                if (knownBad) {
                    System.out.println("...as expected; this test is known bad");
                    ++knownBadFailures;
                } else {
                    System.out.println();
                    int linenum = 0;
                    pos = 0;
                    while (true) {
                        int cutPos = endPos = test.indexOf("\n", pos);
                        if (test.indexOf("\r", pos) + 1 == endPos) {
                            --cutPos;
                        }
                        if (endPos <= pos) break;
                        String line = test.substring(pos, cutPos);
                        System.out.println(++linenum + ": " + line);
                        pos = endPos + 1;
                    }
                    System.out.flush();
                    ++unexpectedFailures;
                }
            }
            if (!warnings.isEmpty()) {
                ++testWarned;
            }
            System.out.println();
        }
        System.out.println("====================");
        System.out.println(testNum + " tests");
        System.out.println(testPassed + " passed");
        System.out.println("   Total injections with unexpected dataflows: " + inexactMatches);
        if (testPassedDespiteKnownBad > 0) {
            System.out.println("   " + testPassedDespiteKnownBad + " of those passed tests were marked 'knownbad'. Progress!");
        }
        System.out.println(testFailed + " failed");
        System.out.println("   " + knownBadFailures + " of those were tests that we know we fail");
        System.out.println("   " + unexpectedFailures + " unexpected, oops");
        System.out.println(testWarned + " tests with warnings: (includes both passed and failed tests)");
        System.out.println(testSkipped + " skipped");
        if (testPassed + testFailed + testSkipped != testNum) {
            System.out.println("Warning: Test numbers don't add up!");
        }
    }

    private static String toString(List<DependencyLink> injection) {
        StringBuffer sb = new StringBuffer();
        String separator = "";
        for (DependencyLink dl : injection) {
            sb.append(separator + dl);
            separator = " ";
        }
        return sb.toString();
    }
}

