/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.AncestorExpr;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.AttributeDefinitions;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.True;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.util.Service;

public class IndependentAttribute
extends Attribute {
    protected MaterializedPredicate content;
    private Predicate failfastFilter = null;

    public IndependentAttribute(String name) {
        this.name = name;
    }

    public MaterializedPredicate getContent() {
        return this.content;
    }

    public void initContent(ParseNode root, List<LexerToken> src, AttributeDefinitions varDefs, String predVar) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(this.name);
        for (String candidate : varDefs.keySet()) {
            Attribute attr = (Attribute)varDefs.get(candidate);
            if (attr == null) {
                attr = null;
            }
            if (attributes.contains(candidate) || !attr.isDependent(this.name, varDefs)) continue;
            attributes.add(candidate);
        }
        MaterializedPredicate newContent = new MaterializedPredicate(attributes, src, null);
        Predicate fullPredicate = varDefs.namedPredicates.get(predVar);
        if (this.content == null) {
            for (ParseNode node = root; node != null; node = node.next()) {
                HashMap<String, ParseNode> t = new HashMap<String, ParseNode>();
                t.put(this.name, node);
                newContent.tuples.addAll(this.addTuples(root, src, varDefs, predVar, attributes, fullPredicate, t, newContent));
            }
        } else {
            for (Tuple tuple : this.content.tuples) {
                HashMap<String, ParseNode> t = new HashMap<String, ParseNode>();
                Object prefix = "";
                int pos = this.content.name.indexOf("->");
                if (0 < pos) {
                    prefix = this.content.name.substring(0, pos) + ".";
                }
                for (String a : this.content.attributes) {
                    t.put((String)prefix + a, this.content.getAttribute(tuple, a));
                }
                newContent.tuples.addAll(this.addTuples(root, src, varDefs, predVar, attributes, fullPredicate, t, newContent));
            }
        }
        newContent.tuples = this.filterClosestAncestorDescendants(varDefs, predVar, newContent.attributePositions, newContent.tuples, root, src);
        this.content = newContent;
    }

    private Set<Tuple> addTuples(ParseNode root, List<LexerToken> src, AttributeDefinitions varDefs, String predVar, ArrayList<String> attributes, Predicate fullPredicate, Map<String, ParseNode> cells, MaterializedPredicate newContent) {
        Set<Tuple> candidates = new TreeSet<Tuple>();
        ParseNode[] t = new ParseNode[newContent.arity()];
        candidates.add(new Tuple(t));
        for (String attr : cells.keySet()) {
            Integer pos = newContent.getAttribute(attr);
            if (pos == null) {
                int p = this.name.indexOf("->");
                pos = newContent.getAttribute(this.name.substring(0, p) + "." + attr);
            }
            if (pos == null) continue;
            t[pos.intValue()] = cells.get(attr);
            if (IndependentAttribute.unaryFilter(fullPredicate, attr).eval(newContent.attributePositions, t, src, varDefs)) continue;
            return new TreeSet<Tuple>();
        }
        for (String attr : attributes) {
            candidates = newContent.assignDependencyChain(attr, candidates, varDefs, root);
            if (candidates.size() != 0) continue;
            return new TreeSet<Tuple>();
        }
        return this.filterUnaryPredicates(varDefs, predVar, newContent.attributePositions, candidates, root, src);
    }

    int getLimits() {
        return this.content.cardinality();
    }

    void putFilter(Predicate filter) {
        this.failfastFilter = filter;
    }

    public Set<Tuple> filterClosestAncestorDescendants(Map<String, Attribute> varDefs, String predVar, Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root, List<LexerToken> src) {
        if (candidates.size() < 2) {
            return candidates;
        }
        HashSet<Long> ancestorDescendantPositions = new HashSet<Long>();
        for (String a : varDefs.keySet()) {
            Integer iAnc;
            Integer iDesc;
            Attribute attr = varDefs.get(a);
            if (!(attr instanceof AncestorExpr)) continue;
            AncestorExpr ancExpr = (AncestorExpr)attr;
            if (ancExpr.type != AncestorDescendantNodes.Type.CLOSEST || !attr.isDependent(this.name, varDefs) || (iDesc = this.getAttrPos(attributePositions, ancExpr.def)) == null || (iAnc = this.getAttrPos(attributePositions, ancExpr.name)) == null) continue;
            ancestorDescendantPositions.add(Service.lPair(iAnc, iDesc));
        }
        candidates = this.filterNested(candidates, ancestorDescendantPositions);
        return candidates;
    }

    public Integer getAttrPos(Map<String, Integer> attributePositions, String str) {
        int id;
        Integer ret = attributePositions.get(str);
        if (ret == null && 0 < (id = str.indexOf(46))) {
            ret = attributePositions.get(str.substring(id + 1));
        }
        return ret;
    }

    private Set<Tuple> filterNested1(Set<Tuple> candidates, Set<Long> ancestorDescendantPositions) {
        if (ancestorDescendantPositions.size() == 0) {
            return candidates;
        }
        TreeSet<Tuple> delete = new TreeSet<Tuple>();
        for (Tuple t : candidates) {
            if (delete.contains(t)) continue;
            for (Tuple cmp : candidates) {
                if (t == cmp || delete.contains(cmp) || !this.isRedundant(t, cmp, ancestorDescendantPositions)) continue;
                delete.add(cmp);
            }
        }
        candidates.removeAll(delete);
        return candidates;
    }

    private boolean isRedundant(Tuple t, Tuple cmp, Set<Long> ancestorDescendantPositions) {
        CmpState isWiderAnc = CmpState.CONFORMAL;
        CmpState isNarrowerDesc = CmpState.CONFORMAL;
        for (long pair : ancestorDescendantPositions) {
            int iAnc = Service.lX(pair);
            int iDesc = Service.lY(pair);
            ParseNode cmpAnc = cmp.values[iAnc];
            ParseNode tAnc = t.values[iAnc];
            ParseNode cmpDesc = cmp.values[iDesc];
            ParseNode tDesc = t.values[iDesc];
            if (cmpAnc.from > tAnc.from || tAnc.to > cmpAnc.to) {
                isWiderAnc = CmpState.FALSE;
            }
            if (isWiderAnc == CmpState.CONFORMAL && (cmpAnc.from < tAnc.from && tAnc.to <= cmpAnc.to || cmpAnc.from <= tAnc.from && tAnc.to < cmpAnc.to)) {
                isWiderAnc = CmpState.STRICT;
            }
            if (tDesc.from > cmpDesc.from || cmpDesc.to > tDesc.to) {
                isNarrowerDesc = CmpState.FALSE;
            }
            if (isNarrowerDesc != CmpState.CONFORMAL || (tDesc.from >= cmpDesc.from || cmpDesc.to > tDesc.to) && (tDesc.from > cmpDesc.from || cmpDesc.to >= tDesc.to)) continue;
            isNarrowerDesc = CmpState.STRICT;
        }
        return isWiderAnc == CmpState.STRICT && isNarrowerDesc != CmpState.FALSE || isNarrowerDesc == CmpState.STRICT && isWiderAnc != CmpState.FALSE;
    }

    private Set<Tuple> filterNested(Set<Tuple> candidates, Set<Long> ancestorDescendantPositions) {
        ParseNode tDesc;
        if (ancestorDescendantPositions.size() == 0) {
            return candidates;
        }
        HashMap colNode2tuple = new HashMap();
        for (long pair : ancestorDescendantPositions) {
            int iDesc;
            HashMap<Long, TreeSet<Tuple>> descMap;
            int iAnc = Service.lX(pair);
            HashMap<Long, TreeSet<Tuple>> ancMap = (HashMap<Long, TreeSet<Tuple>>)colNode2tuple.get(iAnc);
            if (ancMap == null) {
                ancMap = new HashMap<Long, TreeSet<Tuple>>();
                colNode2tuple.put(iAnc, ancMap);
            }
            if ((descMap = (HashMap<Long, TreeSet<Tuple>>)colNode2tuple.get(iDesc = Service.lY(pair))) == null) {
                descMap = new HashMap<Long, TreeSet<Tuple>>();
                colNode2tuple.put(iDesc, descMap);
            }
            for (Tuple t : candidates) {
                ParseNode tAnc = t.values[iAnc];
                TreeSet<Tuple> ancTuples = (TreeSet<Tuple>)ancMap.get(Service.lPair(tAnc.from, tAnc.to));
                if (ancTuples == null) {
                    ancTuples = new TreeSet<Tuple>();
                    ancMap.put(Service.lPair(tAnc.from, tAnc.to), ancTuples);
                }
                ancTuples.add(t);
                tDesc = t.values[iDesc];
                TreeSet<Tuple> descTuples = (TreeSet<Tuple>)descMap.get(Service.lPair(tDesc.from, tDesc.to));
                if (descTuples == null) {
                    descTuples = new TreeSet<Tuple>();
                    descMap.put(Service.lPair(tDesc.from, tDesc.to), descTuples);
                }
                descTuples.add(t);
            }
        }
        TreeSet<Tuple> delete = new TreeSet<Tuple>();
        for (Tuple t : candidates) {
            for (long pair : ancestorDescendantPositions) {
                int iAnc = Service.lX(pair);
                Map ancMap = (Map)colNode2tuple.get(iAnc);
                int iDesc = Service.lY(pair);
                Map descMap = (Map)colNode2tuple.get(iDesc);
                ParseNode tAnc = t.values[iAnc];
                for (ParseNode node = tAnc.parent(); node != null; node = node.parent()) {
                    Set nestedAnc = (Set)ancMap.get(Service.lPair(node.from, node.to));
                    if (nestedAnc == null) continue;
                    for (Tuple tt : nestedAnc) {
                        if (!this.isRedundant(t, tt, ancestorDescendantPositions)) continue;
                        delete.add(tt);
                    }
                }
                tDesc = t.values[iDesc];
                for (ParseNode node = tDesc.parent(); node != null; node = node.parent()) {
                    Set nestedDesc = (Set)descMap.get(Service.lPair(node.from, node.to));
                    if (nestedDesc == null) continue;
                    for (Tuple tt : nestedDesc) {
                        if (!this.isRedundant(tt, t, ancestorDescendantPositions)) continue;
                        delete.add(t);
                    }
                }
            }
        }
        candidates.removeAll(delete);
        return candidates;
    }

    protected Set<Tuple> filterUnaryPredicates(AttributeDefinitions varDefs, String predVar, Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root, List<LexerToken> src) {
        if (this.failfastFilter == null) {
            Predicate fullPredicate = varDefs.namedPredicates.get(predVar);
            this.failfastFilter = this.ubFilter(varDefs, fullPredicate, attributePositions);
        }
        TreeSet<Tuple> ret = new TreeSet<Tuple>();
        for (Tuple t : candidates) {
            if (!this.failfastFilter.eval(attributePositions, t.values, src, varDefs)) continue;
            ret.add(t);
        }
        return ret;
    }

    private Predicate ubFilter(Map<String, Attribute> varDefs, Predicate fullPredicate, Map<String, Integer> attributePositions) {
        LinkedList<Predicate> tmp = new LinkedList<Predicate>();
        for (String s : varDefs.keySet()) {
            Attribute attr = varDefs.get(s);
            if (!attr.isDependent(this.name, varDefs)) continue;
            tmp.add(IndependentAttribute.unaryFilter(fullPredicate, attr.name));
        }
        for (String attr1 : attributePositions.keySet()) {
            for (String attr2 : attributePositions.keySet()) {
                tmp.add(IndependentAttribute.binaryFilter(fullPredicate, attr1, attr2));
            }
        }
        Predicate ret = new True();
        for (Predicate extra : tmp) {
            ret = this.appendProposition(extra, ret);
        }
        return ret;
    }

    @Override
    Set<Tuple> eval(Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root) {
        throw new AssertionError((Object)"or should just return candidates?");
    }

    @Override
    Attribute referredTo(Map<String, Attribute> varDefs) {
        return null;
    }

    @Override
    ParseNode lookup(Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) {
        Integer pos = attributePositions.get(this.name);
        if (pos == null) {
            throw new AssertionError((Object)("Missing column " + this.name));
        }
        return tuple[pos];
    }

    static enum CmpState {
        STRICT,
        CONFORMAL,
        FALSE;

    }
}

