/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import oracle.dbtools.arbori.AggregatePredicate;
import oracle.dbtools.arbori.AncestorDescendantNodes;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.AttributeDefinitions;
import oracle.dbtools.arbori.BindVar;
import oracle.dbtools.arbori.ChildNumRelation;
import oracle.dbtools.arbori.Composite;
import oracle.dbtools.arbori.CompositeExpr;
import oracle.dbtools.arbori.False;
import oracle.dbtools.arbori.Head;
import oracle.dbtools.arbori.Header;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.IndependentAttribute;
import oracle.dbtools.arbori.JSFunc;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.NodeContent;
import oracle.dbtools.arbori.NodeMatchingSrc;
import oracle.dbtools.arbori.NodesWMatchingSrc;
import oracle.dbtools.arbori.Oper;
import oracle.dbtools.arbori.ParentChildNodes;
import oracle.dbtools.arbori.Position;
import oracle.dbtools.arbori.PositionalRelation;
import oracle.dbtools.arbori.PredRef;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.PredicateDependency;
import oracle.dbtools.arbori.SameNodes;
import oracle.dbtools.arbori.ScriptException;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tail;
import oracle.dbtools.arbori.True;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.js.JavaScript;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.scripting.GlobalMap;
import oracle.dbtools.scripting.Scripting;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;

public class Program
extends Scripting {
    public static boolean debug = false;
    public static boolean timing = false;
    public boolean stop = false;
    public Map<String, String> test = null;
    protected Object struct = null;
    protected Earley parser;
    private int objRef;
    private static int objCnt = 0;
    private static int attribute = -1;
    private static int backslash = -1;
    private static int closePar = -1;
    private static int closeBr = -1;
    private static int col = -1;
    private static int conj = -1;
    private static int connect = -1;
    private static int digits = -1;
    private static int disj = -1;
    private static int dot = -1;
    private static int eq = -1;
    private static int excl = -1;
    private static int identifier = -1;
    private static int include = -1;
    private static int js_block = -1;
    private static int header = -1;
    private static int lt = -1;
    private static int minus = -1;
    private static int node_parent = -1;
    private static int node_predecessor = -1;
    private static int node_position = -1;
    private static int node_successor = -1;
    private static int node = -1;
    private static int openBr = -1;
    private static int openPar = -1;
    private static int plus = -1;
    private static int predicate = -1;
    private static int program = -1;
    private static int referenced_node = -1;
    private static int rule = -1;
    private static int srcPtr = -1;
    private static int semicol = -1;
    private static int sharp = -1;
    private static int slash = -1;
    private static int statement = -1;
    private static int string_literal = -1;
    private static Earley parserInstance = null;
    private TreeMap<Integer, Command> execOrder = null;
    public Map<String, Predicate> namedPredicates = new HashMap<String, Predicate>();
    private PredicateDependency dependency = new PredicateDependency();
    private HashMap<String, Boolean> bindsInstance = new HashMap();
    private Parsed prg = null;
    private HashMap<String, Predicate> symbolicPredicates = new HashMap();
    private String targetFileName = null;
    int blockNo = 0;
    private static String javaCallbackCode = "this is java callback (not JS)";
    public Boolean addWsDividers = null;
    public boolean allowJS = true;
    public static String EvalSpace = "EvalSpace";

    public void setStruct(Object struct) {
        this.struct = struct;
    }

    public Program(Earley parser) {
        this(parser, "JS");
    }

    public Program(Earley parser, Object struct) {
        this(parser, struct, null, null, true);
    }

    public Program(Earley parser, Object struct, ScriptEngine engine, GlobalMap globals, boolean allowJS) {
        this.parser = parser;
        this.struct = struct;
        this.engine = engine;
        this.globals = globals;
        this.allowJS = allowJS;
        this.objRef = objCnt++;
    }

    public static void main(String[] args) throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        List<ScriptEngineFactory> factories = manager.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            System.out.println("\nName : " + factory.getEngineName());
            System.out.println("Version : " + factory.getEngineVersion());
            System.out.println("Language name : " + factory.getLanguageName());
            System.out.println("Language version : " + factory.getLanguageVersion());
            System.out.println("Extensions : " + factory.getExtensions());
            System.out.println("Mime types : " + factory.getMimeTypes());
            System.out.println("Names : " + factory.getNames());
            ScriptEngine engine = manager.getEngineByName(factory.getNames().get(0));
            if (engine != null) continue;
            System.out.println("Impossible to find the engine with name " + factory.getEngineName() + "\n");
        }
        long t1 = System.currentTimeMillis();
        String input = Service.readFile("src/test/resources/oracle/dbtools/arbori/example.sql");
        List<LexerToken> src = Lexer.parse(input);
        String arboriProgram = Service.readFile("src/test/resources/oracle/dbtools/arbori/example.arbori");
        SqlProgram r = new SqlProgram(arboriProgram){};
        Map<String, MaterializedPredicate> output = r.run(input, src, "JS action");
        for (String p : output.keySet()) {
            System.out.println(p + "=" + output.get(p).toString(p.length() + 1));
        }
        long t2 = System.currentTimeMillis();
        System.out.println("First time run=" + (t2 - t1));
        System.exit(0);
        t1 = System.currentTimeMillis();
        output = r.run(input, src, new HashMap());
        t2 = System.currentTimeMillis();
        System.out.println("Second time run=" + (t2 - t1));
    }

    public static Earley getArboriParser() throws IOException {
        if (parserInstance != null) {
            return parserInstance;
        }
        Set<RuleTuple> rules = Program.getRules();
        parserInstance = new Earley((Set)rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
            }

            @Override
            protected void initCell00(List<LexerToken> src, Matrix matrix) {
                long t1 = 0L;
                if (matrix.visual != null) {
                    t1 = System.nanoTime();
                }
                matrix.initCells(src.size());
                this.initCell(matrix, new int[]{program}, 0);
                if (matrix.visual != null) {
                    long t2 = System.nanoTime();
                    long[] lArray = matrix.visual.visited[0];
                    lArray[0] = lArray[0] + (long)((int)(t2 - t1));
                }
                LexerToken LAtoken = src.get(0);
                matrix.LAsuspect = (Integer)this.symbolIndexes.get("'" + LAtoken.content.toUpperCase() + "'");
            }

            @Override
            protected boolean scan(Matrix matrix, List<LexerToken> src) {
                boolean ret = super.scan(matrix, src);
                matrix.LAsuspect = null;
                return ret;
            }

            @Override
            protected boolean isAsc(int ruleHead) {
                return true;
            }
        };
        Program.parserInstance.isCaseSensitive = true;
        attribute = (Integer)Program.parserInstance.symbolIndexes.get("attribute");
        backslash = (Integer)Program.parserInstance.symbolIndexes.get("'\\'");
        closePar = (Integer)Program.parserInstance.symbolIndexes.get("')'");
        closeBr = (Integer)Program.parserInstance.symbolIndexes.get("']'");
        col = (Integer)Program.parserInstance.symbolIndexes.get("':'");
        conj = (Integer)Program.parserInstance.symbolIndexes.get("'&'");
        connect = (Integer)Program.parserInstance.symbolIndexes.get("connect");
        digits = (Integer)Program.parserInstance.symbolIndexes.get("digits");
        disj = (Integer)Program.parserInstance.symbolIndexes.get("'|'");
        dot = (Integer)Program.parserInstance.symbolIndexes.get("'.'");
        eq = (Integer)Program.parserInstance.symbolIndexes.get("'='");
        excl = (Integer)Program.parserInstance.symbolIndexes.get("'!'");
        identifier = (Integer)Program.parserInstance.symbolIndexes.get("identifier");
        include = (Integer)Program.parserInstance.symbolIndexes.get("include");
        js_block = (Integer)Program.parserInstance.symbolIndexes.get("js_block");
        header = (Integer)Program.parserInstance.symbolIndexes.get("header");
        lt = (Integer)Program.parserInstance.symbolIndexes.get("'<'");
        minus = (Integer)Program.parserInstance.symbolIndexes.get("'-'");
        node_parent = (Integer)Program.parserInstance.symbolIndexes.get("node_parent");
        node_position = (Integer)Program.parserInstance.symbolIndexes.get("node_position");
        node_predecessor = (Integer)Program.parserInstance.symbolIndexes.get("node_predecessor");
        node_successor = (Integer)Program.parserInstance.symbolIndexes.get("node_successor");
        node = (Integer)Program.parserInstance.symbolIndexes.get("node");
        openBr = (Integer)Program.parserInstance.symbolIndexes.get("'['");
        openPar = (Integer)Program.parserInstance.symbolIndexes.get("'('");
        plus = (Integer)Program.parserInstance.symbolIndexes.get("'+'");
        predicate = (Integer)Program.parserInstance.symbolIndexes.get("predicate");
        program = (Integer)Program.parserInstance.symbolIndexes.get("program");
        referenced_node = (Integer)Program.parserInstance.symbolIndexes.get("referenced_node");
        rule = (Integer)Program.parserInstance.symbolIndexes.get("rule");
        semicol = (Integer)Program.parserInstance.symbolIndexes.get("';'");
        sharp = (Integer)Program.parserInstance.symbolIndexes.get("'#'");
        slash = (Integer)Program.parserInstance.symbolIndexes.get("'/'");
        srcPtr = (Integer)Program.parserInstance.symbolIndexes.get("'?'");
        statement = (Integer)Program.parserInstance.symbolIndexes.get("statement");
        string_literal = (Integer)Program.parserInstance.symbolIndexes.get("string_literal");
        Program.prioritizeRules(parserInstance);
        return parserInstance;
    }

    private static void prioritizeRules(Earley testParser) {
        String rule2 = "program:  statement;";
        String rule3 = "program:  program  statement;";
        testParser.swapRules(rule2, rule3);
    }

    private static Set<RuleTuple> getRules() throws IOException {
        Object input = Service.readFile(Program.class, "arbori.grammar");
        input = (String)input + Service.readFile(JavaScript.class, "js.grammar");
        List<LexerToken> src = Lexer.parse((String)input, false, 57);
        ParseNode root = Grammar.parseGrammarFile(src, (String)input);
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, ret);
        RuleTransforms.eliminateEmptyProductions(ret);
        return ret;
    }

    public LinkedList<String> querySequence() {
        LinkedList<String> ret = new LinkedList<String>();
        for (Integer pos : this.execOrder.keySet()) {
            Command inc = this.execOrder.get(pos);
            if (!(inc instanceof PredicateCmd)) continue;
            ret.add(((PredicateCmd)inc).name);
        }
        return ret;
    }

    public static void resetCompiledPrograms() {
    }

    public void compile(String programText) throws IOException, javax.script.ScriptException {
        this.compile(programText, null);
    }

    public void compile(String programText, Object struct) throws IOException, javax.script.ScriptException {
        this.compile(programText, struct, false);
    }

    public void compile(String programText, Object struct, boolean force) throws IOException, javax.script.ScriptException {
        if (this.prg == null) {
            this.prg = new Parsed(programText, Program.getArboriParser(), "program");
        }
        Set<String> bindVars = this.listBindVariables(this.prg.getRoot(), this.prg.getSrc());
        if (this.execOrder == null || force || 0 < bindVars.size()) {
            this.execOrder = new TreeMap();
            SyntaxError error = this.prg.getSyntaxError();
            if (error != null) {
                throw error;
            }
            this.namedPredicates = new HashMap<String, Predicate>();
            this.program(this.prg.getRoot(), this.prg.getSrc(), this.prg.getInput());
            for (String bindVar : bindVars) {
                this.bindsInstance.put(bindVar, this.getBoolBindVar(bindVar));
            }
            this.symbolicPredicates.putAll(this.namedPredicates);
        }
    }

    private void program(ParseNode root, List<LexerToken> src, String input) throws IOException, javax.script.ScriptException {
        if (root.contains(statement)) {
            this.statement(root, src, input);
            return;
        }
        if (root.contains(js_block)) {
            this.jsBlock(root, src, input);
            return;
        }
        if (root.contains(include)) {
            this.include(root, src, input);
            return;
        }
        for (ParseNode child : root.children()) {
            this.program(child, src, input);
        }
    }

    private void statement(ParseNode root, List<LexerToken> src, String input) throws IOException, javax.script.ScriptException {
        if (root.contains(rule)) {
            this.rule(root, src, input);
        } else if (root.contains(include)) {
            this.include(root, src, input);
        } else if (root.contains(js_block)) {
            this.jsBlock(root, src, input);
        }
    }

    private void include(ParseNode root, List<LexerToken> src, String input) throws IOException, javax.script.ScriptException {
        GlobalMap _globals = this.getGlobals();
        if (_globals != null) {
            _globals.put("struct", this.struct);
            _globals.put("program", (Object)this);
        }
        for (ParseNode child : root.children()) {
            if (child.contains("'include'")) continue;
            String filename = child.content(src);
            if (filename.startsWith("\"")) {
                filename = filename.substring(1, filename.length() - 1);
            }
            String includeContent = Program.getContent(filename);
            int begin = src.get((int)child.from).begin;
            try {
                Program incPrg = new Program(this.parser, this.struct, this.getEngine(), _globals, this.allowJS);
                incPrg.compile(includeContent, this.struct, true);
                this.execOrder.put(begin, new IncludedPrg(incPrg));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SyntaxError e) {
                if (filename.trim().endsWith(".js")) {
                    try {
                        if (this.getEngine() == null || _globals == null) continue;
                        this.execOrder.put(begin, new JavaScriptBlock(includeContent, begin));
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                throw e;
            }
        }
    }

    public static String getContent(String filename) throws AssertionError {
        if (filename.startsWith("file:")) {
            try {
                filename = filename.replace(" ", "%20");
                filename = filename.replace("\\", "/");
                URI url = new URI(filename);
                File file = new File(url);
                return Service.readFile(file.getAbsolutePath());
            }
            catch (IOException | URISyntaxException e) {
                throw new AssertionError((Object)(filename + " not found"));
            }
        }
        String content = null;
        try {
            Object sysSource = filename;
            String downOneLevel = "../";
            if (((String)sysSource).startsWith(downOneLevel)) {
                sysSource = "/oracle/dbtools/" + ((String)sysSource).substring(downOneLevel.length());
            }
            content = Service.readFile(Program.class, (String)sysSource);
        }
        catch (IOException e) {
            try {
                Properties pr = System.getProperties();
                String m = (String)pr.get("dbtools.arbori.home");
                if (m != null && (m.endsWith("/") || m.endsWith("\\"))) {
                    m = m.substring(0, m.length() - 1);
                }
                content = m == null ? Service.readFile(filename) : Service.readFile(m.toString() + "/" + filename);
            }
            catch (IOException e1) {
                try {
                    content = Service.readFile(filename);
                }
                catch (IOException e2) {
                    throw new AssertionError((Object)(filename + " not found"));
                }
            }
        }
        return content;
    }

    public void setTargetFileName(String tfn) {
        this.targetFileName = tfn;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    private void jsBlock(ParseNode root, List<LexerToken> src, String input) {
        int begin = src.get((int)root.from).begin;
        this.execOrder.put(begin, new JavaScriptBlock(input.substring(begin, src.get((int)(root.to - 1)).end), begin));
    }

    private void rule(ParseNode root, List<LexerToken> src, String input) {
        String first = null;
        boolean legitimateOper = false;
        String name = null;
        for (ParseNode child : root.children()) {
            PredicateCmd parent;
            if (first == null) {
                if (child.from + 1 == child.to) {
                    first = child.content(src);
                    continue;
                }
                return;
            }
            if (!legitimateOper) {
                if (child.contains(col)) {
                    legitimateOper = true;
                    continue;
                }
                return;
            }
            if (child.contains(predicate)) {
                Predicate p = this.predicate(child, src, input, false);
                Map<String, Boolean> dependencies = p.dependencies();
                for (String s : dependencies.keySet()) {
                    this.dependency.addDependency(s, first, dependencies.get(s));
                }
                if (this.namedPredicates.containsKey(first)) {
                    throw new AssertionError((Object)("Duplicate defintion of predicate " + first));
                }
                this.execOrder.put(src.get((int)root.from).begin, new PredicateCmd(first, p));
                this.namedPredicates.put(first, p);
                continue;
            }
            if (child.contains(minus)) {
                name = first;
            }
            if (child.contains("js_block")) {
                parent = (PredicateCmd)this.execOrder.get(src.get((int)root.from).begin);
                parent.action = input.substring(src.get((int)child.from).begin + 1, src.get((int)(child.to - 2)).end);
                return;
            }
            if (name == null) continue;
            parent = (PredicateCmd)this.execOrder.get(src.get((int)root.from).begin);
            parent.action = javaCallbackCode;
        }
    }

    private Predicate predicate(ParseNode root, List<LexerToken> src, String input, boolean sawDisj) {
        if (root.contains(identifier)) {
            return new PredRef(root.content(src), this);
        }
        Predicate ret = this.isBrackets(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isParenthesis(root, src, input, sawDisj);
        if (ret != null) {
            return ret;
        }
        ret = this.isConjunction(root, src, input, sawDisj);
        if (ret != null) {
            return ret;
        }
        ret = this.isDisjunction(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isDifference(root, src, input, sawDisj);
        if (ret != null) {
            return ret;
        }
        ret = this.isAtomicPredicate(root, src, input, sawDisj);
        if (ret != null) {
            return ret;
        }
        throw new AssertionError((Object)("unexpected case for: " + root.content(src)));
    }

    private Predicate isConjunction(ParseNode root, List<LexerToken> src, String input, boolean sawDisj) {
        ParseNode first = null;
        boolean legitimateOper = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = child;
                continue;
            }
            if (!legitimateOper) {
                if (child.contains(conj)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            Predicate lft = this.predicate(first, src, input, sawDisj);
            Predicate rgt = this.predicate(child, src, input, sawDisj);
            return new CompositeExpr(lft, rgt, Oper.CONJUNCTION);
        }
        return null;
    }

    private Predicate isDisjunction(ParseNode root, List<LexerToken> src, String input) {
        ParseNode first = null;
        boolean legitimateOper = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = child;
                continue;
            }
            if (!legitimateOper) {
                if (child.contains(disj)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            Predicate lft = this.predicate(first, src, input, true);
            Predicate rgt = this.predicate(child, src, input, true);
            return new CompositeExpr(lft, rgt, Oper.DISJUNCTION);
        }
        return null;
    }

    private Predicate isDifference(ParseNode root, List<LexerToken> src, String input, boolean sawDisj) {
        ParseNode first = null;
        boolean isLegit = false;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = child;
                continue;
            }
            if (!isLegit) {
                if (child.contains(minus)) {
                    isLegit = true;
                    continue;
                }
                return null;
            }
            Predicate lft = this.predicate(first, src, input, sawDisj);
            Predicate rgt = this.predicate(child, src, input, sawDisj);
            return new CompositeExpr(lft, rgt, Oper.DIFFERENCE);
        }
        return null;
    }

    private Predicate isParenthesis(ParseNode root, List<LexerToken> src, String input, boolean sawDisj) {
        boolean isOpenParen = false;
        for (ParseNode child : root.children()) {
            if (!isOpenParen) {
                if (child.contains(openPar)) {
                    isOpenParen = true;
                    continue;
                }
                return null;
            }
            if (isOpenParen && child.contains(predicate)) {
                return this.predicate(child, src, input, sawDisj);
            }
            return null;
        }
        return null;
    }

    private Predicate isBrackets(ParseNode root, List<LexerToken> src, String input) {
        boolean isOpenBr = false;
        for (ParseNode child : root.children()) {
            if (!isOpenBr) {
                if (child.contains(openBr)) {
                    isOpenBr = true;
                    continue;
                }
                return null;
            }
            if (isOpenBr) {
                if (child.contains(header)) {
                    return this.header(child, src, input);
                }
                if (!child.contains(closeBr)) continue;
                return new MaterializedPredicate(new ArrayList<String>(), src, "[]");
            }
            return null;
        }
        return null;
    }

    private Header header(ParseNode root, List<LexerToken> src, String input) {
        if (root.contains(attribute)) {
            ArrayList<String> hdr = new ArrayList<String>();
            hdr.add(root.content(src));
            return new Header(hdr);
        }
        Header ret = null;
        for (ParseNode child : root.children()) {
            if (ret == null) {
                ret = this.header(child, src, input);
                continue;
            }
            Header tmp = this.header(child, src, input);
            ret.attributes.addAll(tmp.attributes);
        }
        return ret;
    }

    private Predicate isAtomicPredicate(ParseNode root, List<LexerToken> src, String input, boolean sawDisj) {
        Predicate ret = this.isExclamation(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isNodeContent(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isNodeMatchingSrc(root, src, input);
        if (ret != null) {
            return ret;
        }
        if (!sawDisj && (ret = this.isNodeParentChild(root, src, input)) != null) {
            return ret;
        }
        ret = this.isSameNode(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isNodeAncestorDescendant(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isAggregate(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isBoolBindVar(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isJSFunc(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isChildNumRelation(root, src, input);
        if (ret != null) {
            return ret;
        }
        ret = this.isPositionalRelation(root, src, input);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private Predicate isAggregate(ParseNode root, List<LexerToken> src, String input) {
        Boolean slash1 = null;
        Boolean slash2 = null;
        ParseNode attribute = null;
        boolean seenOpenParen = false;
        ParseNode p = null;
        for (ParseNode child : root.children()) {
            if (slash1 == null) {
                if (child.contains(slash)) {
                    slash1 = true;
                    continue;
                }
                if (child.contains(backslash)) {
                    slash1 = false;
                    continue;
                }
                return null;
            }
            if (slash2 == null) {
                if (child.contains(slash)) {
                    slash2 = true;
                    continue;
                }
                if (child.contains(backslash)) {
                    slash2 = false;
                    continue;
                }
                if (child.contains(dot)) continue;
                return null;
            }
            if (attribute == null) {
                attribute = child;
                continue;
            }
            if (!seenOpenParen) {
                if (child.contains(openPar)) {
                    seenOpenParen = true;
                    continue;
                }
                throw new AssertionError((Object)"Syntax error not caught by parsing?");
            }
            p = child;
            break;
        }
        Predicate predicate = this.predicate(p, src, input, false);
        return new AggregatePredicate(attribute.content(src), predicate, slash1, slash2);
    }

    private Predicate isExclamation(ParseNode root, List<LexerToken> src, String input) {
        boolean isExcl = false;
        for (ParseNode child : root.children()) {
            if (!isExcl) {
                if (child.contains(excl)) {
                    isExcl = true;
                    continue;
                }
                return null;
            }
            if (!isExcl) continue;
            return new CompositeExpr(this.predicate(child, src, input, false), null, Oper.NEGATION);
        }
        return null;
    }

    private Predicate isNodeContent(ParseNode root, List<LexerToken> src, String input) {
        boolean openBrace = false;
        String first = null;
        boolean legitimateOper = false;
        String second = null;
        for (ParseNode child : root.children()) {
            if (!openBrace) {
                if (child.contains(openBr)) {
                    openBrace = true;
                    continue;
                }
                return null;
            }
            if (first == null && child.contains(node)) {
                if (child.from + 1 == child.to || child.contains(node_parent) || child.contains(node_predecessor) || child.contains(node_successor) || child.contains(referenced_node)) {
                    first = child.content(src);
                    continue;
                }
                return null;
            }
            if (!legitimateOper) {
                if (child.contains(closePar)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            if (second == null) {
                second = child.content(src);
                continue;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        Integer symbol = (Integer)this.parser.symbolIndexes.get(second);
        if (symbol == null) {
            System.err.println("Symbol '" + second + "' not found");
            return new False();
        }
        return new NodeContent(first, symbol);
    }

    private Predicate isNodeMatchingSrc(ParseNode root, List<LexerToken> src, String input) {
        boolean legitimateAt1 = false;
        String first = null;
        boolean legitimateOper = false;
        boolean legitimateAt2 = false;
        String second = null;
        for (ParseNode child : root.children()) {
            if (!legitimateAt1) {
                if (child.contains(srcPtr)) {
                    legitimateAt1 = true;
                    continue;
                }
                return null;
            }
            if (first == null) {
                if (child.contains(node)) {
                    first = child.content(src);
                    continue;
                }
                return null;
            }
            if (!legitimateOper) {
                if (child.contains(eq)) {
                    legitimateOper = true;
                    continue;
                }
                return null;
            }
            if (!legitimateAt2) {
                if (child.contains(srcPtr)) {
                    legitimateAt2 = true;
                    continue;
                }
                if (child.contains(string_literal)) {
                    return new NodeMatchingSrc(first, child.content(src), this.addWsDividers);
                }
                return null;
            }
            if (second == null) {
                if (child.contains(node)) {
                    second = child.content(src);
                    continue;
                }
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new NodesWMatchingSrc(first, second);
    }

    private Predicate isNodeParentChild(ParseNode root, List<LexerToken> src, String input) {
        Pair<String, String> p = this.binaryPredicateNames(root, src, eq);
        if (p == null) {
            return null;
        }
        String prefix = p.first();
        String postfix = p.second();
        List<LexerToken> prefSrc = LexerToken.parse(prefix);
        List<LexerToken> postSrc = LexerToken.parse(postfix);
        if (1 < postSrc.size() && prefSrc.size() == 1) {
            if (!"^".equals(postSrc.get((int)1).content)) {
                return null;
            }
            if (postSrc.size() == 2) {
                return new ParentChildNodes(prefix, postSrc.get((int)0).content, 1, this);
            }
            if (!"^".equals(postSrc.get((int)2).content)) {
                return null;
            }
            if (postSrc.size() == 3) {
                return new ParentChildNodes(prefix, postSrc.get((int)0).content, 2, this);
            }
        }
        return null;
    }

    private Predicate isNodeAncestorDescendant(ParseNode root, List<LexerToken> src, String input) {
        AncestorDescendantNodes.Type type = AncestorDescendantNodes.Type.CLOSEST;
        Pair<String, String> p = this.binaryPredicateNames(root, src, lt);
        if (p == null) {
            p = this.binaryPredicateNames(root, src, lt, eq);
            type = AncestorDescendantNodes.Type.TRANSITIVE;
            if (p == null) {
                p = this.binaryPredicateNames(root, src, lt, lt);
                type = AncestorDescendantNodes.Type.TRANSITIVE;
                if (p == null) {
                    return null;
                }
            }
        }
        return new AncestorDescendantNodes(p.first(), p.second(), type);
    }

    private Predicate isSameNode(ParseNode root, List<LexerToken> src, String input) {
        Pair<String, String> p = this.binaryPredicateNames(root, src, eq);
        if (p == null) {
            return null;
        }
        return new SameNodes(p.first(), p.second());
    }

    public Pair<String, String> binaryPredicateNames(ParseNode root, List<LexerToken> src, int oper) throws AssertionError {
        return this.binaryPredicateNames(root, src, oper, -1);
    }

    public Pair<String, String> binaryPredicateNames(ParseNode root, List<LexerToken> src, int oper1, int oper2) throws AssertionError {
        String first = null;
        boolean legitimateOper1 = false;
        boolean legitimateOper2 = -1 == oper2;
        String second = null;
        for (ParseNode child : root.children()) {
            if (first == null) {
                if (child.contains(node)) {
                    first = child.content(src);
                    if (this.namedPredicates.containsKey(first)) {
                        throw new AssertionError((Object)("Error: " + first + " is a predicate, not predicate attribute within binary operation"));
                    }
                    continue;
                }
                return null;
            }
            if (!legitimateOper1) {
                if (child.contains(oper1)) {
                    legitimateOper1 = true;
                    continue;
                }
                return null;
            }
            if (!legitimateOper2) {
                if (child.contains(oper2)) {
                    legitimateOper2 = true;
                    continue;
                }
                return null;
            }
            if (second == null) {
                if (child.contains(node)) {
                    second = child.content(src);
                    if (this.namedPredicates.containsKey(second)) {
                        throw new AssertionError((Object)("Error: " + second + " is a predicate, not predicate attribute within binary operation"));
                    }
                    continue;
                }
                return null;
            }
            if (!child.contains(semicol)) {
                throw new AssertionError((Object)("unexpected case for: " + root.content(src)));
            }
        }
        return new Pair<Object, Object>(first, second);
    }

    private Predicate isPositionalRelation(ParseNode root, List<LexerToken> src, String input) {
        Position first = null;
        boolean isGT = false;
        boolean isReflexive = false;
        Position second = null;
        for (ParseNode child : root.children()) {
            if (first == null) {
                first = this.nodeRelativePosition(child, src, input);
                if (first != null) continue;
                return null;
            }
            if (child.contains(lt)) {
                isGT = true;
                continue;
            }
            if (child.contains(eq)) {
                isReflexive = true;
                continue;
            }
            if (second == null) {
                second = this.nodeRelativePosition(child, src, input);
                if (second != null) continue;
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new PositionalRelation(first, second, isReflexive, isGT, this);
    }

    private Position nodeRelativePosition(ParseNode root, List<LexerToken> src, String input) {
        String name = null;
        Position t = null;
        int num = -1;
        for (ParseNode child : root.children()) {
            if (name == null && child.contains(attribute) || t instanceof BindVar) {
                name = child.content(src);
                continue;
            }
            if (child.contains(digits)) {
                num = Integer.decode(child.content(src));
                if (t == null) continue;
                ((Composite)t).addendum = num;
                continue;
            }
            if (t != null) continue;
            if (child.contains(openBr)) {
                t = new Head(name);
                continue;
            }
            if (child.contains(closePar)) {
                t = new Tail(name);
                continue;
            }
            if (child.contains(col)) {
                t = new BindVar(name);
                continue;
            }
            if (child.contains(plus)) continue;
            if (child.contains(node_position)) {
                Position tmp = this.nodeRelativePosition(child, src, input);
                name = tmp.name;
                t = new Composite(tmp, num);
                continue;
            }
            throw new AssertionError();
        }
        if (name == null) {
            throw new AssertionError((Object)"name == null");
        }
        if (t == null) {
            throw new AssertionError((Object)"t == null");
        }
        t.setName(name);
        return t;
    }

    private Predicate isChildNumRelation(ParseNode root, List<LexerToken> src, String input) {
        Integer first = null;
        boolean isGT = false;
        boolean isReflexive = false;
        String second = null;
        for (ParseNode child : root.children()) {
            if (first == null) {
                try {
                    first = Integer.parseInt(src.get((int)child.from).content);
                }
                catch (Exception e) {
                    return null;
                }
                if (first != null) continue;
                return null;
            }
            if (child.contains(lt)) {
                isGT = true;
                continue;
            }
            if (child.contains(eq)) {
                isReflexive = true;
                continue;
            }
            if (child.contains(sharp)) continue;
            if (second == null) {
                second = src.get((int)child.from).content;
                if (second != null) continue;
                return null;
            }
            throw new AssertionError((Object)"unexpected case");
        }
        return new ChildNumRelation(first, second, isReflexive, isGT, this);
    }

    public Boolean getBoolBindVar(String name) {
        if (this.struct == null) {
            throw new AssertionError((Object)("_getBoolBindVar(" + name + ") failed, struct == null"));
        }
        try {
            Field field = this.struct.getClass().getField(name);
            if (field.getType() == Boolean.TYPE) {
                return field.getBoolean(this.struct);
            }
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)("field.getBoolean failed due to " + e.getMessage()));
        }
        try {
            Method method = this.struct.getClass().getMethod(name, new Class[0]);
            if (method.getReturnType() == Boolean.TYPE) {
                try {
                    return (boolean)((Boolean)method.invoke(this.struct, new Object[0]));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new AssertionError((Object)("method.invoke failed due to " + e.getMessage()));
                }
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        throw new AssertionError((Object)("_getBoolBindVar(" + name + ") failed"));
    }

    private Predicate isBoolBindVar(ParseNode root, List<LexerToken> src, String input) {
        if (!root.contains("bind_var")) {
            return null;
        }
        String name = src.get((int)(root.from + 1)).content;
        Boolean b = this.getBoolBindVar(name);
        if (b == null) {
            throw new AssertionError((Object)("Bind var '" + name + "' not found."));
        }
        if (b.booleanValue()) {
            return new True();
        }
        return new False();
    }

    private Set<String> listBindVariables(ParseNode root, List<LexerToken> src) {
        HashSet<String> ret = new HashSet<String>();
        if (root.contains("bind_var") && root.contains("atomic_predicate")) {
            ret.add(src.get((int)(root.from + 1)).content);
            return ret;
        }
        for (ParseNode child : root.children()) {
            ret.addAll(this.listBindVariables(child, src));
        }
        return ret;
    }

    private Predicate isJSFunc(ParseNode root, List<LexerToken> src, String input) {
        if (!root.contains("js_condition")) {
            return null;
        }
        String name = src.get((int)(root.from + 1)).content;
        LinkedList<String> args = new LinkedList<String>();
        for (int i = root.from + 2; i < root.to; ++i) {
            LexerToken t = src.get(i);
            if (t.type != Token.QUOTED_STRING) continue;
            args.add(t.content.substring(1, t.content.length() - 1));
        }
        return new JSFunc(name, this, args);
    }

    public Map<String, MaterializedPredicate> eval() throws ScriptException {
        if (this.targetFileName == null) {
            for (Predicate value : this.namedPredicates.values()) {
                if (!(value instanceof True)) {
                    throw new AssertionError((Object)"Not connected to parsed source file");
                }
            }
            Parsed target = new Parsed("connect", SqlEarley.partialRecognizer(), "sql_statement");
            return this.eval(target);
        }
        String input = Program.getContent(this.targetFileName);
        Parsed target = new Parsed(input, SqlEarley.partialRecognizer(), "sql_statement");
        return this.eval(target);
    }

    public Map<String, MaterializedPredicate> eval(Parsed target) throws ScriptException {
        return this.eval(target, this.struct);
    }

    public Map<String, MaterializedPredicate> eval(Parsed target, Object action) throws ScriptException {
        this.struct = action;
        HashMap<String, MaterializedPredicate> ret = new HashMap<String, MaterializedPredicate>();
        GlobalMap _globals = this.getGlobals();
        if (_globals != null) {
            _globals.put("struct", this.struct);
            _globals.put("program", (Object)this);
        }
        ParseNode root = target.getRoot();
        if (timing) {
            System.out.println("tree depth =" + root.treeDepth());
            System.out.println("#tokens =" + target.getSrc().size());
        }
        long t1 = System.currentTimeMillis();
        for (int offset : this.execOrder.keySet()) {
            long t11 = System.currentTimeMillis();
            Command cmd = this.execOrder.get(offset);
            if (debug) {
                System.out.println(">=================================<     " + cmd.name());
            }
            Map<String, MaterializedPredicate> predicates = cmd.eval(target, action);
            if (timing) {
                System.out.print(cmd.name() + " eval time = " + (System.currentTimeMillis() - t11));
            }
            ret.putAll(predicates);
            this.namedPredicates.putAll(predicates);
        }
        this.namedPredicates = new HashMap<String, Predicate>();
        this.namedPredicates.putAll(this.symbolicPredicates);
        long t2 = System.currentTimeMillis();
        if (debug || timing) {
            System.out.println("eval time = " + (t2 - t1));
        }
        return ret;
    }

    @Override
    public ScriptEngine getEngine() {
        if (this.allowJS) {
            return super.getEngine();
        }
        return null;
    }

    private void jsCallback(Parsed target, Map<String, MaterializedPredicate> ret, String predVar, String oa, int offset) throws ScriptException {
        if (this.getEngine() == null) {
            return;
        }
        GlobalMap _globals = this.getGlobals();
        if (_globals == null) {
            return;
        }
        MaterializedPredicate mp = ret.get(predVar);
        for (Tuple t : mp.tuples) {
            if (this.stop) {
                throw new AssertionError((Object)"Arbori program stop requested");
            }
            HashMap<String, ParseNode> tuple = new HashMap<String, ParseNode>();
            for (int j = 0; j < mp.arity(); ++j) {
                String colName = mp.getAttribute(j);
                ParseNode node = mp.getAttribute(t, colName);
                tuple.put(colName, node);
            }
            try {
                _globals.put("target", (Object)target);
                _globals.put("tuple", (Object)tuple);
                _globals.put("struct", this.struct);
                _globals.put("program", (Object)this);
                this.getEngine().eval(oa, (Bindings)_globals);
            }
            catch (javax.script.ScriptException e) {
                throw new ScriptException(e, offset);
            }
            catch (Exception e) {
                System.out.println("predVar=" + predVar);
                System.out.println("tuple=" + tuple);
                e.printStackTrace();
            }
        }
    }

    private void javaCallback(Parsed target, Object action, Map<String, MaterializedPredicate> ret, String predVar) {
        if (debug) {
            System.out.println("-------->>>   " + predVar);
        }
        Class<?> c = action.getClass();
        try {
            Method callback = null;
            try {
                callback = c.getDeclaredMethod(predVar, Parsed.class, Map.class);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                callback = c.getMethod(predVar, Parsed.class, Map.class);
            }
            callback.setAccessible(true);
            MaterializedPredicate mp = ret.get(predVar);
            for (Tuple t : mp.tuples) {
                HashMap<String, ParseNode> tuple = new HashMap<String, ParseNode>();
                for (int j = 0; j < mp.arity(); ++j) {
                    String colName = mp.getAttribute(j);
                    ParseNode node = mp.getAttribute(t, colName);
                    tuple.put(colName, node);
                }
                callback.invoke(action, target, tuple);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.err.println(predVar + " callback: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean isEvaluatedOnTupleLevel(Predicate predicate) {
        if (predicate instanceof IdentedPredicate) {
            return true;
        }
        if (predicate instanceof CompositeExpr) {
            CompositeExpr ce = (CompositeExpr)predicate;
            boolean ret = Program.isEvaluatedOnTupleLevel(ce.lft);
            if (ret) {
                return ret;
            }
            if (ce.rgt != null) {
                return Program.isEvaluatedOnTupleLevel(ce.rgt);
            }
        }
        return false;
    }

    public AttributeDefinitions evalDimensions(String predVar, Parsed target, boolean debug) {
        Predicate origPred;
        AttributeDefinitions varDefs = new AttributeDefinitions(predVar, this.namedPredicates, true);
        int origDim = varDefs.listDimensions().size();
        Predicate modPred = origPred = this.namedPredicates.get(predVar);
        this.namedPredicates.put(predVar, modPred);
        AttributeDefinitions modVarDefs = new AttributeDefinitions(predVar, this.namedPredicates, false);
        int modDim = modVarDefs.listDimensions().size();
        if (modDim <= origDim) {
            varDefs = modVarDefs;
        } else {
            this.namedPredicates.put(predVar, origPred);
        }
        varDefs.evalDimensions(target, false);
        if (debug || timing && 1 < varDefs.listDimensions().size()) {
            System.out.print(predVar + " dimensions: ");
            for (String varDef : varDefs.listDimensions()) {
                System.out.print(" " + varDef);
            }
            System.out.println();
            System.out.print("Eval space = ");
            System.out.print(this.dimensions(varDefs));
            System.out.println();
        }
        if (this.test != null) {
            this.test.put("\"" + predVar + "." + EvalSpace + "\"", "\"" + this.dimensions(varDefs) + "\"");
        }
        return varDefs;
    }

    private String dimensions(AttributeDefinitions varDefs) {
        StringBuilder ret = new StringBuilder();
        boolean firstTime = true;
        for (String varDef : varDefs.listDimensions()) {
            ret.append((firstTime ? "" : "x") + varDefs.getDimensionContent(varDef).cardinality());
            firstTime = false;
        }
        return ret.toString();
    }

    public void logDimensions(String predVar, Parsed target) {
        this.evalDimensions(predVar, target, true);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.objRef;
    }

    class IncludedPrg
    implements Command {
        Program program;

        public IncludedPrg(Program program) {
            this.program = program;
        }

        @Override
        public Map<String, MaterializedPredicate> eval(Parsed target, Object action) throws ScriptException {
            Map<String, MaterializedPredicate> includedPredicates = this.program.eval(target, action);
            return includedPredicates;
        }

        @Override
        public String name() {
            return "Included program.";
        }
    }

    class JavaScriptBlock
    implements Command {
        String content;
        int pos;

        public JavaScriptBlock(String content, int pos) {
            this.content = content;
            this.pos = pos;
        }

        @Override
        public Map<String, MaterializedPredicate> eval(Parsed target, Object action) throws ScriptException {
            HashMap<String, MaterializedPredicate> ret = new HashMap<String, MaterializedPredicate>();
            try {
                GlobalMap _globals = Program.this.getGlobals();
                if (_globals == null) {
                    return ret;
                }
                _globals.put("target", (Object)target);
                _globals.put("struct", Program.this.struct);
                _globals.put("program", (Object)Program.this);
                if (0 < this.content.trim().length()) {
                    Program.this.getEngine().eval(this.content, (Bindings)Program.this.getGlobals());
                }
            }
            catch (javax.script.ScriptException e) {
                throw new ScriptException(e, this.pos);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return ret;
        }

        @Override
        public String name() {
            return "JS @offset " + this.pos;
        }
    }

    class PredicateCmd
    implements Command {
        String name;
        String action = null;
        int offset = 0;

        public PredicateCmd(String name, Predicate p) {
            this.name = name;
        }

        @Override
        public Map<String, MaterializedPredicate> eval(Parsed target, Object struct) throws ScriptException {
            MaterializedPredicate unnamed = this._eval(target, this.name);
            MaterializedPredicate table = new MaterializedPredicate(this.name, unnamed);
            table.trimAttributes();
            HashMap<String, MaterializedPredicate> ret = new HashMap<String, MaterializedPredicate>();
            ret.put(this.name, table);
            if (timing) {
                System.out.println("       (cardinality=" + table.cardinality() + ")");
            }
            if (debug) {
                System.out.println(this.name + "=" + table);
            }
            if (this.action != null) {
                long t2 = System.currentTimeMillis();
                if (javaCallbackCode.equals(this.action)) {
                    Program.this.javaCallback(target, struct, ret, this.name);
                } else {
                    Program.this.jsCallback(target, ret, this.name, this.action, this.offset);
                }
                if (debug || timing) {
                    System.out.println("callback time = " + (System.currentTimeMillis() - t2));
                }
            }
            return ret;
        }

        /*
         * WARNING - void declaration
         */
        private MaterializedPredicate _eval(Parsed target, String predVar) {
            Predicate evaluatedPredicate = Program.this.namedPredicates.get(predVar);
            if (!Program.isEvaluatedOnTupleLevel(evaluatedPredicate)) {
                return evaluatedPredicate.eval(target);
            }
            AttributeDefinitions varDefs = Program.this.evalDimensions(predVar, target, debug);
            String firstDimension = null;
            for (String dim : varDefs.listDimensions()) {
                if (firstDimension != null && varDefs.getDimensionContent(dim).cardinality() >= varDefs.getDimensionContent(firstDimension).cardinality()) continue;
                firstDimension = dim;
            }
            HashSet<String> joined = new HashSet<String>();
            joined.add(firstDimension);
            Attribute firstAttr = (Attribute)varDefs.get(firstDimension);
            MaterializedPredicate ret = ((IndependentAttribute)firstAttr).getContent();
            ret.program = Program.this;
            while (joined.size() < varDefs.listDimensions().size()) {
                String current = varDefs.minimalRelatedDimension(joined, ret.cardinality());
                if (current == null) {
                    throw new AssertionError((Object)("Cartesian product evaluation: failed to find attribute joined to " + joined + ".\n Independent Attributes: " + varDefs.listDimensions()));
                }
                joined.add(current);
                Attribute second = (Attribute)varDefs.get(current);
                MaterializedPredicate pred2 = ((IndependentAttribute)second).getContent();
                Predicate filter = new True();
                if (joined.size() != varDefs.listDimensions().size()) {
                    for (String string : ret.attributes) {
                        if (ret.name != null) {
                            String string2 = ret.name + "." + string;
                        }
                        for (String string3 : pred2.attributes) {
                            void var16_18;
                            void var14_14;
                            Predicate rel;
                            if (pred2.name != null) {
                                String string4 = pred2.name + "." + string3;
                            }
                            if ((rel = evaluatedPredicate.isRelated((String)var14_14, (String)var16_18, varDefs)) == null) continue;
                            if (filter instanceof True) {
                                filter = rel;
                                continue;
                            }
                            if (filter == rel) continue;
                            filter = new CompositeExpr(filter, rel, Oper.CONJUNCTION);
                        }
                    }
                    if (filter instanceof True && 1 < varDefs.getDimensionContent(current).cardinality() && 1 < ret.cardinality()) {
                        throw new AssertionError((Object)"Cartesian product evaluation; check for missing binary predicates");
                    }
                } else {
                    filter = evaluatedPredicate;
                }
                ret = MaterializedPredicate.filteredCartesianProduct(ret, pred2, filter, varDefs, target.getRoot());
                if (!debug) continue;
                System.out.println("dim#" + joined.size() + ",cardinality=" + ret.cardinality());
            }
            ret = MaterializedPredicate.filter(ret, evaluatedPredicate, varDefs, target.getRoot());
            if (joined.size() == varDefs.listDimensions().size()) {
                return ret;
            }
            throw new AssertionError((Object)("Missing dyadic predicate in predvar " + predVar + "; won't evaluate cartesian product"));
        }

        @Override
        public String name() {
            return "Predicate " + this.name;
        }
    }

    public static interface Command {
        public Map<String, MaterializedPredicate> eval(Parsed var1, Object var2) throws ScriptException;

        public String name();
    }
}

