/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.security;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.security.SecureReferenceData;
import oracle.dbtools.connections.security.SecureReferencePair;
import oracle.dbtools.util.Logger;

public abstract class ReferenceWorker<T> {
    public static final String KEY = ReferenceWorker.class.getName();

    public final SecureReferencePair<T> encrypt(String key, char[] data, String connectionName) {
        return SecureReferencePair.createSecureReference(key, this.encryptValue(key, data, connectionName));
    }

    protected abstract SecureReferenceData<T> encryptValue(String var1, char[] var2, String var3);

    public final char[] decrypt(SecureReferencePair<T> ref, String connectionName) {
        return this.decryptValue(ref.getKey(), (SecureReferenceData<T>)ref.getValue(), connectionName);
    }

    protected char[] decryptValue(String name, SecureReferenceData<T> value, String connectionName) {
        return null;
    }

    public final void updateExternalReferences(String oldConnName, String newConnName) {
    }

    protected void updateReferences(String oldConnName, String newConnName) {
    }

    public static ReferenceWorker<char[]> createWorker(String key) {
        ReferenceWorker<char[]> worker = null;
        worker = ModelUtil.hasLength(key) ? ReferenceWorker.createDefaultWorker(key) : ReferenceWorker.createNullWorker();
        return worker;
    }

    public static ReferenceWorker<char[]> createNullWorker() {
        return new ReferenceWorker<char[]>(){

            @Override
            public SecureReferenceData<char[]> encryptValue(String name, char[] value, String connectionName) {
                return null;
            }
        };
    }

    public static ReferenceWorker<char[]> createDefaultWorker(String key) {
        return new AESWorker(key, new PBEWorker(key));
    }

    private static class PBEWorker
    extends ReferenceWorker<char[]> {
        private final AlgorithmParameterSpec m_paramSpec;
        private final SecretKey m_key;
        private Cipher m_encoder;
        private Cipher m_decoder;

        public PBEWorker(String passPhrase) {
            PBEParameterSpec paramSpec = null;
            SecretKey key = null;
            try {
                byte[] salt = new byte[]{5, 19, -103, 66, -109, 114, -24, -83};
                int iterationCount = 42;
                PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, 42);
                key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
                paramSpec = new PBEParameterSpec(salt, 42);
            }
            catch (Exception e) {
                Logger.severe(ReferenceWorker.class, "setup failure", e);
            }
            this.m_paramSpec = paramSpec;
            this.m_key = key;
        }

        @Override
        public SecureReferenceData<char[]> encryptValue(String name, char[] value, String connectionName) {
            String encStr = null;
            if (this.m_key != null) {
                try {
                    if (this.m_encoder == null) {
                        this.m_encoder = Cipher.getInstance(this.m_key.getAlgorithm());
                        this.m_encoder.init(1, (Key)this.m_key, this.m_paramSpec);
                    }
                    String str = new String(value);
                    byte[] utf8 = str.getBytes("UTF8");
                    byte[] enc = this.m_encoder.doFinal(utf8);
                    encStr = Base64.getEncoder().encodeToString(enc);
                }
                catch (Exception e) {
                    String msg = "Password encryption failed for connection " + connectionName;
                    Logger.severe(ReferenceWorker.class, msg);
                    Logger.fine(ReferenceWorker.class, msg, e);
                    this.m_encoder = null;
                }
            }
            return SecureReferenceData.buildCredentialReference(encStr.toCharArray());
        }

        @Override
        public char[] decryptValue(String name, SecureReferenceData<char[]> value, String connectionName) {
            char[] retval = null;
            if (this.m_key != null) {
                try {
                    if (this.m_decoder == null) {
                        this.m_decoder = Cipher.getInstance(this.m_key.getAlgorithm());
                        this.m_decoder.init(2, (Key)this.m_key, this.m_paramSpec);
                    }
                    byte[] dec = Base64.getDecoder().decode(new String(value.getValue()));
                    byte[] utf8 = this.m_decoder.doFinal(dec);
                    retval = new String(utf8, "UTF8").toCharArray();
                }
                catch (Exception e) {
                    String msg = "Password decryption failed for connection " + connectionName;
                    Logger.severe(ReferenceWorker.class, msg);
                    Logger.fine(ReferenceWorker.class, msg, e);
                    this.m_decoder = null;
                }
            }
            if (retval == null) {
                return super.decryptValue(name, value, connectionName);
            }
            return retval;
        }
    }

    private static class AESWorker
    extends ReferenceWorker<char[]> {
        private final SecretKey m_key;
        private final ReferenceWorker<char[]> m_fallback;

        public AESWorker(String passPhrase, ReferenceWorker<char[]> fallback) {
            SecretKeySpec key = null;
            try {
                byte[] salt = new byte[]{6, -74, 97, 35, 61, 104, 50, -72};
                int iterationCount = 5000;
                int keysize = 256;
                PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, 5000, 256);
                SecretKey tmp = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256").generateSecret(keySpec);
                key = new SecretKeySpec(tmp.getEncoded(), "AES");
            }
            catch (Exception e) {
                Logger.severe(ReferenceWorker.class, "setup failure", e);
            }
            this.m_key = key;
            this.m_fallback = fallback;
        }

        @Override
        public SecureReferenceData<char[]> encryptValue(String name, char[] value, String connectionName) {
            String encStr = null;
            if (this.m_key != null) {
                try {
                    Cipher encoder = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    encoder.init(1, this.m_key);
                    AlgorithmParameters params = encoder.getParameters();
                    byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
                    String str = new String(value);
                    byte[] utf8 = str.getBytes("UTF8");
                    byte[] enc = encoder.doFinal(utf8);
                    byte[] data = new byte[iv.length + enc.length];
                    System.arraycopy(iv, 0, data, 0, iv.length);
                    System.arraycopy(enc, 0, data, iv.length, enc.length);
                    encStr = Base64.getEncoder().encodeToString(data);
                }
                catch (Exception e) {
                    String msg = "Password encryption failed for connection " + connectionName;
                    Logger.severe(ReferenceWorker.class, msg);
                    Logger.fine(ReferenceWorker.class, msg, e);
                }
            }
            return SecureReferenceData.buildCredentialReference(encStr.toCharArray());
        }

        @Override
        public char[] decryptValue(String name, SecureReferenceData<char[]> value, String connectionName) {
            char[] retval;
            block9: {
                retval = null;
                if (this.m_key != null) {
                    boolean triedFallback = false;
                    try {
                        byte[] data = Base64.getDecoder().decode(new String(value.getValue()));
                        if (data.length <= 16) {
                            triedFallback = true;
                            retval = this.m_fallback.decryptValue(name, value, connectionName);
                        } else {
                            byte[] iv = new byte[16];
                            byte[] dec = new byte[data.length - 16];
                            System.arraycopy(data, 0, iv, 0, 16);
                            System.arraycopy(data, 16, dec, 0, dec.length);
                            Cipher decoder = Cipher.getInstance("AES/CBC/PKCS5Padding");
                            decoder.init(2, (Key)this.m_key, new IvParameterSpec(iv));
                            byte[] utf8 = decoder.doFinal(dec);
                            if (utf8 == null || utf8.length == 0) {
                                triedFallback = true;
                                retval = this.m_fallback.decryptValue(name, value, connectionName);
                            } else {
                                retval = new String(utf8, "UTF8").toCharArray();
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!triedFallback) {
                            retval = this.m_fallback.decryptValue(name, value, connectionName);
                        }
                        if (retval != null) break block9;
                        String msg = "Password decryption failed for connection " + connectionName;
                        Logger.severe(ReferenceWorker.class, msg);
                        Logger.fine(ReferenceWorker.class, msg, e);
                    }
                }
            }
            if (retval == null) {
                return super.decryptValue(name, value, connectionName);
            }
            return retval;
        }
    }
}

