/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.readservice;

import oracle.dbtools.data.readservice.ReadParmsAPI;

public class ReadParmsDelimitedAPI
extends ReadParmsAPI {
    public static String DEFAULT_ENCODING = "UTF8";
    public static String DEFAULT_DELIMITER = ",";
    public static String DEFAULT_ENCLOSURE = "\"";
    public static int UNLIMITED = -1;
    public static final String EOL_CRLF = "\r\n";
    public static final String EOL_LF = "\n";
    public static final String EOL_CR = "\r";
    private ReadParmsAPI.SERVICE_TYPE _serviceType;
    private String _encoding = DEFAULT_ENCODING;
    private String _delimiter = DEFAULT_DELIMITER;
    private String _enclosureLeft = DEFAULT_ENCLOSURE;
    private String _enclosureRight = DEFAULT_ENCLOSURE;
    private boolean _enclosureRightDouble;
    private String _lineEnd;
    private int _lineMax;

    private ReadParmsDelimitedAPI(Builder builder) {
        super(builder._header, builder._headerBeforeSkip, builder._skipRows, builder._limitRows);
        this._serviceType = builder._serviceType;
        this._encoding = this.notNull(builder._encoding);
        this._delimiter = this.notNull(builder._delimiter);
        this._enclosureLeft = this.notNull(builder._enclosureLeft);
        this._enclosureRight = this.notNull(builder._enclosureRight);
        this._enclosureRightDouble = builder._enclosureRightDouble;
        this._lineEnd = builder._lineEnd;
        this._lineMax = builder._lineMax;
        this.validateParm(PARMS.SERVICE_TYPE, (Object)this._serviceType);
        this.validateParm(PARMS.DELIMITER, this._delimiter);
        if (this._enclosureLeft.length() > 0 && this._enclosureRight.length() == 0) {
            this._enclosureRight = this._enclosureLeft;
        }
        if (this._lineMax < 1) {
            this._lineMax = UNLIMITED;
        }
        if (this.getSkipRows() < 0) {
            throw new IllegalStateException(PARMS.SKIP_ROWS.toString());
        }
    }

    private void validateParm(Enum<PARMS> parm, Object parmValue) {
        if (parmValue == null || parmValue instanceof String && ((String)parmValue).length() == 0) {
            throw new IllegalStateException(parm.toString());
        }
    }

    private String notNull(String string) {
        return string != null ? string : "";
    }

    @Override
    public ReadParmsAPI.SERVICE_TYPE getServiceType() {
        return this._serviceType;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public static boolean isDelimiterWhiteSpace(String delimiter) {
        return delimiter.length() > 1 && delimiter.equals("  ");
    }

    public boolean isDelimiterWhiteSpace() {
        return this._delimiter.length() > 1 && this._delimiter.equals("  ");
    }

    public String getDelimiterValue() {
        String delimChars = this.getDelimiter();
        if (delimChars != null && delimChars.length() > 0) {
            if (delimChars.equals("TAB")) {
                delimChars = "\t";
            } else if (delimChars.equals("WHITESPACE")) {
                delimChars = "  ";
            } else if (delimChars.equals("SPACE")) {
                delimChars = " ";
            }
        }
        return delimChars;
    }

    public static String getDelimiterString(String delim) {
        String delimChars = delim;
        if (delimChars.equals("TAB")) {
            delimChars = "X'09'";
        } else if (delimChars.equals("WHITESPACE")) {
            delimChars = "WHITESPACE";
        } else if (delimChars.equals("SPACE")) {
            delimChars = " ";
        }
        if (delimChars.equals("\t")) {
            return "\\t";
        }
        return delimChars;
    }

    public boolean isEnclosed() {
        return this.getEnclosureLeft().length() != 0 && this.getEnclosureRight().length() != 0;
    }

    public String getEnclosureLeft() {
        return this._enclosureLeft;
    }

    public String getEnclosureRight() {
        return this._enclosureRight;
    }

    public boolean isEnclosureRightDouble() {
        return this._enclosureRightDouble;
    }

    public static String getEnvTerminatorValue() {
        return System.getProperty("line.separator");
    }

    public String getTerminator() {
        return this._lineEnd;
    }

    public boolean isStandardTerminator() {
        return this._lineEnd == null || this._lineEnd.equalsIgnoreCase(EOL_CRLF) || this._lineEnd.equals(EOL_CR) || this._lineEnd.equals(EOL_LF);
    }

    public boolean getUseMaxLength() {
        return this._lineMax > 0;
    }

    public int getMaxLength() {
        return this._lineMax;
    }

    public static class Builder {
        private String _format = "CSV";
        private ReadParmsAPI.SERVICE_TYPE _serviceType;
        private boolean _header = true;
        private boolean _headerBeforeSkip = true;
        private int _skipRows = 0;
        private int _limitRows = UNLIMITED;
        private String _encoding = DEFAULT_ENCODING;
        private String _delimiter = DEFAULT_DELIMITER;
        private String _enclosureLeft = DEFAULT_ENCLOSURE;
        private String _enclosureRight = DEFAULT_ENCLOSURE;
        private boolean _enclosureRightDouble;
        private String _lineEnd;
        private int _lineMax = UNLIMITED;

        public Builder() {
            this._serviceType = ReadParmsAPI.SERVICE_TYPE.CSV;
        }

        public Builder header(boolean header) {
            this._header = header;
            return this;
        }

        public Builder headerBeforeSkip(boolean headerBeforeSkip) {
            this._headerBeforeSkip = headerBeforeSkip;
            return this;
        }

        public Builder skipRows(int skipRows) {
            this._skipRows = skipRows;
            return this;
        }

        public Builder limitRows(int limitRows) {
            this._limitRows = limitRows;
            return this;
        }

        public Builder encoding(String encoding) {
            this._encoding = encoding == null ? DEFAULT_ENCODING : encoding;
            return this;
        }

        public Builder delimiter(String delimiter) {
            this._delimiter = delimiter;
            return this;
        }

        public Builder enclosures(String enclosures) {
            if (enclosures == null || enclosures.length() == 0) {
                this._enclosureLeft = "";
                this._enclosureRight = "";
            } else if (enclosures.length() == 1) {
                this._enclosureLeft = enclosures;
                this._enclosureRight = enclosures;
            } else {
                this._enclosureLeft = enclosures.substring(0, 1);
                this._enclosureRight = enclosures.substring(1, 2);
            }
            return this;
        }

        public Builder enclosureLeft(String enclosureLeft) {
            this._enclosureLeft = enclosureLeft;
            return this;
        }

        public Builder enclosureRight(String enclosureRight) {
            this._enclosureRight = enclosureRight;
            return this;
        }

        public Builder enclosureRightDouble(boolean enclosureRightDouble) {
            this._enclosureRightDouble = enclosureRightDouble;
            return this;
        }

        public Builder lineEnd(String lineEnd) {
            if (lineEnd != null) {
                if (lineEnd.equals("\\r")) {
                    this._lineEnd = ReadParmsDelimitedAPI.EOL_CR;
                } else if (lineEnd.equals("\\r\\n")) {
                    this._lineEnd = ReadParmsDelimitedAPI.EOL_CRLF;
                } else if (lineEnd.equals("\\n")) {
                    this._lineEnd = ReadParmsDelimitedAPI.EOL_LF;
                }
            }
            this._lineEnd = lineEnd;
            return this;
        }

        public Builder lineMax(int lineMax) {
            this._lineMax = lineMax;
            return this;
        }

        public ReadParmsDelimitedAPI build() {
            return new ReadParmsDelimitedAPI(this);
        }
    }

    private static enum PARMS {
        SERVICE_TYPE,
        HEADER,
        SKIP_BEFORE_HEADER,
        SKIP_ROWS,
        LIMIT_ROWS,
        ENCODING,
        DELIMITER,
        LEFT_ENCLOSURE,
        RIGHT_ENCLOSURE,
        RIGHT_ENCLOSURE_DOUBLE,
        LINE_END,
        MAX_LENGTH;

    }
}

