/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.io.IOException;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.BottomTitle;
import oracle.dbtools.raptor.newscriptrunner.commands.Break;
import oracle.dbtools.raptor.newscriptrunner.commands.Compute;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.SetPause;
import oracle.dbtools.raptor.newscriptrunner.commands.TopTitle;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.util.Closeables;
import oracle.dbtools.util.Pair;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class SQLPLUSCmdFormatter
extends ResultSetFormatter {
    private final HashMap<Integer, Integer> m_nls_formats = new HashMap();
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private int m_linesize = -1;
    private int m_pagesize = -1;
    private int m_newpage = 0;
    private String m_scan = "";
    private String m_colsep = "";
    private String m_headsep = "";
    private String m_headsepchar = "";
    private String m_heading = "";
    private String m_wrap = "";
    private int m_numwidth = -1;
    private String m_numformat = "";
    private int m_long = -1;
    private int m_longchunk = -1;
    private String m_null = "";
    private TopTitle m_TopTitle = null;
    private BottomTitle m_BottomTitle = null;
    private boolean m_embedded = false;
    private StringBuffer m_header = new StringBuffer();
    private final StringBuffer m_headerLine = new StringBuffer();
    private String[] m_columns = null;
    private String[] m_formattedcols = null;
    private Integer[] m_colsizes = null;
    private int m_delim_lnsize = -1;
    private final StringBuffer m_empty_page = null;
    private boolean m_foldedrows = false;
    private String m_sql = "";
    private Connection m_conn = null;
    private static final String DONE = "<<DONE>>";
    private final ArrayList<String> m_breakcolumns = new ArrayList();
    private final HashMap<String, String> m_column_to_brkcol = new HashMap();
    private final HashMap<String, Boolean> m_brkcol_to_nodup = new HashMap();
    private final HashMap<String, Integer> m_brkcol_to_rank = new HashMap();
    private boolean m_breakandselorderMatch = true;
    HashMap<Integer, Integer> m_breakcolToSkipLinesForGrp = new HashMap();
    private ArrayList<String> m_brkcmptcolumns = null;
    private ArrayList<String> m_computecolumns = null;
    private final HashMap<String, String> m_column_to_brkcmptcol = new HashMap();
    private final HashMap<String, String> m_brkcol_to_cmplbl = new HashMap();
    private final HashMap<String, String> m_brkcol_to_cmpfn = new HashMap();
    private final HashMap<String, HashMap> m_brkcol_to_cmpfnlbl = new HashMap();
    private final TreeMap<String, String> m_column_to_cmpcol = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final HashMap<String, String> m_brkcmpkey_to_col = new HashMap();
    private final HashMap<String, String[]> m_brkcmpkey_to_cols = new HashMap();
    private Object[] m_summaryLines = null;
    private final HashMap<String, Object[]> m_column_to_summaryLines = new HashMap();
    private final ArrayList<String> m_selTableList = new ArrayList();
    private String m_with = "";
    private final ArrayList<String> m_selColumnList = new ArrayList();
    private final ArrayList<String> m_selPredicateList = new ArrayList();
    private final ArrayList<String> m_selGroupByList = new ArrayList();
    private final ArrayList<String> m_selOrderByList = new ArrayList();
    private final TreeMap<String, String> m_column_to_alias = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final HashMap<String, Integer> m_dtformat_to_colsize = new HashMap();
    private final ArrayList<String> m_121IdentViewList = new ArrayList();
    private String m_cursorHeader = "";

    public SQLPLUSCmdFormatter() {
        super(ScriptRunnerContext.getCurrentContext() != null ? ScriptRunnerContext.getCurrentContext() : new ScriptRunnerContext());
    }

    public SQLPLUSCmdFormatter(ScriptRunnerContext inScriptRunnerContext) {
        super(inScriptRunnerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rset2sqlplus(ResultSet rset, Connection conn, Object out, StringBuffer errbuf) throws IOException, SQLException {
        int cnt = 0;
        int maxRowCache = this.getMaxRows();
        this.m_conn = conn;
        ResultSetMetaData rmeta = rset.getMetaData();
        int colCnt = rmeta.getColumnCount();
        Integer[] colsizes = new Integer[colCnt + 1];
        String[] columns = new String[colCnt + 1];
        String[] coldataTypes = new String[colCnt + 1];
        this.m_formattedcols = new String[colCnt + 1];
        this.m_columns = new String[colCnt + 1];
        String[] lastVal = null;
        String[] oldlVal = null;
        boolean newVal = this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getColumnMap() != null && this.m_scriptRunnerContext.getColumnMap().size() > 0;
        boolean oldVal = this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getOVColumnMap() != null && this.m_scriptRunnerContext.getOVColumnMap().size() > 0;
        StringBuffer header_rows = new StringBuffer("");
        StringBuffer tot_header = new StringBuffer();
        Object tTitle = null;
        Object btmTitle = null;
        boolean bComputed = false;
        int cursorCnt = 0;
        Object cursorData = "";
        HashMap<String, ArrayList<String>> storedColsCmds = this.m_scriptRunnerContext.getStoredFormatCmds();
        LinkedHashMap<String, ArrayList<String>> storedBrkCmds = this.m_scriptRunnerContext.getStoredBreakCmds();
        this.m_pagesize = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setpagesize");
        this.m_linesize = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlinesize");
        this.m_scan = (String)this.m_scriptRunnerContext.getProperty("sql.scan");
        this.m_colsep = (String)this.m_scriptRunnerContext.getProperty("script.runner.setcolsep");
        this.m_headsep = (String)this.m_scriptRunnerContext.getProperty("script.runner.setheadsep");
        this.m_headsepchar = (String)this.m_scriptRunnerContext.getProperty("script.runner.setheadsepchar");
        this.m_heading = (String)this.m_scriptRunnerContext.getProperty("script.runner.setheading");
        this.m_wrap = (String)this.m_scriptRunnerContext.getProperty("script.runner.setwrap");
        this.m_long = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlong");
        this.m_longchunk = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlongchunksize");
        this.m_numwidth = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setnumwidth");
        this.m_numformat = (String)this.m_scriptRunnerContext.getProperty("script.runner.setnumformat");
        this.m_null = (String)this.m_scriptRunnerContext.getProperty("script.runner.setnull");
        this.m_TopTitle = this.m_scriptRunnerContext.getTTitle();
        this.m_BottomTitle = this.m_scriptRunnerContext.getBTitle();
        this.m_delim_lnsize = this.m_linesize + m_lineSeparator.length();
        if (this.m_scriptRunnerContext.getProperty("script.runner.newpage") instanceof String && ((String)this.m_scriptRunnerContext.getProperty("script.runner.newpage")).equalsIgnoreCase("NONE")) {
            this.m_newpage = 0;
        } else if (this.m_pagesize > 0) {
            this.m_newpage = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.newpage");
        }
        this.m_embedded = Boolean.parseBoolean(this.m_scriptRunnerContext.getProperty("sqlplus.embedded.mode").toString());
        Integer linenum = 0;
        Integer page = 0;
        ArrayDeque<String[]> brkColValues = new ArrayDeque<String[]>();
        HashMap<String, String> cMap = new HashMap();
        HashMap<String, String> ovcMap = new HashMap();
        if (this.m_scriptRunnerContext != null) {
            cMap = this.m_scriptRunnerContext.getColumnMap();
            ovcMap = this.m_scriptRunnerContext.getOVColumnMap();
        }
        if (cMap.size() != 0 || ovcMap.size() != 0) {
            for (int i = 1; i < colCnt + 1; ++i) {
                columns[i] = rmeta.getColumnName(i);
                coldataTypes[i] = rmeta.getColumnTypeName(i);
            }
        }
        this.populateDTFmtsToColsizes();
        ArrayList<Object> firstRow = new ArrayList<Object>();
        if (rset.next()) {
            for (int i = 1; i < colCnt + 1; ++i) {
                if (rset instanceof OracleResultSet) {
                    try {
                        if (rmeta.getColumnType(i) == -1 || rmeta.getColumnType(i) == -2) {
                            String data = DataTypesUtil.stringValue(ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, i), conn);
                            firstRow.add(data);
                            continue;
                        }
                        firstRow.add(ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, i));
                    }
                    catch (SQLException e) {
                        firstRow.add(rset.getObject(i));
                    }
                    continue;
                }
                firstRow.add(rset.getObject(i));
            }
        } else {
            this.m_scriptRunnerContext.updateColumn(columns, null, null);
            this.m_scriptRunnerContext.updateOVColumn(columns, null, null);
            return cnt;
        }
        int linediff = this.m_linesize;
        if (this.m_scriptRunnerContext.is121LongIdentUsed()) {
            storedColsCmds = this.m_scriptRunnerContext.get121IdentViewColCmds();
        }
        boolean b_ml_header = this.hasMultiLineHeaders(storedColsCmds, rset);
        for (int i = 1; i < colCnt + 1; ++i) {
            String heading = "";
            String colName = this.getColumnName(rset, i).toLowerCase();
            int colType = rmeta.getColumnType(i);
            colsizes[i] = this.getColumnSize(conn, rset, i, storedColsCmds);
            HashMap<String, ArrayList<String>> prodStoredcolsCmds = this.m_scriptRunnerContext.getStoredFormatCmds();
            heading = prodStoredcolsCmds != storedColsCmds ? this.getHeading(colName, prodStoredcolsCmds) : this.getHeading(colName, storedColsCmds);
            String getColumnNameCache = this.getColumnName(rset, i);
            String string = this.m_columns[i] = getColumnNameCache.length() > colsizes[i] ? getColumnNameCache.substring(0, colsizes[i]) : getColumnNameCache;
            if (this.m_wrap.equalsIgnoreCase("OFF")) {
                if (i == colCnt) {
                    if ((linediff -= colsizes[i].intValue()) < 0) {
                        colsizes[i] = colsizes[i] + linediff;
                    }
                } else if ((linediff -= colsizes[i] + this.m_colsep.length()) < 0) {
                    colsizes[i] = colsizes[i] + linediff + this.m_colsep.length();
                }
            }
            if (heading.equals("")) {
                if (storedColsCmds.get(colName) != null && storedColsCmds.get(colName).contains("heading ")) {
                    this.m_columns[i] = heading;
                } else {
                    String colNameCache = this.getColumnName(rset, i);
                    this.m_columns[i] = colNameCache.length() > colsizes[i] ? colNameCache.substring(0, colsizes[i]) : colNameCache;
                    colsizes[i] = colsizes[i];
                }
            }
            String string2 = this.m_columns[i] = this.m_columns[i].length() > this.m_linesize ? this.m_columns[i].substring(0, this.m_linesize) : this.m_columns[i];
            if (b_ml_header) {
                String string3 = heading = heading.equals("") ? this.m_columns[i] : heading;
                if (this.displayColumnAttributes(storedColsCmds, colName) && storedColsCmds.get(colName.toLowerCase()) != null) {
                    this.convertToMultiLineHeader(colsizes[i], i, heading, this.m_columns);
                }
            } else if (!heading.equals("")) {
                String string4 = this.m_columns[i] = heading.length() > colsizes[i] ? heading.substring(0, colsizes[i]) : heading;
            }
            if (this.printColumn(storedColsCmds, colName)) {
                int colsize;
                int n = colsize = colsizes[i] > this.m_linesize ? this.m_linesize : colsizes[i];
                if (this.isNumericColumn(colType)) {
                    ArrayList<String> colcmds = storedColsCmds.get(colName.toLowerCase());
                    if (colcmds != null && this.displayColumnAttributes(storedColsCmds, colName.toLowerCase()) && (colcmds.contains("justify left") || colcmds.contains("justify right") || colcmds.contains("justify center"))) {
                        this.m_formattedcols[i] = this.justifyHeaders(storedColsCmds, colName.toLowerCase(), this.m_columns[i], colsize);
                        this.m_header.append(this.m_formattedcols[i]);
                    } else {
                        this.m_formattedcols[i] = this.justify_right(this.m_columns[i], colsize);
                        this.m_header.append(this.m_formattedcols[i]);
                    }
                } else if (this.isLongColumn(colType) && colsizes[i] >= this.m_linesize) {
                    this.m_formattedcols[i] = this.justifyHeaders(storedColsCmds, colName.toLowerCase(), this.m_columns[i], this.m_linesize);
                    this.m_header.append(this.m_formattedcols[i]);
                    this.getFontMetrics();
                    this.font_width_adjustment(this.m_header, this.m_linesize);
                } else {
                    this.m_formattedcols[i] = this.justifyHeaders(storedColsCmds, colName.toLowerCase(), this.m_columns[i], colsize);
                    this.m_header.append(this.m_formattedcols[i]);
                }
            }
            char[] chars = new char[colsizes[i].intValue()];
            if (colsizes[i] >= this.m_linesize) {
                chars = new char[this.m_linesize];
                Arrays.fill(chars, '-');
            } else {
                Arrays.fill(chars, '-');
            }
            if (this.printColumn(storedColsCmds, colName)) {
                this.m_headerLine.append(chars);
                if (this.isLongColumn(colType) && colsizes[i] >= this.m_linesize) {
                    this.getFontMetrics();
                    this.font_width_adjustment(this.m_headerLine, this.m_linesize);
                }
                if (!b_ml_header) {
                    if (i <= colCnt && linediff > 0) {
                        this.m_header.append(this.m_colsep);
                        this.m_headerLine.append(this.m_colsep);
                    }
                } else if (i <= colCnt && linediff > 0) {
                    this.m_headerLine.append(this.m_colsep);
                }
            }
            if (this.m_wrap.equalsIgnoreCase("OFF") && linediff <= 0) break;
        }
        if (b_ml_header) {
            this.getFontMetrics();
            this.m_header = this.multilineHeader(rset, storedColsCmds, colsizes, this.m_columns, this.m_columns, true);
        } else if (this.m_header.length() > 0 && this.m_colsep.equals(this.m_header.substring(this.m_header.length() - 1)) && linediff > 0) {
            this.m_header.deleteCharAt(this.m_header.length() - 1);
        }
        header_rows.append(this.m_header);
        header_rows.append(m_lineSeparator);
        if (this.m_headerLine.length() > 0 && this.m_colsep.equals(this.m_headerLine.substring(this.m_headerLine.length() - 1)) && linediff > 0) {
            this.m_headerLine.deleteCharAt(this.m_headerLine.length() - 1);
        }
        header_rows.append(this.m_headerLine);
        header_rows.append(m_lineSeparator);
        boolean bPrintTitle = false;
        StringBuffer bufpage = new StringBuffer("");
        StringBuffer databuf = new StringBuffer("");
        SetPause dataBufHelper = null;
        Boolean isPause = (Boolean)this.m_scriptRunnerContext.getProperty("script.runner.set_pause");
        if (isPause != null && isPause.equals(Boolean.TRUE)) {
            dataBufHelper = new SetPause();
        }
        StringBuffer tTitle_header = null;
        int pageNo = 1;
        int lineNo = 0;
        int bTitle_lines = 0;
        int offSet = 0;
        boolean newPage = true;
        int oldPageNo = -1;
        if (this.m_embedded && (Integer)this.m_scriptRunnerContext.getProperty("script.runner.lno") >= 0) {
            lineNo = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.lno");
            int n = pageNo = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.pno") == 0 ? pageNo : (Integer)this.m_scriptRunnerContext.getProperty("script.runner.pno");
            if ((lineNo += this.m_pagesize * (pageNo - 1)) == 0 || lineNo >= pageNo * this.m_pagesize) {
                if (lineNo > pageNo * this.m_pagesize) {
                    offSet = lineNo - pageNo * this.m_pagesize;
                    lineNo -= offSet;
                }
                offSet = 0;
                if (lineNo > 0) {
                    ++pageNo;
                }
                for (int np = 0; np < this.m_newpage; ++np) {
                    databuf.append(m_lineSeparator);
                    ++lineNo;
                }
            } else {
                this.m_newpage = 0;
            }
        }
        ArrayList<Integer> colsizesList = new ArrayList<Integer>();
        ArrayList<String> columnsList = new ArrayList<String>();
        if (this.m_wrap.equalsIgnoreCase("OFF")) {
            int i;
            for (i = 0; i < colsizes.length; ++i) {
                if (i == 0) {
                    colsizesList.add(colsizes[i]);
                }
                if (i <= 0 || colsizes[i] == null) continue;
                colsizesList.add(colsizes[i]);
            }
            colsizes = new Integer[colsizesList.size()];
            colsizesList.toArray(colsizes);
            for (i = 0; i < this.m_columns.length; ++i) {
                if (i == 0) {
                    columnsList.add(this.m_columns[i]);
                }
                if (i <= 0 || this.m_columns[i] == null) continue;
                columnsList.add(this.m_columns[i]);
            }
            if (columnsList.size() < this.m_columns.length) {
                boolean rowstrunc = false;
                for (int i2 = 1; i2 < this.m_columns.length; ++i2) {
                    if (i2 < columnsList.size()) {
                        if (!((String)columnsList.get(i2)).equals(this.m_columns[i2])) continue;
                        continue;
                    }
                    String message = MessageFormat.format(ScriptRunnerDbArb.getString("ROWSTRUNCATED"), this.getColumnName(rset, i2)) + m_lineSeparator;
                    this.write(out, message);
                    rowstrunc = true;
                }
                if (rowstrunc) {
                    this.write(out, m_lineSeparator);
                }
                this.m_columns = new String[columnsList.size()];
                columnsList.toArray(this.m_columns);
                colCnt = this.m_columns.length;
            }
        }
        this.m_colsizes = colsizes;
        int titleLines = 0;
        int adjPagesize = 0;
        if (this.m_heading.equalsIgnoreCase("ON")) {
            if (this.m_pagesize < 0 && this.m_linesize < 0) {
                this.write(out, header_rows.toString());
            } else {
                if (this.m_linesize == 0) {
                    String msg = ScriptRunnerDbArb.getString("ZERO_LNSIZE");
                    this.write(out, msg + m_lineSeparator + m_lineSeparator);
                    return cnt;
                }
                titleLines = this.getTotTitleLines();
                StringBuffer colsHeader = new StringBuffer("");
                boolean tot_hdr_lines = false;
                if (b_ml_header) {
                    this.adjustHeaderToLineandPageSize(rset, storedColsCmds, this.m_colsizes, this.m_columns, tot_header, 0);
                    if (tot_header.length() == 0) {
                        tot_header = header_rows;
                    }
                } else if (this.isAValidLinesize()) {
                    this.adjustToLineandPageSize(rset, storedColsCmds, this.m_colsizes, this.m_header, this.m_headerLine, tot_header, 0);
                }
                adjPagesize = this.getAdjustedPagesize(tot_header, titleLines);
                if (this.m_pagesize >= 0 && !this.isAValidLinesize()) {
                    int i;
                    int linesize = 0;
                    if (this.m_pagesize > 2) {
                        if (this.m_scriptRunnerContext.getBTitleFlag() || this.m_scriptRunnerContext.getTTitleFlag()) {
                            if (this.m_pagesize > 4) {
                                tot_header = header_rows;
                            }
                        } else if (this.m_pagesize > 2) {
                            tot_header = header_rows;
                        }
                    }
                    for (i = 1; i < colsizes.length; ++i) {
                        if (i < this.m_colsizes.length - 1) {
                            linesize += this.m_colsizes[i] + this.m_colsep.length();
                            continue;
                        }
                        linesize += this.m_colsizes[i].intValue();
                    }
                    if (this.m_linesize > 0 && linesize / this.m_linesize <= 10) {
                        for (i = 1; i < colsizes.length; ++i) {
                            int colType = rmeta.getColumnType(i);
                            if (this.isLongColumn(colType) || this.m_linesize >= colsizes[i]) continue;
                            colsizes[i] = i < this.m_colsizes.length - 1 ? Integer.valueOf(this.m_linesize + this.m_colsep.length()) : Integer.valueOf(this.m_linesize);
                        }
                        this.m_delim_lnsize = this.m_linesize + m_lineSeparator.length();
                        StringBuffer temp_header = new StringBuffer("");
                        String[] strs = tot_header.toString().split(m_lineSeparator);
                        for (int i3 = 0; i3 < strs.length; ++i3) {
                            if (strs[i3].length() <= 0) continue;
                            temp_header.append(strs[i3].substring(0, this.m_linesize));
                            temp_header.append(m_lineSeparator);
                        }
                        tot_header = temp_header;
                    }
                    if (linesize > this.m_linesize) {
                        this.m_delim_lnsize = linesize + m_lineSeparator.length();
                    }
                }
            }
        } else {
            adjPagesize = this.m_pagesize;
        }
        if (dataBufHelper != null) {
            dataBufHelper.mark(this.m_scriptRunnerContext, out, databuf);
        }
        ArrayList<StringBuffer> cacheRow = new ArrayList<StringBuffer>();
        for (int i = 0; i < colCnt + 1; ++i) {
            cacheRow.add(new StringBuffer());
        }
        ArrayList<StringBuffer> cpcacheRow = new ArrayList<StringBuffer>();
        ArrayList<StringBuffer> cpttlcacheRow = new ArrayList<StringBuffer>();
        boolean beginIdx = false;
        boolean endIdx = false;
        boolean startIdx = false;
        boolean idx = false;
        Object lastStr = "";
        HashMap<Integer, String> prevColToVal = new HashMap<Integer, String>();
        ArrayList cmptd_rows = new ArrayList();
        ArrayList<Object> cmptd_columns = new ArrayList<Object>();
        HashMap<String, Object[][]> comp_rows = new HashMap<String, Object[][]>(1000);
        int grpRowCount = 0;
        int grpFirstCmptdCount = 0;
        ArrayList cmptd_rowset = null;
        ArrayList rowIndexes = new ArrayList();
        String[] breakcolcmptkeys = null;
        Object[][] cmptd_rowset_arr = null;
        int missingSkipLines = 0;
        int prevLevelRows = 0;
        int skipLinesPerColumn = 0;
        Object missingLineTerminators = "";
        HashMap<String, Integer> bckeyprevLevelcounts = new HashMap<String, Integer>();
        boolean bAppendedMultiRowLnTerm = true;
        this.populateBreakCmdInfo();
        while (cnt < maxRowCache || SQLPLUSCmdFormatter.continueIfPossible(cnt, maxRowCache, this.m_scriptRunnerContext, out, rset, errbuf, null)) {
            int i;
            ArrayList<String> fList;
            boolean bCmptdReport;
            boolean brsNext;
            block388: {
                block391: {
                    block389: {
                        block390: {
                            this.checkCanProceed();
                            if (this.cancel) break;
                            brsNext = false;
                            bCmptdReport = false;
                            if (cnt == 0 && firstRow.size() == 0) break;
                            if (cnt == 0) break block388;
                            if (grpFirstCmptdCount <= 0 || grpFirstCmptdCount != grpRowCount) break block389;
                            if (!this.isEmptyBreakColKeys(breakcolcmptkeys)) break block390;
                            grpRowCount = 0;
                            break block391;
                        }
                        if (cmptd_rowset_arr != null || breakcolcmptkeys.length < 1) break block391;
                        if (this.isAllRowCountsEqual(comp_rows, cmptd_columns, breakcolcmptkeys)) {
                            cmptd_rowset_arr = this.getComputedRowsForGroup(comp_rows, cmptd_columns, rset, breakcolcmptkeys);
                            prevLevelRows = 0;
                        } else if (prevLevelRows == this.getFirstCmptdRowCount(comp_rows, cmptd_columns, (String)breakcolcmptkeys[breakcolcmptkeys.length - 1])) {
                            cmptd_rowset_arr = this.getComputedRowsForGroup(comp_rows, cmptd_columns, rset, breakcolcmptkeys);
                            prevLevelRows = 0;
                        } else {
                            String[] rbreakcolcmptkeys = breakcolcmptkeys;
                            if (rbreakcolcmptkeys.length > 1) {
                                for (int x = rbreakcolcmptkeys.length - 1; x > 0; --x) {
                                    rbreakcolcmptkeys = this.removeRow(rbreakcolcmptkeys, x);
                                }
                            }
                            cmptd_rowset_arr = this.getComputedRowsForGroup(comp_rows, cmptd_columns, rset, rbreakcolcmptkeys);
                        }
                        break block391;
                    }
                    brsNext = SQLPLUSCmdFormatter.cachedNext(this.m_scriptRunnerContext) != false || rset.next();
                    if (!brsNext && comp_rows.size() == 0 && cmptd_rowset_arr == null) {
                        int skipLines = this.skipLinesForReport(storedBrkCmds);
                        for (Map.Entry<Integer, Integer> key : this.m_breakcolToSkipLinesForGrp.entrySet()) {
                            skipLines += key.getValue().intValue();
                        }
                        for (int k = 0; k < skipLines && lineNo < adjPagesize * pageNo - bTitle_lines - 1; ++lineNo, ++k) {
                            databuf.append(m_lineSeparator);
                            this.write(out, databuf.toString());
                            databuf.setLength(0);
                        }
                        break;
                    }
                }
                if (grpRowCount == 0 && comp_rows.size() > 0 && cmptd_columns.size() > 1) {
                    if (brsNext) {
                        fList = this.filterList(this.m_brkcmptcolumns, "report");
                        String[] prevbreakcolcmptkeys = breakcolcmptkeys;
                        breakcolcmptkeys = this.generateBrkComputeColKeys(comp_rows, cmptd_columns, rset, "");
                        boolean emptyBrkKeys = this.isEmptyBreakColKeys(breakcolcmptkeys);
                        if (emptyBrkKeys) {
                            prevLevelRows = 0;
                        } else {
                            if (breakcolcmptkeys.length > 0 && prevLevelRows > 0 && prevbreakcolcmptkeys[prevbreakcolcmptkeys.length - 1] != null && breakcolcmptkeys[breakcolcmptkeys.length - 1] != null && !prevbreakcolcmptkeys[prevbreakcolcmptkeys.length - 1].equals(breakcolcmptkeys[breakcolcmptkeys.length - 1])) {
                                bckeyprevLevelcounts.put(prevbreakcolcmptkeys[prevbreakcolcmptkeys.length - 1], prevLevelRows);
                                prevLevelRows = 0;
                            }
                            grpFirstCmptdCount = this.getFirstCmptdRowCount(comp_rows, cmptd_columns, breakcolcmptkeys[0]);
                            Integer prevval = (Integer)bckeyprevLevelcounts.get(breakcolcmptkeys[breakcolcmptkeys.length - 1]);
                            if (prevval != null) {
                                prevLevelRows = prevval;
                                bckeyprevLevelcounts.remove(breakcolcmptkeys.length - 1);
                            }
                            prevLevelRows += grpFirstCmptdCount;
                        }
                    } else if (cmptd_rowset_arr == null && !this.isEmptyBreakColKeys(breakcolcmptkeys)) {
                        cmptd_rowset_arr = this.getComputedRowsForGroup(comp_rows, cmptd_columns, rset, breakcolcmptkeys);
                        bCmptdReport = true;
                    }
                }
            }
            if (cnt == 0 && firstRow.size() > 0) {
                brsNext = true;
            }
            if (brsNext) {
                ++cnt;
            }
            if (cnt > 0 && !bComputed) {
                this.computedData(comp_rows, cmptd_columns);
                bComputed = true;
                if (comp_rows.size() > 0 && cmptd_columns.size() > 0) {
                    fList = this.filterList(this.m_brkcmptcolumns, "report");
                    breakcolcmptkeys = fList.size() == 0 && this.m_brkcmptcolumns.contains("report") ? this.generateBrkComputeColKeys(comp_rows, cmptd_columns, rset, "report") : this.generateBrkComputeColKeys(comp_rows, cmptd_columns, rset, "");
                    grpFirstCmptdCount = this.getFirstCmptdRowCount(comp_rows, cmptd_columns, breakcolcmptkeys[0]);
                    prevLevelRows += grpFirstCmptdCount;
                }
            }
            if (grpFirstCmptdCount > 0 && brsNext) {
                ++grpRowCount;
            }
            int cmptdSize = !brsNext && cmptd_rowset != null ? cmptd_rowset.size() : 0;
            boolean ck = false;
            boolean bCmptdData = false;
            HashMap<String, ArrayList<String>> prodStoredcolsCmds = this.m_scriptRunnerContext.getStoredFormatCmds();
            if (prodStoredcolsCmds != storedColsCmds) {
                storedColsCmds = prodStoredcolsCmds;
            }
            for (int i4 = 1; i4 < colCnt + 1 && i4 < colsizes.length; ++i4) {
                String s;
                Object o;
                block386: {
                    BINARY_DOUBLE d;
                    int k1;
                    String[] cmds;
                    String colcmd;
                    ArrayList<String> ls;
                    o = null;
                    String colName = this.getColumnName(rset, i4).toLowerCase();
                    if (cnt == 1 && brsNext) {
                        o = firstRow.get(i4 - 1);
                    } else if (brsNext) {
                        block385: {
                            if (rset instanceof OracleResultSet) {
                                try {
                                    if (rmeta.getColumnType(i4) == -1 || rmeta.getColumnType(i4) == -2) {
                                        o = DataTypesUtil.stringValue(ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, i4), conn);
                                        break block385;
                                    }
                                    o = ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, i4);
                                }
                                catch (SQLException e) {
                                    o = rset.getObject(i4);
                                }
                            } else {
                                o = rset.getObject(i4);
                            }
                        }
                        bCmptdData = false;
                    } else if (cmptd_rowset_arr != null && cmptd_rowset_arr.length > 0) {
                        if (i4 < colsizes.length) {
                            o = cmptd_rowset_arr[0][i4];
                        }
                        bCmptdData = true;
                        if ((i4 == colCnt || i4 == colsizes.length - 1) && (cmptd_rowset_arr = this.removeRow(cmptd_rowset_arr, 0)) == null) {
                            grpRowCount = 0;
                        }
                    }
                    if (brsNext && this.m_scriptRunnerContext != null && o == null) {
                        String setNull = (String)this.m_scriptRunnerContext.getProperty("script.runner.setnull");
                        ArrayList<StringBuffer> buf = new ArrayList<StringBuffer>();
                        StringBuffer sbuf = new StringBuffer();
                        for (int ii = 0; ii < colCnt + 1; ++ii) {
                            buf.add(new StringBuffer());
                        }
                        sbuf.append("");
                        buf.add(i4, sbuf);
                        StringBuffer data = this.checkFormatOptions(rset, i4, storedColsCmds, colsizes, buf);
                        if (data.toString().length() > 0) {
                            o = data.toString();
                        } else if (setNull != null && !setNull.equals("")) {
                            o = setNull;
                        }
                    }
                    s = "";
                    boolean colFormatAvailable = false;
                    if (storedColsCmds.containsKey(colName) && !colFormatAvailable && (o instanceof NUMBER || o instanceof BINARY_DOUBLE || o instanceof BINARY_FLOAT)) {
                        ls = storedColsCmds.get(colName);
                        for (int k = 0; k < ls.size() && (k != 0 || !ls.get(k).equalsIgnoreCase("off") && !ls.get(k).startsWith("off")); ++k) {
                            colcmd = ls.get(k);
                            cmds = colcmd.split(" ");
                            for (k1 = 0; k1 < cmds.length; ++k1) {
                                if (!cmds[k1].equalsIgnoreCase("format") || cmds[k1 + 1].charAt(0) == 'a' || cmds[k1 + 1].charAt(0) == 'A') continue;
                                colFormatAvailable = true;
                            }
                        }
                    }
                    if (storedColsCmds.containsKey(colName) && colFormatAvailable && (o instanceof NUMBER || o instanceof BINARY_DOUBLE || o instanceof BINARY_FLOAT)) {
                        ls = storedColsCmds.get(colName);
                        for (int k = 0; k < ls.size(); ++k) {
                            if (k == 0 && (ls.get(k).equalsIgnoreCase("off") || ls.get(k).startsWith("off"))) {
                                s = DataTypesUtil.stringValue(o, conn);
                                break;
                            }
                            colcmd = ls.get(k);
                            cmds = colcmd.split(" ");
                            for (k1 = 0; k1 < cmds.length; ++k1) {
                                if (!cmds[k1].equalsIgnoreCase("format") || cmds[k1 + 1].charAt(0) == 'a' || cmds[k1 + 1].charAt(0) == 'A') continue;
                                String fmtstr = cmds[k1 + 1];
                                NUMBER num = brsNext ? ((OracleResultSet)rset).getNUMBER(i4) : (NUMBER)o;
                                try {
                                    s = num.toFormattedText(fmtstr, null);
                                    continue;
                                }
                                catch (SQLException ex) {
                                    if (ex.getMessage().equalsIgnoreCase("Unimplemented method called")) {
                                        if (fmtstr.length() == 2 && (fmtstr.startsWith("r") || fmtstr.startsWith("R"))) {
                                            int intval = num.ceil().intValue();
                                            s = RomanUtil.getRomanFmt(intval, colsizes[i4]);
                                            if (!Character.isLowerCase(fmtstr.charAt(0))) continue;
                                            s = s.toLowerCase();
                                            continue;
                                        }
                                        if (!fmtstr.startsWith("x") && !fmtstr.startsWith("X")) continue;
                                        int intval = num.ceil().intValue();
                                        if (intval < 0) {
                                            char[] chars = new char[fmtstr.length() + 1];
                                            Arrays.fill(chars, '#');
                                            s = String.copyValueOf(chars);
                                            continue;
                                        }
                                        if (Character.isLowerCase(fmtstr.charAt(0))) {
                                            s = String.format("%x", num.ceil().bigIntegerValue());
                                            continue;
                                        }
                                        s = String.format("%X", num.ceil().bigIntegerValue());
                                        continue;
                                    }
                                    if (ex.getMessage().equalsIgnoreCase("Invalid Oracle Number")) {
                                        char[] chars = new char[this.formattedNUMBERLength(fmtstr)];
                                        Arrays.fill(chars, '#');
                                        s = String.copyValueOf(chars);
                                        continue;
                                    }
                                    s = DataTypesUtil.stringValue(o, conn);
                                }
                            }
                        }
                        if (s.equals("")) {
                            s = DataTypesUtil.stringValue(o, conn);
                        }
                    } else if (o instanceof NUMBER) {
                        try {
                            NUMBER num = brsNext ? ((OracleResultSet)rset).getNUMBER(i4) : (NUMBER)o;
                            int colsize_i = colsizes[i4];
                            int numFormatLen = this.m_numformat.length();
                            String numberString = NUMBER.toString((byte[])num.toBytes());
                            int numberByteLen = NUMBER.toString((byte[])num.toBytes()).length();
                            if (numFormatLen == 0) {
                                if (numberByteLen > this.m_numwidth && this.m_numwidth < 7) {
                                    num = num.floatingPointRound(this.m_numwidth);
                                    numberString = NUMBER.toString((byte[])num.toBytes());
                                    s = this.processNumberLessThanNumwidth(numberString, this.m_numwidth);
                                } else if (this.checkIntegralPart(numberString, this.m_numwidth)) {
                                    StringBuffer formatStringBuffer = new StringBuffer("9.");
                                    if (num.sign() >= 0) {
                                        for (int j = 0; j < this.m_numwidth - 6; ++j) {
                                            formatStringBuffer.append("9");
                                        }
                                    }
                                    if (num.sign() < 0) {
                                        for (int j = 0; j < this.m_numwidth - 7; ++j) {
                                            formatStringBuffer.append("9");
                                        }
                                    }
                                    formatStringBuffer.append("EEEE");
                                    s = this.formattedNUMBER(conn, num, formatStringBuffer.toString(), colsizes[i4]);
                                } else {
                                    int localWidth = this.m_numwidth;
                                    NUMBER num1 = num.floatingPointRound(localWidth);
                                    String dummy = num1.stringValue();
                                    if (dummy.contains(".") && this.m_numwidth > 1) {
                                        localWidth = this.m_numwidth - 1;
                                    }
                                    num = num.floatingPointRound(localWidth);
                                    s = DataTypesUtil.stringValue(num, conn);
                                    if (dummy.startsWith("0.") && s.length() > 2) {
                                        s = s.substring(1);
                                    }
                                }
                                break block386;
                            }
                            if (numberByteLen > numFormatLen) {
                                char[] chars = new char[numFormatLen];
                                Arrays.fill(chars, '#');
                                s = String.copyValueOf(chars);
                                break block386;
                            }
                            s = this.formattedNUMBER(conn, num, this.m_numformat, colsizes[i4]);
                        }
                        catch (SQLException num) {}
                    } else if (o instanceof BINARY_DOUBLE) {
                        d = (BINARY_DOUBLE)o;
                        double doubleValue = d.doubleValue();
                        s = this.formattedDouble(conn, doubleValue, this.m_numformat, colsizes[i4]);
                    } else if (o instanceof BINARY_FLOAT) {
                        float f = ((BINARY_FLOAT)o).floatValue();
                        s = this.formattedFLOAT(conn, f, this.m_numformat, colsizes[i4]);
                    } else if (o instanceof DATE || o instanceof TIMESTAMP || o instanceof TIMESTAMPTZ || o instanceof TIMESTAMPLTZ || o instanceof INTERVALDS || o instanceof INTERVALYM) {
                        OracleNLSProvider onlsp = (OracleNLSProvider)NLSProvider.getProvider(conn);
                        s = onlsp.format(o);
                    } else if ((o instanceof Clob || DataTypesUtil.isXMLType(o)) && this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getProperty("script.runner.setlong") != null) {
                        s = DataTypesUtil.stringValue(o, conn, (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlong"));
                        Closeables.close(o);
                    } else if (o instanceof Blob && this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getProperty("script.runner.setlong") != null) {
                        Blob bb = (Blob)o;
                        String ss = null;
                        if (bb != null) {
                            byte[] bdata = null;
                            Integer printSize = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlong");
                            printSize = printSize != null ? printSize : (int)bb.length();
                            bdata = bb.getBytes(1L, printSize);
                            ss = bdata == null ? "" : new String(ScriptUtils.bytesToHex(bdata)).toUpperCase();
                        }
                        s = DataTypesUtil.stringValue(ss, conn, (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlong"));
                    } else if (o instanceof BINARY_FLOAT || o instanceof BINARY_DOUBLE) {
                        if (o instanceof BINARY_FLOAT) {
                            BINARY_FLOAT f = (BINARY_FLOAT)o;
                            if (this.m_numformat.length() > 0) {
                                NUMBER fv = new NUMBER(f.floatValue());
                                s = this.formattedNUMBER(conn, fv, this.m_numformat, colsizes[i4]);
                            } else if (!Float.isNaN(f.floatValue())) {
                                NUMBER fv = new NUMBER(f.floatValue());
                                float floatValue = fv.floatingPointRound(this.m_numwidth).floatValue();
                                s = this.formattedFLOAT(conn, floatValue, this.m_numformat, colsizes[i4]);
                            } else {
                                s = this.formattedFLOAT(conn, f.floatValue(), this.m_numformat, colsizes[i4]);
                            }
                        } else {
                            d = (BINARY_DOUBLE)o;
                            if (this.m_numformat.length() > 0) {
                                if (this.m_numformat.matches("9*((.|,)(9+))?")) {
                                    String dfPattern = this.m_numformat.replaceAll("9", "0").replaceFirst("0", "#");
                                    DecimalFormat decimalFormat = new DecimalFormat(dfPattern);
                                    s = decimalFormat.format(d.doubleValue());
                                } else {
                                    Double dbl = Double.parseDouble(String.valueOf(d.doubleValue()));
                                    if (dbl.isNaN() || dbl.isInfinite()) {
                                        s = this.formattedFLOAT(conn, Float.parseFloat(String.valueOf(d.doubleValue())), this.m_numformat, colsizes[i4]);
                                    } else {
                                        NUMBER dv = new NUMBER(d.doubleValue());
                                        s = this.formattedNUMBER(conn, dv, this.m_numformat, colsizes[i4]);
                                    }
                                }
                            } else {
                                s = this.formattedFLOAT(conn, Float.parseFloat(String.valueOf(d.doubleValue())), this.m_numformat, colsizes[i4]);
                            }
                        }
                    } else if (o instanceof ResultSet) {
                        boolean feedOn;
                        SQLPLUSCmdFormatter formatter = new SQLPLUSCmdFormatter(this.m_scriptRunnerContext);
                        String prev_cursorData = "";
                        StringBuffer buf = new StringBuffer();
                        try {
                            cursorCnt = formatter.rset2sqlplus((ResultSet)o, conn, buf);
                        }
                        finally {
                            Closeables.close((ResultSet)o);
                        }
                        this.m_cursorHeader = formatter.getCursorStmtHeader();
                        if (((String)cursorData).length() > 0) {
                            prev_cursorData = cursorData;
                        }
                        cursorData = buf.toString();
                        int feedback = this.m_scriptRunnerContext.getFeedback();
                        Object silentMode = this.m_scriptRunnerContext.getProperty("script.runner.sqlplus.silent");
                        boolean bl = feedOn = feedback != -2 | silentMode != null && !this.m_scriptRunnerContext.isJSONOutput();
                        if (feedOn && feedback != -2 && cursorCnt >= feedback) {
                            cursorData = cursorCnt == 1 ? (String)cursorData + MessageFormat.format(ScriptRunnerDbArb.getString("SELECTONE"), String.valueOf(cursorCnt)) : (String)cursorData + MessageFormat.format(ScriptRunnerDbArb.getString("SELECTED"), String.valueOf(cursorCnt));
                        }
                        s = MessageFormat.format(ScriptRunnerDbArb.getString("CURSOR_STATEMENT"), String.valueOf(i4));
                        cursorData = m_lineSeparator + s + m_lineSeparator + (String)cursorData;
                        if (prev_cursorData.length() > 0) {
                            cursorData = prev_cursorData + m_lineSeparator + (String)cursorData;
                        }
                    } else {
                        s = DataTypesUtil.stringValue(o, conn);
                    }
                }
                if (o instanceof REF) {
                    byte[] rbytes = ((REF)o).getBytes();
                    s = new BigInteger(1, rbytes).toString(16).toUpperCase();
                }
                if (o instanceof STRUCT) {
                    s = this.processTypeAttributesForStruct((Struct)o, conn);
                }
                if (o instanceof ARRAY) {
                    s = this.processTypeAttributesForArray((ARRAY)o, conn);
                }
                StringBuffer nlsed = new StringBuffer();
                if (s != null) {
                    nlsed = o instanceof Clob && this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getProperty("script.runner.setlong") != null ? new StringBuffer(DataTypesUtil.stringValue((Object)s, rset.getStatement().getConnection(), (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlong")).replace("\r\n", m_lineSeparator)) : new StringBuffer(DataTypesUtil.stringValue(s, rset.getStatement().getConnection()).replace("\r\n", m_lineSeparator));
                }
                if (this.m_scriptRunnerContext != null && newVal) {
                    if (lastVal == null) {
                        lastVal = new String[colCnt + 1];
                    }
                    lastVal[i4] = nlsed.toString();
                }
                if (this.m_scriptRunnerContext != null && oldVal) {
                    if (oldlVal == null) {
                        oldlVal = new String[colCnt + 1];
                    }
                    oldlVal[i4] = nlsed.toString();
                }
                cacheRow.set(i4, nlsed);
            }
            boolean multiline = false;
            boolean stopit = false;
            boolean multiLineRow = false;
            this.getFontMetrics();
            boolean bLastCol = false;
            ArrayList<Integer> fmtd_colIndexes = new ArrayList<Integer>();
            boolean brkSkip = true;
            boolean noDupAllowed = false;
            if (cpcacheRow.size() > 0) {
                cpcacheRow.clear();
            }
            for (i = 0; i < cacheRow.size(); ++i) {
                cpcacheRow.add(new StringBuffer((CharSequence)cacheRow.get(i)));
            }
            if (!bCmptdData) {
                if (cpttlcacheRow.size() > 0) {
                    cpttlcacheRow.clear();
                }
                for (i = 0; i < cacheRow.size(); ++i) {
                    cpttlcacheRow.add(new StringBuffer((CharSequence)cacheRow.get(i)));
                }
            }
            if (cnt == 1 && !bCmptdData) {
                int hdr_tpttl_lines = this.numberofLines(tTitle_header);
                int jdiff = adjPagesize - bTitle_lines - this.m_newpage;
                tTitle_header = this.getTopTitleAndHeader(pageNo, tot_header, cMap, ovcMap, cpttlcacheRow, columns);
                bTitle_lines = this.numberofLines(this.getBottomTitle(pageNo, cMap, ovcMap, cpttlcacheRow, columns));
                if (this.m_embedded && cnt == 1) {
                    if (jdiff >= hdr_tpttl_lines) {
                        AtomicInteger lineN = new AtomicInteger(lineNo);
                        AtomicInteger pageN = new AtomicInteger(pageNo);
                        this.appendDataToBuffer(databuf, lineN, pageN, tTitle_header, offSet);
                        lineNo = lineN.intValue();
                        pageNo = pageN.intValue();
                    }
                } else {
                    for (int np = 0; np < this.m_newpage; ++np) {
                        databuf.append(m_lineSeparator);
                        ++lineNo;
                    }
                    if (jdiff >= hdr_tpttl_lines) {
                        databuf.append(tTitle_header);
                        lineNo += this.numberofLines(tTitle_header);
                    }
                }
            }
            if (brsNext) {
                if (oldPageNo < pageNo && this.m_pagesize > 0) {
                    oldPageNo = pageNo;
                    newPage = true;
                } else {
                    newPage = false;
                }
                noDupAllowed = this.hasDuplicates(storedBrkCmds, rset, cpcacheRow, brkColValues, newPage);
            }
            while (!stopit) {
                String tempStr;
                int strIdx;
                int sizediff = this.m_linesize;
                boolean bsizediffed = false;
                stopit = true;
                bLastCol = false;
                for (int i5 = 1; i5 < colCnt + 1 && i5 < colsizes.length; ++i5) {
                    block393: {
                        Object str;
                        boolean bPrint;
                        block394: {
                            boolean bAllowColSep;
                            StringBuffer nextChunk;
                            block392: {
                                String brkCol;
                                if (databuf.length() == 0 && ((String)missingLineTerminators).length() > 0) {
                                    Matcher m = Pattern.compile(m_lineSeparator).matcher((CharSequence)missingLineTerminators);
                                    int lineSeps = 0;
                                    while (m.find()) {
                                        ++lineSeps;
                                    }
                                    int diff = adjPagesize * pageNo - bTitle_lines - this.m_newpage;
                                    for (int ls = 0; ls < lineSeps && lineNo <= diff; ++lineNo, ++ls) {
                                        databuf.append(m_lineSeparator);
                                    }
                                    missingLineTerminators = "";
                                }
                                nextChunk = new StringBuffer();
                                String colName = this.getColumnName(rset, i5).toLowerCase();
                                bPrint = this.printColumn(storedColsCmds, colName);
                                if (!bPrint && (brkCol = this.getBreakColumn(storedBrkCmds, this.getColumnName(rset, i5))) == null) {
                                    cacheRow.set(i5, new StringBuffer(DONE));
                                    continue;
                                }
                                int colType = rmeta.getColumnType(i5);
                                Object o = null;
                                if (bPrint) {
                                    int consoleWidth;
                                    if (((StringBuffer)cacheRow.get(i5)).toString().equals(DONE)) {
                                        if (multiLineRow) continue;
                                        nextChunk.append(this.justify_left(" ", colsizes[i5]));
                                    } else {
                                        if (fmtd_colIndexes.contains(i5)) {
                                            nextChunk = (StringBuffer)cacheRow.get(i5);
                                        } else {
                                            nextChunk = this.checkFormatOptions(rset, i5, storedColsCmds, colsizes, cacheRow);
                                            if (nextChunk.length() == 0 && this.isNumericColumn(colType)) {
                                                nextChunk = cacheRow.get(i5);
                                            }
                                        }
                                        if (nextChunk.length() == 0) {
                                            int colsize;
                                            int n = colsize = colsizes[i5] > this.m_linesize ? this.m_linesize : colsizes[i5];
                                            if (this.isLongColumn(colType)) {
                                                if (colsizes[i5] <= this.m_long) {
                                                    if (this.m_wrap.equalsIgnoreCase("ON")) {
                                                        nextChunk = this.truncate(colType, this.m_long, cacheRow.get(i5));
                                                        nextChunk = this.wrap(colType, colsize, nextChunk);
                                                    } else {
                                                        nextChunk = this.truncate(colType, colsize, cacheRow.get(i5));
                                                    }
                                                } else {
                                                    nextChunk = this.m_wrap.equalsIgnoreCase("ON") ? this.wrap(colType, colsize, cacheRow.get(i5)) : this.truncate(colType, colsize, cacheRow.get(i5));
                                                }
                                            } else {
                                                nextChunk = this.m_wrap.equalsIgnoreCase("ON") ? this.wrap(colType, colsize, cacheRow.get(i5)) : this.truncate(colType, colsize, cacheRow.get(i5));
                                            }
                                        }
                                    }
                                    int tIdx = nextChunk.indexOf("\n");
                                    int ival = nextChunk.indexOf(m_lineSeparator);
                                    if (tIdx != ival && System.getProperty("os.name").startsWith("Windows") && (tIdx >= 0 && ival == -1 || tIdx != ival + 1)) {
                                        nextChunk = new StringBuffer(nextChunk.toString().replaceAll("\\n", m_lineSeparator));
                                    }
                                    if ((ival = nextChunk.indexOf(m_lineSeparator)) != -1 && (nextChunk.lastIndexOf(m_lineSeparator) != ival || i5 >= 1)) {
                                        multiline = true;
                                        fmtd_colIndexes.add(i5);
                                        StringBuffer store = nextChunk;
                                        nextChunk = new StringBuffer(nextChunk.substring(0, ival));
                                        store = store.length() - 1 > ival ? new StringBuffer(store.substring(ival + m_lineSeparator.length())) : new StringBuffer("");
                                        if (store.length() == 0) {
                                            cacheRow.set(i5, new StringBuffer(DONE));
                                        } else {
                                            cacheRow.set(i5, store);
                                            stopit = false;
                                            brkSkip = false;
                                        }
                                    } else {
                                        cacheRow.set(i5, new StringBuffer(DONE));
                                        stopit = true;
                                        if (multiLineRow && i5 > 1 && i5 < colCnt + 1 && this.m_colsizes[i5] < this.m_linesize && databuf.toString().endsWith(m_lineSeparator) && nextChunk.toString().matches("[^\\s]+.*")) {
                                            String[] headers = tot_header.toString().split(m_lineSeparator);
                                            for (int h = 0; h < headers.length; ++h) {
                                                int hidx = -1;
                                                Pattern p = Pattern.compile("(\\b" + Pattern.quote(this.m_columns[i5]) + "\\b)");
                                                Matcher m = p.matcher(headers[h]);
                                                int mCnt = 0;
                                                while (m.find()) {
                                                    ++mCnt;
                                                    if (m.group(1).equals(this.m_columns[i5])) {
                                                        hidx = m.start(mCnt);
                                                        break;
                                                    }
                                                    if (!m.matches()) continue;
                                                    hidx = m.start();
                                                    break;
                                                }
                                                if (hidx <= 0) continue;
                                                nextChunk = new StringBuffer(this.justify_left(" ", hidx) + nextChunk.toString());
                                                sizediff -= hidx;
                                                bsizediffed = true;
                                                break;
                                            }
                                        }
                                    }
                                    int n = consoleWidth = this.m_scriptRunnerContext.getSQLPlusConsoleReader() != null ? this.m_scriptRunnerContext.getSQLPlusConsoleReader().getWidth() : 0;
                                    if (brsNext) {
                                        if (consoleWidth < this.m_linesize && this.m_columns.length < 3) {
                                            this.font_width_adjustment(nextChunk, nextChunk.length());
                                        } else {
                                            this.font_width_adjustment(nextChunk, colsizes[i5]);
                                        }
                                    } else {
                                        String val = nextChunk.toString();
                                        if (val.trim().matches("(\\+|-)?\\d*(\\.\\d+((?i:e){1}(\\+|-))?\\d+)?")) {
                                            nextChunk = new StringBuffer(this.justify_right(val.trim(), colsizes[i5]));
                                        } else {
                                            this.font_width_adjustment(nextChunk, colsizes[i5]);
                                        }
                                    }
                                    if (this.isNumericColumn(colType)) {
                                        String numRegexp = "(\\+|-)?\\d*(\\.\\d+(((?i:e){1}(\\+|-))?\\d+)?)?|Nan|(-)?Inf|((?<!^,)\\d+(,|(\\.(?=\\d+$))(?!$)|$))+";
                                        String val = nextChunk.toString();
                                        if (brsNext) {
                                            if (!val.trim().matches("(\\+|-)?\\d*(\\.\\d+(((?i:e){1}(\\+|-))?\\d+)?)?|Nan|(-)?Inf|((?<!^,)\\d+(,|(\\.(?=\\d+$))(?!$)|$))+")) {
                                                this.font_width_adjustment(nextChunk, colsizes[i5]);
                                            } else {
                                                int colsize = colsizes[i5] > this.m_linesize ? this.m_linesize : colsizes[i5];
                                                nextChunk = new StringBuffer(this.justify_right(val.trim(), colsize));
                                            }
                                        } else if (!val.trim().matches("(\\+|-)?\\d*(\\.\\d+(((?i:e){1}(\\+|-))?\\d+)?)?|Nan|(-)?Inf|((?<!^,)\\d+(,|(\\.(?=\\d+$))(?!$)|$))+")) {
                                            this.font_width_adjustment(nextChunk, colsizes[i5]);
                                        } else if (val.length() <= this.m_linesize) {
                                            nextChunk = o == null || o.isNull() ? (val.trim().matches("(\\+|-)?\\d*(\\.\\d+(((?i:e){1}(\\+|-))?\\d+)?)?|Nan|(-)?Inf|((?<!^,)\\d+(,|(\\.(?=\\d+$))(?!$)|$))+") ? new StringBuffer(this.justify_right(val.trim(), colsizes[i5])) : new StringBuffer(this.justify_left(val.trim(), colsizes[i5]))) : new StringBuffer(this.justify_right(val.trim(), colsizes[i5]));
                                        } else {
                                            String message = MessageFormat.format(ScriptRunnerDbArb.getString("LINESIZELIMIT"), String.valueOf(i5), this.m_columns[i5]) + m_lineSeparator;
                                            this.write(out, message);
                                            return 0;
                                        }
                                    }
                                }
                                if (i5 == colCnt) {
                                    bLastCol = true;
                                }
                                if ((this.m_pagesize < 0 || this.m_linesize < 0) && bPrint) {
                                    if (this.m_colsep.equals(" ")) {
                                        nextChunk.append(this.m_colsep);
                                    } else if (i5 < colCnt) {
                                        nextChunk.append(this.m_colsep);
                                    }
                                    lastStr = nextChunk.toString();
                                    databuf.append((String)lastStr);
                                    continue;
                                }
                                if (this.numberofLines(tot_header) == 2 && !this.isAValidLinesize() && bPrint) {
                                    if (lineNo >= adjPagesize * pageNo - bTitle_lines - 1 && i5 == 1) {
                                        ++pageNo;
                                        databuf.append(m_lineSeparator);
                                        ++lineNo;
                                        databuf.append(tot_header.toString());
                                        lineNo += this.numberofLines(tot_header);
                                    }
                                    if (i5 < colCnt) {
                                        nextChunk.append(this.m_colsep);
                                    }
                                    lastStr = nextChunk.toString();
                                    databuf.append((String)lastStr);
                                    continue;
                                }
                                if (this.m_pagesize < 0 && this.m_linesize <= 0) continue;
                                bAllowColSep = true;
                                if (bPrint) {
                                    int colsize;
                                    int n = colsize = colsizes[i5] > this.m_linesize ? this.m_linesize : colsizes[i5];
                                    if (!bsizediffed) {
                                        if (sizediff <= colsize) {
                                            sizediff -= colsize;
                                        } else if (sizediff < colsize + this.m_colsep.length()) {
                                            sizediff -= colsize;
                                            bAllowColSep = false;
                                        } else {
                                            sizediff -= colsize + this.m_colsep.length();
                                            bAllowColSep = true;
                                        }
                                    }
                                    boolean bl = bsizediffed = bsizediffed ? false : bsizediffed;
                                }
                                if (sizediff >= 0) break block392;
                                if (bPrint) {
                                    if (this.m_colsep.length() > 0 && !this.m_colsep.equals(" ")) {
                                        String tempStr2 = lastStr;
                                        int strIdx2 = databuf.lastIndexOf(tempStr2);
                                        tempStr2 = this.replaceColSep(tempStr2);
                                        if (strIdx2 > -1) {
                                            databuf.replace(strIdx2, strIdx2 + tempStr2.length(), tempStr2);
                                            String tmp = databuf.toString();
                                            tmp = tmp.replaceAll("\\s+$", "");
                                            databuf.setLength(0);
                                            databuf.append(tmp);
                                        }
                                    }
                                    nextChunk = new StringBuffer(nextChunk.toString().trim());
                                    if (cacheRow.get(i5).toString().equals(DONE)) {
                                        cacheRow.set(i5, nextChunk);
                                    } else {
                                        if (multiline) {
                                            nextChunk.append(m_lineSeparator);
                                        }
                                        nextChunk.append(cacheRow.get(i5));
                                        cacheRow.set(i5, nextChunk);
                                    }
                                    multiLineRow = true;
                                    this.m_foldedrows = true;
                                }
                                break block393;
                            }
                            str = "";
                            if (bPrint) {
                                str = i5 == colsizes.length - 1 ? nextChunk.toString() : (bAllowColSep ? (sizediff > 0 ? nextChunk.toString() + this.m_colsep : nextChunk.toString()) : nextChunk.toString().replaceAll("\\s+$", ""));
                                if (this.m_pagesize < 3 && this.m_pagesize <= adjPagesize && i5 == 1 && cnt > 1) {
                                    ++pageNo;
                                }
                            }
                            if (this.m_breakcolumns.size() > 0) {
                                String columnName = "";
                                if ((brsNext || bCmptdReport) && i5 == 1 && !multiline) {
                                    int skipPage;
                                    boolean bskipLines = false;
                                    for (int j = 1; j < colCnt + 1; ++j) {
                                        columnName = this.m_column_to_brkcol.get(this.m_columns[j]);
                                        if (columnName != null) {
                                            int skipPage2;
                                            int cType = rmeta.getColumnType(j);
                                            int skipLines = this.skippedLines(storedBrkCmds, columnName);
                                            if (skipLines > 0) {
                                                Datum n;
                                                String prevVal = (String)prevColToVal.get(j);
                                                if ((prevVal == null || prevVal.length() == 0) && cnt == 1) {
                                                    if (j == 1) {
                                                        if (bPrint) {
                                                            if (this.isNumericColumn(cType)) {
                                                                n = null;
                                                                try {
                                                                    n = ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, j);
                                                                }
                                                                catch (Exception exception) {
                                                                    // empty catch block
                                                                }
                                                                String nStr = n != null ? n.stringValue() : "NULL";
                                                                prevColToVal.put(new Integer(j), nStr);
                                                            } else {
                                                                prevColToVal.put(new Integer(j), ((String)str).trim());
                                                            }
                                                        } else {
                                                            prevColToVal.put(new Integer(j), cacheRow.get(j).toString());
                                                        }
                                                    } else if (this.isNumericColumn(cType)) {
                                                        n = null;
                                                        try {
                                                            n = ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, j);
                                                        }
                                                        catch (Exception nStr) {
                                                            // empty catch block
                                                        }
                                                        String nStr = n != null ? n.stringValue() : "NULL";
                                                        prevColToVal.put(new Integer(j), nStr);
                                                    } else {
                                                        prevColToVal.put(new Integer(j), cacheRow.get(j).toString());
                                                    }
                                                } else if (prevVal != null && this.isNumericColumn(cType)) {
                                                    n = null;
                                                    try {
                                                        n = ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, j);
                                                    }
                                                    catch (Exception nStr) {
                                                        // empty catch block
                                                    }
                                                    String string = nStr = n != null ? n.stringValue() : "NULL";
                                                    if (!prevVal.equals(nStr)) {
                                                        bskipLines = true;
                                                        if (bPrint) {
                                                            prevColToVal.put(new Integer(j), nStr);
                                                        } else {
                                                            prevColToVal.put(new Integer(j), cacheRow.get(j).toString());
                                                        }
                                                    }
                                                } else if (prevVal != null && (((String)str).trim().equals("Nan") || !prevVal.equals(j == 1 && ((String)str).trim().length() > 0 ? ((String)str).trim() : (cacheRow.get(j).toString() == null ? "" : cacheRow.get(j).toString().trim())))) {
                                                    bskipLines = true;
                                                    if (j == 1) {
                                                        if (bPrint) {
                                                            prevColToVal.put(new Integer(j), ((String)str).trim());
                                                        } else {
                                                            prevColToVal.put(new Integer(j), cacheRow.get(j).toString());
                                                        }
                                                    } else {
                                                        prevColToVal.put(new Integer(j), cacheRow.get(j).toString());
                                                    }
                                                }
                                                this.m_breakcolToSkipLinesForGrp.put(j, this.skippedLines(storedBrkCmds, columnName));
                                            }
                                            if ((skipPage2 = this.skippedPage(storedBrkCmds, columnName)) == 1) {
                                                String prevVal = (String)prevColToVal.get(j);
                                                if ((prevVal == null || prevVal.length() == 0) && cnt == 1) {
                                                    if (j == 1) {
                                                        if (bPrint) {
                                                            prevColToVal.put(new Integer(j), ((String)str).trim());
                                                        } else {
                                                            prevColToVal.put(new Integer(j), cacheRow.get(j).toString());
                                                        }
                                                    } else {
                                                        prevColToVal.put(new Integer(j), cacheRow.get(j).toString());
                                                    }
                                                } else if (prevVal != null && (prevVal.equals("Nan") || !prevVal.equals(j == 1 ? ((String)str).trim() : cacheRow.get(j).toString()))) {
                                                    if (j == 1) {
                                                        if (bPrint) {
                                                            prevColToVal.put(new Integer(j), ((String)str).trim());
                                                        } else {
                                                            prevColToVal.put(new Integer(j), cacheRow.get(j).toString());
                                                        }
                                                    } else {
                                                        prevColToVal.put(new Integer(j), cacheRow.get(j).toString());
                                                    }
                                                    int limit = adjPagesize * pageNo - bTitle_lines;
                                                    if (lineNo < limit) {
                                                        lineNo = limit;
                                                    }
                                                }
                                            }
                                        }
                                        if (bPrint) continue;
                                        cacheRow.set(i5, new StringBuffer(DONE));
                                    }
                                    if (bskipLines) {
                                        int size = this.m_breakcolToSkipLinesForGrp.size();
                                        for (int key : this.m_breakcolToSkipLinesForGrp.keySet()) {
                                            if (this.m_breakcolToSkipLinesForGrp.get(key) == null) continue;
                                            skipLinesPerColumn += this.m_breakcolToSkipLinesForGrp.get(key).intValue();
                                        }
                                        int linesLimit = adjPagesize * pageNo - bTitle_lines;
                                        while (skipLinesPerColumn > 0 && (lineNo < linesLimit || this.m_pagesize == 0)) {
                                            --skipLinesPerColumn;
                                            databuf.append(m_lineSeparator);
                                            ++lineNo;
                                        }
                                        if (skipLinesPerColumn > 0) {
                                            missingSkipLines += skipLinesPerColumn;
                                        }
                                        skipLinesPerColumn = 0;
                                    }
                                    if ((skipPage = this.skippedPage(storedBrkCmds)) == 1 && cnt > 1 && lineNo < adjPagesize * pageNo - bTitle_lines) {
                                        lineNo = adjPagesize * pageNo - bTitle_lines;
                                    }
                                } else if (!brsNext || !bPrint) {
                                    cacheRow.set(i5, new StringBuffer(DONE));
                                }
                            }
                            if (!(bAllowColSep || cnt <= 1 && i5 <= 1 || lineNo >= adjPagesize * pageNo - bTitle_lines - 1)) {
                                databuf.append(m_lineSeparator);
                                ++lineNo;
                            }
                            int hdr_tpttl_lines = this.numberofLines(this.getTopTitleAndHeader(pageNo, tot_header, cMap, ovcMap, cpttlcacheRow, columns));
                            int diff = adjPagesize * pageNo - bTitle_lines;
                            int jdiff = adjPagesize - bTitle_lines;
                            if (bPrint && adjPagesize > 0 && cnt > 0 && lineNo >= diff) {
                                int np;
                                if (jdiff >= hdr_tpttl_lines) {
                                    if (bTitle_lines > 0) {
                                        databuf.append(this.getBottomTitle(pageNo, cMap, ovcMap, cpttlcacheRow, columns));
                                        lineNo += bTitle_lines;
                                    }
                                    ++pageNo;
                                    for (np = 0; np < this.m_newpage; ++np) {
                                        databuf.append(m_lineSeparator);
                                        ++lineNo;
                                    }
                                    tTitle_header = this.getTopTitleAndHeader(pageNo, tot_header, cMap, ovcMap, cpttlcacheRow, columns);
                                    int tot_hdr_lines = this.numberofLines(tTitle_header);
                                    databuf.append(tTitle_header);
                                    lineNo += tot_hdr_lines;
                                } else {
                                    ++pageNo;
                                    for (np = 0; np < this.m_newpage; ++np) {
                                        databuf.append(m_lineSeparator);
                                        ++lineNo;
                                    }
                                }
                                if (this.m_foldedrows && !bAppendedMultiRowLnTerm && i5 == 1 && lineNo < adjPagesize * pageNo - bTitle_lines) {
                                    databuf.append(m_lineSeparator);
                                    ++lineNo;
                                    bAppendedMultiRowLnTerm = true;
                                }
                                if (dataBufHelper != null) {
                                    dataBufHelper.mark(this.m_scriptRunnerContext, out, databuf);
                                }
                            }
                            if (missingSkipLines > 0 && lineNo + missingSkipLines < adjPagesize * pageNo - bTitle_lines - 1) {
                                for (int k = 0; k < missingSkipLines; ++k) {
                                    databuf.append(m_lineSeparator);
                                }
                                lineNo += missingSkipLines;
                                missingSkipLines = 0;
                            }
                            if (!brsNext || nextChunk.length() <= 0 || this.m_column_to_brkcol.get(this.m_columns[i5]) == null) break block394;
                            if (oldPageNo < pageNo && this.m_pagesize > 0) {
                                newPage = true;
                                oldPageNo = pageNo;
                                noDupAllowed = this.hasDuplicates(storedBrkCmds, rset, cpcacheRow, brkColValues, newPage);
                            }
                            String columnName = this.m_column_to_brkcol.get(this.m_columns[i5]);
                            if (!bPrint) break block393;
                            if (noDupAllowed && this.m_brkcol_to_nodup.get(columnName).booleanValue()) {
                                char[] chars = new char[((String)str).length()];
                                Arrays.fill(chars, ' ');
                                databuf.append(chars);
                            } else if (this.m_brkcol_to_nodup.get(columnName).booleanValue()) {
                                boolean noDupsFromOuterToInnerBreaks = this.hasDuplicates(storedBrkCmds, rset, cpcacheRow, brkColValues, i5, newPage);
                                if (noDupsFromOuterToInnerBreaks) {
                                    char[] chars = new char[((String)str).length()];
                                    Arrays.fill(chars, ' ');
                                    databuf.append(chars);
                                } else {
                                    databuf.append((String)str);
                                }
                            } else {
                                databuf.append((String)str);
                            }
                            if (!newPage || i5 != colsizes.length - 1) break block393;
                            newPage = false;
                            break block393;
                        }
                        if (bPrint) {
                            databuf.append((String)str);
                            lastStr = str;
                            if (i5 == colsizes.length - 1 && colCnt == 1 && multiline) {
                                sizediff = this.m_linesize;
                                multiline = false;
                                if (cacheRow.get(i5).toString().equals(DONE)) break;
                                multiLineRow = true;
                                break;
                            }
                        }
                    }
                    if (i5 != colsizes.length - 1) continue;
                    if (multiLineRow) {
                        if (!databuf.toString().endsWith(m_lineSeparator) || ((String)lastStr).length() == 0) {
                            databuf.append(m_lineSeparator);
                        }
                        if (this.m_pagesize > 0) {
                            int lines = ((String)lastStr).split(m_lineSeparator).length;
                            for (int li = 0; li < lines; ++li) {
                                if (lineNo >= adjPagesize * pageNo - bTitle_lines) {
                                    ++pageNo;
                                }
                                ++lineNo;
                            }
                        }
                        bLastCol = true;
                    } else {
                        int lines = ((String)lastStr).split(m_lineSeparator).length;
                        if (!multiline && !this.m_foldedrows && lines > 1) {
                            for (int j = 1; j < lines; ++j) {
                                if (lineNo >= adjPagesize * pageNo - bTitle_lines - 1) continue;
                                databuf.append(m_lineSeparator);
                                ++lineNo;
                            }
                        }
                    }
                    if (this.isDataCached(cacheRow)) {
                        stopit = false;
                        continue;
                    }
                    if (this.m_foldedrows) {
                        if (lineNo < adjPagesize * pageNo - bTitle_lines) {
                            databuf.append(m_lineSeparator);
                            ++lineNo;
                            bAppendedMultiRowLnTerm = true;
                        } else {
                            bAppendedMultiRowLnTerm = false;
                        }
                        multiLineRow = false;
                        multiline = false;
                    }
                    if (cnt > 0 && (brsNext || bCmptdReport)) {
                        int skipLinesPerRow;
                        bCmptdReport = false;
                        int linesLimit = adjPagesize * pageNo - bTitle_lines - 1;
                        for (skipLinesPerRow = this.skippedLines(storedBrkCmds); skipLinesPerRow > 0 && lineNo < linesLimit; --skipLinesPerRow, ++lineNo) {
                            databuf.append(m_lineSeparator);
                        }
                        if (skipLinesPerRow > 0) {
                            missingSkipLines += skipLinesPerRow;
                        }
                    }
                    if (adjPagesize != this.m_pagesize || this.m_pagesize > 2 || this.m_pagesize == 0) continue;
                    databuf.append(m_lineSeparator);
                    ++lineNo;
                }
                if (this.m_colsep.length() > 0 && !this.m_colsep.equals(" ") && (strIdx = databuf.lastIndexOf(tempStr = lastStr)) > -1) {
                    tempStr = this.replaceColSep(tempStr);
                    databuf.replace(strIdx, strIdx + tempStr.length(), tempStr);
                }
                if (this.m_foldedrows || adjPagesize != 0 && lineNo > adjPagesize * pageNo - bTitle_lines) continue;
                databuf.append(m_lineSeparator);
                if (adjPagesize <= 0) continue;
                ++lineNo;
            }
            if (multiline && !multiLineRow && !databuf.toString().endsWith(m_lineSeparator + m_lineSeparator)) {
                databuf.append(m_lineSeparator);
                ++lineNo;
            }
            if (((String)cursorData).length() > 0) {
                databuf.append((String)cursorData);
                cursorData = "";
            }
            if (out instanceof StringBuffer) {
                this.setCursorStmtHeader(tot_header.toString());
            } else if (this.m_foldedrows && !databuf.toString().endsWith(m_lineSeparator + m_lineSeparator)) {
                missingLineTerminators = databuf.toString().endsWith(m_lineSeparator) ? m_lineSeparator : m_lineSeparator + m_lineSeparator;
            }
            boolean writtenOut = false;
            if (dataBufHelper != null) {
                writtenOut = dataBufHelper.writeOut(this.m_scriptRunnerContext, out, databuf);
            }
            if (!writtenOut) {
                this.write(out, databuf.toString());
            }
            databuf.setLength(0);
        }
        if (bTitle_lines > 0 && this.m_scriptRunnerContext.getBTitleFlag()) {
            int limit = this.m_pagesize * pageNo - bTitle_lines;
            while (lineNo < limit) {
                this.write(out, m_lineSeparator.toString());
                ++lineNo;
            }
            this.write(out, this.getBottomTitle(pageNo, cMap, ovcMap, cpttlcacheRow, columns).toString());
            lineNo += bTitle_lines;
        }
        if (!(out instanceof StringBuffer)) {
            int nLnNo = 0;
            nLnNo = pageNo > 1 ? lineNo - this.m_pagesize * (pageNo - 1) : lineNo;
            pageNo = this.m_pagesize == 0 ? 0 : pageNo;
            this.m_scriptRunnerContext.putProperty("script.runner.lno", new Integer(nLnNo));
            this.m_scriptRunnerContext.putProperty("script.runner.pno", new Integer(pageNo));
        }
        if (!SQLPLUSCmdFormatter.maxRowsSpoolOnly(this.m_scriptRunnerContext) && cnt == maxRowCache && rset.next()) {
            if (errbuf == null) {
                this.logMaxReached(out);
            } else {
                SQLPLUSCmdFormatter.logMaxReached(errbuf, this.m_scriptRunnerContext);
            }
        }
        if (this.m_scriptRunnerContext != null && newVal) {
            if (cnt == 0) {
                this.m_scriptRunnerContext.updateColumn(columns, null, null);
            } else {
                this.m_scriptRunnerContext.updateColumn(columns, lastVal, coldataTypes);
            }
        }
        if (this.m_scriptRunnerContext != null && oldVal) {
            if (cnt == 0) {
                this.m_scriptRunnerContext.updateOVColumn(columns, null, null);
            } else {
                this.m_scriptRunnerContext.updateOVColumn(columns, oldlVal, coldataTypes);
            }
        }
        return cnt;
    }

    private void appendDataToBuffer(StringBuffer buffer, AtomicInteger lineNo, AtomicInteger pageNo, StringBuffer data, int offset) {
        if (data != null && data.length() > 0) {
            String[] arrdata;
            for (String ad : arrdata = data.toString().split(m_lineSeparator)) {
                if (lineNo.get() >= this.m_pagesize * pageNo.get() + offset) {
                    pageNo.incrementAndGet();
                    this.m_newpage = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.newpage");
                    for (int np = 0; np < this.m_newpage; ++np) {
                        buffer.append(m_lineSeparator);
                        lineNo.incrementAndGet();
                    }
                }
                buffer.append(ad);
                buffer.append(m_lineSeparator);
                lineNo.incrementAndGet();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getColumnSize(Connection conn, ResultSet rs, int colindex, HashMap<String, ArrayList<String>> storedColCmds) throws SQLException {
        rsmd = rs.getMetaData();
        colsize = rsmd.getColumnDisplaySize(colindex);
        colName = rsmd.getColumnName(colindex).toLowerCase();
        formatSize = -1;
        headingSize = -1;
        colType = rsmd.getColumnType(colindex);
        if (storedColCmds.containsKey(colName)) {
            ls = storedColCmds.get(colName);
            ** if (!this.displayColumnAttributes(storedColCmds, (String)colName)) goto lbl53
            for (k = 0; k < ls.size(); ++k) {
                colcmd = ls.get(k);
                cmds = colcmd.split(" ");
                if (cmds[0].equalsIgnoreCase("format") && cmds[cmds.length - 1] != null) {
                    if (cmds[cmds.length - 1].charAt(0) == 'a' || cmds[cmds.length - 1].charAt(0) == 'A') {
                        if (ls.contains("_12.1_longident")) {
                            if (colsize == 128) {
                                formatSize = Integer.parseInt(cmds[cmds.length - 1].substring(1, cmds[cmds.length - 1].length()));
                            }
                        } else {
                            formatSize = Integer.parseInt(cmds[cmds.length - 1].substring(1, cmds[cmds.length - 1].length()));
                        }
                    } else if (this.isNumericColumn(colType)) {
                        fmtstr = cmds[cmds.length - 1];
                        formatSize = this.formattedNUMBERLength(fmtstr);
                        heading = this.getHeading(colName, storedColCmds);
                        biggestStringInHeader = heading.length();
                        if (heading.contains("|")) {
                            biggestStringInHeader = 0;
                            var19_26 = headyStrings = heading.split("\\|");
                            var20_28 = var19_26.length;
                            for (var21_29 = 0; var21_29 < var20_28; ++var21_29) {
                                i = var19_26[var21_29];
                                if (i.length() <= biggestStringInHeader) continue;
                                biggestStringInHeader = i.length();
                            }
                        }
                        if (biggestStringInHeader > 0 && biggestStringInHeader >= formatSize) {
                            formatSize = biggestStringInHeader;
                        } else if (heading.length() == 0 && colName.length() > formatSize) {
                            formatSize = colName.length();
                        }
                    } else {
                        formatSize = -1;
                    }
                }
                heading = this.getHeading(colName, storedColCmds);
                biggestStringInHeader = heading.length();
                if (heading.contains("|")) {
                    biggestStringInHeader = 0;
                    for (String i : headyStrings = heading.split("\\|")) {
                        if (i.length() <= biggestStringInHeader) continue;
                        biggestStringInHeader = i.length();
                    }
                }
                if (biggestStringInHeader <= 0 || biggestStringInHeader < formatSize) continue;
                headingSize = biggestStringInHeader;
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl53:
        // 4 sources

        if ((prodStoredcolCmds = this.m_scriptRunnerContext.getStoredFormatCmds()) != storedColCmds && prodStoredcolCmds.containsKey(colName)) {
            formatSize = this.getColumnSize(conn, rs, colindex, prodStoredcolCmds);
        }
        displaySize = colsize;
        if (this.isNumericColumn(colType)) {
            size = rsmd.getPrecision(colindex);
            if (this.m_numformat.length() > 0) {
                displaySize = this.m_numformat.length() <= 3 ? 4 : (this.m_numformat.matches("9+") ? this.m_numformat.length() + 1 : this.m_numformat.length());
            } else if (this.m_numwidth > 1) {
                colExprLength = this.getColumnName(rs, colindex).length();
                displaySize = colExprLength;
                if (displaySize <= this.m_numwidth) {
                    displaySize = this.m_numwidth;
                }
            } else if (size == 126) {
                displaySize = colsize;
            } else {
                if (size == 0) {
                    num = ((OracleResultSet)rs).getNUMBER(colindex);
                    size = NUMBER.toString((byte[])num.toBytes()).length();
                }
                displaySize = size > this.getColumnName(rs, colindex).length() ? size : this.getColumnName(rs, colindex).length();
            }
        } else if (colType == -8) {
            displaySize = 18;
        } else if (colType == -10) {
            displaySize = 20;
        }
        intvlsize = this.getIntervalTypeDisplaySize(conn, rs, colindex, colType);
        dtsize = this.getDateTimeDisplaySize(conn, rs, colindex);
        v0 = intvlsize == 0 ? (dtsize == 0 ? displaySize : dtsize) : (displaySize = intvlsize);
        if (rsmd.getColumnType(colindex) == -3) {
            displaySize *= 2;
        }
        if (this.isLongColumn(colType)) {
            displaySize = this.m_long;
        }
        max = 4000;
        if (this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getProperty("script.runner.setlong") != null && (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlong") > 4000) {
            max = (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlong");
        }
        if (displaySize == 0) {
            displaySize = 1;
        }
        if (displaySize > max || displaySize <= 0) {
            displaySize = max;
        }
        if (this.isLongColumn(colType)) {
            colsize = this.m_linesize <= displaySize ? this.m_linesize : displaySize;
            if (colsize > 80) {
                colsize = 80;
            }
            if (this.m_longchunk > colsize) {
                colsize = this.m_longchunk;
            }
        } else if (displaySize > colsize) {
            colsize = dtsize == 0 && displaySize < this.getColumnName(rs, colindex).length() && colType != -10 ? this.getColumnName(rs, colindex).length() : displaySize;
        }
        if (formatSize != -1) {
            colsize = formatSize;
        } else if (headingSize != -1 && headingSize > colsize) {
            colsize = headingSize;
        }
        if (this.m_linesize > 0 && colsize > this.m_linesize && !this.isLongColumn(colType)) {
            colsize = this.m_linesize;
        }
        if (this.isNumericColumn(colType) && this.getColumnName(rs, colindex).length() <= displaySize && formatSize < 0 && headingSize < 0) {
            return displaySize;
        }
        return colsize;
    }

    private String getHeading(String colName, HashMap<String, ArrayList<String>> storedColCmds) {
        String heading = "";
        if (this.displayColumnAttributes(storedColCmds, colName) && storedColCmds.containsKey(colName)) {
            ArrayList<String> ls = storedColCmds.get(colName);
            for (int k = 0; k < ls.size(); ++k) {
                String hdgcmd = ls.get(k);
                if (hdgcmd.indexOf("heading") <= -1) continue;
                heading = hdgcmd.replaceFirst("heading ", "");
                break;
            }
        }
        return heading;
    }

    private boolean hasMultiLineHeaders(HashMap<String, ArrayList<String>> storedColCmds, ResultSet rs) throws IOException, SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
            String colName = this.getColumnName(rs, i).toLowerCase();
            ArrayList<String> colcmds = storedColCmds.get(colName);
            if (colcmds == null) continue;
            for (int j = 0; !(j >= colcmds.size() || j == 0 && colcmds.get(j).matches("(?i:off)")); ++j) {
                if (!colcmds.get(j).matches("(?i:heading\\s+.+)")) continue;
                String[] cmds = colcmds.get(j).split(" ");
                for (int k = 0; k < cmds.length; ++k) {
                    if (cmds[k].indexOf(this.m_headsepchar) <= -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void convertToMultiLineHeader(int colsize, int colindex, String colheading, String[] columns) {
        if (!colheading.equals("") && ((String)this.m_scriptRunnerContext.getProperty("script.runner.setheadsep")).equalsIgnoreCase("on")) {
            String ltcolheading;
            columns[colindex] = "";
            String rexp = "[\\" + this.m_headsepchar + "]";
            Pattern pattern = Pattern.compile(rexp);
            Matcher matcher = pattern.matcher(colheading);
            int count = 0;
            while (matcher.find()) {
                ++count;
            }
            String[] tokens = colheading.split(rexp);
            columns[colindex] = count > 0 && tokens.length > 0 ? (ltcolheading = colheading.replaceAll(rexp, m_lineSeparator)) : (colheading.length() > colsize ? colheading.substring(0, colsize) : colheading);
        } else if (colheading.length() > 0) {
            String hdr = colheading;
            if (hdr.length() > colsize) {
                hdr = hdr.substring(0, colsize);
            }
            columns[colindex] = hdr;
        }
    }

    private StringBuffer multilineHeader(ResultSet rs, HashMap<String, ArrayList<String>> storedColsCmds, Integer[] colsizes, String[] columns, String[] originalColumns, boolean printCheck) throws SQLException {
        int i;
        StringBuffer header = new StringBuffer("");
        boolean bdone = false;
        boolean multiline = false;
        ResultSetMetaData rsmd = rs.getMetaData();
        ArrayList<StringBuffer> mlheader = new ArrayList<StringBuffer>();
        for (i = 0; i < columns.length; ++i) {
            mlheader.add(i, null);
        }
        while (!bdone) {
            bdone = true;
            multiline = false;
            for (i = 1; i < columns.length; ++i) {
                if (columns[i] == null) continue;
                String colName = this.getColumnName(rs, i).toLowerCase();
                if (printCheck && !this.printColumn(storedColsCmds, colName)) continue;
                StringBuffer nextChunk = null;
                if (mlheader.get(i) == null) {
                    mlheader.add(i, new StringBuffer(columns[i]));
                    nextChunk = new StringBuffer(columns[i]);
                } else {
                    nextChunk = (StringBuffer)mlheader.get(i);
                }
                int idx = nextChunk.indexOf(m_lineSeparator);
                if (idx != -1) {
                    multiline = true;
                    StringBuffer temp = nextChunk;
                    nextChunk = new StringBuffer(nextChunk.substring(0, idx));
                    temp = temp.length() - 1 > idx ? new StringBuffer(temp.substring(idx + m_lineSeparator.length())) : new StringBuffer("");
                    mlheader.set(i, temp);
                    bdone = false;
                } else {
                    mlheader.set(i, new StringBuffer(""));
                }
                this.font_width_adjustment(nextChunk, colsizes[i]);
                int colType = -99;
                if (columns == originalColumns) {
                    colType = rsmd.getColumnType(i);
                } else {
                    for (int kk = 1; kk < originalColumns.length; ++kk) {
                        if (!columns[i].equals(originalColumns[kk])) continue;
                        colType = rsmd.getColumnType(kk);
                        break;
                    }
                }
                nextChunk = colType == 2 ? new StringBuffer(String.format("%1$" + nextChunk.toString().length() + "s", nextChunk.toString().trim())) : new StringBuffer(this.justifyHeaders(storedColsCmds, this.getColumnName(rs, i).toLowerCase(), nextChunk.toString().trim(), nextChunk.toString().length()));
                if (i < columns.length - 1) {
                    nextChunk.append(this.m_colsep);
                }
                header.append(nextChunk.toString());
            }
            if (!multiline) continue;
            header.append(m_lineSeparator);
        }
        int lines = header.toString().split(m_lineSeparator).length;
        if (lines > 1) {
            int ltIdx = m_lineSeparator.length() > 1 ? header.indexOf(m_lineSeparator) + 1 : header.indexOf(m_lineSeparator);
            int hdrLineLen = ltIdx + 1;
            for (int k = 1; k < columns.length; ++k) {
                String str;
                int k1;
                String[] strs;
                int collines;
                if (columns[k] == null) continue;
                String colName = this.getColumnName(rs, k).toLowerCase();
                if (printCheck && !this.printColumn(storedColsCmds, colName)) continue;
                if (columns[k].indexOf(m_lineSeparator) == -1) {
                    int idx = header.indexOf(columns[k]);
                    if (idx == -1) continue;
                    String blankStr = "";
                    blankStr = String.format("%1$-" + new Integer(columns[k].length()).toString() + "s", "");
                    header.replace(idx, idx + columns[k].length(), blankStr);
                    int start = 0;
                    int end = 0;
                    int l = lines - 1;
                    start = idx + l * hdrLineLen;
                    end = start + columns[k].length();
                    header.replace(start, end, columns[k]);
                    continue;
                }
                if (!this.isMultipleMultilineColumns(columns) || (collines = (strs = columns[k].split(m_lineSeparator, -1)).length) >= lines) continue;
                int startLine = lines - collines;
                int fromIdx = -1;
                int idx = -1;
                HashMap<Integer, Integer> idx_to_stIdx = new HashMap<Integer, Integer>();
                for (k1 = 0; k1 < collines; ++k1) {
                    str = strs[k1];
                    idx = header.indexOf(str, -1);
                    if (idx < 0 || str.length() <= 0) continue;
                    String blankStr = String.format("%1$-" + new Integer(str.length()).toString() + "s", "");
                    header.replace(idx, idx + str.length(), blankStr);
                    int line = startLine + k1;
                    int diff = 0;
                    diff = idx > ltIdx ? idx - ltIdx - 1 : idx;
                    while (diff > ltIdx) {
                        diff = diff - ltIdx - 1;
                    }
                    int start = diff + line * hdrLineLen;
                    int end = start + str.length();
                    idx_to_stIdx.put(k1, start);
                }
                for (k1 = 0; k1 < collines; ++k1) {
                    int start;
                    str = strs[k1];
                    if (str.length() <= 0 || (start = ((Integer)idx_to_stIdx.get(k1)).intValue()) >= header.toString().length()) continue;
                    header.replace(start, start + str.length(), str);
                }
            }
        }
        return header;
    }

    private final boolean isMultipleMultilineColumns(String[] columns) {
        boolean gtOne = false;
        int count = 0;
        for (int i = 1; i < columns.length; ++i) {
            int idx = columns[i].indexOf(m_lineSeparator);
            if (idx <= -1) continue;
            ++count;
        }
        gtOne = count > 1;
        return gtOne;
    }

    private StringBuffer wordwrap(int dataType, int colsize, StringBuffer val) {
        return ScriptUtils.wordwrap(dataType, colsize, val, this.m_long);
    }

    private StringBuffer truncate(int dataType, int colsize, StringBuffer val) {
        return ScriptUtils.truncate(dataType, colsize, val);
    }

    private StringBuffer wrap(int dataType, int colsize, StringBuffer val) {
        return ScriptUtils.wrap(dataType, colsize, val);
    }

    private StringBuffer xmlWordWrap(int colsize, StringBuffer val) {
        return ScriptUtils.xmlWordWrap(colsize, val, this.m_long);
    }

    private void font_width_adjustment(StringBuffer str, int colsize) {
        ScriptRunnerContext ctx = this.m_scriptRunnerContext;
        if (!this.m_scriptRunnerContext.isCommandLine()) {
            int spacePixelWidth = -1;
            if (this.spacePixelWidthMode2 == -1) {
                this.spacePixelWidthMode2 = ResultSetFormatter.getPixelSize(" ", 2);
            }
            spacePixelWidth = this.spacePixelWidthMode2;
            int pixelWidth = ResultSetFormatter.getPixelSize(str.toString(), 2);
            if (pixelWidth < colsize * spacePixelWidth) {
                int pixelsRequired = colsize * spacePixelWidth - pixelWidth;
                int spacesRequired = pixelsRequired / spacePixelWidth;
                str.append(this.justify_left(" ", spacesRequired));
            }
        } else if (str.length() < colsize) {
            int diff = colsize - str.length();
            str.append(this.justify_left(" ", diff));
        }
    }

    private String justify_left(String str, int width) {
        if (width <= 0) {
            return "";
        }
        return String.format("%1$-" + width + "s", str);
    }

    private String justify_right(String str, int width) {
        if (width <= 0) {
            return "";
        }
        return String.format("%1$" + width + "s", str);
    }

    private String justify_center(String str, int width) {
        String val = str.trim();
        if (width < val.length()) {
            return str;
        }
        int lenR = (width - val.length()) / 2 + val.length();
        String strR = String.format("%1$" + lenR + "s", val);
        String ret = String.format("%1$-" + width + "s", strR);
        return ret;
    }

    private String justifyHeaders(HashMap<String, ArrayList<String>> storedColCmds, String column, String colName, int colsize) {
        ArrayList<String> colcmds = storedColCmds.get(column);
        if (colcmds != null && this.displayColumnAttributes(storedColCmds, column)) {
            for (int j = 0; j < colcmds.size(); ++j) {
                if (colcmds.get(j).equalsIgnoreCase("justify right")) {
                    return this.justify_right(colName, colsize);
                }
                if (colcmds.get(j).equalsIgnoreCase("justify center")) {
                    return this.justify_center(colName, colsize);
                }
                if (!colcmds.get(j).toLowerCase().startsWith("justify")) continue;
                return this.justify_left(colName, colsize);
            }
        }
        return this.justify_left(colName, colsize);
    }

    private boolean displayColumnAttributes(HashMap<String, ArrayList<String>> storedColCmds, String column) {
        int j;
        ArrayList<String> colcmds = storedColCmds.get(column);
        if (colcmds != null && (j = 0) < colcmds.size()) {
            return j != 0 || !colcmds.get(j).equalsIgnoreCase("off") && !colcmds.get(j).startsWith("off");
        }
        return true;
    }

    private StringBuffer checkFormatOptions(ResultSet rs, int colidx, HashMap<String, ArrayList<String>> storedColsCmds, Integer[] colsizes, ArrayList<StringBuffer> cacheRow) throws SQLException {
        StringBuffer buf = new StringBuffer("");
        ResultSetMetaData rmeta = rs.getMetaData();
        int colType = rmeta.getColumnType(colidx);
        String colName = "";
        colName = colType == 2002 || colType == 2003 ? rmeta.getColumnName(colidx).toLowerCase() : this.getColumnName(rs, colidx).toLowerCase();
        boolean isLongType = this.isLongColumn(colType);
        boolean bwrapOverride = false;
        if (storedColsCmds.containsKey(colName)) {
            ArrayList<String> ls = storedColsCmds.get(colName);
            StringBuffer dataChunk = new StringBuffer();
            dataChunk = isLongType ? this.truncate(colType, this.m_long, cacheRow.get(colidx)) : cacheRow.get(colidx);
            for (int k = 0; k < ls.size(); ++k) {
                String colcmd = ls.get(k);
                if (k == 0 && (colcmd.equalsIgnoreCase("off") || colcmd.startsWith("off"))) break;
                if (colcmd.startsWith("heading") || colcmd.startsWith("format") || colcmd.startsWith("justify")) continue;
                if (colcmd.indexOf("truncated") > -1) {
                    buf = this.truncate(colType, colsizes[colidx], dataChunk);
                    bwrapOverride = true;
                    continue;
                }
                if (colcmd.indexOf("word_wrapped") > -1) {
                    buf = this.wordwrap(colType, colsizes[colidx], dataChunk);
                    bwrapOverride = true;
                    continue;
                }
                if (colcmd.indexOf("wrapped") > -1) {
                    buf = this.wrap(colType, colsizes[colidx], dataChunk);
                    bwrapOverride = true;
                    continue;
                }
                if (colcmd.indexOf("null") > -1) {
                    if (dataChunk.toString() != null && !dataChunk.toString().equals("") && !dataChunk.toString().equals(" ")) continue;
                    String nullstr = colcmd.replaceFirst("null\\s*", "");
                    buf = new StringBuffer(nullstr);
                    continue;
                }
                if (bwrapOverride) continue;
                buf = this.m_wrap.equalsIgnoreCase("ON") ? this.wrap(colType, colsizes[colidx], dataChunk) : this.truncate(colType, colsizes[colidx], dataChunk);
            }
        }
        return buf;
    }

    private boolean printColumn(HashMap<String, ArrayList<String>> storedColCmds, String column) {
        ArrayList<String> colcmds = storedColCmds.get(column);
        if (colcmds != null) {
            for (int j = 0; j < colcmds.size(); ++j) {
                if (colcmds.get(j).equalsIgnoreCase("off")) {
                    return true;
                }
                if (!colcmds.get(j).equalsIgnoreCase("noprint")) continue;
                return false;
            }
        }
        return true;
    }

    private int getDateTimeDisplaySize(Connection conn, ResultSet rs, int colindex) {
        int dataLength = 0;
        String maskFromNLS = "";
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            String dataType = rsmd.getColumnTypeName(colindex);
            int colType = rsmd.getColumnType(colindex);
            OracleNLSProvider onlsp = (OracleNLSProvider)NLSProvider.getProvider(conn);
            if (dataType.equalsIgnoreCase("date")) {
                DATE date = ((OracleResultSet)rs).getDATE(colindex);
                maskFromNLS = onlsp.getDateFormat();
                if (this.m_dtformat_to_colsize.get(maskFromNLS.toUpperCase()) != null) {
                    dataLength = this.m_dtformat_to_colsize.get(maskFromNLS.toUpperCase());
                }
                if (dataLength == 0) {
                    String val = onlsp.format(date);
                    if (val != null) {
                        dataLength = val.length();
                    }
                    dataLength = dataLength == 0 ? (this.getDateTimeDisplaySize(conn, 91) == 0 ? (this.getDateTimeDisplaySize(conn, 93) == 0 ? dataLength : this.getDateTimeDisplaySize(conn, 93)) : this.getDateTimeDisplaySize(conn, 91)) : dataLength;
                }
            } else if (dataType.equalsIgnoreCase("timestamp")) {
                TIMESTAMP ts = ((OracleResultSet)rs).getTIMESTAMP(colindex);
                maskFromNLS = onlsp.getTimeStampFormat();
                String val = onlsp.format(ts);
                if (val != null) {
                    dataLength = val.length();
                }
                dataLength = dataLength == 0 ? this.getDateTimeDisplaySize(conn, 93) : dataLength;
            } else if (dataType.equalsIgnoreCase("timestamp with local time zone")) {
                TIMESTAMPLTZ tltz = ((OracleResultSet)rs).getTIMESTAMPLTZ(colindex);
                maskFromNLS = onlsp.getTimeStampWithLocalTimeZoneFormat();
                String val = onlsp.format(tltz);
                if (val != null) {
                    dataLength = val.length();
                }
                dataLength = dataLength == 0 ? this.getDateTimeDisplaySize(conn, colType) : dataLength;
            } else if (dataType.equalsIgnoreCase("timestamp with time zone")) {
                TIMESTAMPTZ tstz = ((OracleResultSet)rs).getTIMESTAMPTZ(colindex);
                maskFromNLS = onlsp.getTimeStampWithTimeZoneFormat();
                String val = onlsp.format(tstz);
                if (val != null) {
                    dataLength = val.length();
                }
                dataLength = dataLength == 0 ? this.getDateTimeDisplaySize(conn, colType) : dataLength;
            } else {
                dataLength = this.getDateTimeDisplaySize(conn, colType);
            }
            if (maskFromNLS.matches("(?i:D(L|S)\\s+TS)")) {
                dataLength = 41;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataLength;
    }

    private int getDateTimeDisplaySize(Connection conn, int colType) {
        if (this.m_nls_formats.containsKey(colType)) {
            return this.m_nls_formats.get(colType);
        }
        String maskFromNLS = "";
        if (colType == 92) {
            maskFromNLS = "HH.MI.SSXFF am";
        } else if (colType == 91 || colType == 93) {
            if (colType == 91) {
                maskFromNLS = NLSProvider.getProvider(conn).getDateFormat();
            } else if (colType == 93) {
                maskFromNLS = NLSProvider.getProvider(conn).getTimeStampFormat();
            }
            String dmaskFromNLS = NLSProvider.getProvider(conn).getDateFormat();
            if (dmaskFromNLS.matches("(?i:D(L|S)\\s+TS)") || maskFromNLS.matches("(?i:D(L|S)\\s+TS)")) {
                this.m_nls_formats.put(colType, 42);
                return 42;
            }
        } else if (colType == -101) {
            maskFromNLS = NLSProvider.getProvider(conn).getTimeStampWithTimeZoneFormat();
        } else if (colType == -102) {
            this.m_nls_formats.put(colType, 35);
            return 35;
        }
        int fmtLength = this.queryFormatLength(conn, maskFromNLS);
        this.m_nls_formats.put(colType, fmtLength);
        return fmtLength;
    }

    private int getIntervalTypeDisplaySize(Connection conn, ResultSet rs, int colindex, int colType) {
        if (this.m_nls_formats.containsKey(colType)) {
            return this.m_nls_formats.get(colType);
        }
        try {
            String maskFromNLS = "";
            OracleNLSProvider onlsp = (OracleNLSProvider)NLSProvider.getProvider(conn);
            if (colType == -103 || colType == -104) {
                maskFromNLS = onlsp.format(ScriptUtils.getOracleObjectWrap((OracleResultSet)rs, colindex));
                int fmtLength = this.queryFormatLength(conn, maskFromNLS);
                this.m_nls_formats.put(colType, fmtLength);
                return fmtLength;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private int queryFormatLength(Connection conn, String maskFromNLS) {
        String fmt = "";
        if (maskFromNLS != null && !maskFromNLS.equals("")) {
            fmt = maskFromNLS.toLowerCase();
        }
        int adjustment = 0;
        if (fmt.contains("xff")) {
            adjustment += 7;
        }
        if (fmt.contains("hh24")) {
            adjustment -= 2;
        }
        if (fmt.contains("tzr")) {
            adjustment += 3;
        }
        if (fmt.matches("(?i:D(L|S)\\s+TS)")) {
            return 41;
        }
        return fmt.length() + adjustment;
    }

    private void populateDTFmtsToColsizes() {
        this.m_dtformat_to_colsize.put("DD-MON-RR", 9);
        this.m_dtformat_to_colsize.put("DD/MON/RR", 9);
        this.m_dtformat_to_colsize.put("DD.MON.RR", 9);
        this.m_dtformat_to_colsize.put("DD;MON;RR", 9);
        this.m_dtformat_to_colsize.put("DD:MON:RR", 9);
        this.m_dtformat_to_colsize.put("DDMONRR", 7);
        this.m_dtformat_to_colsize.put("MM-DD-YYYY", 10);
        this.m_dtformat_to_colsize.put("MM/DD/YYYY", 10);
        this.m_dtformat_to_colsize.put("MM.DD.YYYY", 10);
        this.m_dtformat_to_colsize.put("MM;DD;YYYY", 10);
        this.m_dtformat_to_colsize.put("MM:DD:YYYY", 10);
        this.m_dtformat_to_colsize.put("MMDDYYYY", 8);
        this.m_dtformat_to_colsize.put("DD-MON-YYYY", 11);
        this.m_dtformat_to_colsize.put("DD/MON/YYYY", 11);
        this.m_dtformat_to_colsize.put("DD.MON.YYYY", 11);
        this.m_dtformat_to_colsize.put("DD;MON;YYYY", 11);
        this.m_dtformat_to_colsize.put("DDMONYYYY", 9);
        this.m_dtformat_to_colsize.put("DD-MM-YYYY", 10);
        this.m_dtformat_to_colsize.put("DD/MM/YYYY", 10);
        this.m_dtformat_to_colsize.put("DD.MM.YYYY", 10);
        this.m_dtformat_to_colsize.put("DD;MM;YYYY", 10);
        this.m_dtformat_to_colsize.put("DD:MM:YYYY", 10);
        this.m_dtformat_to_colsize.put("DDMMYYYY", 8);
        this.m_dtformat_to_colsize.put("DL", 42);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedNumber(Connection conn, NUMBER number, String fmtstr) {
        String retval = "";
        ResultSet rset = null;
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("NUMVAL", number.stringValue());
        binds.put("FMT", fmtstr);
        String sql = "SELECT TO_CHAR(:NUMVAL, :FMT) FROM DUAL";
        if (conn != null && !"SELECT TO_CHAR(:NUMVAL, :FMT) FROM DUAL".equals("")) {
            try {
                DBUtil dbutil = DBUtil.getInstance(conn);
                rset = dbutil.executeOracleQuery("SELECT TO_CHAR(:NUMVAL, :FMT) FROM DUAL", binds);
                while (rset.next()) {
                    retval = rset.getString(1);
                }
            }
            catch (Exception ex) {
                retval = DataTypesUtil.stringValue(number, conn);
            }
            finally {
                try {
                    if (rset != null) {
                        rset.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return retval;
    }

    private StringBuffer getTopTitleAndHeader(int page, StringBuffer header_lines, Map<String, String> subNewValueMap, Map<String, String> subOldValueMap, ArrayList<StringBuffer> row, String[] columns) {
        boolean tpLines = false;
        boolean btmLines = false;
        StringBuffer tpTitle = new StringBuffer("");
        StringBuffer btmTitle = new StringBuffer("");
        StringBuffer buf = new StringBuffer("");
        if (this.m_linesize > 0 && this.m_pagesize >= 0) {
            if (this.m_TopTitle != null && this.m_scriptRunnerContext.getTTitleFlag() && this.m_pagesize > 0) {
                tpTitle = this.m_TopTitle.getTitle(this.m_scriptRunnerContext, page, subNewValueMap, subOldValueMap, row, columns, this.m_sql);
            }
            if (this.m_scriptRunnerContext.getTTitleFlag()) {
                if (this.m_pagesize <= this.numberofLines(header_lines)) {
                    buf.append(tpTitle);
                } else {
                    buf.append(tpTitle);
                    int titleLines = this.numberofLines(tpTitle);
                    int headerLines = this.numberofLines(header_lines);
                    int totLines = titleLines + headerLines;
                    if (this.m_pagesize >= totLines) {
                        buf.append(header_lines);
                    }
                }
            } else if (this.m_pagesize > 2) {
                buf.append(header_lines);
            }
        }
        return buf;
    }

    private StringBuffer getBottomTitle(int page, Map<String, String> subNewValue, Map<String, String> subOldValue, ArrayList<StringBuffer> row, String[] columns) {
        StringBuffer btmTitle = null;
        StringBuffer buf = new StringBuffer("");
        if (this.m_linesize > 0 && this.m_pagesize >= 0) {
            if (this.m_BottomTitle != null && this.m_scriptRunnerContext.getBTitleFlag() && this.m_pagesize > 0) {
                btmTitle = this.m_BottomTitle.getTitle(this.m_scriptRunnerContext, page, subNewValue, subOldValue, row, columns, this.m_sql);
                String tmp = this.justify_left(" ", this.m_linesize);
                StringBuffer tmpbuf = new StringBuffer("");
                tmpbuf.append(btmTitle);
                btmTitle = tmpbuf;
            }
            if (this.m_scriptRunnerContext.getBTitleFlag() && this.m_pagesize > 0 && btmTitle != null) {
                buf.append(btmTitle);
            }
        }
        return buf;
    }

    private int getTotTitleLines() {
        int lines = 0;
        if (this.m_pagesize > 0) {
            if (this.m_scriptRunnerContext.getTTitleFlag() && this.m_TopTitle != null) {
                StringBuffer topTitleBuffer = this.m_TopTitle.getTitle(this.m_scriptRunnerContext, 1, null, null, null, null, this.m_sql);
                lines += this.numberofLines(topTitleBuffer);
            }
            if (this.m_scriptRunnerContext.getBTitleFlag() && this.m_BottomTitle != null) {
                StringBuffer bottomTitleBuffer = this.m_BottomTitle.getTitle(this.m_scriptRunnerContext, 1, null, null, null, null, this.m_sql);
                lines += this.numberofLines(bottomTitleBuffer);
            }
        }
        return lines;
    }

    private int getTopTitleLength() {
        int lines = 0;
        if (this.m_pagesize > 0 && this.m_scriptRunnerContext.getTTitleFlag() && this.m_TopTitle != null) {
            lines += this.numberofLines(this.m_TopTitle.getTitle(this.m_scriptRunnerContext, 1, null, null, null, null, this.m_sql));
        }
        return lines;
    }

    private Integer adjustToLineandPageSize(ResultSet rs, HashMap<String, ArrayList<String>> storedColsCmds, Integer[] colsizes, StringBuffer data, StringBuffer linedata, StringBuffer buf, Integer linenum) throws SQLException {
        int beginIdx = 0;
        int endIdx = 0;
        int startIdx = 0;
        int idx = 0;
        int lnendIdx = 0;
        int linesize = this.m_linesize;
        boolean bLastCol = false;
        boolean bLinedata = false;
        boolean bPrint = true;
        Object str = "";
        int validLength = 0;
        String colsep = "\\Q" + this.m_colsep + "\\E";
        String[] columns = data.toString().split(colsep);
        String[] lines = linedata.toString().split(colsep);
        ResultSetMetaData rmeta = rs.getMetaData();
        if (data != null || data.length() > 0) {
            if (this.m_columns.length > 2) {
                for (int i = 1; i < 3; ++i) {
                    if (this.printColumn(storedColsCmds, this.getColumnName(rs, i).toLowerCase())) {
                        validLength += colsizes[i].intValue();
                    }
                    if (i >= 2) continue;
                    validLength += this.m_colsep.length();
                }
            }
            int consoleWidth = 10000;
            if (this.m_scriptRunnerContext.isCommandLine()) {
                try {
                    consoleWidth = this.m_scriptRunnerContext.getSQLPlusConsoleReader() != null ? this.m_scriptRunnerContext.getSQLPlusConsoleReader().getWidth() : 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean classic = false;
            if (this.m_scriptRunnerContext.getProperty("sqlplus.classic.mode") != null) {
                classic = Boolean.parseBoolean(this.m_scriptRunnerContext.getProperty("sqlplus.classic.mode").toString());
            }
            if (!classic && linesize < validLength && consoleWidth < validLength && this.m_colsep.length() > 1 || consoleWidth < linesize && this.m_columns.length < 3) {
                for (int i = 1; i < this.m_formattedcols.length; ++i) {
                    if (this.m_formattedcols[i] == null) continue;
                    buf.append(this.m_formattedcols[i].replaceAll("\\s+$", ""));
                    buf.append(m_lineSeparator);
                    Integer n = linenum;
                    Integer n2 = linenum = Integer.valueOf(linenum + 1);
                    if (lines.length != this.m_formattedcols.length - 1 || lines[i - 1].length() <= 0) continue;
                    buf.append(lines[i - 1]);
                    buf.append(m_lineSeparator);
                    n = linenum;
                    n2 = linenum = Integer.valueOf(linenum + 1);
                }
            } else {
                boolean bHeaderDone = false;
                for (int i = 1; i < colsizes.length; ++i) {
                    bPrint = this.printColumn(storedColsCmds, this.getColumnName(rs, i).toLowerCase());
                    if (bPrint) {
                        linesize = i == colsizes.length - 1 ? (linesize -= colsizes[i].intValue()) : (linesize -= colsizes[i] + this.m_colsep.length());
                    } else if (i == colsizes.length - 1) {
                        bLastCol = true;
                        bHeaderDone = true;
                    }
                    if (bHeaderDone && (linesize < 0 || bLastCol)) {
                        Object tmp;
                        int strIdx = buf.indexOf((String)str);
                        if (strIdx <= -1) continue;
                        if (i > 1 && i <= colsizes.length - 1 && !bLastCol) {
                            --i;
                            str = this.replaceColSep((String)str);
                            buf.replace(strIdx, strIdx + ((String)str).length(), (String)str);
                            tmp = buf.toString();
                            tmp = ((String)tmp).replaceAll("\\s+$", "");
                            buf.setLength(0);
                            buf.append((String)tmp);
                        }
                        tmp = linenum;
                        Integer n = linenum = Integer.valueOf(linenum + 1);
                        if (linedata != null) {
                            Object object;
                            if (buf != null && buf.length() != 0 && this.m_colsep.equals(buf.substring(buf.length() - 1)) && !bLastCol) {
                                buf.deleteCharAt(buf.length() - 1);
                            }
                            buf.append(m_lineSeparator);
                            String str1 = "";
                            if (bPrint && linedata.lastIndexOf(this.m_colsep) > -1) {
                                if (!bLastCol) {
                                    str1 = linedata.substring(idx, lnendIdx);
                                    str1 = this.replaceColSep(str1);
                                } else {
                                    str1 = linedata.substring(idx, lnendIdx);
                                }
                            } else if (bLastCol) {
                                str1 = linedata.length() > lnendIdx ? linedata.substring(idx, lnendIdx) : linedata.substring(idx, linedata.length());
                            }
                            try {
                                if (startIdx < this.m_linesize * linenum) {
                                    startIdx = this.m_linesize * linenum;
                                } else if (startIdx == this.m_linesize * linenum) {
                                    ++startIdx;
                                }
                                buf.append(str1);
                                String tmp2 = buf.toString();
                                tmp2 = tmp2.replaceAll("\\s+$", "");
                                buf.setLength(0);
                                buf.append(tmp2);
                                buf.append(m_lineSeparator);
                                bLinedata = true;
                                startIdx += str1.length();
                                idx = endIdx + 1;
                                object = linenum;
                                Integer n3 = linenum = Integer.valueOf(linenum + 1);
                            }
                            catch (Exception ex) {
                                object = ex.getMessage();
                            }
                        }
                        linesize = this.m_linesize;
                        bHeaderDone = false;
                        continue;
                    }
                    if (bPrint) {
                        int colsize = colsizes[i] > this.m_linesize ? this.m_linesize : colsizes[i];
                        endIdx = beginIdx + colsize;
                        if (i == colsizes.length - 1) {
                            if (endIdx > data.length()) {
                                endIdx = data.length();
                            }
                            str = data.substring(beginIdx, endIdx);
                        } else {
                            str = data.substring(beginIdx, endIdx) + this.m_colsep;
                        }
                        endIdx = beginIdx + ((String)str).length() - 1;
                        if (startIdx < this.m_linesize * linenum) {
                            startIdx = this.m_linesize * linenum;
                        }
                        buf.append((String)str);
                        bLinedata = false;
                        startIdx += ((String)str).length();
                        lnendIdx = endIdx + 1;
                        beginIdx = endIdx + 1;
                    }
                    if (i < colsizes.length - 1 && linesize < colsizes[i + 1]) {
                        bHeaderDone = true;
                    }
                    if (i != colsizes.length - 1) continue;
                    if (bPrint) {
                        --i;
                    }
                    bLastCol = true;
                    bHeaderDone = true;
                }
            }
        }
        if (buf.length() > 0 && this.numberofLines(buf) == 1 && buf.indexOf(m_lineSeparator) == -1) {
            buf.append(m_lineSeparator);
        }
        return linenum;
    }

    private Integer adjustHeaderToLineandPageSize(ResultSet rs, HashMap<String, ArrayList<String>> storedColsCmds, Integer[] colsizes, String[] columns, StringBuffer buf, Integer linenum) throws SQLException {
        boolean beginIdx = false;
        boolean endIdx = false;
        int startIdx = 0;
        boolean idx = false;
        int linesize = this.m_delim_lnsize;
        boolean bLastCol = false;
        String[] colsLine = null;
        Integer[] colsizesLine = null;
        ArrayList<String> colList = null;
        ArrayList<Integer> colsizesList = null;
        StringBuffer header = new StringBuffer("");
        StringBuffer headerLine = new StringBuffer("");
        String lastColLine = "";
        ResultSetMetaData rmeta = rs.getMetaData();
        for (int i = 1; i < colsizes.length; ++i) {
            if (!this.printColumn(storedColsCmds, this.getColumnName(rs, i).toLowerCase())) continue;
            if ((linesize -= colsizes[i] + this.m_colsep.length()) < 0 || bLastCol) {
                int ii;
                if (i <= colsizes.length - 1 && !bLastCol) {
                    --i;
                }
                headerLine = new StringBuffer(headerLine.toString().trim());
                colsLine = new String[colList.size()];
                for (ii = 0; ii < colList.size(); ++ii) {
                    colsLine[ii] = (String)colList.get(ii);
                }
                colList = new ArrayList();
                colList.add("");
                colsizesLine = new Integer[colsizesList.size()];
                for (ii = 0; ii < colsizesList.size(); ++ii) {
                    colsizesLine[ii] = (Integer)colsizesList.get(ii);
                }
                colsizesList = new ArrayList();
                colsizesList.add(0);
                this.getFontMetrics();
                header = this.multilineHeader(rs, storedColsCmds, colsizesLine, colsLine, columns, false);
                String[] hdrstrs = header.toString().split(m_lineSeparator);
                for (int k = 0; k < hdrstrs.length; ++k) {
                    startIdx = this.m_delim_lnsize * linenum;
                    String hdrln = hdrstrs[k];
                    buf.append(hdrln);
                    buf.append(m_lineSeparator);
                    Integer n = linenum;
                    Integer n2 = linenum = Integer.valueOf(linenum + 1);
                }
                startIdx = this.m_delim_lnsize * linenum;
                if (headerLine.substring(headerLine.length() - 1, headerLine.length()).equals(this.m_colsep)) {
                    headerLine.delete(headerLine.length() - 1, headerLine.length());
                }
                buf.append(headerLine.toString());
                buf.append(m_lineSeparator);
                Integer n = linenum;
                Integer n3 = linenum = Integer.valueOf(linenum + 1);
                headerLine = new StringBuffer("");
                linesize = this.m_delim_lnsize;
                continue;
            }
            if (colList == null) {
                colList = new ArrayList<String>();
                colList.add("");
            }
            if (colsizesList == null) {
                colsizesList = new ArrayList<Integer>();
                colsizesList.add(0);
            }
            colList.add(columns[i]);
            colsizesList.add(colsizes[i]);
            char[] chars = new char[colsizes[i].intValue()];
            Arrays.fill(chars, '-');
            lastColLine = String.copyValueOf(chars);
            headerLine.append(lastColLine);
            headerLine.append(this.m_colsep);
            if (i != colsizes.length - 1) continue;
            --i;
            bLastCol = true;
        }
        return linenum;
    }

    private String replaceColSep(String str) {
        Object retval = "";
        boolean len = false;
        if (str.length() > 0 && str.indexOf(this.m_colsep) > -1) {
            retval = str.replaceAll(Pattern.quote(this.m_colsep + "$"), "");
            for (int i = 0; i < this.m_colsep.length(); ++i) {
                retval = (String)retval + " ";
            }
        }
        return retval;
    }

    private boolean isLongColumn(int colType) {
        return colType == -1 || colType == -13 || colType == 2004 || colType == 2005 || colType == 2007 || colType == 2009 || colType == 2011;
    }

    private boolean isNumericColumn(int colType) {
        return colType == 2 || colType == 4 || colType == 6 || colType == 100 || colType == 101;
    }

    private boolean isAValidLinesize() {
        for (int i = 1; i < this.m_colsizes.length; ++i) {
            if (this.m_colsizes[i] == null || this.m_linesize >= this.m_colsizes[i] || this.m_linesize >= 10) continue;
            return false;
        }
        return true;
    }

    private int numberofLines(StringBuffer buf) {
        if (buf != null && buf.length() > 0) {
            return new StringTokenizer(buf.toString(), m_lineSeparator).countTokens();
        }
        return 0;
    }

    private Integer getAdjustedPagesize(StringBuffer hdr_lines, int titleLines) {
        int hdr_tpttl_lines = this.numberofLines(this.getTopTitleAndHeader(0, hdr_lines, null, null, null, null));
        int btm_ttl_lines = this.numberofLines(this.getBottomTitle(0, null, null, null, null));
        int lines = hdr_tpttl_lines + btm_ttl_lines;
        Integer adjPagesize = this.m_pagesize;
        if (this.m_pagesize > 0) {
            if (this.m_pagesize == 1) {
                adjPagesize = this.m_pagesize + 1 + titleLines;
            } else if (this.m_pagesize > 1) {
                if (this.m_pagesize <= titleLines) {
                    adjPagesize = 2 + titleLines;
                } else if (lines >= 2 && this.m_pagesize < lines + 2) {
                    adjPagesize = 2 + lines;
                }
            }
        }
        return adjPagesize;
    }

    private int strCount(String findStr, String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            String strAti = str.substring(i, i + 1);
            if (!findStr.equals(strAti)) continue;
            ++count;
        }
        return count;
    }

    private int formattedNUMBERLength(String fmtstr) {
        int tstInt = 10;
        String s = "";
        int length = 0;
        NUMBER num = new NUMBER(10);
        try {
            if (fmtstr.matches("(?i:tm)(?:|9|e|E)")) {
                length = 64;
            } else if (fmtstr.matches("(?i:rn)")) {
                length = 15;
            } else {
                s = num.toFormattedText(fmtstr, null);
                length = s.length();
            }
        }
        catch (SQLException ex) {
            length = 0;
        }
        return length;
    }

    private String formattedFLOAT(Connection conn, float num, String fmtstr, int colsize) throws SQLException {
        boolean formatPreference = false;
        Object formatted = null;
        Object mask = "";
        if (num == 0.0f && (fmtstr == null || fmtstr.length() == 0)) {
            return "0";
        }
        int minsize = 7;
        int hashMarkChar = 35;
        if (colsize < 7) {
            char[] chars = new char[colsize];
            Arrays.fill(chars, '#');
            return String.valueOf(chars);
        }
        if (Float.isInfinite(num) && (fmtstr == null || fmtstr.length() == 0)) {
            formatted = "Inf";
            if (num == Float.NEGATIVE_INFINITY) {
                formatted = "-" + (String)formatted;
            }
            return formatted;
        }
        if (Float.isInfinite(num) && fmtstr != null && fmtstr.length() > 0) {
            char[] chars = new char[fmtstr.length()];
            Arrays.fill(chars, '#');
            formatted = String.valueOf(chars);
            if (num == Float.NEGATIVE_INFINITY) {
                formatted = "-" + (String)formatted;
            }
            return formatted;
        }
        if (Float.isNaN(num) && (fmtstr == null || fmtstr.length() == 0)) {
            formatted = "Nan";
            return formatted;
        }
        if (Float.isNaN(num) && fmtstr != null && fmtstr.length() > 0) {
            char[] chars = new char[fmtstr.length()];
            Arrays.fill(chars, '#');
            formatted = String.valueOf(chars);
            return formatted;
        }
        if (colsize >= 7) {
            if (fmtstr == null || fmtstr.length() == 0) {
                mask = "0.0E000{0}";
            } else if (fmtstr.contains("E") && fmtstr.contains(".")) {
                String subFmtStr = fmtstr.replace("E", "").trim();
                String[] parts = subFmtStr.split("\\.");
                int decimalPlaces = parts[1].length();
                int integralPlaces = parts[0].length();
                Object decimalMask = "0";
                for (int i = 1; i < decimalPlaces; ++i) {
                    decimalMask = (String)decimalMask + "0";
                }
                mask = num == 0.0f ? "." + (String)decimalMask + "E00{0}" : "0." + (String)decimalMask + "E00{0}";
                formatPreference = true;
            } else {
                mask = "0.0E000{0}";
            }
            int numHashMarks = colsize - 7;
            if (colsize <= 10) {
                numHashMarks = colsize - 8;
            }
            if (num < 0.0f && (numHashMarks = colsize - 8) == 0) {
                char[] chars = new char[colsize];
                Arrays.fill(chars, '#');
                return String.valueOf(chars);
            }
            if (numHashMarks > 8) {
                numHashMarks = 8;
            }
            Object maskFiller = "";
            if (numHashMarks >= 0) {
                if (Math.signum(num) < 0.0f && numHashMarks > 0) {
                    --numHashMarks;
                }
                char[] chars = new char[numHashMarks];
                Arrays.fill(chars, '#');
                maskFiller = String.valueOf(chars);
            } else {
                maskFiller = new String() + "#";
            }
            String pattern = null;
            pattern = formatPreference ? MessageFormat.format((String)mask, "") : MessageFormat.format((String)mask, maskFiller);
            DecimalFormat formatter = new DecimalFormat(pattern);
            String s = formatter.format(num);
            String[] as = s.split("E");
            String exponentSign = "+";
            if (as[1].startsWith("-")) {
                exponentSign = "";
            }
            formatted = as[0] + "E" + exponentSign + as[1];
        }
        return formatted;
    }

    private String formattedNUMBER(Connection conn, NUMBER num, String fmtstr, int colsize) throws SQLException {
        String s = "";
        try {
            s = num.toFormattedText(fmtstr, null);
        }
        catch (SQLException ex) {
            if (ex.getMessage().equalsIgnoreCase("Unimplemented method called")) {
                if (fmtstr.length() == 2 && (fmtstr.startsWith("r") || fmtstr.startsWith("R"))) {
                    int intval = num.ceil().intValue();
                    s = RomanUtil.getRomanFmt(intval, colsize);
                    if (Character.isLowerCase(fmtstr.charAt(0))) {
                        s = s.toLowerCase();
                    }
                } else if (fmtstr.startsWith("x") || fmtstr.startsWith("X")) {
                    int intval = num.ceil().intValue();
                    if (intval < 0) {
                        char[] chars = new char[fmtstr.length() + 1];
                        Arrays.fill(chars, '#');
                        s = String.copyValueOf(chars);
                    } else {
                        s = Character.isLowerCase(fmtstr.charAt(0)) ? String.format("%x", num.ceil().bigIntegerValue()) : String.format("%X", num.ceil().bigIntegerValue());
                    }
                }
            }
            if (ex.getMessage().equalsIgnoreCase("Invalid Oracle Number")) {
                char[] chars = new char[this.formattedNUMBERLength(fmtstr)];
                Arrays.fill(chars, '#');
                s = String.copyValueOf(chars);
            }
            s = DataTypesUtil.stringValue(num, conn);
        }
        return s;
    }

    private String formattedDouble(Connection conn, double num, String fmtstr, int colsize) throws SQLException {
        Object formatted = null;
        Object mask = "";
        colsize = this.m_numwidth;
        if (num == 0.0 && (fmtstr == null || fmtstr.length() == 0)) {
            return "0";
        }
        int minsize = 8;
        int hashMarkChar = 35;
        int zeroMarkChar = 48;
        if (colsize < 8) {
            char[] chars = new char[colsize];
            Arrays.fill(chars, '#');
            return String.valueOf(chars);
        }
        if (Double.isInfinite(num) && (fmtstr == null || fmtstr.length() == 0)) {
            formatted = "Inf";
            if (num == Double.NEGATIVE_INFINITY) {
                formatted = "-" + (String)formatted;
            }
            return formatted;
        }
        if (Double.isInfinite(num) && fmtstr != null && fmtstr.length() > 0) {
            char[] chars = new char[fmtstr.length()];
            Arrays.fill(chars, '#');
            formatted = String.valueOf(chars);
            if (num == Double.NEGATIVE_INFINITY) {
                formatted = "-" + (String)formatted;
            }
            return formatted;
        }
        if (Double.isNaN(num) && (fmtstr == null || fmtstr.length() == 0)) {
            formatted = "Nan";
            return formatted;
        }
        if (Double.isNaN(num) && fmtstr != null && fmtstr.length() > 0) {
            char[] chars = new char[fmtstr.length()];
            Arrays.fill(chars, '#');
            formatted = String.valueOf(chars);
            return formatted;
        }
        if (colsize >= 8) {
            int numZeroMarks = 0;
            int numHashMarks = colsize - 7;
            if (colsize <= 10) {
                numHashMarks = colsize - 8;
            }
            if (num < 0.0 && (numHashMarks = colsize - 8) == 0) {
                char[] chars = new char[colsize];
                Arrays.fill(chars, '#');
                return String.valueOf(chars);
            }
            if (numHashMarks > 8 && numHashMarks < 16) {
                numHashMarks = 8;
            }
            if (numHashMarks > 16) {
                numHashMarks = 16;
                numZeroMarks = 16;
            }
            if (fmtstr == null || fmtstr.length() == 0) {
                mask = numHashMarks == 16 ? "0.0{0}E000{1}" : "0.0E000{0}";
            } else if (fmtstr.contains("E") && fmtstr.contains(".")) {
                String subFmtStr = fmtstr.replace("E", "").trim();
                String[] parts = subFmtStr.split("\\.");
                int decimalPlaces = parts[1].length();
                int integralPlaces = parts[0].length();
                Object decimalMask = "0";
                for (int i = 1; i < decimalPlaces; ++i) {
                    decimalMask = (String)decimalMask + "0";
                }
                mask = "0." + (String)decimalMask + "E00{0}";
            } else {
                mask = "0.0E000{0}";
            }
            Object hashMaskFiller = "";
            String zeroMaskFiller = "";
            String decimalPattern = "";
            if (numHashMarks >= 0 && numHashMarks < 16) {
                if (Math.signum(num) < 0.0 && numHashMarks > 0) {
                    --numHashMarks;
                }
                char[] hashChars = new char[numHashMarks];
                Arrays.fill(hashChars, '#');
                hashMaskFiller = String.valueOf(hashChars);
                decimalPattern = MessageFormat.format((String)mask, hashMaskFiller);
            } else if (numHashMarks == 16) {
                if (Math.signum(num) < 0.0 && numHashMarks > 0) {
                    --numHashMarks;
                }
                char[] hashChars = new char[numHashMarks];
                Arrays.fill(hashChars, '#');
                hashMaskFiller = String.valueOf(hashChars);
                char[] zeroChars = new char[numZeroMarks - 1];
                Arrays.fill(zeroChars, '0');
                zeroMaskFiller = String.valueOf(zeroChars);
                decimalPattern = MessageFormat.format((String)mask, zeroMaskFiller, hashMaskFiller);
            } else {
                hashMaskFiller = new String() + "#";
                decimalPattern = MessageFormat.format((String)mask, hashMaskFiller);
            }
            DecimalFormat formatter = new DecimalFormat(decimalPattern);
            formatter.setRoundingMode(RoundingMode.HALF_DOWN);
            String s = formatter.format(num);
            String[] as = s.split("E");
            String exponentSign = "+";
            if (as[1].startsWith("-")) {
                exponentSign = "";
            }
            formatted = as[0] + "E" + exponentSign + as[1];
        }
        return formatted;
    }

    private boolean isDataCached(ArrayList<StringBuffer> data) {
        boolean retval = false;
        for (int i = 1; i < this.m_columns.length; ++i) {
            StringBuffer col = data.get(i);
            if (col == null || col.toString().equals(DONE)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private boolean hasDuplicates(LinkedHashMap<String, ArrayList<String>> storedBrkCmds, ResultSet rs, ArrayList<StringBuffer> cacheRow, ArrayDeque<String[]> brkColValues, boolean newPage) throws SQLException {
        boolean noDuplicate = false;
        ResultSetMetaData rmeta = rs.getMetaData();
        Object[] rowValue = null;
        if (newPage) {
            brkColValues.clear();
        }
        ArrayList<String> cols = new ArrayList<String>();
        for (int k = 1; k < this.m_columns.length; ++k) {
            String columnName;
            if (this.m_columns[k] == null || (columnName = this.m_column_to_brkcol.get(this.m_columns[k])) == null || this.m_brkcol_to_nodup.get(columnName) == null) continue;
            int colType = rmeta.getColumnType(k);
            if (this.isNumericColumn(colType)) {
                Datum n = null;
                try {
                    n = ScriptUtils.getOracleObjectWrap((OracleResultSet)rs, k);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String nStr = n != null ? n.stringValue() : "";
                cols.add(nStr);
                continue;
            }
            cols.add(cacheRow.get(k).toString());
        }
        int size = cols.size();
        if (size > 0) {
            rowValue = new String[size];
            cols.toArray(rowValue);
        }
        if (rowValue != null) {
            if (brkColValues.size() == 0) {
                brkColValues.addFirst((String[])rowValue);
                noDuplicate = false;
            } else if (this.findBreakColValues(brkColValues, (String[])rowValue)) {
                if (!brkColValues.peekFirst()[0].equals("Nan") && Arrays.equals(brkColValues.peekFirst(), rowValue)) {
                    noDuplicate = true;
                } else {
                    String[] foundRow = this.findBreakRow(brkColValues, (String[])rowValue);
                    if (foundRow != null) {
                        brkColValues.remove(foundRow);
                        brkColValues.addFirst((String[])rowValue);
                        noDuplicate = false;
                    }
                }
            } else {
                brkColValues.addFirst((String[])rowValue);
            }
        }
        return noDuplicate;
    }

    private boolean hasDuplicates(LinkedHashMap<String, ArrayList<String>> storedBrkCmds, ResultSet rs, ArrayList<StringBuffer> cacheRow, ArrayDeque<String[]> brkColValues, int colId, boolean newPage) throws SQLException {
        boolean noDuplicate;
        block11: {
            String[] prevBrkValues;
            int brkOrder;
            noDuplicate = false;
            Object rowValue = null;
            ResultSetMetaData rmeta = rs.getMetaData();
            String colName = this.getColumnName(rs, colId);
            int n = this.m_brkcol_to_rank.get(colName) != null ? this.m_brkcol_to_rank.get(colName) : (brkOrder = this.m_brkcol_to_rank.get(colName.toLowerCase()) != null ? this.m_brkcol_to_rank.get(colName.toLowerCase()) : -1);
            if (newPage) break block11;
            String[] stringArray = prevBrkValues = brkColValues.toArray().length > 1 ? (String[])brkColValues.toArray()[1] : null;
            if (brkOrder != -1 && prevBrkValues != null) {
                if (this.m_breakandselorderMatch) {
                    for (int i = 1; i < brkOrder + 1; ++i) {
                        int k = i - 1;
                        int selColId = this.getSelColIdFromBreakColId(k);
                        if (selColId < 1 || k >= prevBrkValues.length) continue;
                        String prevColVal = prevBrkValues[k];
                        String currColVal = cacheRow.get(selColId).toString();
                        if (currColVal.equals(prevColVal)) {
                            if (k == 0) {
                                noDuplicate = true;
                                continue;
                            }
                            noDuplicate &= true;
                            continue;
                        }
                        if (k == 0) {
                            noDuplicate = false;
                            continue;
                        }
                        noDuplicate &= false;
                    }
                } else {
                    for (int i = 1; i < brkOrder + 1; ++i) {
                        int k = i - 1;
                        int selColId = this.getSelColIdFromBreakColId(k);
                        if (selColId < 1 || prevBrkValues.length < selColId) continue;
                        String prevColVal = prevBrkValues[selColId - 1];
                        String currColVal = cacheRow.get(selColId).toString();
                        if (currColVal.equals(prevColVal)) {
                            if (k == 0) {
                                noDuplicate = true;
                                continue;
                            }
                            noDuplicate &= true;
                            continue;
                        }
                        if (k == 0) {
                            noDuplicate = false;
                            continue;
                        }
                        noDuplicate &= false;
                    }
                }
            }
        }
        return noDuplicate;
    }

    private boolean findBreakColValues(ArrayDeque<String[]> brkColValues, String[] rowValue) {
        boolean bFound = false;
        Iterator<String[]> iter = brkColValues.iterator();
        while (iter.hasNext()) {
            bFound = Arrays.equals(iter.next(), rowValue);
            if (!bFound) continue;
            return bFound;
        }
        return bFound;
    }

    /*
     * WARNING - void declaration
     */
    private String[] findBreakRow(ArrayDeque<String[]> brkColValues, String[] rowValue) {
        void var3_4;
        Object var3_3 = null;
        for (Object[] objectArray : brkColValues) {
            boolean found = Arrays.equals(objectArray, rowValue);
            if (!found) continue;
            return objectArray;
        }
        return var3_4;
    }

    private String getBreakColumn(LinkedHashMap<String, ArrayList<String>> storedBrkCmds, String colName) {
        String breakColumn = null;
        String string = breakColumn = storedBrkCmds.containsKey(colName) ? colName : null;
        if (breakColumn == null) {
            for (String col : storedBrkCmds.keySet()) {
                if (!col.equalsIgnoreCase(colName)) continue;
                breakColumn = col;
                break;
            }
        }
        return breakColumn;
    }

    private int getBreakOrder(LinkedHashMap<String, ArrayList<String>> storedBrkCmds, String colName) {
        int breakOrder = -1;
        ArrayList<String> brkCols = new ArrayList<String>();
        brkCols.addAll(storedBrkCmds.keySet());
        for (int i = 0; i < brkCols.size(); ++i) {
            if (!((String)brkCols.get(i)).equalsIgnoreCase(colName)) continue;
            breakOrder = i + 1;
            break;
        }
        return breakOrder;
    }

    private int getSelColIdFromBreakColId(int brkColId) {
        ArrayList<String> breakColList = new ArrayList<String>();
        ArrayList<String> breakAllColList = new ArrayList<String>();
        int colId = 0;
        if (this.m_scriptRunnerContext.getStoredBreakCmds().size() > 0) {
            breakAllColList.addAll(this.m_scriptRunnerContext.getStoredBreakCmds().keySet());
            breakColList.addAll(this.filterList(breakAllColList, "report"));
            ArrayList<String> selList = new ArrayList<String>();
            selList.addAll(this.m_selColumnList);
            for (String selCol : selList) {
                String alias;
                ++colId;
                String breakCol = breakColList.size() > brkColId ? (String)breakColList.get(brkColId) : null;
                String[] colandalias = selCol.split("\\s+");
                String string = colandalias.length > 2 ? colandalias[2] : (alias = colandalias.length > 1 ? colandalias[1] : selCol);
                if (breakCol == null || !breakCol.equalsIgnoreCase(selCol) && !breakCol.equalsIgnoreCase(alias)) continue;
                break;
            }
        }
        if (colId == 0) {
            colId = -1;
        }
        return colId;
    }

    private int skippedLines(LinkedHashMap<String, ArrayList<String>> storedBrkCmds, String colName) {
        int lines = 0;
        String SKIP1 = "(?i:\\bski(?:|p)\\b)\\s+\\d+";
        ArrayList<String> actions = storedBrkCmds.get(colName);
        if (actions != null) {
            for (int i = 0; i < actions.size(); ++i) {
                String action = actions.get(i);
                if (!action.matches("(?i:\\bski(?:|p)\\b)\\s+\\d+")) continue;
                String lineStr = action.replaceAll("(?i:\\bski(?:|p)\\b)\\s+", "");
                lines = new Integer(lineStr);
                break;
            }
        }
        return lines;
    }

    private int skippedLines(LinkedHashMap<String, ArrayList<String>> storedBrkCmds) {
        int lines = 0;
        String SKIP1 = "(?i:\\bski(?:|p)\\b)\\s+\\d+";
        Iterator<String> iter = storedBrkCmds.keySet().iterator();
        ArrayList<String> actions = null;
        block0: while (iter.hasNext()) {
            String val = iter.next();
            if (!val.equalsIgnoreCase("row")) continue;
            actions = storedBrkCmds.get(val);
            for (int i = 0; i < actions.size(); ++i) {
                String action = actions.get(i);
                if (!action.matches("(?i:\\bski(?:|p)\\b)\\s+\\d+")) continue;
                String lineStr = action.replaceAll("(?i:\\bski(?:|p)\\b)\\s+", "");
                lines = new Integer(lineStr);
                break block0;
            }
        }
        return lines;
    }

    private int skipLinesForReport(LinkedHashMap<String, ArrayList<String>> storedBrkCmds) {
        int lines = 0;
        String SKIP1 = "(?i:\\bski(?:|p)\\b)\\s+\\d+";
        Iterator<String> iter = storedBrkCmds.keySet().iterator();
        ArrayList<String> actions = null;
        while (iter.hasNext()) {
            String action;
            String val = iter.next();
            if (!val.equalsIgnoreCase("report")) continue;
            int i = 0;
            actions = storedBrkCmds.get(val);
            if (i >= actions.size() || !(action = actions.get(i)).matches("(?i:\\bski(?:|p)\\b)\\s+\\d+")) break;
            String lineStr = action.replaceAll("(?i:\\bski(?:|p)\\b)\\s+", "");
            lines = new Integer(lineStr);
            break;
        }
        return lines;
    }

    private int skippedPage(LinkedHashMap<String, ArrayList<String>> storedBrkCmds, String colName) {
        int page = 0;
        String SKIP2 = "((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b)";
        ArrayList<String> actions = storedBrkCmds.get(colName);
        if (actions != null) {
            for (int i = 0; i < actions.size(); ++i) {
                String action = actions.get(i);
                if (!action.matches("((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b)")) continue;
                page = 1;
                break;
            }
        }
        return page;
    }

    private int skippedPage(LinkedHashMap<String, ArrayList<String>> storedBrkCmds) {
        int page = 0;
        String SKIP2 = "((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b)";
        Iterator<String> iter = storedBrkCmds.keySet().iterator();
        ArrayList<String> actions = null;
        block0: while (iter.hasNext()) {
            String val = iter.next();
            if (!val.equalsIgnoreCase("row")) continue;
            actions = storedBrkCmds.get(val);
            for (int i = 0; i < actions.size(); ++i) {
                String action = actions.get(i);
                if (!action.matches("((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b)")) continue;
                page = 1;
                break block0;
            }
        }
        return page;
    }

    public void setSQL(String sql) {
        this.m_sql = sql;
    }

    private Object[][] getComputedRowsForGroup(HashMap<String, Object[][]> cmptd_rows, ArrayList<Object> cmptd_columns, ResultSet rs, String[] breakcolcmptkeys) throws SQLException {
        Object[][] grpCmptdRows = null;
        Object[][] comp_rows = null;
        ArrayList<String> brkcolsnorep = this.filterList(this.m_brkcmptcolumns, "report");
        if (brkcolsnorep.size() > 0) {
            boolean bSumLinesAdded = false;
            for (int k = 0; k < breakcolcmptkeys.length; ++k) {
                if (breakcolcmptkeys[k] != null && breakcolcmptkeys[k].equals("report")) continue;
                comp_rows = this.getEqualRowCountRows(cmptd_rows, cmptd_columns, breakcolcmptkeys[k]);
                if (comp_rows != null) {
                    int i;
                    String[] columns = this.m_brkcmpkey_to_cols.get(breakcolcmptkeys[k]);
                    if (columns.length == 1) {
                        String column = columns[0];
                        if (column != null) {
                            if (this.m_column_to_summaryLines.get(column) == null) {
                                this.m_summaryLines = this.getSummaryLines(cmptd_rows, cmptd_columns, breakcolcmptkeys[k], column);
                                this.m_column_to_summaryLines.put(column, this.m_summaryLines);
                            } else {
                                this.m_summaryLines = this.m_column_to_summaryLines.get(column);
                            }
                        }
                        grpCmptdRows = this.addRow(grpCmptdRows, this.m_summaryLines);
                        for (i = 0; i < comp_rows.length; ++i) {
                            Object[] comp_row = comp_rows[i];
                            Object[][] data = this.getComputedRowsForGroup(comp_row, cmptd_columns, breakcolcmptkeys[k], column);
                            if (data == null) continue;
                            for (int j = 0; j < data.length; ++j) {
                                Object[] cmptd_row = data[j];
                                grpCmptdRows = this.addRow(grpCmptdRows, cmptd_row);
                            }
                        }
                    } else {
                        String[] column = columns;
                        i = column.length;
                        for (int j = 0; j < i; ++j) {
                            String column2 = column[j];
                            if (column2 != null) {
                                if (this.m_column_to_summaryLines.get(column2) == null) {
                                    this.m_summaryLines = this.getSummaryLines(cmptd_rows, cmptd_columns, breakcolcmptkeys[k], column2);
                                    this.m_column_to_summaryLines.put(column2, this.m_summaryLines);
                                } else {
                                    this.m_summaryLines = this.m_column_to_summaryLines.get(column2);
                                }
                            }
                            grpCmptdRows = this.addRow(grpCmptdRows, this.m_summaryLines);
                            for (int i2 = 0; i2 < comp_rows.length; ++i2) {
                                Object[][] data;
                                Object[] comp_row = comp_rows[i2];
                                String cmpfn = "";
                                if (this.m_column_to_brkcol.get(column2) != null) {
                                    cmpfn = this.m_brkcol_to_cmpfn.get(this.m_column_to_brkcol.get(column2));
                                }
                                if (!cmpfn.equals(this.getFunction(comp_row, cmptd_columns)) || (data = this.getComputedRowsForGroup(comp_row, cmptd_columns, breakcolcmptkeys[k], column2)) == null) continue;
                                for (int j2 = 0; j2 < data.length; ++j2) {
                                    Object[] cmptd_row = data[j2];
                                    grpCmptdRows = this.addRow(grpCmptdRows, cmptd_row);
                                }
                            }
                        }
                    }
                }
                if (cmptd_rows.get(breakcolcmptkeys[k]) != null && comp_rows != null && cmptd_rows.get(breakcolcmptkeys[k]).length != comp_rows.length) {
                    Object[][] ocrows = cmptd_rows.get(breakcolcmptkeys[k]);
                    for (int x = 0; x < comp_rows.length; ++x) {
                        ocrows = this.removeRow(ocrows, x);
                    }
                    cmptd_rows.remove(breakcolcmptkeys[k]);
                    cmptd_rows.put(breakcolcmptkeys[k], ocrows);
                    continue;
                }
                cmptd_rows.remove(breakcolcmptkeys[k]);
            }
        }
        if (this.m_brkcmptcolumns.get(this.m_brkcmptcolumns.size() - 1).equalsIgnoreCase("report") && cmptd_rows.size() >= 1 && grpCmptdRows == null) {
            comp_rows = this.getEqualRowCountRows(cmptd_rows, cmptd_columns, "report");
            if (comp_rows != null) {
                grpCmptdRows = this.addRow(grpCmptdRows, this.getSummaryLines(cmptd_rows, cmptd_columns, "report", "report"));
                for (int i = 0; i < comp_rows.length; ++i) {
                    Object[] comp_row = comp_rows[i];
                    Object[][] data = this.getComputedRowsForReport(comp_row, cmptd_columns, "report");
                    if (data == null) continue;
                    for (int j = 0; j < data.length; ++j) {
                        Object[] cmptd_row = data[j];
                        grpCmptdRows = this.addRow(grpCmptdRows, cmptd_row);
                    }
                }
            }
            cmptd_rows.remove("report");
            if (cmptd_rows.size() > 0) {
                cmptd_rows.clear();
            }
        }
        return grpCmptdRows;
    }

    private Object[][] getComputedRowsForGroup(Object[] comp_row, ArrayList<Object> cmptd_columns, String breakcolcmptkeys, String column) {
        Object[][] grpCmptdRows = null;
        String breakcol = column;
        if (comp_row != null && cmptd_columns.size() > 1 && breakcol != null) {
            String labelTxt = "";
            ArrayList compCols = new ArrayList();
            ArrayList<TreeMap<String, HashMap<String, String>>> mapList = null;
            int colCnt = this.m_columns.length;
            boolean isComputedReport = false;
            ArrayList<String> prevcmptdFuncs = new ArrayList<String>();
            mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(breakcol);
            if (mapList == null && this.m_column_to_brkcol.get(breakcol) != null) {
                mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(this.m_column_to_brkcol.get(breakcol));
            }
            if (mapList != null) {
                Compute.sort(mapList);
                Iterator<TreeMap<String, HashMap<String, String>>> cmpcolIter = null;
                for (TreeMap<String, HashMap<String, String>> cmpColKey : mapList) {
                    String cmpCol = cmpColKey.firstKey();
                    String currColFunc = "";
                    boolean bReferredFunc = false;
                    Object[] cmp_cols = new Object[colCnt];
                    block1: for (int j = 1; j < colCnt; ++j) {
                        if (this.m_columns[j] == null) continue;
                        String col = "";
                        String brkcol = this.m_column_to_brkcmptcol.get(this.m_columns[j]);
                        if (colCnt > 2 && breakcol != null && breakcol.equals(this.m_columns[j]) && !this.m_column_to_brkcol.get(this.m_columns[j]).equalsIgnoreCase(this.m_column_to_cmpcol.get(this.m_columns[j]))) {
                            int idx = -1;
                            if (this.m_column_to_cmpcol.containsKey(cmpCol) || this.m_column_to_cmpcol.containsKey(this.getHeading(cmpCol, this.m_scriptRunnerContext.getStoredFormatCmds()))) {
                                idx = cmptd_columns.indexOf(cmpCol.toUpperCase() + "_CMPFN") > -1 ? cmptd_columns.indexOf(cmpCol.toUpperCase() + "_CMPFN") : (cmptd_columns.indexOf(cmpCol + "_CMPFN") > -1 ? cmptd_columns.indexOf(cmpCol + "_CMPFN") : cmptd_columns.indexOf(cmpCol.toLowerCase() + "_CMPFN"));
                            } else if (this.m_column_to_cmpcol.containsValue(cmpCol)) {
                                for (String key : this.m_column_to_cmpcol.keySet()) {
                                    if (!this.m_column_to_cmpcol.get(key).equals(cmpCol)) continue;
                                    idx = cmptd_columns.indexOf(key.toUpperCase() + "_CMPFN") > -1 ? cmptd_columns.indexOf(key.toUpperCase() + "_CMPFN") : (cmptd_columns.indexOf(key + "_CMPFN") > -1 ? cmptd_columns.indexOf(cmpCol + "_CMPFN") : cmptd_columns.indexOf(cmpCol.toLowerCase() + "_CMPFN"));
                                    break;
                                }
                            }
                            if (idx <= -1) continue;
                            currColFunc = DataTypesUtil.stringValue(comp_row[idx + 1], this.m_conn);
                            if (currColFunc != null) {
                                String tempf = currColFunc;
                                if (currColFunc.length() > this.m_colsizes[j]) {
                                    tempf = currColFunc.substring(0, this.m_colsizes[j]);
                                }
                                if (prevcmptdFuncs.contains(tempf)) {
                                    bReferredFunc = true;
                                    if (j == colCnt - 1) {
                                        int jIdx = 0;
                                        for (int x = 1; x < cmp_cols.length; ++x) {
                                            if (cmp_cols[x] == null || cmp_cols[x] == "") continue;
                                            jIdx = x;
                                            break;
                                        }
                                        if (jIdx > 0 && cmpCol.length() > 0 && this.m_column_to_cmpcol.get(this.m_columns[jIdx]) != null && (this.m_column_to_cmpcol.get(this.m_columns[jIdx]).equalsIgnoreCase(cmpCol) || this.m_column_to_cmpcol.containsKey(this.getHeading(cmpCol, this.m_scriptRunnerContext.getStoredFormatCmds())))) {
                                            for (int k = 0; k < cmptd_columns.size(); ++k) {
                                                String cmp_col = (String)cmptd_columns.get(k);
                                                if (!cmp_col.equalsIgnoreCase(cmpCol) && !cmp_col.equalsIgnoreCase(this.m_columns[jIdx])) continue;
                                                if (!bReferredFunc || grpCmptdRows[grpCmptdRows.length - 1][jIdx] != "") break;
                                                grpCmptdRows[grpCmptdRows.length - 1][jIdx] = comp_row[k + 1];
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                            if (bReferredFunc) continue;
                            HashMap<String, String> fn_to_lbl = cmpColKey.get(cmpCol);
                            if (fn_to_lbl != null && fn_to_lbl.containsKey(currColFunc)) {
                                String temp = fn_to_lbl.get(currColFunc).replaceAll("'", "");
                                if (temp.length() > this.m_colsizes[j]) {
                                    temp = temp.substring(0, this.m_colsizes[j]);
                                }
                                cmp_cols[j] = temp;
                                continue;
                            }
                            if (currColFunc != null && currColFunc.length() > this.m_colsizes[j]) {
                                currColFunc = currColFunc.substring(0, this.m_colsizes[j]);
                            } else if (currColFunc == null) {
                                currColFunc = "";
                            }
                            cmp_cols[j] = currColFunc;
                            continue;
                        }
                        if (cmpCol.length() > 0 && this.m_column_to_cmpcol.get(this.m_columns[j]) != null && (this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(cmpCol) || this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(this.getColumnFromAlias(cmpCol)) || this.m_column_to_cmpcol.containsKey(this.getHeading(cmpCol, this.m_scriptRunnerContext.getStoredFormatCmds())))) {
                            for (int k = 0; k < cmptd_columns.size(); ++k) {
                                String cmp_col = (String)cmptd_columns.get(k);
                                if (cmptd_columns.get(k + 1) != null && cmp_col.equals(cmptd_columns.get(k + 1))) {
                                    ++k;
                                }
                                if (!cmp_col.equalsIgnoreCase(cmpCol) && !cmp_col.equalsIgnoreCase(this.m_columns[j])) continue;
                                if (bReferredFunc) {
                                    grpCmptdRows[grpCmptdRows.length - 1][j] = comp_row[k + 1];
                                    continue block1;
                                }
                                cmp_cols[j] = comp_row[k + 1];
                                continue block1;
                            }
                            continue;
                        }
                        cmp_cols[j] = "";
                    }
                    if (bReferredFunc) continue;
                    prevcmptdFuncs.add(currColFunc);
                    grpCmptdRows = this.addRow(grpCmptdRows, cmp_cols);
                }
            }
        }
        return grpCmptdRows;
    }

    private Object[][] getComputedRowsForReport(Object[] comp_row, ArrayList<Object> cmptd_columns, String breakcolcmptkeys) {
        Object[][] grpCmptdRows = null;
        if (comp_row != null && cmptd_columns.size() > 1) {
            String labelTxt = "";
            ArrayList compCols = new ArrayList();
            ArrayList<TreeMap<String, HashMap<String, String>>> mapList = null;
            if (breakcolcmptkeys.startsWith("report")) {
                mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get("report");
                Compute.sort(mapList);
            }
            boolean isLabelAllowed = !this.firstColumnAComputeColumn(mapList);
            int colCnt = this.m_columns.length;
            boolean isComputedReport = false;
            ArrayList<String> prevcmptdFuncs = new ArrayList<String>();
            for (TreeMap<String, HashMap<String, String>> cmpColKey : mapList) {
                String cmpCol = cmpColKey.firstKey();
                String currColFunc = "";
                boolean bReferredFunc = false;
                Object[] cmp_cols = new Object[colCnt];
                block1: for (int j = 1; j < colCnt; ++j) {
                    if (this.m_columns[j] == null) continue;
                    String col = "";
                    String brkcol = this.m_column_to_brkcmptcol.get(this.m_columns[j]);
                    if (colCnt > 2 && this.m_brkcmpkey_to_cols.get(breakcolcmptkeys) != null && this.m_brkcmpkey_to_cols.get(breakcolcmptkeys)[j].equals(this.m_columns[j])) {
                        labelTxt = this.m_brkcol_to_cmplbl.get(brkcol);
                        cmp_cols[j] = labelTxt;
                        continue;
                    }
                    if (colCnt > 2 && j == 1 && breakcolcmptkeys.startsWith("report")) {
                        HashMap func_to_lbl = this.m_brkcol_to_cmpfnlbl.get(breakcolcmptkeys);
                        int idx = -1;
                        String heading = this.getHeading(cmpCol, this.m_scriptRunnerContext.getStoredFormatCmds());
                        if (this.m_column_to_cmpcol.containsKey(cmpCol) || heading.length() > 0 && this.m_column_to_cmpcol.containsKey(heading)) {
                            idx = cmptd_columns.indexOf(cmpCol.toUpperCase() + "_CMPFN");
                        } else if (this.m_column_to_cmpcol.containsValue(cmpCol)) {
                            for (String key : this.m_column_to_cmpcol.keySet()) {
                                if (!this.m_column_to_cmpcol.get(key).equals(cmpCol)) continue;
                                idx = cmptd_columns.indexOf(key.toUpperCase() + "_CMPFN");
                                break;
                            }
                        }
                        if (idx <= -1 || (currColFunc = DataTypesUtil.stringValue(comp_row[idx + 1], this.m_conn)) == null) continue;
                        String tempf = currColFunc;
                        if (currColFunc.length() > this.m_colsizes[j]) {
                            tempf = currColFunc.substring(0, this.m_colsizes[j]);
                        }
                        if (prevcmptdFuncs.contains(tempf)) {
                            bReferredFunc = true;
                        }
                        if (bReferredFunc && j != 1) continue;
                        if (isLabelAllowed) {
                            HashMap<String, String> fn_to_lbl = cmpColKey.get(cmpCol);
                            if (fn_to_lbl != null && fn_to_lbl.containsKey(currColFunc)) {
                                String temp = fn_to_lbl.get(currColFunc).replaceAll("'", "");
                                if (temp.length() > this.m_colsizes[j]) {
                                    temp = temp.substring(0, this.m_colsizes[j]);
                                }
                                cmp_cols[j] = temp;
                                continue;
                            }
                            if (currColFunc.length() > this.m_colsizes[j]) {
                                currColFunc = currColFunc.substring(0, this.m_colsizes[j]);
                            }
                            cmp_cols[j] = currColFunc;
                            continue;
                        }
                        for (int k = 0; k < cmptd_columns.size(); ++k) {
                            String cmp_col = (String)cmptd_columns.get(k);
                            for (int x = k + 1; x < cmptd_columns.size(); ++x) {
                                if (!cmp_col.equalsIgnoreCase((String)cmptd_columns.get(x))) continue;
                                k = x;
                                break;
                            }
                            if (!cmp_col.equalsIgnoreCase(cmpCol) || !this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(cmpCol) && !this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(this.getColumnFromAlias(cmpCol))) continue;
                            if (bReferredFunc) {
                                grpCmptdRows[grpCmptdRows.length - 1][j] = comp_row[k + 1];
                                continue block1;
                            }
                            cmp_cols[j] = comp_row[k + 1];
                            continue block1;
                        }
                        continue;
                    }
                    if (cmpCol.length() > 0 && this.m_column_to_cmpcol.get(this.m_columns[j]) != null && (this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(cmpCol) || this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(this.getColumnFromAlias(cmpCol)) || this.m_column_to_cmpcol.containsKey(this.getHeading(cmpCol, this.m_scriptRunnerContext.getStoredFormatCmds())))) {
                        for (int k = 0; k < cmptd_columns.size(); ++k) {
                            String cmp_col = (String)cmptd_columns.get(k);
                            if (cmptd_columns.get(k + 1) != null && cmp_col.equals(cmptd_columns.get(k + 1))) {
                                ++k;
                            }
                            if (!cmp_col.equalsIgnoreCase(cmpCol) && !cmp_col.equalsIgnoreCase(this.m_columns[j])) continue;
                            if (bReferredFunc && grpCmptdRows != null) {
                                grpCmptdRows[grpCmptdRows.length - 1][j] = comp_row[k + 1];
                                continue block1;
                            }
                            cmp_cols[j] = comp_row[k + 1];
                            continue block1;
                        }
                        continue;
                    }
                    cmp_cols[j] = "";
                }
                if (bReferredFunc) continue;
                prevcmptdFuncs.add(currColFunc);
                boolean canAdd = false;
                for (int i = 1; i < cmp_cols.length; ++i) {
                    if (cmp_cols[i] == null || cmp_cols[i] == "") continue;
                    canAdd = true;
                    break;
                }
                if (!canAdd) continue;
                grpCmptdRows = this.addRow(grpCmptdRows, cmp_cols);
            }
        }
        return grpCmptdRows;
    }

    boolean firstColumnAComputeColumn(ArrayList<TreeMap<String, HashMap<String, String>>> mapList) {
        for (TreeMap<String, HashMap<String, String>> cmpColKey : mapList) {
            String cmpCol = cmpColKey.firstKey();
            for (int j = 1; j < this.m_columns.length; ++j) {
                if (this.m_columns[j] == null || j != 1 || this.m_column_to_cmpcol.get(this.m_columns[j]) == null || !this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(cmpCol) && !this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(this.getColumnFromAlias(cmpCol))) continue;
                return true;
            }
        }
        return false;
    }

    private Object[] getSummaryLines(HashMap<String, Object[][]> cmptd_rows, ArrayList<Object> cmptd_columns, String breakcolcmptkeys, String column) {
        Object[][] cmptdRows = cmptd_rows.get(breakcolcmptkeys);
        int colCnt = this.m_columns.length;
        Object[] cmp_cols = new Object[colCnt];
        boolean empty_cmp_cols = true;
        String breakcol = column;
        if (cmptdRows != null && cmptd_rows.size() > 0 && cmptd_columns.size() > 0 && (breakcol != null || breakcolcmptkeys.equalsIgnoreCase("report"))) {
            ArrayList<TreeMap<String, HashMap<String, String>>> mapList = null;
            if (breakcol != null) {
                mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(breakcol);
            } else if (breakcolcmptkeys.equalsIgnoreCase("report")) {
                mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get("report");
            }
            if (mapList == null && this.m_column_to_brkcol.get(breakcol) != null) {
                mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(this.m_column_to_brkcol.get(breakcol));
            }
            if (mapList != null) {
                Iterator<TreeMap<String, HashMap<String, String>>> cmpcolIter = null;
                for (TreeMap<String, HashMap<String, String>> cmpColKey : mapList) {
                    String cmpCol = cmpColKey.firstKey();
                    for (int j = 1; j < colCnt; ++j) {
                        String val;
                        char[] chars;
                        if (this.m_columns[j] == null) continue;
                        String cmptColumn = "";
                        if (colCnt > 2 && (breakcol != null && breakcol.equals(this.m_columns[j]) && !column.equalsIgnoreCase("report") && !this.m_column_to_brkcol.get(this.m_columns[j]).equalsIgnoreCase(this.m_column_to_cmpcol.get(this.m_columns[j])) || j == 1 && breakcolcmptkeys.equalsIgnoreCase("report") && this.m_column_to_brkcol.get(this.m_columns[j]) != null && this.m_breakcolumns.size() > 0 && this.m_brkcmptcolumns.size() == 1)) {
                            chars = new char[this.m_colsizes[j].intValue()];
                            Arrays.fill(chars, '*');
                            cmp_cols[j] = String.copyValueOf(chars);
                            continue;
                        }
                        if (cmpCol.length() > 0 && this.m_column_to_cmpcol.get(this.m_columns[j]) != null && (this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(cmpCol) || this.m_column_to_cmpcol.get(this.m_columns[j]).equalsIgnoreCase(this.getColumnFromAlias(cmpCol)) || this.m_column_to_cmpcol.containsKey(this.getHeading(cmpCol, this.m_scriptRunnerContext.getStoredFormatCmds())))) {
                            chars = new char[this.m_colsizes[j].intValue()];
                            Arrays.fill(chars, '-');
                            cmp_cols[j] = String.copyValueOf(chars);
                            continue;
                        }
                        String string = val = cmp_cols[j] != null ? (String)cmp_cols[j] : null;
                        if (val != null && val.matches("(-)+")) continue;
                        cmp_cols[j] = String.format("%1$-" + new Integer(this.m_colsizes[j]).toString() + "s", "");
                    }
                }
            }
        }
        return cmp_cols;
    }

    private final boolean isBreakColumn(String column) {
        boolean flag = false;
        for (int i = 0; i < this.m_brkcmptcolumns.size(); ++i) {
            String breakCol = this.m_brkcmptcolumns.get(i);
            if (breakCol.equalsIgnoreCase(column)) {
                flag = true;
                break;
            }
            String colAlias = this.getAlias(breakCol);
            if (colAlias.length() > 0 && colAlias.equalsIgnoreCase(column)) {
                flag = true;
                break;
            }
            String colHeading = this.getHeading(breakCol.toLowerCase(), this.m_scriptRunnerContext.getStoredFormatCmds());
            if (colHeading.length() <= 0 || !colHeading.equalsIgnoreCase(column)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private String getFunctionForCmptColumn(String cmptCol, String label, ArrayList<String> reportCols) {
        String function2 = "";
        boolean found = false;
        ArrayList<String> repColsWithAlias = this.getAliasedOrOrigCols(reportCols);
        for (int i = 0; i < repColsWithAlias.size(); ++i) {
            String column = repColsWithAlias.get(i);
            ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(column);
            for (TreeMap<String, HashMap<String, String>> col_cmptfunc : mapList) {
                block2: for (String funckey : col_cmptfunc.keySet()) {
                    if (!cmptCol.equalsIgnoreCase(funckey)) continue;
                    HashMap<String, String> cmpt_func = col_cmptfunc.get(funckey);
                    for (String function2 : cmpt_func.keySet()) {
                        String lbl = cmpt_func.get(function2);
                        found = label.equalsIgnoreCase(lbl = lbl.replaceAll("'", ""));
                        if (!found) continue;
                        break block2;
                    }
                }
                if (!found) continue;
                break;
            }
            if (found) break;
        }
        return function2;
    }

    private boolean isComputedColumn(String column) {
        boolean isCmptCol = false;
        for (String cmptCol : this.m_computecolumns) {
            if (!column.equalsIgnoreCase(cmptCol)) continue;
            isCmptCol = true;
            break;
        }
        return isCmptCol;
    }

    private int findStringIndex(ArrayList<Object> objList, String str) {
        int index = -1;
        if (this.numberofOccurences(objList, str) > 1) {
            int nFind = 0;
            for (int i = 0; i < objList.size(); ++i) {
                String obj = (String)objList.get(i);
                if (obj != null && obj.equalsIgnoreCase(str)) {
                    ++nFind;
                }
                if (nFind <= true) continue;
                return i;
            }
        } else {
            for (int i = 0; i < objList.size(); ++i) {
                String obj = (String)objList.get(i);
                if (obj == null || !obj.equalsIgnoreCase(str)) continue;
                return i;
            }
        }
        return -1;
    }

    private int numberofOccurences(ArrayList<Object> objList, String str) {
        int retval = 0;
        for (int i = 0; i < objList.size(); ++i) {
            String obj = (String)objList.get(i);
            if (obj == null || !obj.equalsIgnoreCase(str)) continue;
            ++retval;
        }
        return retval;
    }

    private String getBreakColCmptKey(HashMap<String, Object[][]> cmptd_rows, ArrayList<Object> cmptd_columns, ResultSet rs) throws SQLException {
        Object brkcolKey = "";
        if (cmptd_rows.size() > 0) {
            String strval;
            int j;
            ArrayList<String> reportCols = this.getAliasedOrOrigCols(this.m_brkcmptcolumns);
            ArrayList<String> fList = this.filterList(this.m_brkcmptcolumns, "report");
            int[] rsetIdxs = new int[fList.size() + 1];
            block0: for (int i = 1; i < this.m_columns.length; ++i) {
                for (j = 0; j < fList.size(); ++j) {
                    if (!fList.get(j).equalsIgnoreCase(this.m_columns[i])) continue;
                    rsetIdxs[i] = i;
                    continue block0;
                }
            }
            String[] brkcmpkeys = new String[rsetIdxs.length];
            for (j = 1; j < rsetIdxs.length; ++j) {
                Datum obj;
                if (rsetIdxs[j] <= 0 || !(rs instanceof OracleResultSet) || cmptd_rows.get(strval = DataTypesUtil.stringValue(obj = ScriptUtils.getOracleObjectWrap((OracleResultSet)rs, rsetIdxs[j]), this.m_conn)) == null) continue;
                brkcolKey = (String)brkcolKey + strval;
            }
            for (j = 1; j < rsetIdxs.length; ++j) {
                if (j == 1) {
                    brkcolKey = "";
                    Datum obj = ((OracleResultSet)rs).getOracleObject(rsetIdxs[j]);
                    strval = DataTypesUtil.stringValue(obj, this.m_conn);
                    if (cmptd_rows.get(strval) == null) continue;
                    brkcmpkeys[0] = brkcolKey = strval;
                    continue;
                }
                brkcolKey = "";
                for (int k = 0; k <= j; ++k) {
                    Datum obj = ScriptUtils.getOracleObjectWrap((OracleResultSet)rs, rsetIdxs[k + 1]);
                    String strval2 = DataTypesUtil.stringValue(obj, this.m_conn);
                    if (cmptd_rows.get((String)brkcolKey + strval2) == null) continue;
                    brkcmpkeys[k] = brkcolKey = (String)brkcolKey + strval2;
                }
            }
            if (((String)brkcolKey).length() == 0 && reportCols.contains("report")) {
                brkcolKey = "report";
                int size = cmptd_columns.size();
                for (int i = 0; i < size; ++i) {
                    String cmpCol = (String)cmptd_columns.get(i);
                    if (cmpCol.endsWith("_CMPFN") || cmpCol.equals("ROW_CNT")) continue;
                    brkcolKey = (String)brkcolKey + cmpCol;
                }
            }
        }
        return brkcolKey;
    }

    private String[] generateBrkComputeColKeys(HashMap<String, Object[][]> cmptd_rows, ArrayList<Object> cmptd_columns, ResultSet rs, String level) throws SQLException {
        ArrayList<String> fList = this.filterList(this.m_brkcmptcolumns, "report");
        fList = this.filterList(fList, "row");
        String[] brkcmpkeys = new String[this.m_brkcmptcolumns.size()];
        int[] rsetIdxs = new int[fList.size() + 1];
        this.m_brkcmpkey_to_cols.clear();
        block0: for (int i = 1; i < this.m_columns.length; ++i) {
            if (this.m_column_to_brkcmptcol.get(this.m_columns[i]) == null) continue;
            for (int j = 1; j < rsetIdxs.length; ++j) {
                String cmptd_col = (String)cmptd_columns.get(j - 1);
                if (cmptd_col == null || !this.m_columns[i].equalsIgnoreCase(cmptd_col) && !this.getHeading(this.m_columns[i], this.m_scriptRunnerContext.getStoredFormatCmds()).equalsIgnoreCase(cmptd_col) && !this.m_column_to_brkcmptcol.get(this.m_columns[i]).equalsIgnoreCase(cmptd_col) && !this.getHeading(this.m_column_to_brkcmptcol.get(this.m_columns[i]), this.m_scriptRunnerContext.getStoredFormatCmds()).equalsIgnoreCase(cmptd_col) || rsetIdxs[j] != 0) continue;
                rsetIdxs[j] = i;
                continue block0;
            }
        }
        if (rsetIdxs.length > 1) {
            boolean isValidKey = false;
            Object brkcolKey = "";
            ArrayList<Object> brkckeys = new ArrayList<Object>();
            HashMap<Integer, Object[]> lvltocol = this.groupLevels(fList);
            ArrayList<Integer> grpLevels = new ArrayList<Integer>();
            grpLevels.addAll(lvltocol.keySet());
            Iterator lvlIter = grpLevels.iterator();
            while (lvlIter.hasNext()) {
                int lvl = (Integer)lvlIter.next();
                Object[] repcols = lvltocol.get(lvl);
                brkcolKey = lvl + "_";
                String strval = "";
                int rsetIdx = -1;
                for (int j = 1; j < rsetIdxs.length && j < repcols.length; ++j) {
                    rsetIdx = rsetIdxs[j];
                    if (rsetIdx <= 0) continue;
                    Datum obj = ScriptUtils.getOracleObjectWrap((OracleResultSet)rs, rsetIdxs[j]);
                    if (obj instanceof BINARY_DOUBLE) {
                        BINARY_DOUBLE d = (BINARY_DOUBLE)obj;
                        float f = Float.parseFloat(String.valueOf(d.doubleValue()));
                        strval = this.formattedFLOAT(this.m_conn, f, this.m_numformat, this.m_colsizes[rsetIdx]);
                    } else if (obj instanceof BINARY_FLOAT) {
                        float f = ((BINARY_FLOAT)obj).floatValue();
                        strval = this.formattedFLOAT(this.m_conn, f, this.m_numformat, this.m_colsizes[rsetIdx]);
                    } else {
                        strval = obj == null || obj.isNull() ? "" : ((OracleResultSet)rs).getString(rsetIdxs[j]);
                    }
                    strval = strval == null ? "" : strval;
                    brkcolKey = (String)brkcolKey + strval;
                    if (j != repcols.length - 1 || cmptd_rows.get(brkcolKey) == null) continue;
                    if (this.m_breakandselorderMatch) {
                        String[] brkcols = this.m_brkcmpkey_to_cols.get(brkcolKey);
                        brkcols = this.addRow(brkcols, this.m_columns[rsetIdxs[j]]);
                        this.m_brkcmpkey_to_cols.put((String)brkcolKey, brkcols);
                    } else {
                        String[] columns = this.getColumns(cmptd_rows, cmptd_columns, (String)brkcolKey);
                        this.m_brkcmpkey_to_cols.put((String)brkcolKey, columns);
                    }
                    if (brkckeys.contains(brkcolKey)) continue;
                    brkckeys.add(brkcolKey);
                }
                if (!((String)brkcolKey).matches("\\d+_$") && !((String)brkcolKey).matches("(?<!\\S)\\d\\S*") || cmptd_rows.get(brkcolKey) == null || brkckeys.contains(brkcolKey)) continue;
                brkckeys.add(brkcolKey);
            }
            if (brkckeys.size() > 0) {
                brkcmpkeys = new String[brkckeys.size()];
                brkckeys.toArray(brkcmpkeys);
            }
            if (this.isAllRowCountsEqual(cmptd_rows, cmptd_columns, brkcmpkeys)) {
                HashMap<String, String> srtdFunctions = Compute.sort(this.m_brkcol_to_cmpfn);
                Set<String> brkcols = srtdFunctions.keySet();
                Iterator<String> brkcolsIter = brkcols.iterator();
                String[] srtdbrkcmpkeys = new String[brkcmpkeys.length];
                ArrayList<String> sortedBrkCmpKeys = new ArrayList<String>();
                while (brkcolsIter.hasNext()) {
                    String brkcol = brkcolsIter.next();
                    for (int i = 0; i < brkcmpkeys.length; ++i) {
                        String[] cols = this.m_brkcmpkey_to_cols.get(brkcmpkeys[i]);
                        if (cols == null) {
                            throw new SQLException(Messages.getString("NO_ORDER_BY"));
                        }
                        for (String col : cols) {
                            String bcol = this.m_column_to_brkcmptcol.get(col);
                            if (bcol == null || !bcol.equals(brkcol) || !sortedBrkCmpKeys.contains(brkcmpkeys[i])) continue;
                            sortedBrkCmpKeys.add(brkcmpkeys[i]);
                        }
                    }
                }
                if (sortedBrkCmpKeys.size() > 0) {
                    sortedBrkCmpKeys.toArray(srtdbrkcmpkeys);
                    brkcmpkeys = srtdbrkcmpkeys;
                }
            }
        }
        if (level.equalsIgnoreCase("report") && this.m_brkcmptcolumns.get(this.m_brkcmptcolumns.size() - 1).equalsIgnoreCase("report")) {
            String brkcolKey = "report";
            int len = brkcmpkeys.length;
            if (len > 0 && cmptd_rows.get("report") != null && brkcmpkeys[len - 1] == null) {
                brkcmpkeys[len - 1] = "report";
            }
        }
        return brkcmpkeys;
    }

    private int getFirstCmptdRowCount(HashMap<String, Object[][]> cmptd_rows, ArrayList<Object> cmptd_columns, String brkColCmptkeys) throws SQLException {
        int rcIdx = cmptd_columns.indexOf("ROW_CNT");
        Object[][] foundRows = cmptd_rows.get(brkColCmptkeys);
        int grpRowCount = 0;
        if (foundRows != null) {
            grpRowCount = Integer.valueOf(DataTypesUtil.stringValue(foundRows[0][rcIdx + 1], this.m_conn));
        }
        return grpRowCount;
    }

    private boolean isRowCountsEqual(HashMap<String, Object[][]> cmptd_rows, ArrayList<Object> cmptd_columns, String brkColCmptkey) {
        boolean isEqual = true;
        int rcIdx = cmptd_columns.indexOf("ROW_CNT");
        Object[][] data = cmptd_rows.get(brkColCmptkey);
        int grpRowCount = -1;
        if (data != null && data.length > 1) {
            for (int j = 0; j < data.length; ++j) {
                Object[] cmptd_row = data[j];
                if (grpRowCount == -1) {
                    grpRowCount = Integer.valueOf(DataTypesUtil.stringValue(cmptd_row[rcIdx + 1], this.m_conn));
                    continue;
                }
                if (grpRowCount == Integer.valueOf(DataTypesUtil.stringValue(cmptd_row[rcIdx + 1], this.m_conn))) continue;
                isEqual = false;
                break;
            }
        }
        return isEqual;
    }

    private boolean isAllRowCountsEqual(HashMap<String, Object[][]> cmptd_rows, ArrayList<Object> cmptd_columns, String[] brkColCmptkeys) {
        boolean isEqual = true;
        int rcIdx = cmptd_columns.indexOf("ROW_CNT");
        int rowCount = -1;
        for (int i = 0; i < brkColCmptkeys.length; ++i) {
            if (this.isRowCountsEqual(cmptd_rows, cmptd_columns, brkColCmptkeys[i])) {
                Object[][] data = cmptd_rows.get(brkColCmptkeys[i]);
                if (data == null) continue;
                if (i == 0) {
                    rowCount = Integer.valueOf(DataTypesUtil.stringValue(data[0][rcIdx + 1], this.m_conn));
                    continue;
                }
                if (rowCount == Integer.valueOf(DataTypesUtil.stringValue(data[0][rcIdx + 1], this.m_conn))) continue;
                isEqual = false;
                break;
            }
            isEqual = false;
            break;
        }
        return isEqual;
    }

    private boolean isEmptyBreakColKeys(String[] breakcolcmptkeys) {
        boolean emptyBrkKeys = true;
        for (int k = 0; k < breakcolcmptkeys.length; ++k) {
            if (breakcolcmptkeys[k] != null) {
                emptyBrkKeys = false;
                break;
            }
            emptyBrkKeys = true;
        }
        return emptyBrkKeys;
    }

    private Object[][] getEqualRowCountRows(HashMap<String, Object[][]> cmptd_rows, ArrayList<Object> cmptd_columns, String brkColCmptkey) {
        Object[][] samecntRows = null;
        int rcIdx = cmptd_columns.indexOf("ROW_CNT");
        Object[][] data = cmptd_rows.get(brkColCmptkey);
        int grpRowCount = -1;
        if (data != null) {
            for (int j = 0; j < data.length; ++j) {
                Object[] cmptd_row = data[j];
                if (j == 0 && grpRowCount == -1) {
                    grpRowCount = Integer.valueOf(DataTypesUtil.stringValue(cmptd_row[rcIdx + 1], this.m_conn));
                    samecntRows = this.addRow(samecntRows, cmptd_row);
                    continue;
                }
                if (grpRowCount != Integer.valueOf(DataTypesUtil.stringValue(cmptd_row[rcIdx + 1], this.m_conn))) continue;
                samecntRows = this.addRow(samecntRows, cmptd_row);
            }
            if (samecntRows.length > 1) {
                String col = "";
                boolean bFunctions = false;
                int colIdx = -1;
                ArrayList<Integer> cmpfnIdxs = new ArrayList<Integer>();
                for (int i = 0; i < cmptd_columns.size(); ++i) {
                    col = (String)cmptd_columns.get(i);
                    if (!col.endsWith("_CMPFN")) continue;
                    for (int j = 0; j < samecntRows.length; ++j) {
                        String func = DataTypesUtil.stringValue(samecntRows[j][i + 1], this.m_conn);
                        if (func.length() <= 0) continue;
                        colIdx = i + 1;
                        cmpfnIdxs.add(colIdx);
                    }
                }
                if (cmpfnIdxs.size() > 0) {
                    final Integer[] idxs = new Integer[cmpfnIdxs.size()];
                    cmpfnIdxs.toArray(idxs);
                    Arrays.sort(samecntRows, new Comparator<Object[]>(){

                        @Override
                        public int compare(Object[] row1, Object[] row2) {
                            int i;
                            int idx1 = 0;
                            int idx2 = 0;
                            for (i = 0; i < idxs.length; ++i) {
                                int len1 = DataTypesUtil.stringValue(row1[idxs[i]], SQLPLUSCmdFormatter.this.m_conn).length();
                                if (len1 <= 0) continue;
                                idx1 = idxs[i];
                                break;
                            }
                            for (i = 0; i < idxs.length; ++i) {
                                int len2 = DataTypesUtil.stringValue(row2[idxs[i]], SQLPLUSCmdFormatter.this.m_conn).length();
                                if (len2 <= 0) continue;
                                idx2 = idxs[i];
                                break;
                            }
                            String func1 = idx1 > 0 ? DataTypesUtil.stringValue(row1[idx1], SQLPLUSCmdFormatter.this.m_conn) : "";
                            String func2 = idx2 > 0 ? DataTypesUtil.stringValue(row2[idx2], SQLPLUSCmdFormatter.this.m_conn) : "";
                            int val1 = Compute.getIndexofFunction(func1);
                            int val2 = Compute.getIndexofFunction(func2);
                            return Integer.valueOf(val1).compareTo(val2);
                        }
                    });
                }
            }
        }
        return samecntRows;
    }

    private String[] getColumns(HashMap<String, Object[][]> cmptd_rows, ArrayList<Object> cmptd_columns, String brkColCmptkey) {
        String[] columns = null;
        String[] funcs = null;
        Object[][] rows = cmptd_rows.get(brkColCmptkey);
        for (int i = 0; i < cmptd_columns.size(); ++i) {
            String col = (String)cmptd_columns.get(i);
            if (!col.endsWith("_CMPFN")) continue;
            for (int j = 0; j < rows.length; ++j) {
                String[] func = DataTypesUtil.stringValue(rows[j][i + 1], this.m_conn);
                if (func.length() <= 0) continue;
                funcs = this.addRow(funcs, (String)func);
            }
        }
        Iterator<String> brkcolIter = this.m_brkcol_to_cmpfn.keySet().iterator();
        String[] brkcols = null;
        while (brkcolIter.hasNext()) {
            String brkcol = brkcolIter.next();
            for (String func : funcs) {
                if (this.m_brkcol_to_cmpfn.get(brkcol) == null || !this.m_brkcol_to_cmpfn.get(brkcol).equals(func)) continue;
                brkcols = this.addRow(brkcols, brkcol);
            }
        }
        for (String col : this.m_column_to_brkcol.keySet()) {
            for (void var14_20 : brkcols) {
                if (this.m_column_to_brkcol.get(col) == null || !this.m_column_to_brkcol.get(col).equals(var14_20)) continue;
                columns = this.addRow(columns, col);
            }
        }
        return columns;
    }

    private String getFunction(Object[] row, ArrayList<Object> cmptd_columns) {
        String cmpfn = "";
        for (int i = 0; i < cmptd_columns.size(); ++i) {
            String col = (String)cmptd_columns.get(i);
            if (!col.endsWith("_CMPFN")) continue;
            cmpfn = DataTypesUtil.stringValue(row[i + 1], this.m_conn);
            break;
        }
        return cmpfn;
    }

    private boolean computedData(HashMap<String, Object[][]> rows, ArrayList<Object> columns) {
        if (rows != null && columns != null) {
            String sql = "";
            this.m_brkcmptcolumns = this.getReportColumns();
            this.m_computecolumns = this.getComputeColumns(this.m_brkcmptcolumns);
            if (this.m_brkcmptcolumns.size() > 0 && this.m_computecolumns.size() > 0) {
                sql = this.generateComputeSQL(this.m_brkcmptcolumns, this.m_computecolumns);
                String err = "";
                try {
                    this.executeComputeSQL(sql, rows, columns);
                }
                catch (SQLException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, Messages.getString("ComputeFailure"), ex);
                }
                return rows.size() > 0;
            }
        }
        return false;
    }

    private void parseSQL() {
        Pair<Integer, Integer> withPair = SqlRecognizer.getWithClauseSpan(this.m_sql);
        this.m_with = withPair == null ? "" : this.m_sql.substring(withPair.first(), withPair.second() + 1);
        this.m_selColumnList.addAll(SqlRecognizer.getColumns(this.m_sql));
        this.m_selTableList.addAll(SqlRecognizer.getTables(this.m_sql));
        this.m_selPredicateList.addAll(SqlRecognizer.getPredicates(this.m_sql));
        this.m_selGroupByList.addAll(SqlRecognizer.getGroupBy(this.m_sql));
        this.m_selOrderByList.addAll(SqlRecognizer.getOrderBy(this.m_sql));
    }

    private void computeDataForRow(ArrayList<Object[]> rows, ArrayList<Object> columns, ResultSet rs) throws SQLException {
        ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get("row");
        for (TreeMap<String, HashMap<String, String>> col_cmptfunc : mapList) {
            if (rows == null || columns == null || col_cmptfunc == null) continue;
            boolean bRowFound = this.findString(this.m_brkcmptcolumns, "row");
            int[] rsetIdxs = new int[this.m_computecolumns.size() + 1];
            Object[] rowobj = new Object[this.m_computecolumns.size() + 2 + 1];
            if (!bRowFound || this.m_computecolumns.size() <= 0) continue;
            block3: for (int i = 1; i < this.m_columns.length; ++i) {
                for (int j = 0; j < this.m_computecolumns.size(); ++j) {
                    if (!this.m_computecolumns.get(j).equalsIgnoreCase(this.m_columns[i])) continue;
                    rsetIdxs[j + 1] = i;
                    columns.add(this.m_columns[i]);
                    continue block3;
                }
            }
            columns.add("ROW_CNT");
            columns.add("COMPUTE");
            for (int k = 1; k < rsetIdxs.length; ++k) {
                try {
                    rowobj[k] = ScriptUtils.getOracleObjectWrap((OracleResultSet)rs, rsetIdxs[k]);
                    continue;
                }
                catch (SQLException ex) {
                    rowobj[k] = rs.getObject(rsetIdxs[k]);
                }
            }
            rowobj[this.m_computecolumns.size() + 1] = new NUMBER(1);
            ArrayList<String> cmptKeys = new ArrayList<String>();
            cmptKeys.addAll(col_cmptfunc.keySet());
            if (cmptKeys.size() > 0) {
                rowobj[this.m_computecolumns.size() + 2] = new CHAR(col_cmptfunc.get(cmptKeys.get(0)), CHAR.DEFAULT_CHARSET);
            }
            rows.add(rowobj);
        }
    }

    private ArrayList<String> getReportColumns() {
        ArrayList<String> repCols = new ArrayList<String>();
        ArrayList<String> breakColsinSel = new ArrayList<String>();
        ArrayList<String> breakColList = new ArrayList<String>();
        boolean bfound = false;
        if (this.m_scriptRunnerContext.getStoredBreakCmds().size() > 0) {
            String alias;
            breakColList.addAll(this.m_scriptRunnerContext.getStoredBreakCmds().keySet());
            ArrayList<String> selList = new ArrayList<String>();
            selList.addAll(this.m_selColumnList);
            if (selList.size() > 0) {
                block0: for (String string : selList) {
                    for (String string2 : breakColList) {
                        String[] colandalias = string.split("\\s+");
                        alias = this.getAlias(string);
                        if (!string2.equalsIgnoreCase(string) && !string2.equalsIgnoreCase(alias)) continue;
                        breakColsinSel.add(string);
                        continue block0;
                    }
                }
                if (this.findString(breakColList, "report")) {
                    breakColsinSel.add("report");
                }
            } else {
                breakColsinSel.addAll(breakColList);
            }
            ArrayList<String> cmptRepCols = new ArrayList<String>();
            cmptRepCols.addAll(this.m_scriptRunnerContext.getStoredComputeCmds().keySet());
            if (this.m_breakandselorderMatch) {
                block2: for (String string : breakColsinSel) {
                    for (String col : cmptRepCols) {
                        alias = this.getAlias(string);
                        if (!col.equalsIgnoreCase(string) && !col.equalsIgnoreCase(alias)) continue;
                        repCols.add(string);
                        continue block2;
                    }
                }
            } else {
                repCols.addAll(breakColsinSel);
            }
            for (String string : breakColList) {
                for (String cmptRepcol : cmptRepCols) {
                    if (!string.equalsIgnoreCase(cmptRepcol) || !string.equalsIgnoreCase("report") || repCols.contains("report")) continue;
                    repCols.add(string);
                    bfound = true;
                    break;
                }
                if (!bfound) continue;
                break;
            }
            ArrayList<String> arrayList = this.filterList(repCols, "report");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.addAll(this.m_selOrderByList);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            if (arrayList2.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String[] colandalias = arrayList.get(i).split("\\s+");
                    int ordByIdx = -1;
                    for (int k = 0; k < colandalias.length && (ordByIdx = arrayList2.indexOf(colandalias[k])) <= -1; ++k) {
                    }
                    if (ordByIdx <= 0) continue;
                    for (int j = 0; j < ordByIdx; ++j) {
                        int repColIdx = arrayList.indexOf(arrayList2.get(j));
                        if (repColIdx != -1) continue;
                        String missingCol = (String)arrayList2.get(j);
                        arrayList3.add(missingCol);
                        if (j < repCols.size()) {
                            repCols.add(j, missingCol);
                            continue;
                        }
                        repCols.add(missingCol);
                    }
                }
            }
        }
        return repCols;
    }

    private ArrayList<String> getComputeColumns(ArrayList<String> reptCols) {
        ArrayList<String> cmptCols = new ArrayList<String>();
        ArrayList<String> selList = new ArrayList<String>();
        try {
            selList.addAll(this.m_selColumnList);
        }
        catch (Error error) {
            // empty catch block
        }
        for (String breakCmptCol : reptCols) {
            String[] colandalias = breakCmptCol.split("\\s+");
            String bkcoloralias = this.getAlias(breakCmptCol);
            ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(bkcoloralias);
            if (mapList == null) continue;
            for (TreeMap<String, HashMap<String, String>> col_cmptfunc : mapList) {
                ArrayList<String> cmptKeys = new ArrayList<String>();
                if (col_cmptfunc == null) continue;
                cmptKeys.addAll(col_cmptfunc.keySet());
                for (String col : cmptKeys) {
                    if (selList.size() > 0) {
                        if ((col = this.getColumnFromAlias(col)) == null || col.equals("") || !this.findString(selList, col) || this.findString(cmptCols, col)) continue;
                        cmptCols.add(col);
                        continue;
                    }
                    cmptCols.add(col);
                }
            }
        }
        final ArrayList<String> tselList = selList;
        Collections.sort(cmptCols, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return tselList.indexOf(o1) - tselList.indexOf(o2);
            }
        });
        return cmptCols;
    }

    private boolean findString(ArrayList<String> listStr, String findStr) {
        boolean found = false;
        for (String str : listStr) {
            if (str.equalsIgnoreCase(findStr)) {
                return true;
            }
            if (str.split("\\s+").length <= 1 || str.indexOf(findStr) <= -1) continue;
            return true;
        }
        return false;
    }

    private String getAlias(String column) {
        int idx;
        String alias = "";
        alias = this.m_column_to_alias.get(column);
        if (alias != null && alias.length() > 0) {
            return alias;
        }
        if (column.equalsIgnoreCase("report")) {
            alias = column;
            this.m_column_to_alias.put(column, "report");
            return alias;
        }
        if (column.equalsIgnoreCase("row")) {
            alias = column;
            this.m_column_to_alias.put(column, "row");
            return alias;
        }
        ArrayList<String> selList = new ArrayList<String>();
        selList.addAll(this.m_selColumnList);
        if (selList.size() == 0) {
            alias = column;
            this.m_column_to_alias.put(column, column);
            return alias;
        }
        for (int i = 0; i < selList.size(); ++i) {
            String str = (String)selList.get(i);
            String[] strArr = null;
            ArrayList<String> matchList = new ArrayList<String>();
            Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
            Matcher regexMatcher = regex.matcher(str);
            while (regexMatcher.find()) {
                matchList.add(regexMatcher.group());
            }
            strArr = new String[matchList.size()];
            matchList.toArray(strArr);
            if (column.equalsIgnoreCase(str)) {
                alias = strArr.length > 1 ? strArr[strArr.length - 1].replaceAll("\"", "") : strArr[0];
            } else if (strArr[strArr.length - 1].replaceAll("\"", "").equalsIgnoreCase(column)) {
                alias = column;
            } else {
                Object modcol = column.replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
                modcol = ((String)modcol).replaceAll("\\*", "\\\\*");
                modcol = "(?i:" + (String)modcol + ")";
                Pattern ptrn = Pattern.compile((String)modcol);
                Matcher m = ptrn.matcher(str);
                while (m.find()) {
                    alias = str.replaceFirst((String)modcol, "").trim().replaceFirst("(?i:as)", "").trim().replaceAll("\"", "");
                }
            }
            if (alias != null && alias.length() > 0) break;
        }
        String modcol = column.replaceAll("\"", "");
        if (alias != null && alias.length() > 0 && (idx = modcol.lastIndexOf(alias)) > 0) {
            modcol = modcol.substring(0, idx).trim();
        }
        if (alias != null && alias.length() > 0) {
            this.m_column_to_alias.put(modcol, alias);
        }
        return alias;
    }

    private String getColumnFromAlias(String alias) {
        String column = "";
        ArrayList<String> selList = new ArrayList<String>();
        selList.addAll(this.m_selColumnList);
        for (int i = 0; i < selList.size(); ++i) {
            String str = (String)selList.get(i);
            String[] strArr = null;
            ArrayList<String> matchList = new ArrayList<String>();
            Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
            Matcher regexMatcher = regex.matcher(str);
            while (regexMatcher.find()) {
                matchList.add(regexMatcher.group());
            }
            strArr = new String[matchList.size()];
            matchList.toArray(strArr);
            if (strArr.length > 1 && strArr[strArr.length - 1].replaceAll("\"", "").equalsIgnoreCase(alias)) {
                column = str.replaceAll("(?i:" + alias + ")$|\"(?i:" + alias + ")\"", "").replaceAll("\"", "");
                column = column.replaceFirst("(?i:as)", "").trim();
            } else if (strArr[0].equalsIgnoreCase(alias)) {
                column = strArr[0];
            }
            if (column.length() > 0) break;
        }
        return column;
    }

    private String getAliasFromColumn(String column) {
        String alias = "";
        ArrayList<String> selList = new ArrayList<String>();
        selList.addAll(this.m_selColumnList);
        for (int i = 0; i < selList.size(); ++i) {
            String str = (String)selList.get(i);
            String[] strArr = null;
            ArrayList<String> matchList = new ArrayList<String>();
            Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
            Matcher regexMatcher = regex.matcher(str);
            while (regexMatcher.find()) {
                matchList.add(regexMatcher.group());
            }
            strArr = new String[matchList.size()];
            matchList.toArray(strArr);
            String col = strArr[0];
            if (!col.equalsIgnoreCase(column)) continue;
            alias = strArr.length > 2 ? strArr[2] : (strArr.length > 1 ? strArr[1] : strArr[0]);
            break;
        }
        return alias;
    }

    private boolean areCompColsFuncExpr(ArrayList<String> cmptCols) {
        String cmpCol;
        boolean isFuncExpr = false;
        for (int i = 0; i < cmptCols.size() && !(isFuncExpr = this.isCompColFuncExpr(cmpCol = cmptCols.get(i))); ++i) {
        }
        return isFuncExpr;
    }

    private boolean isCompColFuncExpr(String cmptCol) {
        boolean isFuncExpr = false;
        String[] oraFunc = new String[]{"AVG", "COLLECT", "CORR", "COUNT", "COVAR_POP", "COVAR_SAMP", "CUME_DIST", "DENSE_RANK", "FIRST", "GROUP_ID", "GROUPING", "GROUPING_ID", "LAST", "LISTAGG", "MAX", "MEDIAN", "MIN", "PERCENT_RANK", "PERCENTILE_CONT", "PERCENTILE_DISC", "RANK", "STDDEV", "STDDEV_POP", "\tSTDDEV_SAMP", "SUM", "SYS_XMLAGG", "VAR_POP", "VAR_SAMP", "VARIANCE", "XMLAGG"};
        for (int j = 0; j < oraFunc.length; ++j) {
            if (!cmptCol.toUpperCase().startsWith(oraFunc[j]) && cmptCol.toUpperCase().indexOf(oraFunc[j]) <= -1) continue;
            isFuncExpr = true;
            break;
        }
        return isFuncExpr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeComputeSQL(String sql, HashMap<String, Object[][]> rows, ArrayList<Object> columns) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            stmt = this.m_conn.prepareStatement(this.m_with + sql);
            rset = stmt.executeQuery();
            ResultSetMetaData rmeta = rset.getMetaData();
            int count = rmeta.getColumnCount();
            columns.ensureCapacity(count);
            for (int i = 1; i < count; ++i) {
                columns.add(rmeta.getColumnName(i));
            }
            int rowCount = 0;
            String breakcolkey = "";
            while (rset.next() && rowCount < this.getMaxRows()) {
                ++rowCount;
                breakcolkey = "";
                Object[] obj = new Object[count];
                for (int i = 1; i <= count; ++i) {
                    if (!(rset instanceof OracleResultSet)) continue;
                    try {
                        Object rObj = ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, i);
                        if (i < count) {
                            if (rObj == null || rObj.isNull()) {
                                rObj = this.m_null != null && this.m_null.length() > 0 ? this.m_null : "";
                            }
                            obj[i] = rObj;
                        }
                        if (i != count) continue;
                        breakcolkey = DataTypesUtil.stringValue(rObj, this.m_conn);
                        breakcolkey = this.modifyScientificNotation(breakcolkey);
                        continue;
                    }
                    catch (Exception ex) {
                        obj[i] = rset.getObject(i);
                    }
                }
                ArrayList<String> fList = this.filterList(this.m_brkcmptcolumns, "report");
                int nBrkCols = fList.size();
                String brkcolskey = "";
                Object[][] existingRows = rows.get(breakcolkey);
                Object[][] newArray = null;
                if (existingRows != null) {
                    newArray = this.addRow(existingRows, obj);
                    rows.put(breakcolkey, newArray);
                    continue;
                }
                Object[][] val = new Object[][]{obj};
                rows.put(breakcolkey, val);
            }
            if (rows.size() > 0) {
                if (this.m_column_to_brkcmptcol.size() == 0) {
                    this.mapSelColstoBreakColumns();
                }
                if (this.m_column_to_cmpcol.size() == 0) {
                    this.mapSelColstoComputeColumns();
                }
                if (this.m_brkcol_to_cmplbl.size() == 0) {
                    this.populateBreakColumnsToComputeLabel();
                }
            }
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "executeComputeSQL", e);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "executeComputeSQL", e);
            }
        }
    }

    private Object[][] addRow(Object[][] existingArr, Object[] newrow) {
        int prevRowCount = existingArr != null ? existingArr.length : 0;
        Object[][] newArray = new Object[prevRowCount + 1][];
        if (existingArr != null) {
            System.arraycopy(existingArr, 0, newArray, 0, existingArr.length);
        }
        newArray[prevRowCount] = newrow;
        return newArray;
    }

    private Object[] addRow(Object[] existingArr, Object newobj) {
        int prevRowCount = existingArr != null ? existingArr.length : 0;
        Object[] newArray = new Object[prevRowCount + 1];
        if (existingArr != null) {
            System.arraycopy(existingArr, 0, newArray, 0, existingArr.length);
        }
        newArray[prevRowCount] = newobj;
        return newArray;
    }

    private String[] addRow(String[] existingArr, String newobj) {
        int prevRowCount = existingArr != null ? existingArr.length : 0;
        String[] newArray = new String[prevRowCount + 1];
        if (existingArr != null) {
            System.arraycopy(existingArr, 0, newArray, 0, existingArr.length);
        }
        newArray[prevRowCount] = newobj;
        return newArray;
    }

    private Object[][] removeRow(Object[][] existingArr, int index) {
        Object[][] newArray = null;
        if (existingArr.length > 1) {
            newArray = new Object[existingArr.length - 1][];
            if (existingArr.length != index) {
                System.arraycopy(existingArr, index + 1, newArray, index, existingArr.length - index - 1);
            }
        }
        return newArray;
    }

    private String[] removeRow(String[] existingArr, int index) {
        String[] newArray = null;
        if (existingArr.length > 1) {
            newArray = new String[existingArr.length - 1];
            System.arraycopy(existingArr, 0, newArray, 0, index);
            if (existingArr.length != index) {
                System.arraycopy(existingArr, index + 1, newArray, index, existingArr.length - index - 1);
            }
        }
        return newArray;
    }

    private Object[] removeRow(Object[] existingArr, int index) {
        Object[] newArray = null;
        if (existingArr.length > 1) {
            newArray = new Object[existingArr.length - 1];
            System.arraycopy(existingArr, 0, newArray, 0, index);
            if (existingArr.length != index) {
                System.arraycopy(existingArr, index + 1, newArray, index, existingArr.length - index - 1);
            }
        }
        return newArray;
    }

    /*
     * WARNING - void declaration
     */
    private String generateComputeSQL(ArrayList<String> reportCols, ArrayList<String> cmptCols) {
        Object sql = "";
        int numFuncs = this.numfunctionsUsedOnComputeCol(reportCols, cmptCols);
        boolean hasFuncExpr = this.areCompColsFuncExpr(cmptCols);
        ArrayList<String> fltreportCols = this.filterList(reportCols, "report");
        if (fltreportCols.size() > 0) {
            for (int i = 0; i < numFuncs; ++i) {
                if (this.m_breakandselorderMatch) {
                    sql = (String)sql + "SELECT " + m_lineSeparator;
                    for (String string : fltreportCols) {
                        void var9_17;
                        void var9_15;
                        String heading;
                        if (hasFuncExpr) {
                            String string2 = this.getAlias(string);
                        }
                        if ((heading = this.getHeading((String)var9_15, this.m_scriptRunnerContext.getStoredFormatCmds())).length() > 0) {
                            String string3 = (String)var9_15 + " " + heading;
                        }
                        sql = (String)sql + (String)var9_17 + ", ";
                    }
                    String caseExprs = this.generateSQLCaseExpressions(fltreportCols, cmptCols, "Expression", i, hasFuncExpr);
                    sql = (String)sql + caseExprs;
                    sql = (String)sql + ", ";
                    caseExprs = this.generateSQLCaseExpressions(fltreportCols, cmptCols, "Function", i, hasFuncExpr);
                    sql = (String)sql + caseExprs + ", ";
                    sql = (String)sql + "COUNT(*) AS ROW_CNT, ";
                    if (hasFuncExpr) {
                        sql = (String)sql + "GROUPING_ID(" + this.join((CharSequence)", ", this.getAliasedOrOrigCols(fltreportCols)) + ") || '_' ";
                        sql = (String)sql + "|| " + this.join((CharSequence)" || ", this.genAliasColsWithDecode(fltreportCols)) + " AS BRKCOLKEY";
                    } else {
                        sql = (String)sql + "GROUPING_ID(" + this.join((CharSequence)", ", this.getOrigColsStripAlias(fltreportCols)) + ") || '_' ";
                        sql = (String)sql + "|| " + this.join((CharSequence)" || ", this.genOrigColsWithDecode(fltreportCols)) + " AS BRKCOLKEY";
                    }
                    sql = (String)sql + " " + m_lineSeparator;
                    sql = (String)sql + "FROM ";
                    if (hasFuncExpr) {
                        sql = (String)sql + m_lineSeparator + "(" + m_lineSeparator + this.m_sql + m_lineSeparator + ") " + m_lineSeparator;
                    } else {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.addAll(this.m_selTableList);
                        sql = (String)sql + this.join((CharSequence)", ", arrayList) + m_lineSeparator;
                        ArrayList<String> whereClause = this.m_selPredicateList;
                        if (whereClause != null && whereClause.size() > 0) {
                            sql = (String)sql + "WHERE ";
                            ArrayList whereList = new ArrayList();
                            whereList.addAll(whereClause);
                            if (whereList.size() == 1) {
                                sql = (String)sql + (String)whereList.get(0) + m_lineSeparator;
                            }
                        }
                    }
                    sql = (String)sql + this.generateSQLGroupby(fltreportCols, hasFuncExpr);
                } else {
                    for (int k = 0; k < fltreportCols.size(); ++k) {
                        String string = fltreportCols.get(k);
                        String rCol = this.getAlias(string);
                        if (this.m_scriptRunnerContext.getStoredComputeCmds().get(rCol) == null) continue;
                        sql = (String)sql + "SELECT " + m_lineSeparator;
                        for (String string4 : fltreportCols) {
                            void var12_28;
                            String heading = this.getHeading(string4, this.m_scriptRunnerContext.getStoredFormatCmds());
                            if (heading.length() > 0) {
                                String string5 = string4 + " " + heading;
                            }
                            sql = (String)sql + (String)var12_28 + ", ";
                        }
                        String caseExprs = this.generateSQLCaseExpressions(string, fltreportCols, cmptCols, "Expression", i);
                        sql = (String)sql + caseExprs;
                        sql = (String)sql + ", ";
                        caseExprs = this.generateSQLCaseExpressions(string, fltreportCols, cmptCols, "Function", i);
                        sql = (String)sql + caseExprs + ", ";
                        sql = (String)sql + "COUNT(*) AS ROW_CNT, ";
                        sql = (String)sql + "GROUPING_ID(" + this.join((CharSequence)", ", this.getOrigColsStripAlias(fltreportCols)) + ")|| '_' ";
                        sql = (String)sql + "|| " + this.join((CharSequence)" || ", this.genOrigColsWithDecode(fltreportCols)) + " AS BRKCOLKEY";
                        sql = (String)sql + " " + m_lineSeparator;
                        sql = (String)sql + "FROM ";
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.addAll(this.m_selTableList);
                        sql = (String)sql + this.join((CharSequence)", ", arrayList) + m_lineSeparator;
                        ArrayList<String> whereClause = this.m_selPredicateList;
                        if (whereClause != null && whereClause.size() > 0) {
                            sql = (String)sql + "WHERE ";
                            ArrayList<String> whereList = new ArrayList<String>();
                            whereList.addAll(whereClause);
                            if (whereList.size() == 1) {
                                sql = (String)sql + (String)whereList.get(0) + m_lineSeparator;
                            }
                        }
                        sql = (String)sql + this.generateSQLGroupby1(fltreportCols) + m_lineSeparator;
                        if (k >= fltreportCols.size() - 1 || fltreportCols.get(k + 1) == null || this.m_scriptRunnerContext.getStoredComputeCmds().get(fltreportCols.get(k + 1)) == null) continue;
                        sql = (String)sql + "UNION" + m_lineSeparator;
                    }
                }
                if (i >= numFuncs - 1) continue;
                sql = (String)sql + m_lineSeparator + "UNION" + m_lineSeparator;
            }
        }
        Object reptSQL = "";
        if (this.findString(reportCols, "report")) {
            void var9_21;
            numFuncs = this.numfunctionsUsedOnReportCol(reportCols, cmptCols);
            ArrayList<String> funcs = this.getFunctionsUsedForReport(reportCols, cmptCols);
            boolean bl = false;
            while (var9_21 < funcs.size()) {
                ArrayList<String> arrayList;
                reptSQL = (String)reptSQL + "SELECT " + m_lineSeparator;
                for (String reportCol : fltreportCols) {
                    reptSQL = (String)reptSQL + "NULL " + this.getAlias(reportCol) + ", ";
                }
                reptSQL = (String)reptSQL + this.generateComputeForColumn(reportCols, cmptCols, funcs.get((int)var9_21));
                reptSQL = (String)reptSQL + ", ";
                reptSQL = (String)reptSQL + this.generateSQLForReportExpr(reportCols, cmptCols, funcs.get((int)var9_21));
                reptSQL = (String)reptSQL + ", ";
                reptSQL = (String)reptSQL + "COUNT(*) AS ROW_CNT, ";
                reptSQL = (String)reptSQL + "'report' AS BRKCOLKEY ";
                reptSQL = (String)reptSQL + " FROM ";
                ArrayList<String> tableList = new ArrayList<String>();
                tableList.addAll(this.m_selTableList);
                reptSQL = (String)reptSQL + this.join((CharSequence)", ", tableList) + m_lineSeparator;
                ArrayList<String> whereClause = this.m_selPredicateList;
                if (whereClause != null && whereClause.size() > 0) {
                    reptSQL = (String)reptSQL + "WHERE ";
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.addAll(whereClause);
                    if (arrayList2.size() == 1) {
                        reptSQL = (String)reptSQL + (String)arrayList2.get(0) + " " + m_lineSeparator;
                    }
                }
                if ((arrayList = this.m_selGroupByList) != null && arrayList.size() > 0) {
                    reptSQL = (String)reptSQL + "GROUP BY ";
                    Iterator iter = arrayList.iterator();
                    Object grpbyStr = "";
                    while (iter.hasNext()) {
                        if (((String)grpbyStr).length() == 0) {
                            grpbyStr = (String)iter.next();
                            continue;
                        }
                        grpbyStr = (String)grpbyStr + ", " + (String)iter.next();
                    }
                    reptSQL = (String)reptSQL + (String)grpbyStr + " " + m_lineSeparator;
                }
                if (var9_21 < funcs.size() - 1) {
                    reptSQL = (String)reptSQL + "UNION" + m_lineSeparator;
                }
                ++var9_21;
            }
        }
        sql = (String)sql + (String)(((String)reptSQL).length() > 0 && ((String)sql).length() > 0 ? m_lineSeparator + "UNION" + m_lineSeparator + (String)reptSQL : (((String)reptSQL).length() > 0 ? reptSQL : ""));
        return sql;
    }

    private String generateSQLGroupby(ArrayList<String> reportCols, boolean hasFuncExpr) {
        Object groupBy = "";
        Object grpCols = "";
        if (reportCols.size() > 0) {
            groupBy = "GROUP BY GROUPING SETS(";
            StrJoin allgrpSet = null;
            for (int i = 0; i < reportCols.size(); ++i) {
                String repCol = this.getAlias(reportCols.get(i));
                ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(repCol);
                if (mapList == null) continue;
                StrJoin grpSet = new StrJoin(", ", "(", ")");
                if (i == 0) {
                    if (hasFuncExpr) {
                        grpSet.add(this.getAliasedOrOrigCols(reportCols).get(i));
                    } else {
                        grpSet.add(this.getOrigColsStripAlias(reportCols).get(i));
                    }
                } else {
                    for (int j = 0; j <= i; ++j) {
                        if (hasFuncExpr) {
                            grpSet.add(this.getAliasedOrOrigCols(reportCols).get(j));
                            continue;
                        }
                        grpSet.add(this.getOrigColsStripAlias(reportCols).get(j));
                    }
                }
                if (hasFuncExpr) {
                    allgrpSet = grpSet;
                    continue;
                }
                grpCols = i + 1 < reportCols.size() ? (String)grpCols + grpSet.toString() + ", " : (String)grpCols + grpSet.toString();
            }
            if (allgrpSet != null && this.m_computecolumns.size() > 0) {
                grpCols = (String)grpCols + allgrpSet.toString();
            }
            groupBy = (String)groupBy + (String)grpCols + ")";
        }
        return groupBy;
    }

    private String generateSQLGroupby1(ArrayList<String> reportCols) {
        Object groupBy = "";
        String grpCols = "";
        if (reportCols.size() > 0) {
            groupBy = "GROUP BY GROUPING SETS(";
            StrJoin grpSet = new StrJoin(", ", "(", ")");
            for (int i = 0; i < reportCols.size(); ++i) {
                grpSet.add(this.getOrigColsStripAlias(reportCols).get(i));
            }
            groupBy = (String)groupBy + grpSet + ")";
        }
        return groupBy;
    }

    private int numfunctionsUsedOnComputeCol(ArrayList<String> reportCols, ArrayList<String> cmptCols) {
        int numofFuncs = 0;
        ArrayList<String> repColsAlias = this.getAliasedOrOrigCols(reportCols);
        for (int i = 0; i < repColsAlias.size(); ++i) {
            String repCol = repColsAlias.get(i);
            ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(repCol);
            if (mapList == null) continue;
            Iterator<TreeMap<String, HashMap<String, String>>> iter = mapList.iterator();
            while (iter.hasNext()) {
                int keys;
                String cmptCol;
                HashMap<String, String> func = null;
                TreeMap<String, HashMap<String, String>> col_cmptfunc = iter.next();
                Iterator<String> ccIter = cmptCols.iterator();
                while (ccIter.hasNext() && (func = col_cmptfunc.get(cmptCol = ccIter.next()) != null ? col_cmptfunc.get(cmptCol) : col_cmptfunc.get(this.getAlias(cmptCol))) == null) {
                }
                if (func == null || (keys = func.size()) <= numofFuncs) continue;
                numofFuncs = keys;
            }
        }
        return numofFuncs;
    }

    private int numfunctionsUsedOnReportCol(ArrayList<String> reportCols, ArrayList<String> cmptCols) {
        int numofFuncs = 0;
        ArrayList<String> repColsAlias = this.getAliasedOrOrigCols(reportCols);
        for (int i = 0; i < repColsAlias.size(); ++i) {
            ArrayList<TreeMap<String, HashMap<String, String>>> mapList;
            String repCol = repColsAlias.get(i);
            if (!repCol.equals("report") || (mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(repCol)) == null) continue;
            Iterator<TreeMap<String, HashMap<String, String>>> iter = mapList.iterator();
            while (iter.hasNext()) {
                int keys;
                String cmptCol;
                HashMap<String, String> func = null;
                TreeMap<String, HashMap<String, String>> col_cmptfunc = iter.next();
                Iterator<String> ccIter = cmptCols.iterator();
                while (ccIter.hasNext() && (func = col_cmptfunc.get(cmptCol = ccIter.next()) != null ? col_cmptfunc.get(cmptCol) : col_cmptfunc.get(this.getAlias(cmptCol))) == null) {
                }
                if (func == null || (keys = func.size()) <= numofFuncs) continue;
                numofFuncs = keys;
            }
        }
        return numofFuncs;
    }

    private ArrayList<String> getFunctionsUsedForReport(ArrayList<String> reportCols, ArrayList<String> cmptCols) {
        ArrayList<String> funcs = new ArrayList<String>();
        ArrayList<String> repColsAlias = this.getAliasedOrOrigCols(reportCols);
        for (int i = 0; i < repColsAlias.size(); ++i) {
            ArrayList<TreeMap<String, HashMap<String, String>>> mapList;
            String repCol = repColsAlias.get(i);
            if (!repCol.equals("report") || (mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(repCol)) == null) continue;
            for (String cmptCol : cmptCols) {
                TreeMap<String, HashMap<String, String>> col_cmptfunc;
                Iterator<TreeMap<String, HashMap<String, String>>> iter = mapList.iterator();
                HashMap<String, String> func = null;
                while (iter.hasNext() && (func = (col_cmptfunc = iter.next()).get(cmptCol) != null ? col_cmptfunc.get(cmptCol) : col_cmptfunc.get(this.getAlias(cmptCol))) == null) {
                }
                if (func == null) continue;
                for (String funct : func.keySet()) {
                    if (funcs.contains(funct)) continue;
                    funcs.add(funct);
                }
            }
        }
        return funcs;
    }

    private String generateSQLCaseExpressions(ArrayList<String> reportCols, ArrayList<String> cmptCols, String type, int funcKeyIdx, boolean hasFuncExpr) {
        Object totcaseStmt = "";
        for (int k = 0; k < cmptCols.size(); ++k) {
            ArrayList<Object> caseExprs = new ArrayList<Object>();
            if (reportCols.size() > 0 && !this.findString(reportCols, "report")) {
                Object grouping_id = "";
                grouping_id = hasFuncExpr ? "WHEN GROUPING_ID(" + this.join((CharSequence)", ", this.getAliasedOrOrigCols(reportCols)) + ")" : "WHEN GROUPING_ID(" + this.join((CharSequence)", ", this.getOrigColsStripAlias(reportCols)) + ")";
                Object condition = "";
                Object caseStmt = "";
                for (int i = 0; i < reportCols.size(); ++i) {
                    String string = this.getAlias(reportCols.get(i));
                    ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(string);
                    if (mapList == null) continue;
                    for (TreeMap<String, HashMap<String, String>> col_cmptfunc : mapList) {
                        HashMap<String, String> func = col_cmptfunc.get(cmptCols.get(k)) != null ? col_cmptfunc.get(cmptCols.get(k)) : col_cmptfunc.get(this.getAlias(cmptCols.get(k)));
                        if (func == null) continue;
                        ArrayList<String> funcKeys = new ArrayList<String>();
                        funcKeys.addAll(func.keySet());
                        String funcKey = "";
                        for (int j = funcKeyIdx; j >= 0; --j) {
                            if (j >= funcKeys.size() || funcKeys.get(j) == null) continue;
                            funcKey = (String)funcKeys.get(j);
                            break;
                        }
                        condition = (String)grouping_id + " = BIN_TO_NUM(";
                        condition = (String)condition + this.genBitVectorforBreakCols(i, reportCols) + ")";
                        condition = (String)condition + " THEN ";
                        if (type.equalsIgnoreCase("Expression")) {
                            String colOrAlias = cmptCols.get(k);
                            if (this.isCompColFuncExpr(colOrAlias)) {
                                colOrAlias = this.getAliasFromColumn(colOrAlias);
                            }
                            condition = funcKey.equalsIgnoreCase("number") ? (String)condition + "count(nvl(" + colOrAlias + ", 0))" + m_lineSeparator : (String)condition + funcKey + "(" + colOrAlias + ")" + m_lineSeparator;
                        } else if (type.equalsIgnoreCase("Function")) {
                            condition = (String)condition + func.get(funcKey) + m_lineSeparator;
                        }
                        caseExprs.add(condition);
                    }
                }
                if (caseExprs.size() > 0) {
                    caseStmt = "CASE " + m_lineSeparator;
                    for (String string : caseExprs) {
                        caseStmt = (String)caseStmt + "\t" + string;
                    }
                    caseStmt = (String)caseStmt + "END AS ";
                    caseStmt = type.equalsIgnoreCase("Expression") ? (String)caseStmt + this.optionalQuote(this.getAlias(cmptCols.get(k))) : (String)caseStmt + this.optionalQuote(this.getAlias(cmptCols.get(k)) + "_CMPFN");
                    totcaseStmt = (String)totcaseStmt + (String)caseStmt;
                }
            }
            if (k >= cmptCols.size() - 1 || caseExprs.size() <= 0) continue;
            totcaseStmt = (String)totcaseStmt + ", " + m_lineSeparator;
        }
        int lidx = ((String)totcaseStmt).lastIndexOf(", " + m_lineSeparator);
        if (((String)totcaseStmt).endsWith(", " + m_lineSeparator) && lidx > 0) {
            totcaseStmt = ((String)totcaseStmt).substring(0, lidx);
        }
        return totcaseStmt;
    }

    private String generateSQLCaseExpressions(String reportCol, ArrayList<String> reportCols, ArrayList<String> cmptCols, String type, int funcKeyIdx) {
        Object totcaseStmt = "";
        for (int k = 0; k < cmptCols.size(); ++k) {
            ArrayList<Object> caseExprs = new ArrayList<Object>();
            if (reportCols.size() > 0 && !this.findString(reportCols, "report")) {
                String grouping_id = "WHEN GROUPING_ID(" + this.join((CharSequence)", ", this.getOrigColsStripAlias(reportCols)) + ")";
                Object condition = "";
                Object caseStmt = "";
                for (int i = 0; i < reportCols.size(); ++i) {
                    if (!reportCol.equalsIgnoreCase(reportCols.get(i))) continue;
                    String[] stringArray = reportCols.get(i).split("\\s+");
                    String repCol = stringArray.length > 1 ? stringArray[1].replaceAll("\"", "") : reportCols.get(i);
                    ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(repCol);
                    if (mapList == null) continue;
                    for (TreeMap<String, HashMap<String, String>> col_cmptfunc : mapList) {
                        HashMap<String, String> func = col_cmptfunc.get(cmptCols.get(k)) != null ? col_cmptfunc.get(cmptCols.get(k)) : col_cmptfunc.get(this.getAlias(cmptCols.get(k)));
                        if (func == null) continue;
                        ArrayList<String> funcKeys = new ArrayList<String>();
                        funcKeys.addAll(func.keySet());
                        String funcKey = "";
                        for (int j = funcKeyIdx; j >= 0; --j) {
                            if (j >= funcKeys.size() || funcKeys.get(j) == null) continue;
                            funcKey = (String)funcKeys.get(j);
                            break;
                        }
                        condition = grouping_id + " = BIN_TO_NUM(";
                        condition = (String)condition + this.genBitVectorStr(reportCols.size()) + ")";
                        condition = (String)condition + " THEN ";
                        if (type.equalsIgnoreCase("Expression")) {
                            condition = funcKey.equalsIgnoreCase("number") ? (String)condition + "count(nvl(" + cmptCols.get(k) + ", 0))" + m_lineSeparator : (String)condition + funcKey + "(" + cmptCols.get(k) + ")" + m_lineSeparator;
                        } else if (type.equalsIgnoreCase("Function")) {
                            condition = (String)condition + func.get(funcKey) + m_lineSeparator;
                        }
                        caseExprs.add(condition);
                    }
                }
                if (caseExprs.size() > 0) {
                    caseStmt = "CASE " + m_lineSeparator;
                    for (String string : caseExprs) {
                        caseStmt = (String)caseStmt + "\t" + string;
                    }
                    caseStmt = (String)caseStmt + "END AS ";
                } else {
                    caseStmt = (String)caseStmt + "NULL AS ";
                }
                caseStmt = type.equalsIgnoreCase("Expression") ? (String)caseStmt + this.optionalQuote(this.getAlias(cmptCols.get(k))) : (String)caseStmt + this.optionalQuote(this.getAlias(cmptCols.get(k)) + "_CMPFN");
                totcaseStmt = (String)totcaseStmt + (String)caseStmt;
            }
            if (k >= cmptCols.size() - 1) continue;
            totcaseStmt = (String)totcaseStmt + ", " + m_lineSeparator;
        }
        return totcaseStmt;
    }

    private String optionalQuote(String selItem) {
        Object qstr = selItem;
        Pattern p = Pattern.compile("\\s|\\p{Punct}");
        Matcher matcher = p.matcher(selItem);
        boolean found = matcher.find();
        if (found) {
            qstr = "\"" + (String)qstr + "\"";
        }
        return qstr;
    }

    private ArrayList<String> getOrigColsStripAlias(ArrayList<String> reportCols) {
        ArrayList<String> colsNoAlias = new ArrayList<String>();
        for (String colNoAlias : reportCols) {
            String[] vals = colNoAlias.split("\\s+");
            String col = vals.length > 1 ? vals[0] : colNoAlias;
            colsNoAlias.add(col);
        }
        return colsNoAlias;
    }

    private ArrayList<String> genOrigColsWithDecode(ArrayList<String> reportCols) {
        ArrayList<String> decodeCols = new ArrayList<String>();
        ArrayList<String> colNoAlias = this.getOrigColsStripAlias(reportCols);
        for (String col : colNoAlias) {
            String genDecode = "DECODE(GROUPING(" + col + "), 1, " + col + ", NULL, '<NULL>', " + col + ")";
            decodeCols.add(genDecode);
        }
        return decodeCols;
    }

    private ArrayList<String> genAliasColsWithDecode(ArrayList<String> reportCols) {
        ArrayList<String> decodeCols = new ArrayList<String>();
        ArrayList<String> colNoAlias = this.getAliasedOrOrigCols(reportCols);
        for (String col : colNoAlias) {
            String genDecode = "DECODE(GROUPING(" + col + "), 1, " + col + ", NULL, '<NULL>', " + col + ")";
            decodeCols.add(genDecode);
        }
        return decodeCols;
    }

    private ArrayList<String> getAliasedOrOrigCols(ArrayList<String> reportCols) {
        ArrayList<String> colsUseAlias = new ArrayList<String>();
        for (String colUseAlias : reportCols) {
            String[] vals = colUseAlias.split("\\s+");
            String col = vals.length > 1 ? vals[vals.length - 1].replaceAll("\"", "") : vals[0];
            colsUseAlias.add(col);
        }
        return colsUseAlias;
    }

    private ArrayList<String> filterList(ArrayList<String> reportCols, String filter) {
        ArrayList<String> colsFiltered = new ArrayList<String>();
        for (String col : reportCols) {
            if (col.equalsIgnoreCase(filter)) continue;
            colsFiltered.add(col);
        }
        return colsFiltered;
    }

    private boolean breakColandSelColOrderMatch() {
        boolean orderMatch = false;
        ArrayList repCols = new ArrayList();
        ArrayList<String> breakColsinSel = new ArrayList<String>();
        ArrayList<String> nonBreakColsinSel = new ArrayList<String>();
        ArrayList<String> breakColList = new ArrayList<String>();
        ArrayList<String> breakAllColList = new ArrayList<String>();
        if (this.m_scriptRunnerContext.getStoredBreakCmds().size() > 0) {
            breakAllColList.addAll(this.m_scriptRunnerContext.getStoredBreakCmds().keySet());
            ArrayList<String> tempList = this.filterList(breakAllColList, "report");
            breakColList.addAll(this.filterList(tempList, "row"));
            ArrayList<String> selList = new ArrayList<String>();
            selList.addAll(this.m_selColumnList);
            if (selList.size() == 0) {
                orderMatch = true;
                return orderMatch;
            }
            for (int i = 0; i < selList.size(); ++i) {
                String selCol = (String)selList.get(i);
                boolean bFound = false;
                for (int j = 0; j < breakColList.size(); ++j) {
                    String alias;
                    String col = (String)breakColList.get(j);
                    String[] colandalias = selCol.split("\\s+");
                    String string = colandalias.length > 2 ? colandalias[2].replaceAll("\"", "") : (alias = colandalias.length > 1 ? colandalias[1].replaceAll("\"", "") : selCol);
                    if (col.equalsIgnoreCase(selCol) || col.equalsIgnoreCase(alias)) {
                        bFound = true;
                        break;
                    }
                    bFound = false;
                }
                if (bFound) continue;
                nonBreakColsinSel.add(selCol);
            }
            if (selList.size() == breakColList.size() && nonBreakColsinSel.size() == 0) {
                orderMatch = true;
            }
            for (String selCol : nonBreakColsinSel) {
                if (breakColsinSel.size() == 0) {
                    breakColsinSel = this.filterList(selList, selCol);
                    continue;
                }
                breakColsinSel = this.filterList(breakColsinSel, selCol);
            }
        }
        if (breakColList.size() == breakColsinSel.size()) {
            for (int i = 0; i < breakColList.size() && (orderMatch = this.getAlias((String)breakColList.get(i)).equalsIgnoreCase(this.getAlias((String)breakColsinSel.get(i)))); ++i) {
            }
        }
        return orderMatch;
    }

    private String generateSQLForReportExpr(ArrayList<String> reportCols, ArrayList<String> cmptCols, int funcKeyIdx) {
        Object colExpr = "";
        if (reportCols.size() > 0 && this.findString(reportCols, "report")) {
            for (int k = 0; k < cmptCols.size(); ++k) {
                for (int i = 0; i < reportCols.size(); ++i) {
                    if (!reportCols.get(i).equalsIgnoreCase("report")) continue;
                    ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(reportCols.get(i));
                    Iterator<TreeMap<String, HashMap<String, String>>> iter = mapList.iterator();
                    Object expr = "";
                    while (iter.hasNext()) {
                        expr = "";
                        TreeMap<String, HashMap<String, String>> col_cmptfunc = iter.next();
                        HashMap<String, String> func = col_cmptfunc.get(cmptCols.get(k)) != null ? col_cmptfunc.get(cmptCols.get(k)) : col_cmptfunc.get(this.getAlias(cmptCols.get(k)));
                        ArrayList<String> funcKeys = new ArrayList<String>();
                        boolean bfound = false;
                        if (func == null) continue;
                        funcKeys.addAll(func.keySet());
                        String funcKey = "";
                        if (funcKeys.size() > funcKeyIdx) {
                            for (int j = funcKeyIdx; j >= 0; --j) {
                                funcKey = (String)funcKeys.get(j);
                                if (funcKey == null) continue;
                                bfound = true;
                                break;
                            }
                        }
                        if (funcKey.length() > 0) {
                            expr = (String)expr + func.get(funcKey) + " ";
                        }
                        if (!bfound) continue;
                        break;
                    }
                    colExpr = ((String)expr).length() > 0 ? (String)colExpr + (String)expr : (String)colExpr + "NULL ";
                }
                colExpr = (String)colExpr + this.getAlias(cmptCols.get(k)) + "_CMPFN";
                if (k >= cmptCols.size() - 1) continue;
                colExpr = (String)colExpr + ", " + m_lineSeparator;
            }
        }
        return colExpr;
    }

    private String generateSQLForReportExpr(ArrayList<String> reportCols, ArrayList<String> cmptCols, String funct) {
        Object colExpr = "";
        if (reportCols.size() > 0 && this.findString(reportCols, "report")) {
            for (int k = 0; k < cmptCols.size(); ++k) {
                for (int i = 0; i < reportCols.size(); ++i) {
                    if (!reportCols.get(i).equalsIgnoreCase("report")) continue;
                    ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(reportCols.get(i));
                    Iterator<TreeMap<String, HashMap<String, String>>> iter = mapList.iterator();
                    Object expr = "";
                    while (iter.hasNext()) {
                        expr = "";
                        TreeMap<String, HashMap<String, String>> col_cmptfunc = iter.next();
                        HashMap<String, String> func = col_cmptfunc.get(cmptCols.get(k)) != null ? col_cmptfunc.get(cmptCols.get(k)) : col_cmptfunc.get(this.getAlias(cmptCols.get(k)));
                        ArrayList<String> funcKeys = new ArrayList<String>();
                        boolean bfound = false;
                        if (func == null) continue;
                        funcKeys.addAll(func.keySet());
                        String funcKey = "";
                        if (func.get(funct) == null) continue;
                        expr = (String)expr + func.get(funct) + " ";
                        break;
                    }
                    colExpr = ((String)expr).length() > 0 ? (String)colExpr + (String)expr : (String)colExpr + "NULL ";
                }
                colExpr = (String)colExpr + this.getAlias(cmptCols.get(k)) + "_CMPFN";
                if (k >= cmptCols.size() - 1) continue;
                colExpr = (String)colExpr + ", " + m_lineSeparator;
            }
        }
        return colExpr;
    }

    private String generateComputeForColumn(ArrayList<String> reportCols, ArrayList<String> cmptCols, int funcKeyIdx) {
        Object cmptFnExpr = "";
        if (reportCols.size() > 0 && this.findString(reportCols, "report")) {
            for (int k = 0; k < cmptCols.size(); ++k) {
                for (int i = 0; i < reportCols.size(); ++i) {
                    if (!reportCols.get(i).equalsIgnoreCase("report")) continue;
                    ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(reportCols.get(i));
                    Iterator<TreeMap<String, HashMap<String, String>>> iter = mapList.iterator();
                    boolean bFound = false;
                    Object expr = "";
                    while (iter.hasNext()) {
                        expr = "";
                        TreeMap<String, HashMap<String, String>> col_cmptfunc = iter.next();
                        HashMap<String, String> func = col_cmptfunc.get(cmptCols.get(k)) != null ? col_cmptfunc.get(cmptCols.get(k)) : col_cmptfunc.get(this.getAlias(cmptCols.get(k)));
                        ArrayList<String> funcKeys = new ArrayList<String>();
                        if (func == null) continue;
                        funcKeys.addAll(func.keySet());
                        String funcKey = "";
                        if (funcKeys.size() > funcKeyIdx) {
                            for (int j = funcKeyIdx; j >= 0; --j) {
                                funcKey = (String)funcKeys.get(j);
                                if (funcKey == null) continue;
                                bFound = true;
                                break;
                            }
                        }
                        if (funcKey.length() > 0) {
                            expr = funcKey.equalsIgnoreCase("number") ? "count(nvl(" + cmptCols.get(k) + ", 0)) AS " + this.getAlias(cmptCols.get(k)) : funcKey + "(" + cmptCols.get(k) + ") AS " + this.getAlias(cmptCols.get(k));
                        }
                        if (!bFound) continue;
                        break;
                    }
                    cmptFnExpr = ((String)expr).length() > 0 ? (String)cmptFnExpr + (String)expr : (String)cmptFnExpr + "NULL AS " + this.getAlias(cmptCols.get(k));
                }
                if (k >= cmptCols.size() - 1) continue;
                cmptFnExpr = (String)cmptFnExpr + ", " + m_lineSeparator;
            }
        }
        return cmptFnExpr;
    }

    private String generateComputeForColumn(ArrayList<String> reportCols, ArrayList<String> cmptCols, String funct) {
        Object cmptFnExpr = "";
        if (reportCols.size() > 0 && this.findString(reportCols, "report")) {
            for (int k = 0; k < cmptCols.size(); ++k) {
                for (int i = 0; i < reportCols.size(); ++i) {
                    if (!reportCols.get(i).equalsIgnoreCase("report")) continue;
                    ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(reportCols.get(i));
                    Iterator<TreeMap<String, HashMap<String, String>>> iter = mapList.iterator();
                    boolean bFound = false;
                    Object expr = "";
                    while (iter.hasNext()) {
                        expr = "";
                        TreeMap<String, HashMap<String, String>> col_cmptfunc = iter.next();
                        HashMap<String, String> func = col_cmptfunc.get(cmptCols.get(k)) != null ? col_cmptfunc.get(cmptCols.get(k)) : col_cmptfunc.get(this.getAlias(cmptCols.get(k)));
                        ArrayList<String> funcKeys = new ArrayList<String>();
                        if (func == null) continue;
                        funcKeys.addAll(func.keySet());
                        String funcKey = "";
                        if (func.get(funct) == null) continue;
                        funcKey = funct;
                        if (funcKey.equalsIgnoreCase("number")) {
                            expr = "count(nvl(" + cmptCols.get(k) + ", 0)) AS " + this.getAlias(cmptCols.get(k));
                            break;
                        }
                        expr = funcKey + "(" + cmptCols.get(k) + ") AS " + this.getAlias(cmptCols.get(k));
                        break;
                    }
                    cmptFnExpr = ((String)expr).length() > 0 ? (String)cmptFnExpr + (String)expr : (String)cmptFnExpr + "NULL AS " + this.getAlias(cmptCols.get(k));
                }
                if (k >= cmptCols.size() - 1) continue;
                cmptFnExpr = (String)cmptFnExpr + ", " + m_lineSeparator;
            }
        }
        return cmptFnExpr;
    }

    private String genBitVectorforBreakCols(int index, ArrayList<String> reportCols) {
        String ret = "";
        if (this.m_breakandselorderMatch) {
            ret = this.genBitVectorStr(index, reportCols.size());
        } else {
            int selIdx;
            String repCol = reportCols.get(index);
            int rank = this.m_brkcol_to_rank.get(repCol);
            if (rank > 0 && (selIdx = this.getSelColIdFromBreakColId(rank)) >= 1) {
                ret = this.genBitVectorStr(selIdx - 1, reportCols.size());
            }
        }
        return ret;
    }

    private String genBitVectorStr(int index, int length) {
        String ret = "";
        Object[] val = new String[length];
        Arrays.fill(val, "1");
        for (int i = 0; i < length; ++i) {
            if (i > index) continue;
            val[i] = "0";
        }
        ret = this.join((CharSequence)", ", (CharSequence[])val);
        return ret;
    }

    private String genBitVectorStr(int length) {
        String ret = "";
        Object[] val = new String[length];
        Arrays.fill(val, "0");
        ret = this.join((CharSequence)", ", (CharSequence[])val);
        return ret;
    }

    private int[] groupingLevels(ArrayList<String> reportCols) {
        int i;
        int[] grpLevels = null;
        int length = reportCols.size();
        Object[] val = new String[length];
        Arrays.fill(val, "1");
        boolean k = false;
        String binStr = "";
        ArrayList<Integer> decimals = new ArrayList<Integer>();
        for (i = 0; i < length; ++i) {
            if (i == 0) {
                val[i] = "0";
            } else {
                for (int j = 0; j <= i; ++j) {
                    val[j] = "0";
                }
            }
            binStr = this.join((CharSequence)"", (CharSequence[])val);
            int decimal = Integer.parseInt(binStr, 2);
            decimals.add(decimal);
        }
        grpLevels = new int[decimals.size()];
        for (i = 0; i < decimals.size(); ++i) {
            Integer iVal = (Integer)decimals.get(i);
            grpLevels[i] = iVal;
        }
        Arrays.sort(grpLevels);
        return grpLevels;
    }

    private HashMap<Integer, Object[]> groupLevels(ArrayList<String> reportCols) {
        HashMap<Integer, Object[]> lvltocol = new HashMap<Integer, Object[]>();
        int length = reportCols.size();
        Object[] val = new String[length];
        Object[] repCols = null;
        repCols = this.addRow(repCols, null);
        Arrays.fill(val, "1");
        boolean k = false;
        String binStr = "";
        String repCol = "";
        int lvl = -1;
        for (int i = 0; i < length; ++i) {
            val[i] = "0";
            repCol = reportCols.get(i);
            repCols = this.addRow(repCols, (Object)repCol);
            binStr = this.join((CharSequence)"", (CharSequence[])val);
            lvl = Integer.parseInt(binStr, 2);
            lvltocol.put(lvl, repCols);
        }
        ArrayList lvlkeys = new ArrayList(lvltocol.keySet());
        Collections.sort(lvlkeys);
        HashMap<Integer, Object[]> sortedlvltocol = new HashMap<Integer, Object[]>();
        for (int i = 0; i < lvlkeys.size(); ++i) {
            int lvlkey = (Integer)lvlkeys.get(i);
            sortedlvltocol.put(lvlkey, lvltocol.get(lvlkey));
        }
        if (sortedlvltocol.size() > 0) {
            lvltocol = sortedlvltocol;
        }
        return lvltocol;
    }

    private String findColumnfromComputelabel(ArrayList<String> reportCols, String label) {
        String column = "";
        boolean found = false;
        ArrayList<String> repColsWithAlias = this.getAliasedOrOrigCols(reportCols);
        for (int i = 0; i < repColsWithAlias.size(); ++i) {
            column = repColsWithAlias.get(i);
            ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(column);
            for (TreeMap<String, HashMap<String, String>> col_cmptfunc : mapList) {
                for (String key : col_cmptfunc.keySet()) {
                    HashMap<String, String> cmpt_func = col_cmptfunc.get(key);
                    for (String func : cmpt_func.keySet()) {
                        String lbl = cmpt_func.get(func);
                        found = label.equalsIgnoreCase(lbl = lbl.replaceAll("'", ""));
                        if (!found) continue;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) break;
        }
        return column;
    }

    private void populateBreakCmdInfo() {
        LinkedHashMap<String, ArrayList<String>> storedBrkCmds = this.m_scriptRunnerContext.getStoredBreakCmds();
        HashMap<String, ArrayList<String>> storedColsCmds = this.m_scriptRunnerContext.getStoredFormatCmds();
        if (this.m_columns != null && storedBrkCmds.size() > 0) {
            this.parseSQL();
            block0: for (int i = 1; i < this.m_columns.length; ++i) {
                String column = this.m_columns[i];
                Iterator<String> iter = storedBrkCmds.keySet().iterator();
                int rank = 0;
                while (iter.hasNext()) {
                    String brkcol = iter.next();
                    if (brkcol.equals("report")) continue;
                    String aliascol = this.getAlias(brkcol);
                    ++rank;
                    if (aliascol == null || !column.equalsIgnoreCase(aliascol) && !column.equalsIgnoreCase(brkcol) && !column.equalsIgnoreCase(this.getHeading(aliascol, storedColsCmds)) && !(aliascol.length() > this.m_colsizes[i] ? aliascol.substring(0, this.m_colsizes[i]) : aliascol).equalsIgnoreCase(column)) continue;
                    this.m_breakcolumns.add(brkcol);
                    this.m_column_to_brkcol.put(column, brkcol);
                    this.m_brkcol_to_nodup.put(brkcol, storedBrkCmds.get(brkcol).contains("nodup"));
                    this.m_brkcol_to_rank.put(brkcol, rank);
                    continue block0;
                }
            }
        }
        if (Break.hasRowElement(storedBrkCmds)) {
            this.m_breakcolumns.add("row");
        }
        this.m_breakandselorderMatch = this.breakColandSelColOrderMatch();
    }

    private void populateBreakColumnsToComputeLabel() {
        if (this.m_brkcmptcolumns.size() > 0) {
            for (int i = 0; i < this.m_brkcmptcolumns.size(); ++i) {
                String column = this.getAlias(this.m_brkcmptcolumns.get(i));
                ArrayList<TreeMap<String, HashMap<String, String>>> mapList = this.m_scriptRunnerContext.getStoredComputeCmds().get(column);
                if (mapList == null) continue;
                for (TreeMap<String, HashMap<String, String>> col_cmptfunc : mapList) {
                    for (String key : col_cmptfunc.keySet()) {
                        HashMap<String, String> cmpt_func = col_cmptfunc.get(key);
                        for (String func : cmpt_func.keySet()) {
                            String lbl = cmpt_func.get(func);
                            lbl = lbl.replaceAll("'", "");
                            this.m_brkcol_to_cmplbl.put(column, lbl);
                            this.m_brkcol_to_cmpfn.put(column, func);
                            HashMap<String, String> cmpfn_to_lbl = this.m_brkcol_to_cmpfnlbl.get(column);
                            if (cmpfn_to_lbl == null) {
                                cmpfn_to_lbl = new HashMap<String, String>();
                            }
                            cmpfn_to_lbl.put(func, lbl);
                            this.m_brkcol_to_cmpfnlbl.put(column, cmpfn_to_lbl);
                        }
                    }
                }
            }
        }
    }

    private void mapSelColstoBreakColumns() {
        int size = this.m_brkcmptcolumns.size();
        HashMap<String, ArrayList<String>> storedColsCmds = this.m_scriptRunnerContext.getStoredFormatCmds();
        block0: for (int i = 1; i < this.m_columns.length; ++i) {
            String col = this.m_columns[i];
            for (int j = 0; j < size; ++j) {
                String brkCol = this.m_brkcmptcolumns.get(j);
                String aliascol = this.getAlias(brkCol);
                if (!col.equalsIgnoreCase(aliascol) && !col.equalsIgnoreCase(this.getHeading(aliascol, storedColsCmds)) && !(aliascol.length() > this.m_colsizes[i] ? aliascol.substring(0, this.m_colsizes[i]) : aliascol).equalsIgnoreCase(col)) continue;
                this.m_column_to_brkcmptcol.put(col, aliascol);
                continue block0;
            }
        }
    }

    private void mapSelColstoComputeColumns() {
        int size = this.m_computecolumns.size();
        HashMap<String, ArrayList<String>> storedColsCmds = this.m_scriptRunnerContext.getStoredFormatCmds();
        block0: for (int i = 1; i < this.m_columns.length; ++i) {
            String col = this.m_columns[i];
            for (int j = 0; j < size; ++j) {
                String cmpCol = this.m_computecolumns.get(j);
                String aliascol = this.getAlias(cmpCol);
                if (!col.equalsIgnoreCase(aliascol) && !col.equalsIgnoreCase(this.getHeading(aliascol, storedColsCmds))) continue;
                this.m_column_to_cmpcol.put(col, cmpCol);
                continue block0;
            }
        }
    }

    private String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StrJoin joiner = new StrJoin(delimiter);
        for (CharSequence charSequence : elements) {
            joiner.add(charSequence);
        }
        return joiner.toString();
    }

    public String join(CharSequence delimiter, CharSequence ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StrJoin joiner = new StrJoin(delimiter);
        for (CharSequence cs : elements) {
            joiner.add(cs);
        }
        return joiner.toString();
    }

    private boolean checkIntegralPart(String numberString, int numwidth) {
        int decimalIndex;
        String integralPartString;
        int numberStringLen = numberString.length();
        return numberString.contains(".") ? (integralPartString = numberString.substring(0, decimalIndex = numberString.indexOf("."))).length() > numwidth : numberStringLen > numwidth;
    }

    private String getNumericFormatedValue(String value, String formatValue) {
        String[] formatValues;
        String integralPart = null;
        String decimalPart = null;
        Object pattern = "";
        DecimalFormat myFormatter = null;
        boolean startsWithDollar = false;
        if (value == null) {
            return "";
        }
        if ((value = value.trim()).length() == 0) {
            return "";
        }
        formatValue = ((String)formatValue).toUpperCase();
        if (value.startsWith("-") && ((String)formatValue).length() > 0) {
            formatValue = "-" + (String)formatValue;
        }
        if (((String)formatValue).startsWith("$")) {
            formatValue = ((String)formatValue).substring(1, ((String)formatValue).length());
            startsWithDollar = true;
        }
        if (value.equalsIgnoreCase("Infinity")) {
            return "Inf";
        }
        if (value.equalsIgnoreCase("-Infinity")) {
            return "-Inf";
        }
        if (value.equalsIgnoreCase("NaN")) {
            return "Nan";
        }
        if (value.length() > this.m_numwidth && this.m_numwidth < 7) {
            char[] chars = new char[this.m_numwidth];
            Arrays.fill(chars, '#');
            return String.copyValueOf(chars);
        }
        if (this.checkIntegralPart(value, this.m_numwidth)) {
            pattern = this.createScientificNotation(value, this.m_numwidth, (String)formatValue);
        } else if (((String)formatValue).length() == 0) {
            char[] chars;
            if (value.startsWith("-")) {
                chars = new char[this.m_numwidth - 3];
                Arrays.fill(chars, '#');
                pattern = "-#." + String.copyValueOf(chars);
            } else {
                chars = new char[this.m_numwidth - 2];
                Arrays.fill(chars, '#');
                pattern = "#." + String.copyValueOf(chars);
            }
        } else if (((String)formatValue).matches("\\d*D\\d*")) {
            formatValues = ((String)formatValue).split("D");
            integralPart = formatValues[0].trim();
            integralPart = integralPart.replaceAll("9", "#");
            decimalPart = formatValues[1].trim();
            decimalPart = decimalPart.replaceAll("9", "0");
            pattern = integralPart + "." + decimalPart;
        } else if (((String)formatValue).contains(".")) {
            formatValues = ((String)formatValue).split("\\.");
            integralPart = formatValues[0].trim();
            integralPart = integralPart.replaceAll("9", "#");
            decimalPart = formatValues[1].trim();
            decimalPart = decimalPart.replaceAll("9", "0");
            pattern = integralPart + "." + decimalPart;
        } else {
            integralPart = ((String)formatValue).replaceAll("9", "#");
            pattern = integralPart;
        }
        if (((String)pattern).contains("E") || ((String)pattern).contains("e")) {
            DecimalFormatSymbols SYMBOLS = DecimalFormatSymbols.getInstance();
            double doubleValue = Double.parseDouble(value);
            if (doubleValue > 1.0 || doubleValue < -1.0 || doubleValue == 0.0) {
                SYMBOLS.setExponentSeparator("E+");
            } else {
                SYMBOLS.setExponentSeparator("E");
            }
            myFormatter = new DecimalFormat((String)pattern, SYMBOLS);
        } else {
            myFormatter = new DecimalFormat((String)pattern);
            myFormatter.setRoundingMode(RoundingMode.HALF_EVEN);
        }
        Object output = "";
        try {
            Number num = myFormatter.parse(value);
            output = myFormatter.format(num);
            if (startsWithDollar) {
                output = "$" + (String)output;
            }
        }
        catch (ParseException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, Messages.getString("DecicmalFormatParseFailure"), e);
        }
        return output;
    }

    private String createScientificNotation(String value, int numwidth, String numformat) {
        String pattern = null;
        if (numformat.length() == 0) {
            int j;
            StringBuffer formatStringBuffer = new StringBuffer("0.");
            double valueDouble = Double.parseDouble(value);
            if (valueDouble >= 0.0) {
                for (j = 0; j < numwidth - 6; ++j) {
                    formatStringBuffer.append("0");
                }
                formatStringBuffer.append("E00");
            }
            if (valueDouble < 0.0) {
                for (j = 0; j < numwidth - 7; ++j) {
                    formatStringBuffer.append("0");
                }
                formatStringBuffer.append("E00");
            }
            pattern = formatStringBuffer.toString();
        } else {
            if (!numformat.toUpperCase().contains("EEEE")) {
                String string = MessageFormat.format(ScriptRunnerDbArb.getString("EXPONENTIAL_FORMAT_EEEE_MISSING"), new Object[0]) + m_lineSeparator;
            }
            pattern = new String(numformat).replace("9", "0");
            pattern = pattern.toUpperCase().replace("EEEE", "E00");
        }
        return pattern;
    }

    private String processTypeAttributesForStruct(Struct obj, Connection conn) throws SQLException, IOException {
        OracleNLSProvider onlsp = (OracleNLSProvider)NLSProvider.getProvider(conn);
        onlsp.setNullDisplay("NULL");
        String schemaDotType = obj.getSQLTypeName().toUpperCase();
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)schemaDotType, (Connection)conn);
        OracleTypeADT oracleTypeADT = (OracleTypeADT)structDescriptor.getPickler();
        String[] schemaDotTypeParts = schemaDotType.split("\\.");
        String schema = schemaDotTypeParts[0].trim();
        String objectTypeName = schemaDotTypeParts[1].trim();
        String s = objectTypeName.toUpperCase() + "(";
        Object[] data = obj.getAttributes();
        for (int k = 0; k < data.length; ++k) {
            String attrName = oracleTypeADT.getAttributeName(k + 1);
            String attrType = oracleTypeADT.getAttributeType(k + 1);
            Object attributeData = data[k];
            if (attributeData != null) {
                Object oraIDS;
                if (attrType.equals("RAW")) {
                    byte[] attrByte = (byte[])attributeData;
                    RAW oraRAW = new RAW(attrByte);
                    String orastr = oraRAW.stringValue();
                    attributeData = "'" + orastr + "'";
                } else if (attrType.equals("BINARY_FLOAT")) {
                    if (this.m_numformat.length() > 0) {
                        NUMBER fv = new NUMBER(attributeData);
                        attributeData = this.formattedNUMBER(conn, fv, this.m_numformat, 10);
                    } else if (!Float.isNaN(((Float)attributeData).floatValue())) {
                        NUMBER fv = new NUMBER(attributeData);
                        float floatValue = fv.floatingPointRound(this.m_numwidth).floatValue();
                        attributeData = this.formattedFLOAT(conn, floatValue, this.m_numformat, 10);
                    } else {
                        attributeData = this.formattedFLOAT(conn, ((Float)attributeData).floatValue(), this.m_numformat, 10);
                    }
                    attrType = "BINARY_FLOAT_TYPE";
                } else if (attributeData instanceof STRUCT) {
                    attributeData = this.processTypeAttributesForStruct((Struct)((STRUCT)attributeData), conn);
                } else if (attributeData instanceof ARRAY) {
                    attributeData = this.processTypeAttributesForArray((ARRAY)attributeData, conn);
                }
                String oradtstr = "";
                if (attributeData instanceof Timestamp) {
                    Timestamp ats = (Timestamp)attributeData;
                    if (attrType.equals("DATE")) {
                        Date attrDate = new Date(ats.getTime());
                        DATE oraDate = new DATE(attrDate);
                        oradtstr = onlsp.formatDate(oraDate);
                    } else if (attrType.equals("TIMESTAMP")) {
                        TIMESTAMP oraTS = new TIMESTAMP(ats);
                        oradtstr = (String)onlsp.getValue(oraTS, FormatType.PREFERRED);
                    } else if (attrType.equals("TIMESTAMP WITH TZ")) {
                        TIMESTAMPTZ oraTSTZ = new TIMESTAMPTZ(conn, ats);
                        oradtstr = (String)onlsp.getValue(oraTSTZ, FormatType.PREFERRED);
                    } else if (attrType.equals("TIMESTAMP WITH LOCAL TZ")) {
                        TIMESTAMPLTZ oraTSLTZ = new TIMESTAMPLTZ(conn, ats);
                        oradtstr = (String)onlsp.getValue(oraTSLTZ, FormatType.PREFERRED);
                    }
                } else if (attributeData instanceof INTERVALYM && attrType.equals("INTERVAL YEAR TO MONTH")) {
                    INTERVALYM oraIYM = (INTERVALYM)attributeData;
                    oradtstr = (String)onlsp.getValue(oraIYM, FormatType.PREFERRED);
                } else if (attributeData instanceof INTERVALDS && attrType.equals("INTERVAL DAY TO SECOND")) {
                    oraIDS = (INTERVALDS)attributeData;
                    oradtstr = (String)onlsp.getValue(oraIDS, FormatType.PREFERRED);
                } else if (attributeData instanceof CLOB && attrType.equals("CLOB")) {
                    oraIDS = (Clob)attributeData;
                    oradtstr = (String)onlsp.getValue(oraIDS, FormatType.PREFERRED);
                } else if (attributeData instanceof BLOB && attrType.equals("BLOB")) {
                    oraIDS = (Blob)attributeData;
                    byte[] bdata = oraIDS.getBytes(1L, (int)oraIDS.length());
                    String ss = new String(ScriptUtils.bytesToHex(bdata)).toUpperCase();
                    oradtstr = DataTypesUtil.stringValue((Object)ss, conn, (Integer)this.m_scriptRunnerContext.getProperty("script.runner.setlong"));
                }
                if (attrType.equals("CLOB") || attrType.equals("BLOB")) {
                    attributeData = attributeData == null ? "NULL" : (oradtstr.length() == 0 ? "''" : "'" + oradtstr + "'");
                } else if (oradtstr.length() > 0) {
                    attributeData = "'" + oradtstr + "'";
                }
            } else {
                attributeData = "NULL";
            }
            boolean showAttributesFlag = true;
            int maxLength = this.m_linesize;
            String dataTypeValue = DataTypesUtil.stringValue(attributeData, conn, maxLength, false, 3, FormatType.DEFAULT);
            HashMap<String, HashMap<String, String>> attributeMap = this.m_scriptRunnerContext.getObjectTypeAttributes().get(objectTypeName);
            if (attributeMap != null) {
                HashMap<String, String> attributeValueMap = attributeMap.get(attrName);
                if (attributeValueMap != null) {
                    String formatPattern = attributeValueMap.get("FORMAT");
                    String likeValue = attributeValueMap.get("LIKE");
                    String onOffValue = attributeValueMap.get("ON_OFF");
                    if (onOffValue != null) {
                        showAttributesFlag = !onOffValue.equalsIgnoreCase("OFF");
                    }
                    if (showAttributesFlag) {
                        if (formatPattern != null && formatPattern.length() > 0) {
                            s = s + this.processTypeAttributeFormat(formatPattern, attrType, dataTypeValue);
                        } else if (likeValue != null && likeValue.length() > 0) {
                            if (likeValue.contains(".")) {
                                s = s + this.processLikeTypeAttribute(likeValue, attrType, dataTypeValue, attributeMap);
                            } else {
                                String aliasValueName = likeValue.toUpperCase();
                                String typeAttribute = this.m_scriptRunnerContext.getAliasTypeAttributesMap().get(aliasValueName);
                                if (typeAttribute != null) {
                                    s = s + this.processLikeAlias(typeAttribute, attrType, dataTypeValue);
                                }
                            }
                        } else {
                            s = s + this.addQuotesToTextualAttributes(dataTypeValue, attrType);
                        }
                    } else {
                        s = s + this.addQuotesToTextualAttributes(dataTypeValue, attrType);
                    }
                } else {
                    s = s + this.addQuotesToTextualAttributes(dataTypeValue, attrType);
                }
            } else {
                s = s + this.addQuotesToTextualAttributes(dataTypeValue, attrType);
            }
            if (k >= data.length - 1) continue;
            s = s + ", ";
        }
        s = s + ")";
        onlsp.setNullDisplay(null);
        return s;
    }

    private String processTypeAttributesForArray(ARRAY obj, Connection conn) throws SQLException, IOException {
        OracleNLSProvider onlsp = (OracleNLSProvider)NLSProvider.getProvider(conn);
        onlsp.setNullDisplay("NULL");
        String attrType = "";
        String schemaDotType = obj.getSQLTypeName().toUpperCase();
        String[] schemaDotTypeParts = schemaDotType.split("\\.");
        String schema = schemaDotTypeParts[0].trim();
        String objectTypeName = schemaDotTypeParts[1].trim();
        String s = objectTypeName.toUpperCase() + "(";
        Datum[] data = obj.getOracleArray();
        String dataTypeValue = null;
        int maxLength = this.m_linesize;
        for (int k = 0; k < data.length; ++k) {
            Datum arrayElementData = data[k];
            if (arrayElementData instanceof BINARY_FLOAT) {
                attrType = "BINARY_FLOAT";
                dataTypeValue = this.formattedFLOAT(this.m_conn, ((BINARY_FLOAT)arrayElementData).floatValue(), this.m_numformat, 10);
                s = s + dataTypeValue;
            } else {
                if (arrayElementData instanceof NUMBER) {
                    attrType = "NUMBER";
                }
                if (arrayElementData instanceof CHAR) {
                    attrType = "VARCHAR2";
                }
                if (arrayElementData instanceof RAW) {
                    attrType = "RAW";
                }
                dataTypeValue = arrayElementData instanceof STRUCT ? this.processTypeAttributesForStruct((Struct)((STRUCT)arrayElementData), conn) : DataTypesUtil.stringValue(arrayElementData, conn);
                String schemaName = "";
                if (arrayElementData instanceof ARRAY) {
                    schemaName = ((ARRAY)arrayElementData).getOracleMetaData().getSchemaName();
                    dataTypeValue = dataTypeValue != null ? dataTypeValue.replaceAll(schemaName + "\\.", "") : dataTypeValue;
                } else if (arrayElementData instanceof STRUCT) {
                    schemaName = ((STRUCT)arrayElementData).getOracleMetaData().getSchemaName();
                    dataTypeValue = dataTypeValue != null ? dataTypeValue.replaceAll(schemaName + "\\.", "") : dataTypeValue;
                }
                s = dataTypeValue == null && arrayElementData == null ? s + "NULL" : s + this.addQuotesToTextualAttributes(dataTypeValue, attrType);
            }
            if (k >= data.length - 1) continue;
            s = s + ", ";
        }
        s = s + ")";
        onlsp.setNullDisplay(null);
        return s;
    }

    private String processLikeTypeAttribute(String likeValue, String attrType, String dataTypeValue, HashMap<String, HashMap<String, String>> attributeMap) {
        HashMap<String, String> likeValueAttributeValueMap;
        String finalFormattedString = "";
        String[] likeValueParts = likeValue.split("\\.");
        String likeValueType = likeValueParts[0].trim().toUpperCase();
        String likeValueAttribute = likeValueParts[1].trim().toUpperCase();
        HashMap<String, HashMap<String, String>> likeValueAttributeMap = this.m_scriptRunnerContext.getObjectTypeAttributes().get(likeValueType);
        if (likeValueAttributeMap != null && likeValueAttribute != null && likeValueAttribute.length() > 0 && (likeValueAttributeValueMap = attributeMap.get(likeValueAttribute)) != null) {
            HashMap<String, String> referencedAttributeMap;
            String likeValueFormatPattern = likeValueAttributeValueMap.get("LIKE");
            String[] referencedlikeValueParts = likeValueFormatPattern.split("\\.");
            String referencedLikeValueType = referencedlikeValueParts[0].trim().toUpperCase();
            String referencedLikeValueAttribute = referencedlikeValueParts[1].trim().toUpperCase();
            HashMap<String, HashMap<String, String>> referencedlikeValueAttributeMap = this.m_scriptRunnerContext.getObjectTypeAttributes().get(referencedLikeValueType);
            if (referencedlikeValueAttributeMap != null && (referencedAttributeMap = referencedlikeValueAttributeMap.get(referencedLikeValueAttribute)) != null) {
                String referencedAttributePattern = referencedAttributeMap.get("FORMAT");
                finalFormattedString = this.processTypeAttributeFormat(referencedAttributePattern, attrType, dataTypeValue);
            }
        }
        return finalFormattedString;
    }

    private String processLikeAlias(String typeAttribute, String attrType, String dataTypeValue) {
        HashMap<String, String> attributeValueMap;
        String finalFormattedString = "";
        String[] typeAttributeParts = typeAttribute.split("\\.");
        String type = typeAttributeParts[0].trim().toUpperCase();
        String attribute = typeAttributeParts[1].trim().toUpperCase();
        HashMap<String, HashMap<String, String>> attributeMap = this.m_scriptRunnerContext.getObjectTypeAttributes().get(type);
        if (attributeMap != null && (attributeValueMap = attributeMap.get(attribute)) != null) {
            String formatPattern = attributeValueMap.get("FORMAT");
            finalFormattedString = this.processTypeAttributeFormat(formatPattern, attrType, dataTypeValue);
        }
        return finalFormattedString;
    }

    private String processTypeAttributeFormat(String formatPattern, String attrType, String dataTypeValue) {
        Object formattedString = "";
        if (formatPattern.length() > 0) {
            if (attrType.equalsIgnoreCase("VARCHAR") || attrType.equalsIgnoreCase("VARCHAR2")) {
                if (formatPattern.matches("[a|A]\\d*")) {
                    String columnWidthString = formatPattern.substring(1, formatPattern.length());
                    int columnWidth = Integer.parseInt(columnWidthString);
                    if (columnWidth <= dataTypeValue.length()) {
                        dataTypeValue = dataTypeValue.substring(0, columnWidth);
                    }
                    formattedString = (String)formattedString + "'" + dataTypeValue + "'";
                } else {
                    formattedString = (String)formattedString + "'" + dataTypeValue + "'";
                }
            }
            if (attrType.equalsIgnoreCase("NUMBER") || attrType.equalsIgnoreCase("INTEGER") || attrType.equalsIgnoreCase("DOUBLE") || attrType.equalsIgnoreCase("FLOAT") || attrType.equalsIgnoreCase("BINARY_DOUBLE") || attrType.equalsIgnoreCase("BINARY_FLOAT")) {
                formattedString = (String)formattedString + this.getNumericFormatedValue(dataTypeValue, formatPattern);
            }
        }
        return formattedString;
    }

    private String addQuotesToTextualAttributes(String text, String attrType) {
        if (((String)text).equals("NULL")) {
            return this.m_null != null && this.m_null.length() > 0 ? this.m_null : text;
        }
        if ((attrType.equalsIgnoreCase("VARCHAR") || attrType.equalsIgnoreCase("VARCHAR2") || attrType.equalsIgnoreCase("CHAR") || attrType.equalsIgnoreCase("RAW")) && !((String)text).matches("'([^']*)'")) {
            text = "'" + (String)text + "'";
        }
        if (attrType.equalsIgnoreCase("NUMBER") || attrType.equalsIgnoreCase("INTEGER") || attrType.equalsIgnoreCase("DOUBLE") || attrType.equalsIgnoreCase("FLOAT") || attrType.equalsIgnoreCase("BINARY_DOUBLE") || attrType.equalsIgnoreCase("BINARY_FLOAT")) {
            text = this.getNumericFormatedValue((String)text, "");
        }
        return text;
    }

    private String getColumnName(ResultSet rset, int index) {
        String colName;
        block10: {
            colName = "";
            if (index > 0 && rset != null) {
                try {
                    Datum obj = null;
                    if (rset.getMetaData().getColumnType(index) != -1 && rset.getMetaData().getColumnType(index) != -2 && rset.getMetaData().getColumnType(index) != 2009 && rset.getMetaData().getColumnType(index) != 2005 && rset.getMetaData().getColumnType(index) != 2004 && rset.getMetaData().getColumnType(index) != 2011) {
                        obj = ScriptUtils.getOracleObjectWrap((OracleResultSet)rset, index);
                    }
                    if (obj != null) {
                        String pcolName = "";
                        pcolName = rset.getMetaData().getColumnName(index);
                        if (obj instanceof STRUCT || obj instanceof ARRAY) {
                            colName = this.getUDTColumnName(pcolName, obj);
                        }
                    }
                    if (colName.length() == 0) {
                        colName = rset.getMetaData().getColumnName(index);
                    }
                }
                catch (Exception ex) {
                    String msg = ex.getMessage();
                    if (!msg.equalsIgnoreCase("Stream has already been closed") && !(ex instanceof SQLException)) break block10;
                    try {
                        colName = rset.getMetaData().getColumnName(index);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
        if (colName.equals("COLUMN_VALUE")) {
            colName = ScriptRunnerDbArb.getString("COLUMN_VALUE");
        }
        return colName;
    }

    private String getUDTColumnName(String parentObj, Object obj) throws SQLException {
        Object udtColName = "";
        Object subCols = "";
        if (obj != null) {
            if (obj instanceof STRUCT) {
                Struct struct = (Struct)obj;
                String typeName = struct.getSQLTypeName();
                StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)typeName, (Connection)this.m_conn);
                OracleTypeADT oracleTypeADT = (OracleTypeADT)structDescriptor.getPickler();
                Object[] attrs = struct.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    String attrName = oracleTypeADT.getAttributeName(i + 1);
                    String subCol = "";
                    if (attrs[i] instanceof STRUCT || attrs[i] instanceof ARRAY) {
                        subCol = this.getUDTColumnName(attrName, attrs[i]);
                    }
                    if (i + 1 == 1) {
                        if (parentObj.length() > 0) {
                            subCols = parentObj + "(" + (subCol.length() > 0 ? subCol : attrName);
                            continue;
                        }
                        subCols = attrName + "(" + subCol;
                        continue;
                    }
                    subCols = (String)subCols + ", " + (subCol.length() > 0 ? subCol : attrName);
                }
                udtColName = (String)subCols + ")";
            } else if (obj instanceof ARRAY) {
                ArrayDescriptor arrayDescriptor = ((ARRAY)obj).getDescriptor();
                Datum[] arrayData = ((ARRAY)obj).getOracleArray();
                OracleTypeADT oracleTypeADT = (OracleTypeADT)arrayDescriptor.getPickler();
                String attrName = "";
                for (int i = 0; i < arrayData.length; ++i) {
                    if (arrayData[i] instanceof ARRAY) {
                        attrName = this.getUDTColumnName(parentObj, arrayData[i]);
                        udtColName = attrName;
                        break;
                    }
                    if (arrayData[i] instanceof STRUCT) {
                        attrName = this.getUDTColumnName(parentObj, arrayData[i]);
                        udtColName = attrName;
                        continue;
                    }
                    attrName = oracleTypeADT.getAttributeName(i + 1);
                    udtColName = attrName;
                }
            }
        }
        return udtColName;
    }

    private void setCursorStmtHeader(String header) {
        this.m_cursorHeader = header;
    }

    public String getCursorStmtHeader() {
        return this.m_cursorHeader;
    }

    public String processNumberLessThanNumwidth(String numberString, int numwidth) {
        Object returnableString = "";
        int numberStringLen = numberString.length();
        if (numberString.contains(".")) {
            int decimalIndex = numberString.indexOf(".");
            String integralPartString = numberString.substring(0, decimalIndex);
            int integralPartStringLen = integralPartString.length();
            String decimalPartString = numberString.substring(decimalIndex + 1, numberStringLen);
            int decimalPartStringLen = decimalPartString.length();
            if (integralPartStringLen > numwidth) {
                char[] chars = new char[numwidth];
                Arrays.fill(chars, '#');
                returnableString = String.copyValueOf(chars);
            } else {
                int delta = numwidth - (integralPartStringLen + 1);
                returnableString = delta > 0 ? integralPartString + "." + decimalPartString.substring(0, delta) : integralPartString;
            }
        } else if (numberStringLen > numwidth) {
            char[] chars = new char[numwidth];
            Arrays.fill(chars, '#');
            returnableString = String.copyValueOf(chars);
        } else {
            returnableString = numberString;
        }
        return returnableString;
    }

    private final String modifyScientificNotation(String brkcolkey) throws SQLException {
        Object modbrkcolkey = "";
        modbrkcolkey = brkcolkey.replaceFirst("\\d+_", "");
        Pattern ptrn = Pattern.compile("\\d+_");
        Matcher m = ptrn.matcher(brkcolkey);
        String prefix = "";
        if (m.find()) {
            prefix = m.group(0);
        }
        String floatval = "";
        if (((String)modbrkcolkey).matches("-?\\d+(\\.\\d+)?((?i:e)(-|\\+)?\\d+)")) {
            float f = Float.parseFloat(String.valueOf(modbrkcolkey));
            floatval = this.formattedFLOAT(this.m_conn, f, this.m_numformat, 10);
            modbrkcolkey = prefix + floatval;
        } else if (((String)modbrkcolkey).equals("Inf")) {
            float f = Float.POSITIVE_INFINITY;
            floatval = this.formattedFLOAT(this.m_conn, Float.POSITIVE_INFINITY, this.m_numformat, 7);
            modbrkcolkey = prefix + floatval;
        } else if (((String)modbrkcolkey).equals("Nan")) {
            float f = Float.NaN;
            floatval = this.formattedFLOAT(this.m_conn, Float.NaN, this.m_numformat, 7);
            modbrkcolkey = prefix + floatval;
        } else {
            modbrkcolkey = brkcolkey;
        }
        return modbrkcolkey;
    }

    public final class StrJoin {
        private final String prefix;
        private final String delimiter;
        private final String suffix;
        private final String emptyValue;
        private StringBuilder value;

        public StrJoin(CharSequence delimiter) {
            this(delimiter, "", "");
        }

        public StrJoin(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
            Objects.requireNonNull(prefix, "The prefix must not be null");
            Objects.requireNonNull(delimiter, "The delimiter must not be null");
            Objects.requireNonNull(suffix, "The suffix must not be null");
            this.prefix = prefix.toString();
            this.delimiter = delimiter.toString();
            this.suffix = suffix.toString();
            this.emptyValue = this.prefix + this.suffix;
        }

        private StringBuilder prepareBuilder() {
            if (this.value != null) {
                this.value.append(this.delimiter);
            } else {
                this.value = new StringBuilder().append(this.prefix);
            }
            return this.value;
        }

        public StrJoin add(CharSequence newElement) {
            this.prepareBuilder().append(newElement);
            return this;
        }

        public String toString() {
            if (this.value == null) {
                return this.emptyValue;
            }
            if (this.suffix.equals("")) {
                return this.value.toString();
            }
            int initialLength = this.value.length();
            String result = this.value.append(this.suffix).toString();
            this.value.setLength(initialLength);
            return result;
        }
    }

    static class RomanUtil {
        private static LinkedHashMap<Integer, String> m_int_to_roman = new LinkedHashMap();

        RomanUtil() {
        }

        private static String getRomanValue(Integer num) {
            if (num <= 3999 && num >= 1) {
                m_int_to_roman.put(1000, "M");
                m_int_to_roman.put(900, "CM");
                m_int_to_roman.put(500, "D");
                m_int_to_roman.put(400, "CD");
                m_int_to_roman.put(100, "C");
                m_int_to_roman.put(90, "XC");
                m_int_to_roman.put(50, "L");
                m_int_to_roman.put(40, "XL");
                m_int_to_roman.put(10, "X");
                m_int_to_roman.put(9, "IX");
                m_int_to_roman.put(5, "V");
                m_int_to_roman.put(4, "IV");
                m_int_to_roman.put(1, "I");
                Set<Map.Entry<Integer, String>> keys = m_int_to_roman.entrySet();
                StringBuffer result = new StringBuffer("");
                for (Map.Entry<Integer, String> key : keys) {
                    while (num >= key.getKey()) {
                        num = num - key.getKey();
                        result.append(key.getValue());
                    }
                }
                return result.toString();
            }
            return "";
        }

        private static String getRomanFmt(Integer num, int size) {
            String romanVal = RomanUtil.getRomanValue(num);
            if (romanVal.length() > size || romanVal.equals("")) {
                char[] chars = new char[size];
                Arrays.fill(chars, '#');
                return String.copyValueOf(chars);
            }
            return String.format("%1$" + size + "s", romanVal);
        }
    }
}

