/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.app.Completer;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.dictionary.DictionaryCompleter;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.lsp.features.DocumentSymbol;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.dictionary.DictionaryEarley;

class BackgroundDictParser
extends BackgroundParser {
    DictionaryCompleter completer = null;

    public BackgroundDictParser(String input, String url, LanguageServer languageServer) throws IOException {
        super(input, DictionaryEarley.getInstance(), "dictionary", url, languageServer);
        this.initRegistry(new OracleDictionary(this));
        this.lateInit();
    }

    @Override
    public String label(ParseNode node) {
        String label = ((LexerToken)this.src.get((int)node.from)).content;
        if (node.contains("index_node")) {
            return "Indexes";
        }
        if (node.contains("directory_node")) {
            return "Directories";
        }
        if (node.contains("other_users_node")) {
            return "Other Users";
        }
        if (node.contains("other_datatypes_node")) {
            return "Other Datatypes";
        }
        if (node.contains("object")) {
            return label;
        }
        if (node.contains("object_name")) {
            return label;
        }
        if (node.contains("user_name")) {
            return label;
        }
        for (int l : node.content()) {
            int cut;
            String payload;
            if (l < 0 || 0 <= (payload = this.earley.allSymbols[l]).indexOf("\"") || 0 <= payload.indexOf("[") || 0 >= (cut = payload.indexOf("_node"))) continue;
            return payload.substring(0, 1).toUpperCase() + payload.substring(1, cut).replace('_', ' ') + "s";
        }
        return null;
    }

    @Override
    int kind(ParseNode node) {
        if (node.contains("object") || node.contains("object_name")) {
            return DocumentSymbol.SymbolKind.Object.getValue();
        }
        return DocumentSymbol.SymbolKind.Array.getValue();
    }

    @Override
    public String semanticActionsFile() {
        return "dictCodeLens.arbori";
    }

    @Override
    public Set<String> getOpenConnections() {
        HashSet<String> ret = new HashSet<String>();
        for (BackgroundParser parser : this.languageServer.parsers.values()) {
            String candidate;
            Registry registry = parser.getRegistry();
            if (!(registry.getConnection() instanceof Connection) || (candidate = registry.getConnString()) == null || ret.contains(candidate)) continue;
            ret.add(candidate);
        }
        return ret;
    }

    @Override
    public void associateUnambiguousConnection() {
        Registry reg = this.languageServer.getUnambiguousConnectedRegistry();
        if (reg != null) {
            this.getRegistry().copyConnection(reg);
        }
    }

    @Override
    public Completer getCompleter() {
        if (this.completer == null) {
            this.completer = new DictionaryCompleter(this);
        }
        return this.completer;
    }
}

