/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.app.Completer;
import oracle.dbtools.app.SqlCompleter;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.lsp.dictionary.Registry;
import oracle.dbtools.lsp.features.DocumentSymbol;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SqlEarley;

class BackgroundSqlParser
extends BackgroundParser {
    SqlCompleter completer = null;

    public BackgroundSqlParser(String input, String url, LanguageServer languageServer) {
        super(input, SqlEarley.partialRecognizer(), "sql_statements", url, languageServer);
        this.initRegistry(new OracleDictionary(this));
        this.lateInit();
    }

    @Override
    public String label(ParseNode node) {
        String label = ((LexerToken)this.src.get((int)node.from)).content;
        if (node.contains("sql_statement") && !node.contains("sqlplus_command")) {
            return label;
        }
        if (node.contains("sqlplus_command")) {
            return label;
        }
        if (node.contains("subprg_body")) {
            return this.text.substring(((LexerToken)this.src.get((int)node.from)).begin, ((LexerToken)this.src.get((int)(node.from + 1))).end);
        }
        if (node.contains("basic_d")) {
            return this.text.substring(((LexerToken)this.src.get((int)node.from)).begin, ((LexerToken)this.src.get((int)(node.from + 1))).end);
        }
        if (node.contains("prm_spec")) {
            return this.text.substring(((LexerToken)this.src.get((int)node.from)).begin, ((LexerToken)this.src.get((int)(node.from + 1))).end);
        }
        return null;
    }

    @Override
    int kind(ParseNode node) {
        if (node.contains("sql_statement")) {
            return DocumentSymbol.SymbolKind.Function.getValue();
        }
        if (node.contains("subprg_body")) {
            return DocumentSymbol.SymbolKind.Module.getValue();
        }
        if (node.contains("basic_d")) {
            return DocumentSymbol.SymbolKind.Property.getValue();
        }
        if (node.contains("prm_spec")) {
            return DocumentSymbol.SymbolKind.Variable.getValue();
        }
        return super.kind(node);
    }

    @Override
    public String semanticActionsFile() {
        return "sqlCodeLens.arbori";
    }

    @Override
    public Set<String> getOpenConnections() {
        HashSet<String> ret = new HashSet<String>();
        for (BackgroundParser parser : this.languageServer.parsers.values()) {
            String candidate;
            Registry registry = parser.getRegistry();
            if (!(registry.getConnection() instanceof Connection) || (candidate = registry.getConnString()) == null || ret.contains(candidate)) continue;
            ret.add(candidate);
        }
        return ret;
    }

    @Override
    public void associateUnambiguousConnection() {
        Registry reg = this.languageServer.getUnambiguousConnectedRegistry();
        if (reg != null) {
            this.getRegistry().copyConnection(reg);
        }
    }

    @Override
    public Completer getCompleter() {
        if (this.completer == null) {
            Registry dict = this.getRegistry();
            if (dict == null) {
                return null;
            }
            Object conn = ((OracleDictionary)dict).getConnection();
            if (conn == null || !(conn instanceof Connection)) {
                return null;
            }
            this.completer = new SqlCompleter((Connection)conn);
        }
        return this.completer;
    }
}

