/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.TableRenderer;
import oracle.dbtools.raptor.utils.DataTypesUtil;

class CsvRenderer
extends TableRenderer {
    public CsvRenderer(BackgroundParser parser, OutputStream send) {
        super(parser, send);
    }

    @Override
    public String render(ResultSet rs, Connection conn) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        StringBuilder ret = new StringBuilder();
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            ret.append((1 < i ? "," : "") + rsmd.getColumnName(i));
        }
        ret.append("\n");
        int line = 0;
        while (rs.next() && line++ < 10000) {
            this.jsCallback(rs, conn, line);
            if (this.isSilent) continue;
            for (int i = 1; i <= cols; ++i) {
                Object o = rs.getObject(i);
                String s = DataTypesUtil.stringValueChecked(o, conn);
                ret.append((1 < i ? "," : "") + s);
            }
            ret.append("\n");
        }
        if (this.isSilent) {
            ret.append("... (silent mode)\n");
        }
        return ret.toString();
    }
}

