/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import javax.script.Bindings;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.CsvRenderer;
import oracle.dbtools.lsp.GridRenderer;
import oracle.dbtools.lsp.HtmlRenderer;
import oracle.dbtools.lsp.InsertRenderer;
import oracle.dbtools.lsp.JsonRenderer;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.scripting.GlobalMap;

public abstract class TableRenderer {
    protected BackgroundParser parser;
    protected OutputStream send;
    public ParseNode jsNode;
    public boolean isSilent = false;
    public String jsCallback = null;

    public TableRenderer(BackgroundParser parser, OutputStream send) {
        this.parser = parser;
        this.send = send;
    }

    public abstract String render(ResultSet var1, Connection var2) throws Exception;

    protected Object jsCallback(ResultSet rs, Connection conn, int line) {
        if (this.jsCallback == null) {
            return null;
        }
        if (this.parser.program.getEngine() == null) {
            return null;
        }
        GlobalMap _globals = this.parser.program.getGlobals();
        if (_globals == null) {
            return null;
        }
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            HashMap<String, Object> tuple = new HashMap<String, Object>();
            int cols = rsmd.getColumnCount();
            for (int i = 1; i <= cols; ++i) {
                tuple.put(rsmd.getColumnName(i), rs.getObject(i));
            }
            _globals.put("resultSet", (Object)rs);
            _globals.put("line", (Object)line);
            _globals.put("tuple", (Object)tuple);
            _globals.put("renderer", (Object)this);
            _globals.put("connection", (Object)conn);
            _globals.put("parser", (Object)this.parser);
            _globals.put("outputStream", (Object)this.send);
            return this.parser.program.getEngine().eval(this.jsCallback, (Bindings)_globals);
        }
        catch (Throwable e) {
            if (this.jsNode != null) {
                this.parser.failedCommand(this.jsNode, e);
            }
            if (!(e instanceof Exception)) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static TableRenderer factory(String type, BackgroundParser parser, OutputStream send) {
        if ("html".equalsIgnoreCase(type) || "xml".equalsIgnoreCase(type)) {
            return new HtmlRenderer(parser, send);
        }
        if ("grid".equalsIgnoreCase(type)) {
            return new GridRenderer(parser, send);
        }
        if ("csv".equalsIgnoreCase(type)) {
            return new CsvRenderer(parser, send);
        }
        if ("json".equalsIgnoreCase(type)) {
            return new JsonRenderer(parser, send);
        }
        if ("insert".equalsIgnoreCase(type)) {
            return new InsertRenderer(parser, send);
        }
        throw new AssertionError((Object)("VT: mismatching type: " + type));
    }
}

