/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands;

import java.io.OutputStream;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.Jsonable;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.features.Command;
import oracle.dbtools.lsp.features.Diagnostics;
import oracle.dbtools.lsp.features.Position;
import oracle.dbtools.lsp.features.Range;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

public abstract class CodeLens
implements Jsonable,
Comparable<CodeLens> {
    protected BackgroundParser parser;
    public ParseNode node;
    protected Command command = null;
    protected String argument = "empty";
    private final String pattern1 = "<eval>:";
    private final String pattern2 = "<eval> at line number ";
    private String pattern = "<eval>:";

    public Range getRange() {
        return this.parser.nodeRange(this.node);
    }

    public String getTitle() {
        return this.command.title;
    }

    public CodeLens(ParseNode node, String title, BackgroundParser parser) {
        this.node = node;
        String cmd = Thread.currentThread().getStackTrace()[2].getClassName();
        this.command = new Command(title, "arbori.oneLinerCommand", "`" + cmd + "` `" + node.interval() + "`");
        this.parser = parser;
    }

    public CodeLens(ParseNode node, String title, String argument, BackgroundParser parser) {
        this.node = node;
        String cmd = Thread.currentThread().getStackTrace()[2].getClassName();
        this.command = new Command(title, "arbori.oneLinerCommand", "`" + cmd + "` `" + node.interval() + "` `" + argument + "`");
        this.parser = parser;
        this.argument = argument;
    }

    @Override
    public String toJson() {
        return "{ \"range\": " + this.getRange().toJson() + ", \"command\": " + this.command.toJson() + " }";
    }

    public String toString() {
        return "node=" + this.node.toString() + ", command.title=" + this.command.title + ", command.command=" + this.command.command + ", command.class=" + this.command.getClass() + ",parser=" + this.parser;
    }

    public static void print(CodeLens[] arr) {
        if (arr == null) {
            return;
        }
        for (int i = 0; i < arr.length; ++i) {
            System.out.println(arr[i].toString());
        }
    }

    public abstract Object executeCommand(OutputStream var1);

    public static CodeLens rangedCommandAt(CodeLens[] codeLens, int index) {
        int trueIndex = 0;
        for (int i = 0; i < codeLens.length; ++i) {
            if (codeLens[i].node.to < 1) continue;
            if (trueIndex == index) {
                return codeLens[i];
            }
            ++trueIndex;
        }
        throw new AssertionError((Object)("Index out of bounds: " + (codeLens.length - 1) + "<" + index));
    }

    public static CodeLens find(CodeLens[] codeLens, String classname, String interval, String argument) {
        String name = CodeLens.normalizedClassName(classname);
        for (int i = 0; i < codeLens.length; ++i) {
            if (!name.equals(CodeLens.normalizedClassName(codeLens[i].getClass().getName())) || !interval.equals(codeLens[i].node.interval()) || !argument.equals(codeLens[i].argument)) continue;
            return codeLens[i];
        }
        throw new AssertionError((Object)("Index out of bounds: " + (codeLens.length - 1)));
    }

    @Override
    public int compareTo(CodeLens o) {
        int posDiff = this.node.compareTo(o.node);
        if (posDiff != 0) {
            return posDiff;
        }
        int cmdDiff = this.command.toJson().compareTo(o.command.toJson());
        if (cmdDiff != 0) {
            return cmdDiff;
        }
        int argDiff = this.argument.compareTo(o.argument);
        if (argDiff != 0) {
            return argDiff;
        }
        return 0;
    }

    public static String normalizedClassName(String name) {
        String ret = name;
        int pos = (ret = ret.replace('_', '.')).indexOf("oracle.dbtools");
        if (0 < pos) {
            ret = ret.substring(pos);
        }
        return ret;
    }

    public Throwable processScriptException(Throwable e) {
        e.printStackTrace();
        String jsLine = this.jsLine1(e);
        try {
            int pos = jsLine.indexOf(this.pattern);
            int pos2 = jsLine.indexOf(")", pos += this.pattern.length());
            if (pos2 < 0) {
                pos2 = jsLine.indexOf(" ", pos);
            }
            if (pos2 < 0) {
                pos2 = jsLine.length();
            }
            int line = Integer.parseInt(jsLine.substring(pos, pos2).trim()) - 1;
            int offset = 0;
            try {
                int to;
                LexerToken t = LexerToken.getTokenAtCharOffset(this.parser.src, this.parser.lineNo2CharPos0(line));
                offset = t.begin - this.parser.lineNo2CharPos0(line);
                if (offset < 0) {
                    offset = 0;
                }
                if ((to = this.node.to) == 0) {
                    line = 0;
                    offset = 0;
                } else if (this.parser.src.get((int)(to - 1)).end <= t.begin || t.end <= this.parser.src.get((int)this.node.from).begin) {
                    int from = this.node.from;
                    LexerToken current = this.parser.src.get(from);
                    int commandOffset = current.begin;
                    line = this.parser.charPos2LineNo0(commandOffset);
                    offset = commandOffset - this.parser.lineNo2CharPos0(line);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                LSP.LOG.log(Level.SEVERE, e1.getMessage(), e1);
                int from = this.node.from;
                LexerToken current = this.parser.src.get(from);
                int commandOffset = current.begin;
                line = this.parser.charPos2LineNo0(commandOffset);
                offset = commandOffset - this.parser.lineNo2CharPos0(line);
            }
            Position start = new Position(line, offset);
            Position end = new Position(line, offset + 3);
            Range range = new Range(start, end);
            Diagnostics diag = new Diagnostics(range, e.getMessage());
            if (!this.parser.diagnostics.contains(diag)) {
                this.parser.diagnostics.add(diag);
            }
            return e;
        }
        catch (Throwable e1) {
            e1.printStackTrace();
            return e;
        }
    }

    private String jsLine1(Throwable cause) {
        if (cause == null) {
            return "N/A";
        }
        StackTraceElement[] elems = cause.getStackTrace();
        String ret = cause.getMessage();
        if (0 < ret.indexOf("<eval>:")) {
            this.pattern = "<eval>:";
        } else if (0 < ret.indexOf("<eval> at line number ")) {
            this.pattern = "<eval> at line number ";
        } else {
            ret = "N/A";
        }
        for (StackTraceElement elem : elems) {
            String line = elem.toString();
            if (0 < line.indexOf("<eval>:")) {
                this.pattern = "<eval>:";
            } else {
                if (0 >= line.indexOf("<eval> at line number ")) continue;
                this.pattern = "<eval> at line number ";
            }
            ret = line;
        }
        return ret;
    }
}

