/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.dictionary;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.Item;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;

public class CacheTreeNode
extends CodeLens {
    public CacheTreeNode(ParseNode node, BackgroundParser parser) {
        super(node, "Cache Object Definitions", parser);
    }

    @Override
    public Object executeCommand(final OutputStream send) {
        LanguageServer server = this.parser.languageServer;
        ParseNode grandParent = this.node.parent().parent();
        Object schema = "USER";
        if (grandParent != null && !grandParent.contains("other_datatypes_node")) {
            schema = "'" + this.parser.src.get((int)grandParent.from).content.toUpperCase() + "'";
        }
        final String owner = schema;
        String symbol = this.parser.earley.allSymbols[this.node.content()[0]].toUpperCase();
        int chop = symbol.indexOf("_NODE");
        final String objType = symbol.substring(0, chop);
        final Connection conn = (Connection)server.getLastConnection();
        if (conn == null) {
            return new ResponseError(-32603, "Not connected", server.getLastUrl());
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    List<Item> items = OracleDictionary.queryItems(CacheTreeNode.this.node, ((CacheTreeNode)CacheTreeNode.this).parser.src, owner, objType, conn);
                    for (Item item : items) {
                        if (item == Item.MORE) break;
                        Object e = CacheTreeNode.this.parser.locate(send, item, (OracleDictionary)CacheTreeNode.this.parser.getRegistry(), false);
                        if (!(e instanceof ResponseError)) continue;
                        ((CacheTreeNode)CacheTreeNode.this).parser.languageServer.getLSP().notifyClient(send, "window/showMessage", e);
                    }
                }
                catch (SQLException e) {
                    LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
                    ((CacheTreeNode)CacheTreeNode.this).parser.languageServer.getLSP().notifyClient(send, "window/showMessage", e);
                }
            }
        }.start();
        return "OK";
    }
}

