/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.io.OutputStream;
import java.util.List;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.ConnUserPwd;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class CloseConnection
extends CodeLens {
    public CloseConnection(ParseNode node, BackgroundParser parser) {
        super(node, "Close Connection", parser);
    }

    @Override
    public Object executeCommand(OutputStream send) {
        LanguageServer server = this.parser.languageServer;
        String sql = this.parser.text.substring(this.parser.src.get((int)this.node.from).begin, this.parser.src.get((int)(this.node.to - 1)).end);
        List<LexerToken> src = LexerToken.parse(sql);
        try {
            ConnUserPwd cup = ConnUserPwd.parseConnectCommand(src);
            String connstr = OracleDictionary.connAlias(cup);
            server.closeConnection(connstr);
            server.documentsBump(send);
            return "OK";
        }
        catch (Throwable e) {
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), sql);
        }
    }
}

