/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.commands.sql.RunScript;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;
import oracle.dbtools.util.Service;

public class RunFile
extends CodeLens {
    public RunFile(ParseNode node, BackgroundParser parser) {
        super(node, "Run File", parser);
    }

    @Override
    public Object executeCommand(final OutputStream send) {
        String cmd = this.parser.text.substring(this.parser.src.get((int)this.node.from).begin, this.parser.src.get((int)(this.node.to - 1)).end);
        List<LexerToken> src1 = LexerToken.parse(cmd);
        final String filename = src1.get((int)1).content;
        this.parser.resetDiagnostics();
        try {
            final String text = Service.readFile(filename);
            new Thread(){

                @Override
                public void run() {
                    try {
                        LanguageServer server = ((RunFile)RunFile.this).parser.languageServer;
                        BackgroundParser parser1 = server.getParser(filename);
                        if (parser1 == null) {
                            parser1 = BackgroundParser.factory(text, filename, server);
                            server.parsers.put(filename, parser1);
                        }
                        String connStr = RunFile.this.parser.getAssociatedConnstr();
                        server.associateConnection(filename, connStr);
                        parser1.parse();
                        parser1.waitForArboriFinish();
                        Object log = RunScript.iterateCodeLenses(parser1, send);
                        if (log instanceof ResponseError) {
                            RunFile.this.parser.failedCommand(RunFile.this.node, new Exception(log.toString()));
                        }
                        server.getLSP().notifyClient(send, "window/showMessage", "\"Script finished\"");
                    }
                    catch (Exception e) {
                        LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }.start();
        }
        catch (Exception e) {
            LSP.LOG.log(Level.SEVERE, e.getMessage(), e);
            return new ResponseError(-32603, Util.sugarcoatText(e.getMessage()), filename);
        }
        return "OK";
    }
}

