/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.dictionary;

import java.util.List;
import oracle.dbtools.parser.LexerToken;

public class ConnUserPwd {
    public String connStr;
    public String user;
    public String pwd;

    public ConnUserPwd(String connStr, String user, String pwd) {
        this.connStr = connStr;
        this.user = user;
        this.pwd = pwd;
    }

    public static ConnUserPwd parseConnectCommand(List<LexerToken> fullCommand) {
        if (fullCommand.size() == 6) {
            String user = fullCommand.get((int)1).content;
            String pwd = fullCommand.get((int)3).content;
            String conn = fullCommand.get((int)5).content.trim();
            return new ConnUserPwd(conn, user, pwd);
        }
        if (fullCommand.size() == 4) {
            String user = fullCommand.get((int)1).content;
            String conn = fullCommand.get((int)3).content.trim();
            return new ConnUserPwd(conn, user, null);
        }
        if (fullCommand.size() == 2) {
            String connUserPwd = fullCommand.get((int)1).content;
            int chop = connUserPwd.indexOf(63);
            String conn = connUserPwd.substring(0, chop) + "\"";
            String userPwd = connUserPwd.substring(chop + 1);
            chop = userPwd.indexOf(61);
            userPwd = userPwd.substring(chop + 1);
            chop = userPwd.indexOf(38);
            String user = userPwd.substring(0, chop);
            String pwd = userPwd.substring(chop + 1);
            chop = pwd.indexOf(61);
            pwd = pwd.substring(chop + 1, pwd.length() - 1);
            return new ConnUserPwd(conn, user, pwd);
        }
        throw new AssertionError((Object)("Unexpected JDBC connect command lenghth = " + fullCommand.size()));
    }
}

