/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.util.Service;

public class Grammar {
    private static Earley earley = new Earley((Set)Grammar.getRules()){

        @Override
        protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
            LexerToken token = src.get(y);
            return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
        }
    };
    static int rule = (Integer)Grammar.earley.symbolIndexes.get("rule");
    static int grammar = (Integer)Grammar.earley.symbolIndexes.get("grammar");
    static int variable = (Integer)Grammar.earley.symbolIndexes.get("variable");
    static int disjunct = (Integer)Grammar.earley.symbolIndexes.get("disjunct");
    static int postfix = (Integer)Grammar.earley.symbolIndexes.get("postfix");
    static int concat = (Integer)Grammar.earley.symbolIndexes.get("concat");
    static int or = (Integer)Grammar.earley.symbolIndexes.get("'|'");
    static int minus = (Integer)Grammar.earley.symbolIndexes.get("'-'");
    static int plus = (Integer)Grammar.earley.symbolIndexes.get("'+'");
    static int star = (Integer)Grammar.earley.symbolIndexes.get("'*'");
    static int question = (Integer)Grammar.earley.symbolIndexes.get("'?'");
    static int colon = (Integer)Grammar.earley.symbolIndexes.get("':'");
    static int equality = (Integer)Grammar.earley.symbolIndexes.get("'='");
    static int semicolon = (Integer)Grammar.earley.symbolIndexes.get("';'");
    static int oparen = (Integer)Grammar.earley.symbolIndexes.get("'('");
    static int cparen = (Integer)Grammar.earley.symbolIndexes.get("')'");
    private static ParseNode ruleRoot;

    public static void main(String[] args) throws Exception {
        Set<RuleTuple> rules = Grammar.extractRules(SqlEarley.class, "json.ebnf");
        RuleTuple.printRules(rules);
    }

    public static Set<RuleTuple> extractRules(Class c, String file) throws IOException {
        String input = Service.readFile(c, file);
        return Grammar.extractRules(input);
    }

    public static Set<RuleTuple> extractRules(String input) throws IOException {
        input = input.replace("::=", ":");
        input = input.replace("\"", "'");
        List<LexerToken> src = Lexer.parse(input);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, rules);
        RuleTransforms.eliminateEmptyProductions(rules);
        RuleTransforms.substituteSingleUnaryProductions(rules);
        return rules;
    }

    public static Earley bnfParser() {
        return earley;
    }

    private static Set<RuleTuple> getRules() {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        rules.add(new RuleTuple("variable", new String[]{"identifier"}));
        rules.add(new RuleTuple("variable", new String[]{"identifier", "'['", "identifier", "']'"}));
        rules.add(new RuleTuple("variable", new String[]{"string_literal"}));
        rules.add(new RuleTuple("variable", new String[]{"identifier", "'['", "digits", "','", "digits", "')'"}));
        rules.add(new RuleTuple("postfix", new String[]{"variable"}));
        rules.add(new RuleTuple("postfix", new String[]{"variable", "'*'"}));
        rules.add(new RuleTuple("postfix", new String[]{"variable", "'+'"}));
        rules.add(new RuleTuple("postfix", new String[]{"variable", "'?'"}));
        rules.add(new RuleTuple("postfix", new String[]{"'('", "disjunct", "')'", "'*'"}));
        rules.add(new RuleTuple("postfix", new String[]{"'('", "disjunct", "')'", "'+'"}));
        rules.add(new RuleTuple("postfix", new String[]{"'('", "disjunct", "')'", "'?'"}));
        rules.add(new RuleTuple("postfix", new String[]{"'('", "disjunct", "')'"}));
        rules.add(new RuleTuple("postfix", new String[]{"'('", "disjunct", "')'", "'='", "'>'", "disjunct"}));
        rules.add(new RuleTuple("postfix", new String[]{"identifier", "'='", "postfix"}));
        rules.add(new RuleTuple("postfix", new String[]{"identifier", "'+'", "'='", "postfix"}));
        rules.add(new RuleTuple("concat", new String[]{"postfix"}));
        rules.add(new RuleTuple("concat", new String[]{"concat", "postfix"}));
        rules.add(new RuleTuple("disjunct", new String[]{"concat"}));
        rules.add(new RuleTuple("disjunct", new String[]{"'|'", "concat"}));
        rules.add(new RuleTuple("disjunct", new String[]{"disjunct", "'|'", "concat"}));
        rules.add(new RuleTuple("disjunct", new String[]{"disjunct", "'|'"}));
        rules.add(new RuleTuple("rule", new String[]{"variable", "':'", "disjunct", "';'"}));
        rules.add(new RuleTuple("rule", new String[]{"variable", "':'", "';'"}));
        rules.add(new RuleTuple("rule", new String[]{"variable", "':'", "':'", "'='", "disjunct"}));
        rules.add(new RuleTuple("rule", new String[]{"'-'", "variable", "';'"}));
        rules.add(new RuleTuple("grammar", new String[]{"rule"}));
        rules.add(new RuleTuple("grammar", new String[]{"grammar", "rule"}));
        TreeSet<RuleTuple> nonEmptyRules = rules;
        return nonEmptyRules;
    }

    public static ParseNode parseGrammarFile(List<LexerToken> src, String input) {
        return Grammar.parseGrammarFile(src, input, earley);
    }

    public static ParseNode parseGrammarFile(List<LexerToken> src, String input, Earley parser) {
        Matrix matrix = new Matrix(parser);
        parser.parse(src, matrix);
        SyntaxError s = SyntaxError.checkSyntax(input, new String[]{"grammar"}, src, parser, matrix);
        if (s != null) {
            if (matrix.visual != null) {
                matrix.visual.draw(matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + s.line);
            System.out.println(s.code);
            System.out.println(s.marker);
            System.out.println("Expected:  ");
            for (String tmp : s.getSuggestions()) {
                System.out.print(tmp + ",");
            }
            throw new AssertionError((Object)s.toString());
        }
        ParseNode root = parser.forest(src, matrix);
        return root;
    }

    public static void grammar(ParseNode root, List<LexerToken> src, Set<RuleTuple> grammar) {
        if (root.contains(rule)) {
            Grammar.rule(root, src, grammar);
        } else {
            for (ParseNode child : root.children()) {
                Grammar.grammar(child, src, grammar);
            }
        }
    }

    private static void rule(ParseNode node, List<LexerToken> src, Set<RuleTuple> grammar) {
        ruleRoot = node;
        String header = null;
        boolean isEmpty = true;
        for (ParseNode child : node.children()) {
            if (header == null && child.contains(minus)) {
                Grammar.delete(node, src, grammar);
                return;
            }
            if (header == null && child.contains(variable)) {
                header = child.content(src);
                continue;
            }
            if (child.contains(disjunct)) {
                grammar.addAll(Grammar.disjunct(header, child, src));
                isEmpty = false;
                continue;
            }
            if (child.contains(colon) || child.contains(equality)) continue;
            if (child.contains(semicolon)) {
                if (!isEmpty) continue;
                grammar.add(new RuleTuple(header, new String[0]));
                continue;
            }
            throw new AssertionError((Object)"not expr?");
        }
    }

    private static void delete(ParseNode node, List<LexerToken> src, Set<RuleTuple> grammar) {
        String var = null;
        for (ParseNode child : node.children()) {
            if (var != null || !child.contains(variable)) continue;
            var = child.content(src);
            break;
        }
        TreeSet<RuleTuple> deletions = new TreeSet<RuleTuple>();
        block1: for (RuleTuple t : grammar) {
            if (t.head.equals(var)) {
                deletions.add(t);
                continue;
            }
            for (String rhs : t.rhs) {
                if (!rhs.equals(var)) continue;
                deletions.add(t);
                continue block1;
            }
        }
        grammar.removeAll(deletions);
    }

    private static Set<RuleTuple> disjunct(String header, ParseNode node, List<LexerToken> src) {
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        if (node.contains(concat)) {
            ret.add(new RuleTuple(header, Grammar.concat(header, node, src, ret)));
        } else {
            int cnt = -1;
            int lastOrPos = -1;
            for (ParseNode child : node.children()) {
                ++cnt;
                if (child.contains(disjunct)) {
                    ret.addAll(Grammar.disjunct(header, child, src));
                } else if (child.contains(concat)) {
                    ret.add(new RuleTuple(header, Grammar.concat(header, child, src, ret)));
                }
                if (lastOrPos + 1 == cnt && child.contains(or)) {
                    ret.add(new RuleTuple(header, new String[0]));
                }
                if (!child.contains(or)) continue;
                lastOrPos = cnt;
                if (cnt != node.children().size() - 1) continue;
                ret.add(new RuleTuple(header, new String[0]));
            }
        }
        return ret;
    }

    private static List<String> concat(String header, ParseNode node, List<LexerToken> src, Set<RuleTuple> grammar) {
        LinkedList<String> payload = new LinkedList<String>();
        if (node.contains(postfix)) {
            payload.add(Grammar.postfix(header, node, src, grammar));
        } else {
            for (ParseNode child : node.children()) {
                if (child.contains(postfix)) {
                    payload.add(Grammar.postfix(header, child, src, grammar));
                    continue;
                }
                if (child.contains(concat)) {
                    payload.addAll(Grammar.concat(header, child, src, grammar));
                    continue;
                }
                throw new AssertionError((Object)"!concat & !postfix?");
            }
        }
        return payload;
    }

    private static String postfix(String header, ParseNode node, List<LexerToken> src, Set<RuleTuple> grammar) {
        if (node.contains(variable)) {
            return Grammar.variable(node, src, grammar);
        }
        String head = null;
        String rhs = null;
        for (ParseNode child : node.children()) {
            if (child.contains(oparen) || child.contains(cparen)) continue;
            if (child.contains(variable)) {
                rhs = Grammar.variable(child, src, grammar);
                continue;
            }
            if (child.contains(disjunct)) {
                rhs = Grammar.auxiliarySymbol(header, node);
                grammar.addAll(Grammar.disjunct(rhs, child, src));
                continue;
            }
            if (rhs != null) {
                if (child.contains(star)) {
                    head = Grammar.auxiliarySymbol(header, node);
                    grammar.add(new RuleTuple(head, new String[0]));
                    grammar.add(new RuleTuple(head, new String[]{head, rhs}));
                    continue;
                }
                if (child.contains(plus)) {
                    head = Grammar.auxiliarySymbol(header, node);
                    grammar.add(new RuleTuple(head, new String[]{rhs}));
                    grammar.add(new RuleTuple(head, new String[]{head, rhs}));
                    continue;
                }
                if (!child.contains(question)) continue;
                head = Grammar.auxiliarySymbol(header, node);
                grammar.add(new RuleTuple(head, new String[0]));
                grammar.add(new RuleTuple(head, new String[]{rhs}));
                continue;
            }
            if (child.contains("identifier") || child.contains("'='") || child.contains("'+'")) continue;
            if (child.contains(postfix)) {
                return Grammar.postfix(header, child, src, grammar);
            }
            throw new AssertionError((Object)"unexpected case");
        }
        if (head != null) {
            return head;
        }
        return rhs;
    }

    private static String auxiliarySymbol(String head, ParseNode node) {
        String tmp = head;
        if (tmp.charAt(0) == '\"') {
            tmp = tmp.substring(1, tmp.length() - 1);
        }
        if (0 < tmp.indexOf(91)) {
            tmp = tmp.substring(0, tmp.indexOf(91));
        }
        return "\"" + tmp + "[" + (node.from - Grammar.ruleRoot.from) + "," + (node.to - Grammar.ruleRoot.from) + ")\"";
    }

    private static String variable(ParseNode node, List<LexerToken> src, Set<RuleTuple> grammar) {
        String prefix = src.get((int)node.from).content;
        if (node.from + 1 == node.to) {
            return prefix;
        }
        if (node.from + 6 == node.to && ")".equals(src.get((int)(node.to - 1)).content)) {
            return src.get((int)node.from).content + src.get((int)(node.from + 1)).content + src.get((int)(node.from + 2)).content + src.get((int)(node.from + 3)).content + src.get((int)(node.from + 4)).content + src.get((int)(node.from + 5)).content;
        }
        String postfix = src.get((int)(node.from + 2)).content;
        String header = prefix + "[" + postfix + "]";
        String quotetedHdr = "\"" + header + "\"";
        for (int i = 0; i < postfix.length() + 1; ++i) {
            grammar.add(new RuleTuple(quotetedHdr, new String[]{"'" + prefix + postfix.substring(0, i) + "'"}));
        }
        return quotetedHdr;
    }

    public static Earley constructParser(Class location, String grammarFile) throws IOException {
        String input = Service.readFile(location, grammarFile);
        List<LexerToken> src = Lexer.parse(input, false, 1);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, rules);
        Earley ret = new Earley(rules){

            @Override
            protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
                LexerToken token = src.get(y);
                return symbol == this.identifier && token.type == Token.IDENTIFIER || symbol == this.identifier && token.type == Token.DQUOTED_STRING;
            }
        };
        return ret;
    }
}

