/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Visual;

public abstract class Matriceable {
    public Visual visual = null;
    public Parser parser = null;
    public Queue<Long> completionQueue = new LinkedList<Long>();

    abstract Cell get(int var1, int var2);

    abstract List<Integer> getEarleyBackptrs(int var1, int var2, Cell var3, int var4);

    abstract Matriceable recalc();

    public boolean contains(int x, int y, int symbol) {
        Cell cell = this.get(x, y);
        if (cell == null) {
            return false;
        }
        for (int i = 0; i < cell.size(); ++i) {
            Parser.Tuple tuple = this.parser.rules[cell.getRule(i)];
            if (tuple.head != symbol || tuple.rhs.length != cell.getPosition(i)) continue;
            return true;
        }
        return false;
    }

    public void enqueue(long candidate) {
        this.completionQueue.add(candidate);
    }

    public long dequeue() {
        if (this.completionQueue.isEmpty()) {
            return -1L;
        }
        return this.completionQueue.remove();
    }

    public Visual getVisual() {
        return this.visual;
    }
}

