/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LeafNode;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.util.Array;

public abstract class Parser
implements Serializable {
    public String[] allSymbols = new String[0];
    public Map<String, Integer> symbolIndexes = new HashMap<String, Integer>();
    public Tuple[] rules;

    public Parser(Set<RuleTuple> originalRules) {
        this.extractSymbols(originalRules);
        this.rules = new Tuple[originalRules.size()];
        int p = 0;
        for (RuleTuple t : originalRules) {
            if (t.rhs.length == 0) {
                throw new AssertionError((Object)("empty production " + t.toString()));
            }
            int h = this.symbolIndexes.get(t.head);
            int[] rhs = new int[t.rhs.length];
            for (int i = 0; i < rhs.length; ++i) {
                rhs[i] = this.symbolIndexes.get(t.rhs[i]);
            }
            this.rules[p++] = new Tuple(h, rhs);
        }
    }

    public Parser() {
    }

    protected void extractSymbols(Set<RuleTuple> symbolicRules) {
        TreeSet<String> tmpSymbols = new TreeSet<String>();
        String nnil = "!nil";
        if (!this.symbolIndexes.containsKey(nnil)) {
            tmpSymbols.add(nnil);
        }
        for (RuleTuple ct : symbolicRules) {
            if (ct.head == null || ct.rhs.length == 0 || ct.rhs[0] == null || ct.rhs.length > 1 && ct.rhs[1] == null) {
                throw new AssertionError((Object)("grammar has null symbols (or empty productions): " + ct.toString()));
            }
            if (!this.symbolIndexes.containsKey(ct.head)) {
                tmpSymbols.add(ct.head);
            }
            for (String s : ct.rhs) {
                if (this.symbolIndexes.containsKey(s)) continue;
                tmpSymbols.add(s);
            }
        }
        int k = this.allSymbols.length;
        this.allSymbols = Arrays.copyOf(this.allSymbols, this.allSymbols.length + tmpSymbols.size());
        for (String s : tmpSymbols) {
            this.symbolIndexes.put(s, k);
            this.allSymbols[k] = s;
            ++k;
        }
    }

    protected void extractSymbolsOld(Set<RuleTuple> originalRules) {
        TreeSet<String> tmpSymbols = new TreeSet<String>();
        tmpSymbols.add("!nil");
        for (RuleTuple ct : originalRules) {
            if (ct.head == null || ct.rhs.length == 0 || ct.rhs[0] == null || ct.rhs.length > 1 && ct.rhs[1] == null) {
                throw new AssertionError((Object)"grammar has null symbols (or empty productions)");
            }
            tmpSymbols.add(ct.head);
            for (String s : ct.rhs) {
                tmpSymbols.add(s);
            }
        }
        this.allSymbols = new String[tmpSymbols.size()];
        this.symbolIndexes = new HashMap<String, Integer>();
        int k = 0;
        for (String s : tmpSymbols) {
            this.symbolIndexes.put(s, k);
            this.allSymbols[k] = s;
            ++k;
        }
    }

    public boolean isTerminal(int terminal) {
        return this.allSymbols[terminal].charAt(0) == '\'';
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix) {
        return this.forest(src, matrix, false);
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix, boolean full) {
        return this.forest(src, matrix, false, null);
    }

    protected boolean isAsc(int ruleHead) {
        return false;
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix, boolean full, String input) {
        HashMap explored = new HashMap();
        try {
            int len = src.size();
            if (len == 0) {
                return new ParseNode(0, len, -1, this);
            }
            EarleyCell cell = matrix.get(0, len);
            if (cell != null && 0 < cell.size()) {
                ParseNode root = this.treeForACell(src, matrix, cell, 0, len);
                if ((root = this.replaceLeaves(root, input, src)) != null) {
                    return root;
                }
            }
            ParseNode pseudoRoot = new ParseNode(0, len, -1, this);
            int X = 0;
            int Y = matrix.lastY();
            for (int offset = 0; offset < Y; ++offset) {
                for (int t = 0; t < offset + 1; ++t) {
                    int x = X + t;
                    int y = Y + t - offset;
                    ParseNode coverX = pseudoRoot.coveredByOnTopLevel(x);
                    ParseNode coverY = pseudoRoot.coveredByOnTopLevel(y);
                    while (coverX != null || coverY != null) {
                        int delta = 0;
                        if (coverX != null) {
                            delta = coverX.to - y + 1;
                        }
                        if (coverY != null) {
                            delta = coverY.to - y + 1;
                        }
                        if (delta <= 0) break;
                        x = X + (t += delta);
                        y = Y + t - offset;
                        coverX = pseudoRoot.coveredByOnTopLevel(x);
                        coverY = pseudoRoot.coveredByOnTopLevel(y);
                    }
                    if (offset + 1 <= t || (cell = matrix.get(x, y)) == null) continue;
                    explored = new HashMap();
                    ParseNode node = this.treeForACell(src, matrix, cell, x, y);
                    if (node == null) continue;
                    pseudoRoot.addTopLevel(node);
                    node.parent = pseudoRoot;
                    if (full) continue;
                    pseudoRoot = this.replaceLeaves(pseudoRoot, input, src);
                    return pseudoRoot;
                }
            }
            if (full) {
                pseudoRoot = this.replaceLeaves(pseudoRoot, input, src);
                return pseudoRoot;
            }
            return new ParseNode(0, 1, -1, this);
        }
        catch (AssertionError e) {
            System.err.println("Parser.forest(): AssertionError " + ((Throwable)((Object)e)).getMessage());
            return null;
        }
    }

    private ParseNode replaceLeaves(ParseNode root, String input, List<LexerToken> src) {
        if (input == null) {
            return root;
        }
        for (ParseNode node = root; node != null; node = node.next()) {
            ParseNode parent;
            if (node.from + 1 != node.to || (parent = node.parent) == null) continue;
            LeafNode leaf = new LeafNode(node.from, node.to, -1, node.parser, src, input);
            leaf.parent = parent;
            leaf.symbols = node.symbols;
            if (parent.lft == node) {
                parent.lft = leaf;
                continue;
            }
            if (parent.rgt == node) {
                parent.rgt = leaf;
                continue;
            }
            TreeSet<ParseNode> newTopLevel = new TreeSet<ParseNode>();
            for (ParseNode child : parent.topLevel) {
                if (child == node) {
                    newTopLevel.add(node);
                    continue;
                }
                newTopLevel.add(child);
            }
            parent.topLevel = newTopLevel;
        }
        return root;
    }

    public abstract ParseNode parse(List<LexerToken> var1);

    ParseNode treeForACell(List<LexerToken> src, Matrix m, EarleyCell cell, int x, int y) {
        throw new AssertionError((Object)"Abstract method");
    }

    void parse(List<LexerToken> src, Matriceable matrix) {
        throw new AssertionError((Object)"Abstract method");
    }

    void toHtml(int ruleNo, int pos, boolean selected, int x, int mid, int y, Matriceable matrix, StringBuffer sb) {
        throw new AssertionError((Object)"Abstract method");
    }

    public int getSymbol(String string) {
        try {
            return this.symbolIndexes.get(string);
        }
        catch (NullPointerException e) {
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void printOrderedRules(String symbol, boolean headOnly, boolean exactMatch) {
        for (int i = 0; i < this.rules.length; ++i) {
            Tuple tuple = this.rules[i];
            if (!exactMatch && this.allSymbols[tuple.head].contains(symbol) || exactMatch && this.allSymbols[tuple.head].equals(symbol)) {
                System.out.println(i + "     " + tuple.toString());
            }
            if (headOnly) continue;
            for (int rhsi : tuple.rhs) {
                if ((exactMatch || !this.allSymbols[rhsi].contains(symbol)) && (!exactMatch || !this.allSymbols[rhsi].equals(symbol))) continue;
                System.out.println(i + "     " + tuple.toString());
            }
        }
    }

    public Tuple[] invertRules() {
        Tuple[] ret = new Tuple[this.rules.length];
        for (int i = 0; i < this.rules.length; ++i) {
            Tuple rule = this.rules[i];
            int head = rule.head;
            int[] rhs = new int[rule.rhs.length];
            for (int j = 0; j < rhs.length; ++j) {
                rhs[rhs.length - j - 1] = rule.rhs[j];
            }
            ret[i] = new Tuple(head, rhs);
        }
        return ret;
    }

    public void swapRules(String rule2, String rule3) {
        Tuple t2 = null;
        int i2 = -1;
        Tuple t3 = null;
        int i3 = -1;
        for (int i = 0; i < this.rules.length; ++i) {
            Tuple t = this.rules[i];
            if (rule2.equals(t.toString())) {
                t2 = t;
                i2 = i;
            }
            if (!rule3.equals(t.toString())) continue;
            t3 = t;
            i3 = i;
        }
        this.rules[i2] = t3;
        this.rules[i3] = t2;
    }

    public boolean isAuxNode(int symbol) {
        return false;
    }

    protected static long makeMatrixCellElem(int rule, int pos, Tuple t) {
        long activeVar = 0L;
        if (pos < t.rhs.length) {
            activeVar = t.rhs[pos];
        }
        return (long)rule << 16 | (long)pos | activeVar << 48;
    }

    public static int ruleFromEarleyCell(long code) {
        return (int)((code & 0xFFFFFFFFFFFFL) >> 16);
    }

    public static int posFromEarleyCell(long code) {
        return (int)(code & 0xFFFFL);
    }

    public static int activeVarFromEarleyCell(long code) {
        return (int)(code >> 48);
    }

    public class EarleyCell
    implements Cell {
        long[] content = null;

        public EarleyCell(long[] content) {
            this.content = content;
        }

        @Override
        public int getRule(int index) {
            return Parser.ruleFromEarleyCell(this.content[index]);
        }

        @Override
        public int getPosition(int index) {
            return Parser.posFromEarleyCell(this.content[index]);
        }

        @Override
        public int size() {
            if (this.content == null) {
                return 0;
            }
            return this.content.length;
        }

        @Override
        public long[] getContent() {
            return this.content;
        }

        @Override
        public void insertContent(long cellElem) {
            this.content = Array.insert(this.content, cellElem);
        }

        public LinkedList<Long> orderedContent() {
            LinkedList<Long> ret = new LinkedList<Long>();
            for (long l : this.getContent()) {
                ret.add(l);
            }
            ret.sort(new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    Tuple t1 = Parser.this.rules[Parser.ruleFromEarleyCell(o1)];
                    Tuple t2 = Parser.this.rules[Parser.ruleFromEarleyCell(o2)];
                    return t2.compareTo(t1);
                }
            });
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{ ");
            for (int i = 0; i < this.content.length; ++i) {
                if (0 < i) {
                    sb.append(" , ");
                }
                Tuple t = Parser.this.rules[this.getRule(i)];
                sb.append(t.toString(this.getPosition(i)));
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public class Tuple
    implements Comparable<Tuple>,
    Serializable {
        public int head;
        public int[] rhs;

        public Tuple(int h, int[] r) {
            this.head = h;
            this.rhs = r;
        }

        public int size() {
            return this.rhs.length;
        }

        public int content(int i) {
            return this.rhs[i];
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Tuple && this.compareTo((Tuple)obj) == 0;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode inconsistent with equals");
        }

        @Override
        public int compareTo(Tuple src) {
            if (this.head == 0 || src.head == 0) {
                throw new RuntimeException("head==0 || src.head==0");
            }
            int cmp = this.head - src.head;
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.rhs.length - src.rhs.length;
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < this.rhs.length; ++i) {
                cmp = this.rhs[i] - src.rhs[i];
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        public String toString() {
            StringBuilder s = new StringBuilder(Parser.this.allSymbols[this.head] + ":");
            for (int i : this.rhs) {
                s.append("  " + Parser.this.allSymbols[i]);
            }
            s.append(";");
            return s.toString();
        }

        public String toString(int pos) {
            StringBuilder s = new StringBuilder(Parser.this.allSymbols[this.head] + ":");
            for (int i = 0; i < this.rhs.length; ++i) {
                s.append(' ');
                if (pos == i) {
                    s.append('!');
                }
                s.append(Parser.this.allSymbols[this.rhs[i]]);
            }
            if (pos == this.rhs.length) {
                s.append('!');
            }
            s.append(";");
            return s.toString();
        }
    }
}

