/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.json;

public class Util {
    static String specialEncoding = "^$%s%$^";

    public static String cleanText(String input) {
        String ret = input;
        if (ret.startsWith("\"")) {
            ret = ret.substring(1, ret.length() - 1);
        }
        ret = ret.replace("\\\\", specialEncoding);
        ret = ret.replace("\\\"", "\"");
        ret = ret.replace("\\r", "\r");
        ret = ret.replace("\\n", "\n");
        ret = ret.replace("\\t", "\t");
        ret = ret.replace("\\b", "\b");
        ret = ret.replace("\\f", "\f");
        ret = ret.replace(specialEncoding, "\\");
        return ret;
    }

    public static String sugarcoatText(String input) {
        if (input == null) {
            return null;
        }
        String ret = input;
        ret = ret.replace("\\", "\\\\");
        ret = ret.replace("\r", "\\r");
        ret = ret.replace("\n", "\\n");
        ret = ret.replace("\t", "\\t");
        ret = ret.replace("\b", "\\b");
        ret = ret.replace("\f", "\\f");
        ret = ret.replace("\"", "\\\"");
        StringBuilder b = new StringBuilder();
        for (char c : ret.toCharArray()) {
            if (c >= '\u0080') {
                b.append("\\u").append(String.format("%04X", c));
                continue;
            }
            if (c < ' ') {
                b.append('?');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }
}

