/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.mysql;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Service;

public class MysqlRules {
    public static void main(String[] args) throws Exception {
        boolean T = true;
        boolean F = false;
        Set<RuleTuple> rules = MysqlRules.getRules();
        System.out.println(rules.size());
    }

    static Set<RuleTuple> getRules() throws Exception {
        Set<RuleTuple> rules = MysqlRules.parseBNFtext(MysqlRules.readBNFfile());
        rules.add(new RuleTuple("simpleId", new String[]{"identifier"}));
        rules.add(new RuleTuple("simpleId", new String[]{"'?'"}));
        MysqlRules.substitute(rules, "'STRING_USER_NAME'", "STRING_USER_NAME");
        rules.add(new RuleTuple("STRING_USER_NAME", new String[]{"string_literal", "'@'", "string_literal"}));
        rules.add(new RuleTuple("STRING_USER_NAME", new String[]{"identifier", "'@'", "string_literal"}));
        rules.add(new RuleTuple("STRING_USER_NAME", new String[]{"string_literal", "'@'", "identifier"}));
        rules.add(new RuleTuple("STRING_USER_NAME", new String[]{"identifier", "'@'", "identifier"}));
        MysqlRules.substitute(rules, "'LOCAL_ID'", "LOCAL_ID");
        rules.add(new RuleTuple("LOCAL_ID", new String[]{"'@'", "identifier"}));
        MysqlRules.substitute(rules, "'GLOBAL_ID'", "GLOBAL_ID");
        rules.add(new RuleTuple("GLOBAL_ID", new String[]{"'@'", "'@'", "identifier"}));
        rules.add(new RuleTuple("GLOBAL_ID", new String[]{"'@'", "'@'", "identifier", "'.'", "identifier"}));
        MysqlRules.substitute(rules, "'ID'", "ID");
        rules.add(new RuleTuple("ID", new String[]{"identifier"}));
        MysqlRules.substitute(rules, "'DECIMAL_LITERAL'", "DECIMAL_LITERAL");
        rules.add(new RuleTuple("DECIMAL_LITERAL", new String[]{"digits"}));
        rules.add(new RuleTuple("DECIMAL_LITERAL", new String[]{"digits", "'.'", "digits"}));
        rules.add(new RuleTuple("DECIMAL_LITERAL", new String[]{"'.'", "digits"}));
        rules.add(new RuleTuple("DECIMAL_LITERAL", new String[]{"DECIMAL_LITERAL", "'E'", "digits"}));
        RuleTransforms.eliminateEmptyProductions(rules);
        return rules;
    }

    public static Set<RuleTuple> parseBNFtext(String input) throws Exception {
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        List<LexerToken> src1 = LexerToken.parse(input, true, 41);
        ArrayList<LexerToken> src = new ArrayList<LexerToken>();
        for (int i = 0; i < src1.size(); ++i) {
            LexerToken current = src1.get(i);
            if (current.type == Token.WS || current.type == Token.LINE_COMMENT || current.type == Token.COMMENT) continue;
            try {
                LexerToken next = src1.get(i + 1);
                LexerToken secondNext = src1.get(i + 2);
                if (":".equals(next.content) && secondNext.type != Token.WS || ":".equals(current.content) && next.type != Token.WS) {
                    continue;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (current.type == Token.IDENTIFIER && current.content.toUpperCase().equals(current.content)) {
                current.content = "'" + current.content.toUpperCase() + "'";
            }
            src.add(current);
        }
        ParseNode root = Grammar.parseGrammarFile(src, input);
        Grammar.grammar(root, src, ret);
        return ret;
    }

    private static void substitute(Set<RuleTuple> ret, String expr, String subst) {
        TreeSet<RuleTuple> delete = new TreeSet<RuleTuple>();
        TreeSet<RuleTuple> add = new TreeSet<RuleTuple>();
        boolean replace = false;
        for (RuleTuple r : ret) {
            RuleTuple clone = new RuleTuple(r.head, new String[r.rhs.length]);
            if (r.head.equals(expr)) {
                clone.head = subst;
                replace = true;
            }
            for (int i = 0; i < r.rhs.length; ++i) {
                if (r.rhs[i].equals(expr)) {
                    clone.rhs[i] = subst;
                    replace = true;
                    continue;
                }
                clone.rhs[i] = r.rhs[i];
            }
            if (!replace) continue;
            delete.add(r);
            add.add(clone);
        }
        ret.removeAll(delete);
        ret.addAll(add);
    }

    public static Set<String> getKeywords(Set<RuleTuple> rules) {
        TreeSet<String> ret = new TreeSet<String>();
        for (RuleTuple rule : rules) {
            for (String token : rule.rhs) {
                if (!token.startsWith("'")) continue;
                ret.add(token);
            }
        }
        return ret;
    }

    static String readBNFfile() throws Exception {
        String rulesTxt = Service.readFile(MysqlRules.class, "MySQLParser.g");
        String startPattern = "// Top Level Description";
        rulesTxt = rulesTxt.substring(rulesTxt.indexOf(startPattern) + startPattern.length());
        rulesTxt = MysqlRules.removeNestedBlock(rulesTxt, "/*", "*/");
        rulesTxt = MysqlRules.removeNestedBlock(rulesTxt, "{", "}?");
        rulesTxt = MysqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = MysqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = MysqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = MysqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = MysqlRules.removeNestedBlock(rulesTxt, "#", "\r\n");
        rulesTxt = rulesTxt.replace("DOT", "'.'");
        rulesTxt = rulesTxt.replace("SEMICOLON", "';'");
        rulesTxt = rulesTxt.replace(" SEMI", " ';'");
        rulesTxt = rulesTxt.replace("COLON", "':'");
        rulesTxt = rulesTxt.replace("COMMA", "','");
        rulesTxt = rulesTxt.replace("LPAREN", "'('");
        rulesTxt = rulesTxt.replace("RPAREN", "')'");
        rulesTxt = rulesTxt.replace("PLUS", "'+'");
        rulesTxt = rulesTxt.replace("MINUS", "'-'");
        rulesTxt = rulesTxt.replace("TILDE", "'~'");
        rulesTxt = rulesTxt.replace("!", "");
        rulesTxt = rulesTxt.replace("^", "");
        rulesTxt = rulesTxt.replace("NULL_LITERAL", "'NULL'");
        rulesTxt = rulesTxt.replace("FILESIZE_LITERAL", "( digits+ ('K'|'M'|'G'|'T'))");
        rulesTxt = rulesTxt.replace("START_NATIONAL_STRING_LITERAL", "'N' string_literal");
        rulesTxt = rulesTxt.replace("STRING_LITERAL", "string_literal");
        rulesTxt = rulesTxt.replace("HEXADECIMAL_LITERAL", "'x' digits");
        rulesTxt = rulesTxt.replace("REAL_LITERAL", "digits");
        rulesTxt = rulesTxt.replace("NULL_SPEC_LITERAL", "'\\' 'N'");
        rulesTxt = rulesTxt.replace("ID_LITERAL", "identifier");
        return rulesTxt;
    }

    static String removeNestedBlock(String src, String br1, String br2) {
        return MysqlRules.removeNestedBlock(src, br1, br2, "");
    }

    static String removeNestedBlock(String src, String br1, String br2, String replacement) {
        int len1 = br1.length();
        int len2 = br2.length();
        int beg = 0;
        int end = 0;
        StringBuffer out = new StringBuffer();
        while (beg < src.length()) {
            beg = src.indexOf(br1, end);
            int beg1 = src.indexOf(br1, beg + len1);
            int end1 = src.indexOf(br2, beg + len1) + len2;
            if (beg > 0 && beg < beg1 && beg1 < end1) {
                out.append(src.substring(end, beg + len1));
                out.append(replacement);
                end = beg + len1 + replacement.length();
                continue;
            }
            if (beg < 0) {
                beg = src.length();
            }
            out.append(src.substring(end, beg));
            out.append(replacement);
            end = src.indexOf(br2, beg + len1) + len2 + replacement.length();
            if (end >= len2) continue;
            out.append(src.substring(beg));
            break;
        }
        return out.toString();
    }
}

