/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parseable;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.UnifiedRules;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class SqlEarley
extends Earley
implements Parseable {
    public static boolean visualize = false;
    private static SqlEarley partialRecInst = null;
    private static SqlEarley fullRecInst = null;
    private static Set<RuleTuple> origRules = null;
    private int as;
    private int aliased_dml_table_expression_clause;
    private int basic_decl_item;
    private int begin;
    private int body;
    private int boolean_primary;
    private int compound_expression;
    public int CONNECT;
    private int dbtools_lexeme;
    private int dotted_name;
    public int decl_id;
    private int distinct;
    private int ELSE;
    private int expr;
    private int grouping_expression_list;
    private int json_object_arg_list;
    public int multiset_except;
    private int pkg_spec;
    private int pls_expr;
    public int query_block;
    public int REPLACE;
    public int select;
    public int simple_expression;
    public int sim_stmt;
    private int singleExpression;
    public int sql_statement;
    public int sql_statements;
    public int sqlplus_lexeme;
    private int start;
    public int stmt;
    public int subquery;
    public int table_reference;
    private int unlabeled_nonblock_stmt;
    private int user_defined_types;
    private int VAR;
    private int where_gby_hier;
    private int[] whatToRecognize = new int[0];
    boolean isAsc = false;
    public static String[] keywords = new String[]{"'WITH'", "'SELECT'", "'FROM'", "'WHERE'", "'AND'", "'OR'", "'NOT'", "'DISTINCT'", "'UNION'", "'ALL'", "'NATURAL'", "'ON'", "'INSERT'", "'UPDATE'", "'CREATE'", "'ALTER'", "'TABLE'", "'VALUES'", "'VARCHAR2'", "'INTEGER'", "'WHEN'"};
    private Set<Integer> _keywords = new TreeSet<Integer>();

    public static void main(String[] args) throws Exception {
        System.setProperty("sun.java2d.uiScale", "1");
        visualize = true;
        String file = "example.sql";
        String input = Service.readFile(SqlEarley.class, file);
        if (1 == args.length) {
            input = args[0];
        }
        if ("MSC_CL_PRE_PROCESS.pkgbdy".equals(file)) {
            System.out.println("***** Benchmark:   Lex time = 650\nEarley parse time = 5861\n213089 tokens, top = { create: create_plsql!; ...\nReduction time = 416\n");
        }
        long t1 = System.currentTimeMillis();
        SqlEarley earley = SqlEarley.getInstance();
        long t2 = System.currentTimeMillis();
        System.out.println("Earley init time = " + (t2 - t1));
        boolean T = true;
        boolean F = false;
        earley.printOrderedRules("json_value___0", true, false);
        int maxRuleLen = 0;
        for (Parser.Tuple rule : SqlEarley.getInstance().rules) {
            if (maxRuleLen < rule.rhs.length) {
                maxRuleLen = rule.rhs.length;
            }
            if (rule.rhs.length != 1 || rule.head != rule.rhs[0]) continue;
            System.out.println("***** " + SqlEarley.getInstance().allSymbols[rule.head] + ":" + SqlEarley.getInstance().allSymbols[rule.head]);
        }
        System.out.println("----rules=" + SqlEarley.getInstance().rules.length);
        System.out.println("----maxRuleLen=" + maxRuleLen);
        System.out.println("!nil=" + SqlEarley.getInstance().getSymbol("!nil"));
        System.out.println("allSymbols[0]=" + SqlEarley.getInstance().allSymbols[0]);
        System.out.println("allSymbols[1]=" + SqlEarley.getInstance().allSymbols[1]);
        System.out.println("allSymbols[2]=" + SqlEarley.getInstance().allSymbols[2]);
        SqlEarley.parse(input);
    }

    public static void amendGrammar() throws IOException {
        String input = Service.readFile(SqlEarley.class, "amended.grammar");
        List<LexerToken> src = Lexer.parse(input);
        ParseNode root = Grammar.parseGrammarFile(src, input);
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        Grammar.grammar(root, src, rules);
        SqlEarley.extendGrammar(rules);
    }

    public static void parse(String input) throws IOException, AssertionError {
        Parser.EarleyCell top;
        long t1 = System.currentTimeMillis();
        List<LexerToken> src = Lexer.parse(input);
        if (src.size() > Integer.MAX_VALUE) {
            throw new AssertionError((Object)(src.size() + " tokens"));
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Lex time = " + (t2 - t1));
        if (src.size() < 100) {
            LexerToken.print(src);
        }
        SqlEarley earley = SqlEarley.getInstance();
        earley = SqlEarley.partialRecognizer();
        Matrix matrix = new Matrix(earley);
        if (visualize && src.size() < 1000) {
            matrix.visual = new Visual(src, earley);
        }
        if (!visualize) {
            matrix.visual = null;
        }
        t1 = System.currentTimeMillis();
        earley.parse(src, matrix);
        t2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (t2 - t1));
        if (matrix.visual != null) {
            matrix.visual.draw(matrix);
        }
        if ((top = matrix.get(0, src.size())) == null) {
            System.out.println((Object)SyntaxError.checkSyntax(input, new String[]{"sql_statements", "select", "insert", "update", "delete", "merge"}));
            return;
        }
        System.out.println(src.size() + " tokens, top = " + ((Object)top).toString());
        t1 = System.currentTimeMillis();
        ParseNode root = earley.forest(src, matrix, true, input);
        t2 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (t2 - t1));
        if (src.size() < 1000) {
            root.printTree();
        } else {
            root.printTree(10);
        }
    }

    public static SqlEarley partialRecognizer() {
        if (partialRecInst == null) {
            partialRecInst = SqlEarley.newPartialRecognizer();
        }
        return partialRecInst;
    }

    public static SqlEarley newPartialRecognizer() {
        return SqlEarley.newPartialRecognizer(new String[]{"sql_statements", "subprg_body", "expr"});
    }

    public static SqlEarley newPartialRecognizer(String[] what2Recognize) {
        SqlEarley ret = new SqlEarley(){

            @Override
            protected boolean lookaheadOK(Parser.Tuple t, int pos, Matrix matrix) {
                return true;
            }

            @Override
            protected boolean scan(Matrix matrix, List<LexerToken> src) {
                boolean ret = super.scan(matrix, src);
                matrix.LAsuspect = null;
                return ret;
            }
        };
        for (String symbol : what2Recognize) {
            ret.addSymbol2Recognize(symbol);
        }
        return ret;
    }

    public static synchronized SqlEarley getInstance() {
        if (fullRecInst == null) {
            fullRecInst = SqlEarley.newFullRecognizer();
        }
        return fullRecInst;
    }

    private static SqlEarley newFullRecognizer() {
        SqlEarley ret = new SqlEarley();
        ret.addSymbol2Recognize("sql_statements");
        ret.addSymbol2Recognize("subprg_body");
        ret.addSymbol2Recognize("expr");
        ret.addSymbol2Recognize("fml_part");
        ret.addSymbol2Recognize("paren_expr_list");
        ret.addSymbol2Recognize("basic_decl_item_list");
        return ret;
    }

    public SqlEarley grammarExtension(Set<RuleTuple> additionalRules) {
        Set<RuleTuple> originalRules = SqlEarley.getRules();
        this.extractSymbols(additionalRules);
        this.rules = Arrays.copyOf(this.rules, originalRules.size() + additionalRules.size());
        int p = originalRules.size();
        for (RuleTuple t : additionalRules) {
            if (t.rhs.length == 0) {
                throw new AssertionError((Object)("empty production " + t.toString()));
            }
            int h = (Integer)this.symbolIndexes.get(t.head);
            int[] rhs = new int[t.rhs.length];
            for (int i = 0; i < rhs.length; ++i) {
                rhs[i] = (Integer)this.symbolIndexes.get(t.rhs[i]);
            }
            this.rules[p++] = new Parser.Tuple(h, rhs);
        }
        return this;
    }

    public static void extendGrammar(Set<RuleTuple> additionalRules) {
        fullRecInst = SqlEarley.newFullRecognizer().grammarExtension(additionalRules);
        partialRecInst = SqlEarley.newPartialRecognizer().grammarExtension(additionalRules);
    }

    static synchronized Set<RuleTuple> getRules() {
        if (origRules == null) {
            try {
                origRules = UnifiedRules.getRules();
                origRules.remove(new RuleTuple("identifier", new String[]{"idq"}));
                origRules.remove(new RuleTuple("identifier", new String[]{"id"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'@'", "dblink", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "'@'", "dblink", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'@'", "dblink", "';'"}));
                origRules.remove(new RuleTuple("create_synonym", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "'PUBLIC'", "'SYNONYM'", "identifier", "'.'", "identifier", "'FOR'", "identifier", "'.'", "identifier", "'@'", "dblink", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "create_database_link___0", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "identifier", "'USING'", "string_literal", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "create_database_link___0", "identifier", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'DATABASE'", "'LINK'", "create_database_link___0", "identifier", "'USING'", "string_literal", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "identifier", "'USING'", "string_literal", "';'"}));
                origRules.remove(new RuleTuple("create_database_link", new String[]{"'CREATE'", "'SHARED'", "'PUBLIC'", "'DATABASE'", "'LINK'", "create_database_link___0", "identifier", "'USING'", "string_literal", "';'"}));
                origRules.remove(new RuleTuple("function_call", new String[]{"name", "'('", "call_arg", "')'"}));
                origRules.remove(new RuleTuple("function_call", new String[]{"name", "'('", "call_arg", "call_arg_list", "')'"}));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return origRules;
    }

    private SqlEarley() {
        this(SqlEarley.getRules());
    }

    private SqlEarley(Set<RuleTuple> rules) {
        super(rules, false);
        this.initKeywords();
        this.as = this.getSymbol("'AS'");
        this.aliased_dml_table_expression_clause = this.getSymbol("aliased_dml_table_expression_clause");
        this.basic_decl_item = this.getSymbol("basic_decl_item");
        this.begin = this.getSymbol("'BEGIN'");
        this.body = this.getSymbol("'BODY'");
        this.boolean_primary = this.getSymbol("boolean_primary");
        this.compound_expression = this.getSymbol("compound_expression");
        this.CONNECT = this.getSymbol("CONNECT");
        this.dbtools_lexeme = this.getSymbol("dbtools_lexeme");
        this.dotted_name = this.getSymbol("dotted_name");
        this.decl_id = this.getSymbol("decl_id");
        this.distinct = this.getSymbol("'DISTINCT'");
        this.ELSE = this.getSymbol("'ELSE'");
        this.expr = this.getSymbol("expr");
        this.grouping_expression_list = this.getSymbol("grouping_expression_list");
        this.json_object_arg_list = this.getSymbol("json_object_arg_list");
        this.multiset_except = this.getSymbol("multiset_except");
        this.pkg_spec = this.getSymbol("pkg_spec");
        this.pls_expr = this.getSymbol("pls_expr");
        this.query_block = this.getSymbol("query_block");
        this.REPLACE = this.getSymbol("'REPLACE'");
        this.select = this.getSymbol("select");
        this.simple_expression = this.getSymbol("simple_expression");
        this.sim_stmt = this.getSymbol("sim_stmt");
        this.singleExpression = this.getSymbol("\"singleExpression\"");
        this.sql_statement = this.getSymbol("sql_statement");
        this.sql_statements = this.getSymbol("sql_statements");
        this.sqlplus_lexeme = this.getSymbol("sqlplus_lexeme");
        this.start = this.getSymbol("'START'");
        this.stmt = this.getSymbol("stmt");
        this.subquery = this.getSymbol("subquery");
        this.table_reference = this.getSymbol("table_reference");
        this.unlabeled_nonblock_stmt = this.getSymbol("unlabeled_nonblock_stmt");
        this.user_defined_types = this.getSymbol("user_defined_types");
        this.VAR = this.getSymbol("'VAR'");
        this.where_gby_hier = this.getSymbol("\"where,gby,hier\"");
        this.prioritizeRules();
    }

    private void prioritizeRules() {
        this.prioritizeRules(this.getSymbol("\"alter_pluggable_database_clause\""), new int[]{this.getSymbol("pdb_datafile_clause"), this.getSymbol("pdb_change_state_from_root")});
        this.prioritizeRules(this.getSymbol("alter_table___0#"), new int[]{this.getSymbol("constraint_clauses"), this.getSymbol("column_clauses"), this.getSymbol("alter_external_table")});
        this.prioritizeRules(this.getSymbol("analytic_function"), new int[]{this.getSymbol("count"), this.getSymbol("nth_value"), this.getSymbol("first_last_value"), this.getSymbol("listagg"), this.getSymbol("lag"), this.getSymbol("lead"), this.getSymbol("sum"), this.getSymbol("min"), this.getSymbol("max"), this.getSymbol("a_f")});
        String plsRule = "assoc_arg:  assoc_name_list  '='  '>'  pls_expr;";
        String sqlRule = "assoc_arg:  sim_expr  '='  '>'  expr;";
        this.swapRules(plsRule, sqlRule);
        this.prioritizeRules(this.getSymbol("basic_d"), new int[]{this.getSymbol("subprg_i"), this.getSymbol("object_d")});
        this.prioritizeRules(this.basic_decl_item, new int[]{this.getSymbol("pragma"), this.getSymbol("basic_d")});
        this.prioritizeRules(this.boolean_primary, new int[]{this.getSymbol("sim_expr"), this.getSymbol("condition"), this.getSymbol("function_expression")});
        String simExprRule = "boolean_primary:  sim_expr;";
        String boolPriRule = "boolean_primary:  condition;";
        this.swapRules(simExprRule, boolPriRule);
        this.prioritizeRules(this.getSymbol("cell_assignment___0"), new int[]{this.getSymbol("multi_column_for_loop"), this.getSymbol("cell_assignment___1")});
        this.prioritizeRules(this.getSymbol("col_properties"), new int[]{this.getSymbol("out_of_line_ref_constraint"), this.getSymbol("out_of_line_constraint"), this.getSymbol("column_definition")});
        this.prioritizeRules(this.getSymbol("column_definition___2"), new int[]{this.getSymbol("inline_ref_constraint"), this.getSymbol("inline_constraint")});
        String rule2 = "insert_into_clause:  'INTO'  aliased_dml_table_expression_clause;";
        String rule3 = "insert_into_clause:  'INTO'  aliased_dml_table_expression_clause  insert_into_clause___0;";
        this.swapRules(rule2, rule3);
        this.prioritizeRules(this.getSymbol("comparison_condition"), new int[]{this.getSymbol("between_condition"), this.getSymbol("group_comparison_condition"), this.getSymbol("simple_comparison_condition")});
        this.prioritizeRules(this.compound_expression, new int[]{this.getSymbol("expr"), this.getSymbol("compound_expression___1")});
        this.prioritizeRules(this.getSymbol("datetime_expression___1"), new int[]{this.getSymbol("'DBTIMEZONE'"), this.getSymbol("string_literal"), this.expr});
        this.prioritizeRules(this.getSymbol("expr#"), new int[]{this.simple_expression, this.getSymbol("function_expression"), this.getSymbol("JSON_object_access_expr"), this.getSymbol("model_expression"), this.getSymbol("object_access_expression"), this.getSymbol("type_constructor_expression")});
        this.prioritizeRules(this.getSymbol("function_expression"), new int[]{this.getSymbol("function"), this.getSymbol("function_call")});
        this.prioritizeRules(this.getSymbol("function"), new int[]{this.getSymbol("aggregate_function"), this.getSymbol("analytic_function"), this.getSymbol("single_row_function"), this.getSymbol("user_defined_function"), this.getSymbol("object_reference_function")});
        this.prioritizeRules(this.getSymbol("group_by_col"), new int[]{this.getSymbol("rollup_cube_clause"), this.getSymbol("expr")});
        this.prioritizeRules(this.getSymbol("modify_column_clauses___1"), new int[]{this.getSymbol("modify_col_visibility"), this.getSymbol("modify_col_properties"), this.getSymbol("virtual_column_definition")});
        this.prioritizeRules(this.pls_expr, new int[]{this.getSymbol("pls_expr"), this.getSymbol("and_expr")});
        this.prioritizeRules(this.getSymbol("query_table_expression"), new int[]{this.getSymbol("xmltable"), this.getSymbol("table_collection_expression"), this.getSymbol("function_expression")});
        this.prioritizeRules(this.getSymbol("select_term"), new int[]{this.expr, this.getSymbol("\"aliased_expr\"")});
        this.prioritizeRules(this.simple_expression, new int[]{this.getSymbol("'NULL'"), this.getSymbol("'CONNECT_BY_ROOT'"), this.getSymbol("'ROWID'"), this.getSymbol("'ROWNUM'"), this.getSymbol("'CONNECT_BY_ISCYCLE'"), this.getSymbol("'CONNECT_BY_ISLEAF'"), this.getSymbol("identifier"), this.getSymbol("column")});
        this.prioritizeRules(this.sim_stmt, new int[]{this.getSymbol("null_stmt"), this.getSymbol("exit_stmt"), this.getSymbol("continue_stmt"), this.getSymbol("raise_stmt"), this.getSymbol("return_stmt"), this.getSymbol("procedure_call")});
        this.prioritizeRules(this.getSymbol("\"sourceElements\""), new int[]{this.getSymbol("sourceElement"), this.getSymbol("\"sourceElements\"")});
        this.prioritizeRules(this.getSymbol("ty_def"), new int[]{this.getSymbol("array_ty_def"), this.getSymbol("tbl_ty_def")});
        this.prioritizeRules(this.getSymbol("unconstrained_type_wo_datetime_wo_national"), new int[]{this.getSymbol("pls_number_datatypes"), this.getSymbol("link_expanded_n")});
        this.prioritizeRules(this.unlabeled_nonblock_stmt, new int[]{this.getSymbol("sql_stmt"), this.sim_stmt});
        this.prioritizeRules(this.getSymbol("values_clause___0"), new int[]{this.getSymbol("par_expr_list"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause___3"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause___6"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
    }

    private void prioritizeRules(int head, int[] symbols) {
        int[] ruleNumbers = new int[symbols.length];
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Parser.Tuple t = this.rules[i];
            if (t.head != head || t.rhs.length != 1 && t.head != this.boolean_primary && t.head != this.basic_decl_item && t.head != this.compound_expression && t.head != this.simple_expression && t.head != this.pls_expr && t.head != this.unlabeled_nonblock_stmt && t.head != this.sim_stmt) continue;
            for (int j = 0; j < symbols.length; ++j) {
                if (t.rhs[0] != symbols[j]) continue;
                ruleNumbers[j] = i;
                continue block0;
            }
        }
        Parser.Tuple[] tuples = new Parser.Tuple[symbols.length];
        for (int j = 0; j < symbols.length; ++j) {
            tuples[j] = this.rules[ruleNumbers[j]];
        }
        Arrays.sort(ruleNumbers);
        for (int i = 0; i < ruleNumbers.length; ++i) {
            this.rules[ruleNumbers[i]] = tuples[i];
        }
    }

    public void addSymbol2Recognize(String additionalSymbol) {
        this.addSymbol2Recognize(this.getSymbol(additionalSymbol));
    }

    public void addSymbol2Recognize(int additionalSymbol) {
        int[] tmp = new int[this.whatToRecognize.length + 1];
        for (int i = 0; i < this.whatToRecognize.length; ++i) {
            if (this.whatToRecognize[i] == additionalSymbol) {
                return;
            }
            tmp[i] = this.whatToRecognize[i];
        }
        tmp[this.whatToRecognize.length] = additionalSymbol;
        this.whatToRecognize = tmp;
    }

    @Override
    protected void initCell00(List<LexerToken> src, Matrix matrix) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        matrix.initCells(src.size());
        this.initCell(matrix, this.whatToRecognize, 0);
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[0];
            lArray[0] = lArray[0] + (long)((int)(t2 - t1));
        }
        LexerToken LAtoken = src.get(0);
        matrix.LAsuspect = (Integer)this.symbolIndexes.get("'" + LAtoken.content.toUpperCase() + "'");
    }

    @Override
    protected boolean scan(Matrix matrix, List<LexerToken> src) {
        int y = matrix.lastY();
        if (src.size() <= y) {
            return false;
        }
        LexerToken token = src.get(y);
        String tokUpper = token.content.toUpperCase();
        Integer suspect = (Integer)this.symbolIndexes.get("'" + tokUpper + "'");
        matrix.LAsuspect = null;
        if (y + 1 < src.size()) {
            LexerToken LAtoken = src.get(y + 1);
            matrix.LAsuspect = (Integer)this.symbolIndexes.get("'" + LAtoken.content.toUpperCase() + "'");
        }
        boolean ret = false;
        for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            int x = matrix.allXs[i];
            if (!this.scan(matrix, y, src, x, suspect)) continue;
            ret = true;
        }
        if (this.scan(matrix, y, src, y, suspect)) {
            ret = true;
        }
        return ret;
    }

    private boolean scan(Matrix matrix, int y, List<LexerToken> src, int x, Integer suspect) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        long[] content = null;
        Parser.EarleyCell candidateRules = matrix.get(x, y);
        if (candidateRules == null) {
            return false;
        }
        for (int j = 0; j < candidateRules.size(); ++j) {
            int pos = candidateRules.getPosition(j);
            int ruleNo = candidateRules.getRule(j);
            Parser.Tuple t = this.rules[ruleNo];
            if (t.size() - 1 < pos || !this.isScannedSymbol(y, src, pos, t, suspect) || !this.lookaheadOK(t, pos + 1, matrix)) continue;
            long cellElem = SqlEarley.makeMatrixCellElem(ruleNo, pos + 1, t);
            content = Array.insert(content, cellElem);
            if (t.rhs.length != pos + 1) continue;
            matrix.enqueue(Service.lPair(x, t.head));
        }
        if (content == null) {
            return false;
        }
        matrix.put(x, y + 1, new Parser.EarleyCell(content));
        matrix.allXs = Array.insert(matrix.allXs, x);
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[x];
            int n = y + 1;
            lArray[n] = lArray[n] + (long)((int)(t2 - t1));
        }
        return true;
    }

    @Override
    protected boolean lookaheadOK(Parser.Tuple t, int pos, Matrix matrix) {
        if (pos > t.size() - 1) {
            return true;
        }
        int nextInTuple = t.content(pos);
        if (this.isTerminal(nextInTuple)) {
            return matrix.LAsuspect != null && nextInTuple == matrix.LAsuspect;
        }
        Earley.PredictedTerminals terminal = this.terminalPredictions[nextInTuple];
        if (terminal != null) {
            return terminal.matches(matrix.LAsuspect);
        }
        return true;
    }

    @Override
    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
        LexerToken next;
        if (symbol != this.identifier) {
            return false;
        }
        LexerToken prior = null;
        if (suspect != null && this._keywords.contains(suspect)) {
            if (0 < y) {
                prior = src.get(y - 1);
            }
            if (prior == null || !":".equals(prior.content)) {
                return false;
            }
        }
        LexerToken token = src.get(y);
        if (token.type == Token.DQUOTED_STRING) {
            return true;
        }
        if (token.type != Token.IDENTIFIER) {
            return false;
        }
        if (suspect == null) {
            return true;
        }
        if (prior == null && 0 < y) {
            prior = src.get(y - 1);
        }
        if ("TO".equalsIgnoreCase(token.content) && prior != null && ("YEAR".equalsIgnoreCase(prior.content) || "HOUR".equalsIgnoreCase(prior.content) || "MINUTE".equalsIgnoreCase(prior.content))) {
            return false;
        }
        if ("BY".equalsIgnoreCase(token.content) && prior != null && "CONNECT".equalsIgnoreCase(prior.content)) {
            return false;
        }
        if ("CASE".equalsIgnoreCase(token.content) && y + 1 < src.size() && "WHEN".equalsIgnoreCase(src.get((int)(y + 1)).content)) {
            return false;
        }
        if (("LEFT".equalsIgnoreCase(token.content) || "CROSS".equalsIgnoreCase(token.content)) && y < src.size() - 1) {
            LexerToken next2 = src.get(y + 1);
            return !"JOIN".equalsIgnoreCase(next2.content);
        }
        if ("INNER".equalsIgnoreCase(token.content) && y < src.size() - 1) {
            LexerToken next3 = src.get(y + 1);
            if ("JOIN".equalsIgnoreCase(next3.content)) {
                return false;
            }
            return prior == null || !"NATURAL".equalsIgnoreCase(prior.content);
        }
        if (prior != null && "FROM".equalsIgnoreCase(prior.content) && ("FIRST".equalsIgnoreCase(token.content) || "LAST".equalsIgnoreCase(token.content))) {
            next = null;
            if (y + 1 < src.size()) {
                next = src.get(y + 1);
            }
            if (next != null && ("OVER".equalsIgnoreCase(next.content) || "IGNORE".equalsIgnoreCase(next.content) || "RESPECT".equalsIgnoreCase(next.content))) {
                return false;
            }
        }
        if ("AS".equalsIgnoreCase(token.content) && prior != null && "@".equalsIgnoreCase(prior.content)) {
            return false;
        }
        if ("BETWEEN".equalsIgnoreCase(token.content)) {
            next = null;
            if (y < src.size()) {
                next = src.get(y + 1);
            }
            if (next != null && "-".equalsIgnoreCase(next.content)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isScannedSymbol(int y, List<LexerToken> src, int pos, Parser.Tuple t, Integer suspect) {
        LexerToken token = src.get(y);
        int symbol = t.content(pos);
        if (symbol == this.dbtools_lexeme && token.type == Token.DBTOOLS_COMMAND) {
            return true;
        }
        if (symbol == this.sqlplus_lexeme && token.type == Token.SQLPLUS_COMMAND) {
            return true;
        }
        return super.isScannedSymbol(y, src, pos, t, suspect);
    }

    @Override
    protected boolean notConfusedAsId(int suspect, int head, int pos) {
        return !(suspect == this.begin && (head == this.dotted_name || head == this.decl_id) && pos == 0 || suspect == this.start && head == this.table_reference && pos == 1 || suspect == this.distinct && head == this.multiset_except && pos == 3 || suspect == this.body && head == this.pkg_spec && pos == 1 || suspect == this.as && head == this.table_reference && pos == 1 || suspect == this.ELSE && head == this.aliased_dml_table_expression_clause && pos == 1 || suspect == this.VAR && head == this.singleExpression && pos == 0 || suspect == this.REPLACE && head == this.user_defined_types && pos == 0);
    }

    @Override
    protected boolean isOptimizable(int headSym, int preSym, int mid, int y) {
        if (preSym == this.sql_statement && y < mid + 3) {
            return false;
        }
        if (headSym == this.grouping_expression_list) {
            return false;
        }
        if (headSym == this.json_object_arg_list) {
            return false;
        }
        if ("pivot_clause___0#".equals(this.allSymbols[headSym])) {
            return false;
        }
        return super.isOptimizable(headSym, preSym, mid, y);
    }

    @Override
    public synchronized void parse(List<LexerToken> src, Matriceable matrix) {
        super.parse(src, matrix);
        this.skipRanges = true;
    }

    @Override
    protected boolean isAsc(int ruleHead) {
        return ruleHead == this.getSymbol("\"sourceElements\"") || ruleHead == this.getSymbol("\"singleExpression\"") || ruleHead == this.getSymbol("\"statementList___0\"") || ruleHead == this.getSymbol("sql_statements");
    }

    public int recognize(List<LexerToken> src) {
        Matrix matrix = new Matrix(SqlEarley.getInstance());
        this.parse(src, matrix);
        for (int i = src.size(); 0 < i; --i) {
            Parser.EarleyCell top = matrix.get(0, i);
            if (top == null) continue;
            return i;
        }
        throw new AssertionError((Object)"all empty cells?");
    }

    void initKeywords() {
        for (String k : keywords) {
            this._keywords.add(this.getSymbol(k));
        }
    }

    public void reInitKeywords(String[] replacement) {
        this._keywords.clear();
        for (String k : replacement) {
            this._keywords.add(this.getSymbol(k));
        }
    }

    @Override
    protected ParseNode tree(List<LexerToken> src, Matrix m, int x, int y, int rule, int pos) {
        ParseNode ret = super.tree(src, m, x, y, rule, pos);
        if (ret.contains(this.subquery) && !ret.contains(this.query_block)) {
            for (ParseNode child : ret.children()) {
                if (!child.contains(this.query_block)) continue;
                child.deleteContent(this.query_block);
            }
            ret.addContent(this.query_block);
        }
        return ret;
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m, Parser.EarleyCell cell, int x, int y) {
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            Parser.Tuple t = this.rules[rule];
            if (t.head != this.sql_statements && t.head != this.select || this.rules[rule].rhs.length != (pos = cell.getPosition(i))) continue;
            return this.tree(src, m, x, y, rule, pos);
        }
        return super.treeForACell(src, m, cell, x, y);
    }

    public void parse(List<LexerToken> src, Matrix matrix, InterruptedException interrupted) throws InterruptedException {
        this.initCell00(src, matrix);
        this.predict(matrix);
        while (true) {
            if (interrupted != null && Thread.interrupted()) {
                throw interrupted;
            }
            if (!this.scan(matrix, src)) break;
            this.complete(matrix, src.size());
            this.predict(matrix);
        }
    }

    @Override
    public boolean isAuxNode(int symbol) {
        return this.where_gby_hier == symbol;
    }
}

