/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.DatumWithConnection;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingARRAY;
import oracle.dbtools.raptor.datatypes.strategies.preparedstatement.PrepareBindingARRAY;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.CompositeValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.JDBCProxyUtil;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleConnection;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;

public class ARRAY
extends DatumWithConnection {
    protected final DataType subType = this.getTypeComponents().iterator().next().getValue();

    protected ARRAY(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, ARRAY.expandTypeMetadata(context, typeMetadata));
    }

    protected static TypeMetadata expandTypeMetadata(DataTypeContext context, TypeMetadata typeMetadata) {
        TypeMetadata newTypeMetadata = typeMetadata;
        if (typeMetadata.getAttribute(TypeMetadata.Attribute.TYPE_COMPONENTS) == null) {
            try {
                List<NamedValue<TypeMetadata>> attributes = ARRAY.loadAttributes(context, typeMetadata);
                HashMap<TypeMetadata.Attribute, Object> attributeMap = new HashMap<TypeMetadata.Attribute, Object>();
                attributeMap.put(TypeMetadata.Attribute.TYPE_COMPONENTS, attributes);
                newTypeMetadata = DataTypeFactory.getTypeMetadata(typeMetadata, attributeMap);
            }
            catch (SQLException e) {
                throw new DataTypeSQLException(e);
            }
        }
        return newTypeMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<NamedValue<TypeMetadata>> loadAttributes(DataTypeContext context, TypeMetadata typeMetadata) throws SQLException {
        DataTypeConnectionProvider provider = context.getDataTypeConnectionProvider();
        LinkedList<NamedValue<TypeMetadata>> typeComponents = new LinkedList<NamedValue<TypeMetadata>>();
        Object conn = provider.lockDataTypeConnection();
        if (conn != null) {
            try {
                Connection validConnection = (Connection)JDBCProxyUtil.getInstance().unwrap(conn);
                ArrayDescriptor desc = ArrayDescriptor.createDescriptor((String)ARRAY.getUserDataTypeString(typeMetadata), (Connection)validConnection);
                TypeMetadata componentTypeMetadata = context.getDataTypeFactory().getTypeMetadata(desc.getBaseType(), desc.getBaseName());
                typeComponents.add(new NamedValue<TypeMetadata>(null, componentTypeMetadata));
            }
            finally {
                provider.unlockDataTypeConnection();
            }
        }
        return typeComponents;
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        StringBuilder sb = new StringBuilder();
        int len = 0;
        String subTypeSting = this.subType.getPlainDataTypeString();
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append(subTypeSting);
        }
        len += subTypeSting.length();
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append("(");
        }
        ++len;
        List<DataValue> components = this.getComponents(value);
        int i = 0;
        for (DataValue component : components) {
            if (i > 0) {
                if (maxLen < 0 || sb.length() < maxLen) {
                    sb.append(", ");
                }
                len += 2;
            }
            String componentValue = "" + component.getStringValue(connectionProvider, stringType, maxLen);
            if (maxLen < 0 || sb.length() < maxLen) {
                sb.append(componentValue);
            }
            len += componentValue.length();
            ++i;
        }
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append(")");
        }
        return new StringValue(sb.toString(), ++len);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        try {
            List dataValueArray = this.customComponents(value);
            int arraySize = ((ArrayList)dataValueArray).size();
            ArrayList<Object> objectArray = new ArrayList<Object>(arraySize);
            ValueType subTypeValueType = valueType;
            for (DataValue dataValue : dataValueArray) {
                objectArray.add(dataValue.getTypedValue(subTypeValueType));
            }
            switch (valueType) {
                case JDBC: {
                    OracleConnection validConnection = (OracleConnection)connectionProvider.getValidDataTypeConnection();
                    return validConnection.createArrayOf(this.getUserDataTypeString(), objectArray.toArray(new Object[arraySize]));
                }
                case DATUM: {
                    OracleConnection validConnection = (OracleConnection)connectionProvider.getValidDataTypeConnection();
                    return validConnection.createOracleArray(this.getUserDataTypeString(), (Object)objectArray.toArray(new Object[arraySize]));
                }
            }
            return objectArray;
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                Object[] arrayTemplate = (Object[])Array.newInstance(this.subType.getTypedClass(valueType), 0);
                return arrayTemplate.getClass();
            }
            case DEFAULT: {
                return OracleArray.class;
            }
        }
        return ArrayList.class;
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2003;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        ArrayList<DataValue> dataValueArray = new ArrayList<DataValue>();
        try {
            if (value == null) {
                return this.customInternalValue(connectionProvider, dataValueArray);
            }
            if (value instanceof Datum[]) {
                Datum[] datumArray;
                for (Datum datum : datumArray = (Datum[])value) {
                    dataValueArray.add(this.subType.getDataValue(datum));
                }
                return dataValueArray;
            }
            if (value instanceof oracle.jdbc.internal.OracleArray) {
                oracle.jdbc.internal.OracleArray valueArray = (oracle.jdbc.internal.OracleArray)value;
                Datum[] datumArray = valueArray.getOracleArray();
                return this.customInternalValue(connectionProvider, datumArray);
            }
            if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                for (int i = 0; i < arrayLength; ++i) {
                    Object arrayElement = Array.get(value, i);
                    DataValue dataValue = this.subType.getDataValue(arrayElement);
                    dataValueArray.add(dataValue);
                }
                return dataValueArray;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object[] values = collection.toArray(new Object[0]);
                return this.customInternalValue(connectionProvider, values);
            }
            throw new DataTypeIllegalArgumentException(this, value);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    @Override
    public <P extends DataBinding> BindingStrategy getBind(BindContext context, P param) {
        if (CallableStatement.class.isAssignableFrom(context.getEffectiveStatementClass())) {
            return new CallableBindingARRAY(context, param);
        }
        return new PrepareBindingARRAY(context, param);
    }

    @Override
    protected Object customInternalValueFilter(DataTypeConnectionProvider connectionProvider, Object value) {
        if (DataTypesUtil.isEmpty(value)) {
            return this.customInternalValue(connectionProvider, null);
        }
        return super.customInternalValueFilter(connectionProvider, value);
    }

    protected ArrayList<DataValue> customComponents(DataValueInternal value) {
        return (ArrayList)value.getInternalValue();
    }

    @Override
    protected DataValue customDataValue(Object object) {
        return new CompositeValue((DataTypeImpl)this, object);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return this.customInternalValue(this.getDataTypeContext().getDataTypeConnectionProvider(), null);
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
    }

    @Override
    public void bodyDataValue(NamedValue value, String text) {
    }

    @Override
    public void bodyDataValue(NamedValue value, DataValue dataValue) {
        ArrayList dataValueArray = (ArrayList)value.getValue();
        dataValueArray.add(NamedDataValue.getNamedDataValue(null, dataValue));
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        return this.customDataValue(value.getValue());
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.TABLE;
    }
}

