/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.NumericDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class BINARY_FLOAT
extends NumericDatum {
    protected BINARY_FLOAT(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        switch (stringType) {
            case REST: 
            case GENERIC: {
                try {
                    return new StringValue(this.getGenericStringValue((oracle.sql.BINARY_FLOAT)internalValue));
                }
                catch (SQLException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        switch (valueType) {
            case JAVA: {
                return super.customTypedValue(connectionProvider, value, ValueType.JDBC, target);
            }
            case JDBC: {
                return this.customTypedValue(connectionProvider, value, ValueType.DEFAULT, target);
            }
        }
        return super.customTypedValue(connectionProvider, value, valueType, target);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JAVA: {
                return Float.class;
            }
            case JDBC: {
                return this.customTypedClass(connectionProvider, ValueType.DEFAULT);
            }
            case DEFAULT: {
                return oracle.sql.BINARY_FLOAT.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 100;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customUnscaledInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            if (value instanceof oracle.sql.BINARY_FLOAT) {
                return value;
            }
            if (value instanceof Float) {
                return new oracle.sql.BINARY_FLOAT((Float)value);
            }
            if (value instanceof Double) {
                return new oracle.sql.BINARY_FLOAT(((Double)value).floatValue());
            }
            if (value instanceof byte[]) {
                return new oracle.sql.BINARY_FLOAT(Arrays.copyOf((byte[])value, ((byte[])value).length));
            }
            String stringValue = value.toString();
            if (this.isPosInf(stringValue)) {
                return new oracle.sql.BINARY_FLOAT(Float.POSITIVE_INFINITY);
            }
            if (this.isNegInf(stringValue)) {
                return new oracle.sql.BINARY_FLOAT(Float.NEGATIVE_INFINITY);
            }
            if (this.isNaN(stringValue)) {
                return new oracle.sql.BINARY_FLOAT(Float.NaN);
            }
            try {
                return new oracle.sql.BINARY_FLOAT(Float.valueOf(stringValue));
            }
            catch (Exception e1) {
                return this.typedValueFromNLSString(connectionProvider, stringValue);
            }
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    protected oracle.sql.BINARY_FLOAT typedValueFromNLSString(DataTypeConnectionProvider connectionProvider, String value) throws SQLException {
        return new oracle.sql.BINARY_FLOAT(((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).parseNumber(value).floatValue());
    }

    private BigDecimal getBigDecimal(oracle.sql.BINARY_FLOAT flt) throws SQLException {
        BigDecimal ret = null;
        if (flt != null) {
            ret = new BigDecimal(Double.valueOf(flt.stringValue()));
        }
        return ret;
    }

    private String getGenericStringValue(oracle.sql.BINARY_FLOAT flt) throws SQLException {
        String ret = null;
        if (flt != null) {
            ret = this.getBigDecimal(flt).toString();
        }
        return ret;
    }
}

