/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.values;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueImpl;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;

public class CompositeValue
extends DataValueImpl {
    public CompositeValue(DataTypeImpl datatype) {
        super(datatype);
    }

    public CompositeValue(DataTypeImpl datatype, Object value) {
        super(datatype, value);
    }

    public CompositeValue(DataTypeImpl datatype, Collection<DataValue> internalValue) {
        super(datatype, internalValue);
    }

    @Override
    protected boolean customEquals(Object obj) {
        if (obj instanceof CompositeValue && super.customEquals(obj)) {
            CompositeValue objCompositeValue = (CompositeValue)obj;
            List<DataValue> thisComponents = this.getComponents();
            List<DataValue> objComponents = objCompositeValue.getComponents();
            return this.areEquals(thisComponents, objComponents);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areEquals(List<DataValue> thisComponents, List<DataValue> thatComponents) {
        if (thisComponents == thatComponents) return true;
        if (thisComponents == null || thatComponents == null) return false;
        int thisListLength = thisComponents.size();
        if (thisListLength != thatComponents.size()) return false;
        Iterator<DataValue> thatIterator = thatComponents.iterator();
        for (DataValue thisValue : thisComponents) {
            DataValue thatValue;
            if (thisValue.equals(thatValue = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void customMarshal(DataValueMarshalHandler hd, String name) {
        this.customMarshalComponents(hd, name);
    }

    protected void customMarshalComponents(DataValueMarshalHandler hd, String name) {
        List<DataValue> componentValues = this.getComponents();
        if (componentValues != null) {
            for (DataValue componentValue : componentValues) {
                hd.marshal(componentValue, componentValue.getName());
            }
        }
    }
}

