/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class FallbackParserProvider
implements Iterator<ISQLCommand> {
    private ScriptParser m_parser = null;
    private ISQLCommand m_nextCmd = null;
    private Logger m_logger = Logger.getLogger(this.getClass().getName());

    public FallbackParserProvider(ScriptRunnerContext runCtx, Reader reader) {
        this.m_parser = new ScriptParser(reader);
        this.m_parser.setScriptRunnerContext(runCtx);
    }

    @Override
    public boolean hasNext() {
        ISQLCommand cmd = null;
        try {
            if (this.m_nextCmd != null) {
                return true;
            }
            this.m_nextCmd = cmd = this.getNextValidCmd();
        }
        catch (Exception e) {
            return false;
        }
        return cmd != null;
    }

    private ISQLCommand getNextValidCmd() {
        ISQLCommand cmd = null;
        try {
            cmd = this.m_parser.next();
        }
        catch (IOException e1) {
            this.m_logger.log(Level.SEVERE, e1.getStackTrace()[0].toString(), e1);
        }
        while (cmd != null && !this.isValidCommand(cmd)) {
            try {
                cmd = this.m_parser.next();
            }
            catch (IOException e) {
                this.m_logger.log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
            }
        }
        if (cmd != null && this.isValidCommand(cmd)) {
            return cmd;
        }
        return null;
    }

    private boolean isValidCommand(ISQLCommand cmd) {
        return true;
    }

    @Override
    public ISQLCommand next() {
        ISQLCommand sqlCommand = null;
        try {
            if (this.m_nextCmd != null) {
                sqlCommand = this.m_nextCmd;
                this.m_nextCmd = null;
            } else {
                sqlCommand = this.getNextValidCmd();
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
        }
        return sqlCommand;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

