/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ResetPasswordHelper {
    public static final String NEW_PWD = "OCINewPassword";
    public static final String THIN_NEW_PWD = "oracle.jdbc.newPassword";
    private static final Logger LOGGER = Logger.getLogger(ResetPasswordHelper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection resetAndReconnect(ScriptRunnerContext ctx, String username, String urlOrig, Properties props, String newPassword, Throwable firstError) throws Throwable {
        String url = urlOrig;
        boolean reset_ok = false;
        boolean reportFirstError = true;
        boolean alsoTryThick = false;
        if (url.toLowerCase(Locale.US).startsWith("jdbc:oracle:thin")) {
            alsoTryThick = true;
        }
        SQLException toReport = null;
        String[] tryMultiple = null;
        tryMultiple = alsoTryThick ? new String[]{url, url.replaceFirst("jdbc:oracle:thin", "jdbc:oracle:oci8")} : new String[]{url};
        Properties localProps = new Properties();
        localProps.putAll((Map<?, ?>)props);
        Connection conn = null;
        for (String current : tryMultiple) {
            String newPwd = newPassword;
            localProps.setProperty(NEW_PWD, newPassword);
            try {
                if (current.startsWith("jdbc:oracle:thin")) {
                    localProps.remove(NEW_PWD);
                    localProps.setProperty(THIN_NEW_PWD, newPwd);
                } else {
                    localProps.remove(THIN_NEW_PWD);
                    localProps.setProperty(NEW_PWD, newPwd);
                }
                conn = DriverManager.getConnection(current, localProps);
                reset_ok = true;
                break;
            }
            catch (SQLException e) {
                if (!reportFirstError || toReport != null) continue;
                toReport = e;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                        conn = null;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (reset_ok) {
            Properties testProps = new Properties();
            testProps.putAll((Map<?, ?>)props);
            testProps.remove(NEW_PWD);
            testProps.remove(THIN_NEW_PWD);
            testProps.setProperty("password", newPassword);
            try {
                if (ctx != null) {
                    ctx.putProperty("cli.conn.url", urlOrig);
                    ctx.putProperty("cli.conn.props", testProps);
                }
                conn = DriverManager.getConnection(urlOrig, testProps);
            }
            catch (SQLException ex) {
                toReport = ex;
                reset_ok = false;
            }
        }
        if (conn != null && !conn.isClosed()) {
            return conn;
        }
        if (toReport != null) {
            throw toReport;
        }
        throw firstError;
    }
}

