/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.logging.Timer;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.MatchRecognizeUtil;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.CommitParser;
import oracle.dbtools.raptor.newscriptrunner.commands.SetServerOutput;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.SqlId;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class SQL
extends SQLCommandRunner {
    private String _format;
    private boolean warningReported = false;

    public SQL(ISQLCommand cmd, BufferedOutputStream out) {
        super(cmd, out);
    }

    public void setFormat(String format) {
        this._format = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.psrCheck();
        ScriptRunnerContext sr_ctx = this.getScriptRunnerContext();
        if (sr_ctx != null) {
            sr_ctx.putProperty("sqldev.last.err.message.forsqlcode", null);
        }
        if (!this.lockConnection()) {
            return;
        }
        try {
            Timer timer = new Timer();
            timer.start();
            Debug.debug(this.cmd);
            if (this.cmd.getProperty("STRIPPED_CONTINUATION") == null) {
                this.cmd.setSql(ScriptUtils.checkforContinuationChars(this.cmd.getSql()));
            }
            if (this.cmd.getResultsType() == null) {
                this.execute(true);
            } else if (this.cmd.getResultsType().equals((Object)SQLCommand.StmtResultType.G_R_DML)) {
                if (this.isBatchDML()) {
                    this.reportDML(this.cmd.getStmtId(), this.processBatchDML());
                } else {
                    this.reportDML(this.cmd.getStmtId(), this.processDML());
                }
            } else if (this.cmd.getResultsType().equals((Object)SQLCommand.StmtResultType.G_R_QUERY) || this.cmd.getResultsType().equals((Object)SQLCommand.StmtResultType.G_R_SCRIPTEDQUERY)) {
                if (this.cmd.getRunnable()) {
                    this.executeQuery();
                }
            } else if (this.cmd.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_COMMIT)) {
                boolean bad = false;
                CommitParser p = new CommitParser(this.cmd.getSql());
                boolean bl = bad = !p.parse();
                if (!bad) {
                    Statement stmt = null;
                    try {
                        stmt = this.conn.createStatement();
                        try {
                            stmt.setEscapeProcessing(false);
                        }
                        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                            // empty catch block
                        }
                        stmt.execute(p.getOriginalStmt());
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (bad) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("UNKNOWN_COMMAND_ARG", this.cmd.getSql()));
                } else if (this.getScriptRunnerContext().getFeedback() != -2 | this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") == null) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("COMMITCOMPLETE"));
                }
            } else if (this.cmd.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_ROLLBACK_SQL)) {
                String[] tokens = this.getStringToTokens(this.cmd.getSql());
                Savepoint localSavepoint = null;
                int withWork = 0;
                boolean unknownCommand = false;
                String[] splitRollback = this.cmd.getSql().trim().split("[ \t\n\r\f]+");
                if (tokens.length > 1 && tokens[1].equalsIgnoreCase("work")) {
                    withWork = 1;
                }
                if (tokens.length > 3 + withWork && tokens[1 + withWork].toLowerCase().equals("to") && tokens[2 + withWork].toLowerCase().equals("savepoint")) {
                    localSavepoint = sr_ctx.getSavepoint(tokens[3 + withWork]);
                    if (localSavepoint == null) {
                        throw new SQLException(ScriptRunnerDbArb.format("UNKNOWN_SAVEPOINT", tokens[3 + withWork]));
                    }
                    this.conn.rollback(localSavepoint);
                } else if (tokens.length > 2 + withWork && tokens[1 + withWork].toLowerCase().equals("to")) {
                    localSavepoint = sr_ctx.getSavepoint(tokens[2 + withWork]);
                    if (localSavepoint == null) {
                        throw new SQLException(ScriptRunnerDbArb.format("UNKNOWN_SAVEPOINT", tokens[2 + withWork]));
                    }
                    this.conn.rollback(localSavepoint);
                } else if (splitRollback.length > 2 + withWork && splitRollback[1 + withWork].equalsIgnoreCase("force")) {
                    int counter = 0;
                    boolean bad = false;
                    counter = this.cmd.getSql().indexOf("'");
                    if (counter == -1 || counter == this.cmd.getSql().length() - 1) {
                        bad = true;
                    } else {
                        while (true) {
                            if ((counter = this.cmd.getSql().indexOf("'", counter + 1)) == -1) {
                                bad = true;
                                break;
                            }
                            if (counter == this.cmd.getSql().length() - 1 || this.cmd.getSql().charAt(counter + 1) != '\'') break;
                            ++counter;
                        }
                    }
                    if (!bad) {
                        Statement stmt = null;
                        try {
                            stmt = this.conn.createStatement();
                            stmt.execute(this.cmd.getSql().substring(0, counter + 1));
                        }
                        finally {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    unknownCommand = true;
                } else {
                    this.conn.rollback();
                }
                if (unknownCommand) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("UNKNOWN_COMMAND_ARG", this.cmd.getSql()));
                } else if (this.getScriptRunnerContext().getFeedback() != -2 | this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") == null) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("ROLLED_BACK"));
                }
            } else if (this.cmd.getStmtId().equals((Object)SQLCommand.StmtSubType.G_S_SAVEPOINT)) {
                String[] tokens = this.getStringToTokens(this.cmd.getSql());
                if (tokens.length > 1) {
                    Savepoint sp = this.conn.setSavepoint(tokens[1]);
                    sr_ctx.addSavepoint(sp);
                    if (this.getScriptRunnerContext().getFeedback() != -2 | this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") == null) {
                        this.report(this.getScriptRunnerContext(), this.processMessage(this.cmd.getSql()));
                    }
                } else {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.getString("ORA03001"));
                }
            } else if (this.cmd.getResultsType().equals((Object)SQLCommand.StmtResultType.G_R_THREE_WORD)) {
                this.execute(false);
                if (this.getScriptRunnerContext().getFeedback() != -2 | this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent") == null && !this.warningReported) {
                    this.report(this.getScriptRunnerContext(), this.processMessage(this.cmd.getSql()));
                }
            } else if (this.conn != null && this.conn instanceof OracleConnection && this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_UNKNOWN)) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerDbArb.format("UNKNOWN_COMMAND_ARG", this.cmd.getSql()));
            } else {
                this.execute(true);
            }
            timer.end();
            this.cmd.setTiming(timer.duration());
        }
        catch (SQLException se) {
            this.cmd.setFail();
            this.handleSQLException(se, sr_ctx);
        }
        catch (IOException ioe) {
            if (sr_ctx != null) {
                sr_ctx.putProperty("sqldev.error", Boolean.TRUE);
            }
            if (sr_ctx != null) {
                sr_ctx.putProperty("script.runner.autocommit.errorFlag", Boolean.TRUE);
            }
            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine()), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("IO_ERROR", ioe.getMessage()), this.getScriptRunnerContext()));
            if (sr_ctx != null) {
                sr_ctx.putProperty("sqldev.last.err.message", ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine()), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("IO_ERROR", ioe.getMessage()), this.getScriptRunnerContext()));
            }
            this.doWhenever(false);
        }
        finally {
            this.unlockConnection();
        }
    }

    public void psrCheck() {
        SQLCommand.StmtSubType stmtId = this.cmd.getStmtId();
        if (stmtId == SQLCommand.StmtSubType.G_S_SELECT || stmtId == SQLCommand.StmtSubType.G_S_WITH) {
            boolean doPsrCheck;
            Object psrCheck = this.getScriptRunnerContext().getProperty("sqlcl.codescan.PSRCHECKS");
            boolean bl = doPsrCheck = psrCheck == null ? true : Boolean.parseBoolean(psrCheck.toString());
            if (doPsrCheck) {
                String input = this.cmd.getSql();
                TreeMap diagnostics = new TreeMap();
                try {
                    Program.debug = false;
                    String include = Program.getContent("../app/psr/sqlclCallbacks.arbori");
                    Object prg = Program.getContent("../app/psr/smallchecks.arbori");
                    prg = (String)prg + Program.getContent("../app/psr/mediumchecks.arbori");
                    prg = ((String)prg).replace("include \"../app/psr/queryUtil.js\"", include);
                    prg = ((String)prg).replace("include \"..\\app\\psr\\queryUtil.js\"", include);
                    SqlProgram program = new SqlProgram(include + (String)prg);
                    Map<String, MaterializedPredicate> map = program.run(input, diagnostics);
                }
                catch (SyntaxError e) {
                    Object sqlFragment = input.trim();
                    if (((String)sqlFragment).length() > 100) {
                        sqlFragment = ((String)sqlFragment).substring(0, 97) + "...";
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Local codescan (PSR check) failed to parse statement: " + (String)sqlFragment);
                }
                catch (AssertionError e) {
                    System.err.println(((Throwable)((Object)e)).getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int[] lineMap = Service.lineMap(input);
                Iterator iterator = diagnostics.keySet().iterator();
                while (iterator.hasNext()) {
                    int pos = (Integer)iterator.next();
                    int ln = Service.charPos2LineNo0(lineMap, pos);
                    int col = pos - Service.lineNo2CharPos0(lineMap, ln);
                    this.getScriptRunnerContext().write("\nSQL performance check warning (" + (ln + 1) + "," + col + "): " + (String)diagnostics.get(pos) + " \n");
                }
            }
        }
    }

    private void handleSQLException(SQLException se, ScriptRunnerContext sr_ctx) {
        try {
            if (sr_ctx != null) {
                sr_ctx.putProperty("sqlcl.in.handleSQLException", Boolean.TRUE);
            }
            this.handleSQLExceptionInner(se, sr_ctx);
        }
        finally {
            if (sr_ctx != null) {
                sr_ctx.putProperty("sqlcl.in.handleSQLException", null);
            }
        }
    }

    private void handleSQLExceptionInner(SQLException se, ScriptRunnerContext sr_ctx) {
        ExceptionHandler.handleException((Exception)se, this.connName, true, false);
        if (sr_ctx != null) {
            sr_ctx.putProperty("sqldev.error", Boolean.TRUE);
            sr_ctx.putProperty("script.runner.autocommit.errorFlag", Boolean.TRUE);
            sr_ctx.putProperty("sqldev.last.err.message.forsqlcode", se.getMessage());
            sr_ctx.putProperty("sqldev.last.err.sqlcode", se.getErrorCode());
        }
        if (se instanceof BatchUpdateException) {
            sr_ctx.setDMLResult(((BatchUpdateException)se).getUpdateCounts());
        }
        sr_ctx.errorLog(sr_ctx.getSourceRef(), se.getMessage(), this.cmd.getSql());
        boolean defaultErrorHandling = true;
        SQLCommand.StmtSubType stmtId = this.cmd.getStmtId();
        int startLine = this.cmd.getStartLine();
        if ((SQLCommand.StmtResultType.G_R_QUERY.equals((Object)this.cmd.getResultsType()) || stmtId.equals((Object)SQLCommand.StmtSubType.G_S_INSERT) || stmtId.equals((Object)SQLCommand.StmtSubType.G_S_INSERT) || stmtId.equals((Object)SQLCommand.StmtSubType.G_S_UPDATE) || stmtId.equals((Object)SQLCommand.StmtSubType.G_S_DELETE) || stmtId.equals((Object)SQLCommand.StmtSubType.G_S_SELECT) || stmtId.equals((Object)SQLCommand.StmtSubType.G_S_MERGE) || stmtId.equals((Object)SQLCommand.StmtSubType.G_S_WITH)) && !this.cmd.getSQLOrig().toUpperCase().startsWith("DESC")) {
            Object toSend;
            int offset = 0;
            if (!(se instanceof SQLRecoverableException)) {
                offset = DBUtil.getInstance(this.conn).getErrorOffset(this.cmd.getSql());
            }
            int col = 0;
            int line = 0;
            String[] lines = null;
            if (offset >= 0) {
                String sql = this.cmd.getSql();
                if (sql.length() >= offset) {
                    String sqlSubSet = "";
                    sqlSubSet = sql.length() >= offset + 1 ? sql.substring(0, offset + 1) : sql.substring(0, offset);
                    lines = sqlSubSet.split("\n");
                } else {
                    lines = new String[]{sql};
                }
                col = lines[lines.length - 1].length();
                line = lines.length;
            }
            if (offset >= 0) {
                toSend = se.getMessage();
                int ls = (Integer)sr_ctx.getProperty("script.runner.setlinesize");
                StringBuffer sb = new StringBuffer((String)toSend);
                toSend = ScriptUtils.wordwrap(1, ls, sb, 1).toString();
                if (this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString())) {
                    StringBuilder error = new StringBuilder();
                    if (line > 0) {
                        error.append(this.cmd.getSql().split("\n")[line - 1] + "\n");
                        if (col > 1) {
                            String pad = new String(new char[col]).replace('\u0000', ' ');
                            error.append(pad.substring(0, pad.length() - 1) + "*\n");
                        }
                        error.append(MessageFormat.format(Messages.getString("SQL.5"), line));
                    } else {
                        error.append(this.cmd.getSql() + Messages.getString("SQL.6"));
                    }
                    error.append((String)toSend + "\n");
                    this.report(this.getScriptRunnerContext(), error.toString());
                    if (sr_ctx != null) {
                        sr_ctx.putProperty("sqldev.last.err.message", error);
                    }
                } else {
                    Oerr oerr = new Oerr();
                    try {
                        toSend = (String)toSend + oerr.oerr((String)toSend);
                    }
                    catch (OerrException pad) {
                        // empty catch block
                    }
                    Object[] oarray = new Object[]{new Integer(startLine + 1), this.cmd.getSql(), new Integer(startLine + 1 + (line - 1)), new Integer(col), ScriptRunnerDbArb.format("SQL_ERROR", toSend)};
                    String error = ScriptRunnerContext.lineColErr(oarray[0], oarray[1], oarray[2], oarray[3], oarray[4], sr_ctx);
                    this.report(this.getScriptRunnerContext(), error);
                    if (sr_ctx != null) {
                        sr_ctx.putProperty("sqldev.last.err.message", error);
                    }
                }
            } else {
                toSend = se.getMessage();
                int ls = (Integer)sr_ctx.getProperty("script.runner.setlinesize");
                StringBuffer sb = new StringBuffer((String)toSend);
                toSend = ScriptUtils.wordwrap(1, ls, sb, 1).toString();
                if (sr_ctx.getProperty("sqlplus.classic.mode") == null || !Boolean.parseBoolean(sr_ctx.getProperty("sqlplus.classic.mode").toString())) {
                    this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(startLine + 1), this.cmd.getSQLOrig(), toSend, this.getScriptRunnerContext()));
                    if (sr_ctx != null) {
                        sr_ctx.putProperty("sqldev.last.err.message", ScriptRunnerContext.lineErr(new Integer(startLine + 1), this.cmd.getSQLOrig(), toSend, this.getScriptRunnerContext()));
                    }
                } else {
                    this.report(this.getScriptRunnerContext(), MessageFormat.format(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR_CLASSIC"), ScriptUtils.getErrorStringAtLine(this.cmd, se), ScriptUtils.getErrorAsterixFromException(this.cmd, se), ScriptUtils.getErrorLineFromException(this.cmd, se), toSend));
                    if (sr_ctx != null) {
                        sr_ctx.putProperty("sqldev.last.err.message", ScriptRunnerContext.lineErr(new Integer(startLine + 1), this.cmd.getSQLOrig(), toSend, this.getScriptRunnerContext()));
                    }
                }
            }
            defaultErrorHandling = false;
        }
        if (defaultErrorHandling) {
            StringBuffer toSend = new StringBuffer(se.getMessage());
            toSend = ScriptUtils.wordwrap(1, (Integer)sr_ctx.getProperty("script.runner.setlinesize"), toSend, 1);
            if (this.conn instanceof OracleConnection) {
                Oerr oerr = new Oerr();
                try {
                    if (sr_ctx.getProperty("sqlplus.classic.mode") == null || !Boolean.parseBoolean(sr_ctx.getProperty("sqlplus.classic.mode").toString())) {
                        toSend.append(oerr.oerr(toSend.toString()));
                    }
                }
                catch (OerrException oerrException) {
                    // empty catch block
                }
            }
            if (sr_ctx.getProperty("sqlplus.classic.mode") == null || !Boolean.parseBoolean(sr_ctx.getProperty("sqlplus.classic.mode").toString())) {
                this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(startLine + 1), this.cmd.getSQLOrig(), toSend, this.getScriptRunnerContext()));
                if (sr_ctx != null) {
                    sr_ctx.putProperty("sqldev.last.err.message", ScriptRunnerContext.lineErr(new Integer(startLine + 1), this.cmd.getSQLOrig(), toSend, this.getScriptRunnerContext()));
                }
            } else {
                this.report(this.getScriptRunnerContext(), MessageFormat.format(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR_CLASSIC"), ScriptUtils.getErrorStringAtLine(this.cmd, se), ScriptUtils.getErrorAsterixFromException(this.cmd, se), ScriptUtils.getErrorLineFromException(this.cmd, se), toSend));
                if (sr_ctx != null) {
                    sr_ctx.putProperty("sqldev.last.err.message", ScriptRunnerContext.lineErr(new Integer(startLine + 1), this.cmd.getSQLOrig(), toSend, this.getScriptRunnerContext()));
                }
            }
        }
        this.doWhenever(true);
    }

    private boolean isBatchDML() {
        if (this.getCmd().getBatchStatements() != null && this.getCmd().getBatchStatements().size() > 0) {
            return true;
        }
        Map<String, List<DataValue>> binds = this.getScriptRunnerContext().getBatchVarMap();
        return binds != null && binds.size() > 0;
    }

    private int[] processBatchDML() throws SQLException {
        if (this.cmd.getBatchStatements() != null && this.cmd.getBatchStatements().size() > 0) {
            return this.processBatchStatements();
        }
        return this.processBatchBinds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] processBatchStatements() throws SQLException {
        int[] rowsEffected = null;
        boolean connAutoCommit = this.conn.getAutoCommit();
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            try {
                this.stmt.setEscapeProcessing(false);
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                // empty catch block
            }
            this.conn.setAutoCommit(false);
            for (String batchStmt : this.cmd.getBatchStatements()) {
                statement.addBatch(batchStmt);
            }
            try {
                rowsEffected = statement.executeBatch();
            }
            finally {
                SetServerOutput.coreEndWatcher(this.conn, this.getScriptRunnerContext(), this.cmd);
            }
        }
        catch (SQLException se) {
            this.cmd.setFail();
            if (statement != null) {
                statement.close();
            }
            throw se;
        }
        finally {
            this.conn.setAutoCommit(connAutoCommit);
            if (statement != null) {
                statement.close();
            }
        }
        return rowsEffected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] processBatchBinds() throws SQLException {
        int[] rowsEffected = null;
        try {
            MatchRecognizeUtil matchRecognize = new MatchRecognizeUtil(this.cmd.getSql());
            if (!matchRecognize.isAltered()) {
                this.stmt = this.conn.prepareStatement(this.cmd.getSql());
                try {
                    this.stmt.setEscapeProcessing(false);
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {}
            } else {
                this.stmt = this.conn.prepareStatement(matchRecognize.getOutputText());
                try {
                    this.stmt.setEscapeProcessing(true);
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                    // empty catch block
                }
            }
            try {
                this.setBatchBinds((OraclePreparedStatement)this.stmt);
                rowsEffected = this.stmt.executeBatch();
            }
            finally {
                SetServerOutput.coreEndWatcher(this.conn, this.getScriptRunnerContext(), this.cmd);
            }
        }
        catch (SQLException se) {
            this.cmd.setFail();
            throw se;
        }
        finally {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        return rowsEffected;
    }

    public void setBatchBinds(OraclePreparedStatement pstmt) throws SQLException {
        Map<String, List<DataValue>> batchBinds = this.getScriptRunnerContext().getBatchVarMap();
        Set<String> bindKeys = batchBinds.keySet();
        int batchSize = batchBinds.get(bindKeys.iterator().next()).size();
        for (int index = 0; index < batchSize; ++index) {
            for (String bindKey : bindKeys) {
                List<DataValue> bindValueList = batchBinds.get(bindKey);
                pstmt.setObjectAtName(bindKey, bindValueList.get(index).getTypedValue());
            }
            pstmt.addBatch();
        }
    }

    public void reportDML(SQLCommand.StmtSubType dmlType, int num) throws IOException {
        int[] nums = new int[]{num};
        this.reportDML(dmlType, nums);
    }

    public void reportDML(SQLCommand.StmtSubType dmlType, int[] nums) throws IOException {
        int count = 0;
        this.getScriptRunnerContext().setDMLResult(nums);
        for (int num : nums) {
            boolean classic;
            ++count;
            String action = null;
            boolean bl = classic = this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString());
            if (this.getScriptRunnerContext().getFeedback() == -2) continue;
            if (dmlType.equals((Object)SQLCommand.StmtSubType.G_S_INSERT)) {
                action = classic ? MessageFormat.format(ScriptRunnerDbArb.getString("CREATED"), "").trim() : ScriptRunnerDbArb.getString("INSERTED");
            } else if (dmlType.equals((Object)SQLCommand.StmtSubType.G_S_UPDATE)) {
                action = ScriptRunnerDbArb.getString("UPDATED");
            } else if (dmlType.equals((Object)SQLCommand.StmtSubType.G_S_DELETE)) {
                action = ScriptRunnerDbArb.getString("DELETED");
            } else if (dmlType.equals((Object)SQLCommand.StmtSubType.G_S_MERGE)) {
                action = ScriptRunnerDbArb.getString("MERGED");
            }
            action = num == 1 ? MessageFormat.format(ScriptRunnerDbArb.getString("ACTION_RESULT1"), num, action) : (classic ? MessageFormat.format(ScriptRunnerDbArb.getString("ACTION_RESULT"), String.valueOf(num), action) : MessageFormat.format(ScriptRunnerDbArb.getString("ACTION_RESULT"), num, action));
            this.report(this.getScriptRunnerContext(), "\n" + action + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processDML() throws SQLException {
        int rowsEffected = 0;
        try {
            MatchRecognizeUtil matchRecognize = new MatchRecognizeUtil(this.cmd.getSql());
            if (!matchRecognize.isAltered()) {
                this.stmt = this.conn.prepareStatement(this.cmd.getSql());
                try {
                    this.stmt.setEscapeProcessing(false);
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {}
            } else {
                this.stmt = this.conn.prepareStatement(matchRecognize.getOutputText());
                try {
                    this.stmt.setEscapeProcessing(true);
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                    // empty catch block
                }
            }
            try {
                if (DBUtil.getBindNames(this.cmd.getSql(), true) != null && DBUtil.getBindNames(this.cmd.getSql(), true).size() > 0) {
                    if (this.setBinds(this.stmt)) {
                        this.registerReturningBinds();
                        rowsEffected = this.stmt.executeUpdate();
                        this.fetchReturningValues();
                    }
                } else {
                    rowsEffected = this.stmt.executeUpdate();
                }
            }
            finally {
                SetServerOutput.coreEndWatcher(this.conn, this.getScriptRunnerContext(), this.cmd);
            }
        }
        catch (SQLException se) {
            this.cmd.setFail();
            throw se;
        }
        finally {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        return rowsEffected;
    }

    private void registerReturningBinds() throws SQLException {
        int bindIdx = 1;
        List<Bind> al = DBUtil.getBinds(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
        String bindName = null;
        for (int i = 0; i < al.size(); ++i) {
            bindName = null;
            if (this.doubleBinds != null && al.get(i).getName().contains(this.myUniq + "Init")) {
                ++bindIdx;
                continue;
            }
            Bind bindFromStatement = al.get(i);
            bindName = bindFromStatement.getName();
            if (!m.containsKey(bindName.toUpperCase())) continue;
            if (bindFromStatement.getMode() == Bind.Mode.RETURNING) {
                Bind bind = m.get(bindName.toUpperCase());
                String type = bind.getType();
                if (type == null) {
                    DataType dataType = bind.getDataType();
                    ((OraclePreparedStatement)this.stmt).registerReturnParameter(bindIdx, dataType.getSqlDataType(ValueType.JDBC));
                } else {
                    if (type.toUpperCase().indexOf("NCHAR") > -1 || type.toUpperCase().indexOf("NVARCHAR") > -1 || type.toUpperCase().indexOf("NCLOB") > -1) {
                        ((OracleCallableStatement)this.stmt).setFormOfUse(bindIdx, (short)2);
                    }
                    if (type.toUpperCase().indexOf("CHAR") > -1) {
                        ((OraclePreparedStatement)this.stmt).registerReturnParameter(bindIdx, 12);
                    } else if (type.toUpperCase().equals("NUMBER")) {
                        ((OraclePreparedStatement)this.stmt).registerReturnParameter(bindIdx, 2);
                    } else if (type.toUpperCase().indexOf("CLOB") > -1) {
                        ((OraclePreparedStatement)this.stmt).registerReturnParameter(bindIdx, 2005);
                    } else if (type.toUpperCase().equals("REFCURSOR")) {
                        ((OraclePreparedStatement)this.stmt).registerReturnParameter(bindIdx, -10);
                    } else if (type.toUpperCase().equals("BLOB")) {
                        ((OraclePreparedStatement)this.stmt).registerReturnParameter(bindIdx, 2004);
                    } else if (type.toUpperCase().equals("BINARY_DOUBLE")) {
                        ((OraclePreparedStatement)this.stmt).registerReturnParameter(bindIdx, 101);
                    } else if (type.toUpperCase().equals("BINARY_FLOAT")) {
                        ((OraclePreparedStatement)this.stmt).registerReturnParameter(bindIdx, 100);
                    }
                }
            }
            ++bindIdx;
        }
    }

    private void fetchReturningValues() throws SQLException {
        int bindIdx = 1;
        Map<String, Bind> m = this.getScriptRunnerContext().getVarMap();
        List<Bind> al = DBUtil.getBinds(this.alteredSQL(this.doubleBinds, this.cmd.getSql(), this.altSQL), true);
        bindIdx = al.size();
        for (int i = al.size() - 1; i >= 0; --i) {
            if (al.get(i).getMode() != Bind.Mode.RETURNING) {
                ++bindIdx;
                continue;
            }
            if (bindIdx <= 0) continue;
            String bindName = null;
            if (this.doubleBinds != null) {
                bindName = (String)this.lookUpMangle.get(al.get(i).getName());
                if (bindName == null) {
                    bindName = al.get(i).getName();
                }
                if (al.get(i).getName().contains(this.myUniq + "Init")) {
                    --bindIdx;
                    continue;
                }
                if (bindName == null) {
                    bindName = al.get(i).getName();
                }
            } else {
                bindName = al.get(i).getName();
            }
            Bind bind = m.get(bindName.toUpperCase());
            String type = bind.getType();
            if (bind.getDataType() != null) {
                if (bind.getMode() == Bind.Mode.OUT || bind.getMode() == Bind.Mode.INOUT) {
                    bind.setDataValue(bind.getDataType().getDataValue(this.getReturnValue(this.stmt, bindIdx)));
                }
            } else if (type.toUpperCase().indexOf("CHAR") > -1) {
                try {
                    bind.setValue((String)this.getReturnValue(this.stmt, bindIdx));
                }
                catch (SQLException sQLException) {}
            } else if (type.toUpperCase().equals("NUMBER")) {
                Object o = null;
                try {
                    o = this.getReturnValue(this.stmt, bindIdx);
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                bind.setValue(o == null ? null : o.toString());
            } else if (type.toUpperCase().indexOf("CLOB") > -1) {
                try {
                    bind.setValue(DataTypesUtil.stringValue(this.getReturnValue(this.stmt, bindIdx), this.conn, Integer.MAX_VALUE));
                }
                catch (SQLException o) {}
            } else if (type.toUpperCase().equals("REFCURSOR")) {
                try {
                    bind.setValue(DataTypesUtil.stringValue(this.getReturnValue(this.stmt, bindIdx), this.conn));
                }
                catch (SQLException o) {}
            } else if (type.toUpperCase().indexOf("BINARY_") > -1) {
                try {
                    bind.setValue(DataTypesUtil.stringValue(this.getReturnValue(this.stmt, bindIdx), this.conn));
                }
                catch (SQLException o) {}
            } else if (type.toUpperCase().equals("BLOB")) {
                Blob b = null;
                try {
                    b = (Blob)this.getReturnValue(this.stmt, bindIdx);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                String s = null;
                if (b != null) {
                    byte[] bdata = null;
                    bdata = b.getBytes(1L, (int)b.length());
                    s = new String(ScriptUtils.bytesToHex(bdata)).toUpperCase();
                }
                bind.setValue(s);
            }
            m.put(bindName.toUpperCase(), bind);
            --bindIdx;
        }
    }

    private Object getReturnValue(PreparedStatement stmt, int bindIdx) throws SQLException {
        ResultSet rs = ((OraclePreparedStatement)stmt).getReturnResultSet();
        rs.next();
        return rs.getObject(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery() throws SQLException, IOException {
        ResultSet rset = null;
        boolean run = true;
        try {
            MatchRecognizeUtil matchRecognize = new MatchRecognizeUtil(this.cmd.getSql());
            if (!matchRecognize.isAltered()) {
                this.stmt = this.conn.prepareStatement(this.cmd.getSql());
                try {
                    this.stmt.setEscapeProcessing(false);
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {}
            } else {
                this.stmt = this.conn.prepareStatement(matchRecognize.getOutputText());
                try {
                    this.stmt.setEscapeProcessing(true);
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                    // empty catch block
                }
            }
            if (DBUtil.getBindNames(this.cmd.getSql(), true) != null && DBUtil.getBindNames(this.cmd.getSql(), true).size() > 0 && !this.setBinds(this.stmt)) {
                run = false;
            }
            if (run) {
                rset = this.stmt.executeQuery();
                this.processResultSet(rset);
            }
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception exception) {}
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void processResultSet(ResultSet rset) throws SQLException, IOException {
        boolean feedOn;
        String amISelectString = null;
        amISelectString = this.cmd.getSQLOrig().length() > 10 ? this.cmd.getSQLOrig().substring(0, 8).toLowerCase() : this.cmd.getSQLOrig().toLowerCase();
        boolean originalSelect = true;
        if (amISelectString.startsWith("desc")) {
            originalSelect = false;
        }
        ResultSetFormatter rFormat = null;
        rFormat = originalSelect ? (this.conn instanceof OracleConnection ? new SQLPLUSCmdFormatter(this.getScriptRunnerContext()) : new ResultSetFormatter(this.getScriptRunnerContext())) : (this.conn instanceof OracleConnection ? (this.getScriptRunnerContext() != null && (this.isClassicMode() || this.getScriptRunnerContext().isJSONOutput()) ? new SQLPLUSCmdFormatter(this.getScriptRunnerContext()) : new SQLPLUSCmdFormatter()) : new ResultSetFormatter());
        rFormat.setProgressUpdater(this.getScriptRunnerContext().getTaskProgressUpdater());
        int cnt = 0;
        Properties props = this.getConnectionInfo();
        Integer fs = null;
        try {
            if (this.getScriptRunnerContext().getProperty("script.runner.arraysize") != null) {
                fs = Integer.valueOf((String)this.getScriptRunnerContext().getProperty("script.runner.arraysize"));
            } else if (props != null) {
                String prefFetchSize = props.getProperty("PreferfedFetchSize");
                fs = Integer.valueOf(prefFetchSize);
            } else {
                fs = 2;
            }
        }
        catch (NumberFormatException prefFetchSize) {
            // empty catch block
        }
        if (fs != null) {
            try {
                rset.setFetchSize(fs);
            }
            catch (SQLFeatureNotSupportedException prefFetchSize) {
                // empty catch block
            }
        }
        if (this.conn instanceof OracleConnection && rFormat instanceof SQLPLUSCmdFormatter) {
            ((SQLPLUSCmdFormatter)rFormat).setSQL(this.cmd.getSql());
        }
        if (this.getScriptRunnerContext().getFeedback() == -3) {
            while (rset.next()) {
                ++cnt;
            }
        } else {
            cnt = rFormat.formatResults(this.out, rset, this.cmd);
        }
        int feedback = this.getScriptRunnerContext().getFeedback();
        Object silentMode = this.getScriptRunnerContext().getProperty("script.runner.sqlplus.silent");
        boolean bl = feedOn = feedback != -2 | silentMode != null && !this.getScriptRunnerContext().isJSONOutput();
        if (feedOn && feedback != -2) {
            if (cnt >= feedback) {
                if (cnt == 1) {
                    this.report(this.getScriptRunnerContext(), MessageFormat.format(ScriptRunnerDbArb.getString("SELECTONE"), cnt));
                } else if (this.isClassicMode()) {
                    this.report(this.getScriptRunnerContext(), MessageFormat.format(ScriptRunnerDbArb.getString("SELECTED"), String.valueOf(cnt)));
                } else {
                    this.report(this.getScriptRunnerContext(), MessageFormat.format(ScriptRunnerDbArb.getString("SELECTED"), cnt));
                }
            } else if (cnt == 0) {
                this.report(this.getScriptRunnerContext(), MessageFormat.format(ScriptRunnerDbArb.getString("NOROWS_SELECTED"), cnt));
            } else {
                this.report(this.getScriptRunnerContext(), "");
            }
            try {
                if (this.getScriptRunnerContext().getFeedbackSQLID()) {
                    String sqlid = SqlId.stmt2sqlid(this.cmd.getSql());
                    this.report(this.getScriptRunnerContext(), "SQL_ID: " + sqlid);
                    this.getScriptRunnerContext().getMap().put(ScriptRunnerContext.SqlplusVariable._SQL_ID.toString(), sqlid);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isClassicMode() {
        return this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean status) throws SQLException, IOException {
        block51: {
            String owner = "";
            String name = "";
            String type = "";
            try {
                String[] retVal22;
                if (this.cmd.getSql().toLowerCase().startsWith("alter") && (retVal22 = ScriptUtils.parseNameAndTypeUtil(this.cmd.getSql())) != null) {
                    owner = retVal22[0];
                    name = retVal22[1];
                    type = retVal22[2];
                    this.getScriptRunnerContext().putProperty("sqldev.last.err.type", type == null ? "UNKNOWN" : type.toUpperCase());
                    this.getScriptRunnerContext().putProperty("sqldev.last.err.name", name);
                }
                this.st = this.conn.createStatement();
                try {
                    this.st.setEscapeProcessing(false);
                }
                catch (SQLFeatureNotSupportedException retVal22) {
                    // empty catch block
                }
                try {
                    this.st.execute(this.cmd.getSql().trim());
                }
                finally {
                    SetServerOutput.coreEndWatcher(this.conn, this.getScriptRunnerContext(), this.cmd);
                }
                boolean isOracleConnection = this.getConn() instanceof OracleConnection;
                if (!isOracleConnection && this.st.getResultSet() != null) {
                    ResultSet rset = this.st.getResultSet();
                    this.processResultSet(rset);
                    if (rset != null) {
                        try {
                            rset.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block51;
                }
                SetServerOutput.coreEndWatcher(this.conn, this.getScriptRunnerContext(), this.cmd);
                SQLWarning warn = this.st.getWarnings();
                if (warn == null && status) {
                    if (this.getScriptRunnerContext().getFeedback() != -2) {
                        this.report(this.getScriptRunnerContext(), this.processMessage(this.cmd.getSql()));
                    }
                    break block51;
                }
                if (warn == null) break block51;
                if (isOracleConnection) {
                    Object warnText = ScriptRunnerDbArb.format("SQL_COMMAND", this.processMessage(this.cmd.getSql(), false));
                    Object toSend = warn.getMessage();
                    if (this.conn instanceof OracleConnection) {
                        Oerr oerr = new Oerr();
                        try {
                            toSend = (String)toSend + oerr.oerr((String)toSend);
                        }
                        catch (OerrException oerrException) {
                            // empty catch block
                        }
                    }
                    boolean realWarning = false;
                    boolean reportCompletedWithWarnings = false;
                    while (warn != null) {
                        if (!isOracleConnection || warn.getErrorCode() != 17110 && warn.getErrorCode() != 24344) {
                            warnText = (String)warnText + "\n" + ScriptRunnerDbArb.format("FAILED", toSend);
                            realWarning = true;
                        } else if (!isOracleConnection || warn.getErrorCode() != 17110 && warn.getErrorCode() != 24344 || this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_ALTER)) {
                            boolean classic;
                            if (isOracleConnection && (warn.getErrorCode() == 17110 || warn.getErrorCode() == 24344) && this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_ALTER) && this.cmd.getSQLOrig().toLowerCase().trim().endsWith("compile") && type != null && type.equals("JAVA SOURCE")) {
                                this.warningReported = true;
                                this.report(this.getScriptRunnerContext(), Messages.getString("ALTER_JAVA_COMPILE"));
                                return;
                            }
                            boolean bl = classic = this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString());
                            if (classic) {
                                String returnString = "";
                                if (this.cmd.getSQLOrig().toLowerCase().replaceAll("\\s+", "").contains("view")) {
                                    returnString = Messages.getString("SQL.20");
                                    this.warningReported = true;
                                    this.report(this.getScriptRunnerContext(), returnString);
                                    return;
                                }
                                if (this.cmd.getSQLOrig().toLowerCase().replaceAll("\\s+", "").contains("pluggable")) {
                                    returnString = Messages.getString("SQL.24");
                                    if (this.getScriptRunnerContext().getFeedback() != -2) {
                                        this.report(this.getScriptRunnerContext(), returnString);
                                    }
                                    this.warningReported = true;
                                    return;
                                }
                                warnText = (String)warnText + "\n" + (String)toSend;
                                reportCompletedWithWarnings = true;
                            } else {
                                warnText = (String)warnText + "\n" + (String)toSend;
                                reportCompletedWithWarnings = true;
                            }
                        } else {
                            if (isOracleConnection && warn.getErrorCode() == 17110 && this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CREATE_VIEW)) {
                                if (this.getScriptRunnerContext().getFeedback() != -2) {
                                    this.report(this.getScriptRunnerContext(), Messages.getString("SQL.25"));
                                }
                                return;
                            }
                            if (isOracleConnection && warn.getErrorCode() == 17710 && this.cmd.getSQLOrig().replaceAll("\\s+|\n", "").toLowerCase().startsWith("alterpluggabledatabase")) {
                                if (this.getScriptRunnerContext().getFeedback() != -2) {
                                    this.report(this.getScriptRunnerContext(), Messages.getString("SQL.29"));
                                }
                                return;
                            }
                        }
                        warn = warn.getNextWarning();
                    }
                    if (realWarning) {
                        if (this.getScriptRunnerContext().getFeedback() != -2) {
                            this.report(this.getScriptRunnerContext(), ScriptRunnerContext.lineErr(new Integer(this.cmd.getStartLine() + 1), this.cmd.getSQLOrig(), warnText, this.getScriptRunnerContext()));
                        }
                    } else if (reportCompletedWithWarnings) {
                        if (this.getScriptRunnerContext().getFeedback() != -2) {
                            this.report(this.getScriptRunnerContext(), (String)toSend);
                        }
                    } else if (status && this.getScriptRunnerContext().getFeedback() != -2) {
                        this.report(this.getScriptRunnerContext(), this.processMessage(this.cmd.getSql()));
                    }
                    break block51;
                }
                String warnText = warn.getMessage();
                if (this.getScriptRunnerContext().getFeedback() != -2) {
                    this.report(this.getScriptRunnerContext(), warnText);
                }
            }
            catch (SQLException se) {
                this.cmd.setFail();
                throw se;
            }
            finally {
                if (this.st != null) {
                    this.st.close();
                }
            }
        }
    }

    public void reportObjectAction() {
    }

    private String processMessage(String cmd) {
        return this.processMessage(cmd, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String processMessage(String cmdText, boolean action) {
        String[] thirdPartyKeywords = new String[]{"CREATE", "SCHEMA", "AUTHORIZATION", "IF", "NOT", "EXISTS", "DROP", "TABLE", "ALTER", "USER"};
        cmdText = ScriptUtils.stripFirstN(cmdText, 1000, this.cmd.getProperty("STRIPPED_CONTINUATION") == null, false);
        cmdText = cmdText.replaceAll("[oO][rR]\\s+[rR][eE][pP][lL][Aa][Cc][Ee]", " ");
        cmdText = cmdText.replaceAll("\\s+[nN][oO][nN][eE][dD][iI][tT][iI][oO][nN][aA][bB][lL][eE]\\s", " ");
        cmdText = cmdText.replaceAll("\\s+[eE][dD][iI][tT][iI][oO][nN][aA][bB][lL][eE]\\s", " ");
        cmdText = cmdText.replaceAll("\\s+[eE][dD][iI][tT][iI][oO][nN][iI][nN][gG]\\s", " ");
        String[] tokens = this.getStringToTokens(cmdText);
        Object result = "";
        if (tokens == null) {
            return cmdText;
        }
        if (tokens.length < 3 && !tokens[0].equalsIgnoreCase("savepoint") && !tokens[0].equalsIgnoreCase("noaudit")) {
            if (tokens.length != 2) return cmdText;
            result = tokens[1];
        } else {
            tokens[0] = this.capitalize(tokens[0].toLowerCase());
            if (!tokens[0].equalsIgnoreCase("explain")) {
                if (tokens[0].equalsIgnoreCase("comment")) {
                    result = tokens[0].toLowerCase();
                } else if ((tokens[0].equalsIgnoreCase("restore") || tokens[0].equalsIgnoreCase("recover")) && tokens[1].equalsIgnoreCase("database")) {
                    result = tokens[1].toLowerCase();
                } else if (tokens[0].toLowerCase().equals("grant") || tokens[0].toLowerCase().equals("revoke") || tokens[0].toLowerCase().equals("audit") || tokens[0].toLowerCase().equals("lock") || tokens[0].toLowerCase().equals("noaudit") || tokens[0].toLowerCase().equals("call") || tokens[0].toLowerCase().equals("flashback")) {
                    result = tokens[0];
                } else if (tokens[1].toLowerCase().equals("restore") && tokens[2].toLowerCase().equals("point")) {
                    result = tokens[1] + " " + tokens[2] + " " + this.getQuotedName(tokens[3], cmdText);
                } else if (tokens[0].toLowerCase().equals("rename")) {
                    result = "";
                } else if (tokens[0].toLowerCase().equals("savepoint")) {
                    result = tokens[0].toLowerCase();
                } else if (tokens[1].toLowerCase().equals("on")) {
                    result = tokens[0] + " " + tokens[1].toLowerCase() + " " + tokens[2].toLowerCase() + " " + tokens[3].toLowerCase() + " " + this.getQuotedName(tokens[5], cmdText);
                } else if (tokens[0].toLowerCase().equals("purge") || tokens[1].toLowerCase().equals("session")) {
                    result = tokens[1].toLowerCase();
                } else if (tokens[1].toLowerCase().equals("tablespace") || tokens[2].toLowerCase().equals("tablespace")) {
                    result = tokens[1].toLowerCase().equals("tablespace") ? tokens[1] + " " + this.getQuotedName(tokens[2], cmdText) : tokens[2] + " " + this.getQuotedName(tokens[3], cmdText);
                } else if (tokens[1].toLowerCase().equals("materialized") || tokens[1].toLowerCase().equals("bitmap") || tokens[1].toLowerCase().equals("search") || tokens[1].toLowerCase().equals("unique") || tokens[1].toLowerCase().equals("public") || tokens[1].toLowerCase().equals("database") || tokens[1].toLowerCase().equals("force") || tokens[1].toLowerCase().equals("noaudit") || tokens[1].toLowerCase().equals("shared") || tokens[1].toLowerCase().equals("pluggable") || tokens[1].equalsIgnoreCase("rollback") || tokens[2].toLowerCase().equals("body") || tokens[1].toLowerCase().equals("global")) {
                    if (tokens.length < 4) {
                        if (tokens.length != 3) return cmdText;
                        if (!tokens[0].toLowerCase().equals("alter")) return cmdText;
                        if (!tokens[1].toLowerCase().equals("database")) return cmdText;
                        if (tokens[2].toLowerCase().equals("mount")) return "\n" + this.capitalize(ScriptRunnerDbArb.format("ALTERED", "Database")) + "\n";
                        if (!tokens[2].toLowerCase().equals("open")) return cmdText;
                        return "\n" + this.capitalize(ScriptRunnerDbArb.format("ALTERED", "Database")) + "\n";
                    }
                    result = tokens[1].toLowerCase().equals("database") && tokens[2].toLowerCase().equals("link") ? tokens[1].toLowerCase() + " " + tokens[2].toLowerCase() + " " + this.getQuotedName(tokens[3], cmdText) : (tokens[1].toLowerCase().equals("database") || tokens[2].toLowerCase().equals("flashback") ? tokens[1].toLowerCase() : (tokens[1].equalsIgnoreCase("rollback") && tokens[2].equalsIgnoreCase("segment") ? tokens[1].toLowerCase() + " " + tokens[2].toLowerCase() + " " + this.getQuotedName(tokens[3], cmdText) : (tokens[1].equalsIgnoreCase("database") && (tokens[2].equalsIgnoreCase("backup") || tokens[2].equalsIgnoreCase("add")) ? tokens[1].toLowerCase() : (tokens[3].toLowerCase().equals("log") || tokens[3].toLowerCase().equals("temporary") ? tokens[1].toLowerCase() + " " + tokens[2].toLowerCase() + " " + tokens[3].toLowerCase() + " " + this.getQuotedName(tokens[5], cmdText) : (tokens[2].toLowerCase().equals("database") && tokens[3].toLowerCase().equals("link") ? tokens[2].toLowerCase() + " " + tokens[3].toLowerCase() + " " + this.getQuotedName(tokens[4], cmdText) : (tokens[2].equalsIgnoreCase("index") || tokens[3].equalsIgnoreCase("index") ? (tokens[2].equalsIgnoreCase("index") ? tokens[2] + " " + this.getQuotedName(tokens[3], cmdText) : tokens[3] + " " + this.getQuotedName(tokens[4], cmdText)) : (tokens[3].toLowerCase().equals("link") ? tokens[1].toLowerCase() + " " + tokens[2].toLowerCase() + " " + tokens[3].toLowerCase() + " " + this.getQuotedName(tokens[4], cmdText) : (tokens[1].toLowerCase().equals("pluggable") && tokens[2].toLowerCase().equals("database") ? tokens[1].toLowerCase() + " " + tokens[2].toLowerCase() + " " + this.getQuotedName(tokens[3], cmdText) : (tokens[1].toLowerCase().equals("public") && tokens[2].toLowerCase().equals("synonym") || tokens[1].toLowerCase().equals("synonym") ? (tokens[1].toLowerCase().equals("public") ? tokens[2] + " " + this.getQuotedName(tokens[3], cmdText) : tokens[1] + " " + this.getQuotedName(tokens[2], cmdText)) : (tokens[1].toLowerCase().equals("force") ? tokens[2].toLowerCase() + " " + this.getQuotedName(tokens[3], cmdText) : tokens[1].toLowerCase() + " " + tokens[2].toLowerCase() + " " + this.getQuotedName(tokens[3], cmdText)))))))))));
                } else if (this.conn instanceof OracleConnection) {
                    result = tokens[1].toLowerCase() + " " + this.getQuotedName(tokens[2], cmdText);
                } else {
                    void var6_7;
                    List<String> list = Arrays.asList(tokens);
                    for (String tpk : thirdPartyKeywords) {
                        List list2 = var6_7.stream().filter(id -> !tpk.equalsIgnoreCase((String)id)).collect(Collectors.toList());
                    }
                    result = tokens[1].toLowerCase() + " " + this.getQuotedName((String)var6_7.get(0), cmdText).replaceAll("\\{", "");
                }
            }
        }
        String string = this.getVerb(tokens, action);
        result = string != null ? MessageFormat.format(this.getVerb(tokens, action), ((String)result).trim()) : ((String)result).trim();
        return "\n" + this.capitalize(((String)result).trim()) + "\n";
    }

    private String capitalize(String line) {
        boolean classic;
        boolean bl = classic = this.getScriptRunnerContext().getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(this.getScriptRunnerContext().getProperty("sqlplus.classic.mode").toString());
        if (classic) {
            return Character.toUpperCase(line.charAt(0)) + line.substring(1).toLowerCase();
        }
        return Character.toUpperCase(line.charAt(0)) + line.substring(1);
    }

    private String getQuotedName(String nameToken, String cmd) {
        boolean classic;
        ScriptRunnerContext ctx = this.getScriptRunnerContext();
        boolean bl = classic = ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString());
        if (classic) {
            return "";
        }
        String retVal = SQL.getQuotedNameComma(nameToken, cmd);
        if (retVal.endsWith(",")) {
            retVal = retVal.substring(0, retVal.length() - 1);
        }
        return retVal;
    }

    private static String getQuotedNameComma(String nameToken, String cmd) {
        if (nameToken.contains("\"") || nameToken.contains("[") || nameToken.contains("`")) {
            String endQuoteBrace;
            boolean braces = nameToken.contains("[");
            String startQuoteBrace = !braces ? "\"" : "[";
            String string = endQuoteBrace = !braces ? "\"" : "]";
            if (nameToken.contains("`")) {
                startQuoteBrace = "`";
                endQuoteBrace = "`";
            }
            StringTokenizer st = new StringTokenizer(cmd, "[]\"`");
            String[] tokens = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                tokens[i] = st.nextToken();
                ++i;
            }
            if (i > 3 && tokens[2].trim().equals(".")) {
                return startQuoteBrace + tokens[1] + endQuoteBrace + "." + startQuoteBrace + tokens[3] + endQuoteBrace;
            }
            if (i > 2 && tokens[2].trim().startsWith(".") && tokens[2].trim().length() > 1) {
                return startQuoteBrace + tokens[1] + endQuoteBrace + "." + tokens[2].trim().substring(1).trim().split("[ \r\t\n]")[0].toUpperCase(Locale.US);
            }
            if (i > 1 && tokens[0].trim().endsWith(".") && tokens[0].trim().indexOf(" ") != -1) {
                String removeDot = tokens[0].trim();
                removeDot = removeDot.substring(0, removeDot.length() - 1).trim();
                String[] alreadySplit = removeDot.split("[ \r\t\n]");
                String lastString = alreadySplit[alreadySplit.length - 1];
                return lastString.toUpperCase(Locale.US) + "." + startQuoteBrace + tokens[1] + endQuoteBrace;
            }
            return startQuoteBrace + tokens[1] + endQuoteBrace;
        }
        String retVal = nameToken;
        if (retVal != null) {
            retVal = nameToken.toUpperCase(Locale.US);
        }
        return retVal;
    }

    private String[] getStringToTokens(String cmd) {
        StringTokenizer st = new StringTokenizer(cmd, " \t\n\r\f(");
        String[] tokensOversize = new String[st.countTokens()];
        int quoteCount = 0;
        boolean append = false;
        int i = 0;
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            if (append) {
                int n = i;
                tokensOversize[n] = tokensOversize[n] + " " + next;
                append = false;
            } else {
                tokensOversize[i] = next;
            }
            int posQuote = 0;
            while ((posQuote = next.indexOf("'", posQuote)) != -1) {
                ++quoteCount;
                if (++posQuote != next.length()) continue;
            }
            if (quoteCount % 2 == 1 && st.hasMoreTokens()) {
                append = true;
                continue;
            }
            ++i;
        }
        if (append) {
            ++i;
        }
        String[] tokens = new String[i];
        for (int count = 0; count < i; ++count) {
            tokens[count] = tokensOversize[count];
        }
        return tokens;
    }

    private String getVerb(String[] string, boolean action) {
        if (action) {
            if (string[0].toLowerCase().equals("comment") || string[0].toLowerCase().equals("savepoint")) {
                return ScriptRunnerDbArb.get("CREATED");
            }
            if (string[0].toLowerCase().equals("create")) {
                String t2 = string[1].toLowerCase();
                if (t2.equals("procedure") || t2.equals("function") || t2.equals("package") || t2.equals("trigger")) {
                    return ScriptRunnerDbArb.get("COMPILED");
                }
                return ScriptRunnerDbArb.get("CREATED");
            }
            if (string[0].toLowerCase().equals("drop")) {
                return ScriptRunnerDbArb.get("DROPPED");
            }
            if (string[0].toLowerCase().equals("alter")) {
                if (string.length > 3 && string[3].equalsIgnoreCase("truncate")) {
                    return ScriptRunnerDbArb.get("TRUNCATED");
                }
                return ScriptRunnerDbArb.get("ALTERED");
            }
            if (string[0].toLowerCase().equals("truncate")) {
                return ScriptRunnerDbArb.get("TRUNCATED");
            }
            if (string[0].toLowerCase().equals("analyze")) {
                return ScriptRunnerDbArb.get("ANALYZED");
            }
            if (string[0].toLowerCase().equals("purge")) {
                return ScriptRunnerDbArb.get("PURGED");
            }
            if (string[0].toLowerCase().equals("call")) {
                return ScriptRunnerDbArb.get("COMPLETED");
            }
            if (string[0].toLowerCase().equals("rename")) {
                return ScriptRunnerDbArb.get("RENAMED");
            }
            if (string[0].toLowerCase().equals("restore")) {
                return ScriptRunnerDbArb.get("RESTORED");
            }
            if (string[0].toLowerCase().equals("recover")) {
                return ScriptRunnerDbArb.get("RECOVERED");
            }
            if (string[0].toLowerCase().equals("explain")) {
                return ScriptRunnerDbArb.get("EXPLAINED");
            }
            return ScriptRunnerDbArb.get("SUCCEEDED");
        }
        return null;
    }

    public static void main(String[] args) {
        SQLCommand s = new SQLCommand("alter type body whatever compile");
        SQL sql = new SQL(s, null);
        ScriptRunnerContext ctx = new ScriptRunnerContext();
        ctx.putProperty("sqlplus.classic.mode", true);
        sql.setScriptRunnerContext(ctx);
    }
}

