/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

public class SQLCommand
implements ISQLCommand {
    public static final String SCRIPTTABLE = "/*SQLDEV:SCRIPTTABLE*/";
    public static final String CREATEREFINE = "CREATEREFINE";
    public static final String STRIPPED_CONTINUATION = "STRIPPED_CONTINUATION";
    public static final String ORIGLINE = "ORIG_LINE";
    private StmtType m_stmtType = null;
    private StmtSubType m_stmtSubType = null;
    private StmtResultType m_stmtResultType = null;
    private String m_stmtProperty = null;
    private boolean m_isExecutable = true;
    private Restricted.Level m_restrictedLevel = Restricted.Level.R4;
    private boolean m_isRunnable = true;
    private int m_origStartLine = -1;
    private int m_origEndLine = -1;
    private String m_origSQL = null;
    private String m_modifiedSQL = null;
    private List<Object> m_binds = new ArrayList<Object>();
    private Properties m_properties = new Properties();
    private String m_stmtTerminator = null;
    private long m_time = 0L;
    private boolean m_topLevelCommand = false;
    private boolean _isComplete = true;
    private boolean failed = false;
    private boolean m_setCompoundCmd = false;
    private String m_compoundSetCmd = null;
    private int scriptDepth = 0;
    private List<String> batchStatements = null;
    private String _loweredTrimmed;
    private String _loweredTrimmedNOWS;
    private boolean requiresSpecialParsing = false;
    private static StmtSubType[] NoLogExecutableStmtSubType = new StmtSubType[]{StmtSubType.G_S_ATNESTED, StmtSubType.G_S_AT, StmtSubType.G_S_START, StmtSubType.G_S_HOSTALIAS, StmtSubType.G_S_HELP, StmtSubType.G_S_COMMENT_PLUS, StmtSubType.G_S_SPOOL, StmtSubType.G_S_SET_PAGESIZE, StmtSubType.G_S_SET_LINESIZE, StmtSubType.G_S_SET_LONG, StmtSubType.G_S_SET_COLSEP, StmtSubType.G_S_SET_HEADINGSEP, StmtSubType.G_S_SET_HEADING, StmtSubType.G_S_SET_WRAP, StmtSubType.G_S_SET_NUMBERFORMAT, StmtSubType.G_S_SET_NUMBERWIDTH, StmtSubType.G_S_COLUMN, StmtSubType.G_S_EXIT, StmtSubType.G_S_QUIT, StmtSubType.G_S_CONNECT, StmtSubType.G_S_SET_SQLPROMPT, StmtSubType.G_S_SET_NET, StmtSubType.G_S_SET_NETOVERWRITE, StmtSubType.G_S_NET, StmtSubType.G_S_FORMAT, StmtSubType.G_S_SHOW};
    private static StmtSubType[] NonOracleExecutableStmtSubType = new StmtSubType[]{StmtSubType.G_S_ATNESTED, StmtSubType.G_S_AT, StmtSubType.G_S_START, StmtSubType.G_S_SLASH, StmtSubType.G_S_HOSTALIAS, StmtSubType.G_S_HELP, StmtSubType.G_S_COMMENT_PLUS, StmtSubType.G_S_COLUMN, StmtSubType.G_S_SPOOL, StmtSubType.G_S_SET_PAGESIZE, StmtSubType.G_S_SET_LINESIZE, StmtSubType.G_S_SET_LONG, StmtSubType.G_S_SET_COLSEP, StmtSubType.G_S_SET_HEADINGSEP, StmtSubType.G_S_SET_HEADING, StmtSubType.G_S_SET_WRAP, StmtSubType.G_S_SET_NUMBERFORMAT, StmtSubType.G_S_SET_NUMBERWIDTH, StmtSubType.G_S_EXIT, StmtSubType.G_S_QUIT, StmtSubType.G_S_CONNECT, StmtSubType.G_S_DELIMITER};
    private static final String DDL = "ddl";
    private static final String DML = "dml";
    private static final String QUERY = "query";
    private static final String PLSQL = "plsql";
    private static final String SQLPLUS = "sqlplus";
    private static final String TRANS = "transaction-control";
    private static final String SESSION = "session-control";
    private static final String SYSTEM = "system-control";
    private static final String OTHER = "other";
    private static final String IGNORE = "ignore";
    private static final String JDBC = "jdbc";

    public SQLCommand(String origSQL) {
        this.m_origSQL = origSQL;
    }

    public SQLCommand(StmtType stmtType, StmtSubType stmtSubType, StmtResultType stmtResultType, boolean stmtExecutable, Restricted.Level restrictedLevel) {
        this.m_stmtType = stmtType;
        this.m_stmtSubType = stmtSubType;
        this.m_stmtResultType = stmtResultType;
        this.m_isExecutable = stmtExecutable;
        this.m_restrictedLevel = restrictedLevel;
    }

    public SQLCommand(SQLCommand cmd) {
        this.m_stmtType = cmd.getStmtType();
        this.m_stmtSubType = cmd.getStmtSubType();
        this.m_stmtResultType = cmd.getResultsType();
        this.m_isExecutable = cmd.getExecutable();
        this.m_restrictedLevel = cmd.getRestrictedLevel();
    }

    @Override
    public Restricted.Level getRestrictedLevel() {
        return this.m_restrictedLevel;
    }

    public StmtResultType getStmtResultType() {
        return this.m_stmtResultType;
    }

    public void setStmtResultType(StmtResultType stmtResultType) {
        this.m_stmtResultType = stmtResultType;
    }

    public boolean isStmtExecutable() {
        return this.m_isExecutable;
    }

    public void setStmtExecutable(boolean isExecutable) {
        this.m_isExecutable = isExecutable;
    }

    @Override
    public StmtSubType getStmtSubType() {
        return this.m_stmtSubType;
    }

    @Override
    public void setStmtSubType(StmtSubType stmtSubType) {
        this.m_stmtSubType = stmtSubType;
    }

    @Override
    public StmtType getStmtType() {
        return this.m_stmtType;
    }

    @Override
    public void setStmtType(StmtType stmtType) {
        this.m_stmtType = stmtType;
    }

    public void setRequiresSpecialParsing(boolean requiresSpecialParsing) {
        this.requiresSpecialParsing = requiresSpecialParsing;
    }

    public boolean requiresSpecialParsing() {
        return this.requiresSpecialParsing;
    }

    @Override
    public String getModifiedSQL() {
        return this.m_modifiedSQL;
    }

    @Override
    public void setModifiedSQL(String modifiedSQL) {
        this.m_modifiedSQL = modifiedSQL = this.removeHints(modifiedSQL);
    }

    private String removeHints(String modifiedSQL) {
        if (modifiedSQL == null) {
            return null;
        }
        if (modifiedSQL.indexOf("/*sqldev") > 0) {
            int spaceOnLeft = StringUtils.rtrim(modifiedSQL).length() - modifiedSQL.trim().length();
            for (String hint : SQLStatementTypes.hintTokens.keySet()) {
                if (!modifiedSQL.trim().toLowerCase().startsWith(hint.toLowerCase())) continue;
                modifiedSQL = modifiedSQL.substring(hint.length() + spaceOnLeft);
            }
        }
        return modifiedSQL;
    }

    public int getOrigEndLine() {
        return this.m_origEndLine;
    }

    public void setOrigEndLine(int origEndLine) {
        this.m_origEndLine = origEndLine;
    }

    public String getOrigSQL() {
        if (this.m_origSQL == null) {
            return null;
        }
        return StringUtils.rtrim(this.m_origSQL);
    }

    public void setOrigSQL(String origSQL) {
        this.m_origSQL = origSQL;
    }

    public int getOrigStartLine() {
        return this.m_origStartLine;
    }

    public void setOrigStartLine(int origStartLine) {
        this.m_origStartLine = origStartLine;
    }

    @Override
    public List<Object> getBinds() {
        return this.m_binds;
    }

    @Override
    public void setBinds(List<Object> binds) {
        this.m_binds = binds;
    }

    @Override
    public void addBind(Object o) {
        this.m_binds.add(o);
    }

    @Override
    public int getEndLine() {
        return this.getOrigEndLine();
    }

    @Override
    public int getLines() {
        return this.getOrigEndLine() - this.getOrigStartLine();
    }

    @Override
    public StmtResultType getResultsType() {
        return this.getStmtResultType();
    }

    @Override
    public boolean getRunnable() {
        return this.m_isRunnable;
    }

    @Override
    public String getSQLOrig() {
        return this.getOrigSQL();
    }

    @Override
    public String getSQLOrigWithTerminator() {
        return this.m_origSQL + this.getStatementTerminator();
    }

    @Override
    public String getSql() {
        return this.getModifiedSQL();
    }

    @Override
    public String getSqlWithTerminator() {
        String seperator = "";
        if (this.getStatementTerminator().equals("/")) {
            seperator = "\n";
        }
        return this.getModifiedSQL() + seperator + this.getStatementTerminator();
    }

    @Override
    public int getStartLine() {
        return this.getOrigStartLine();
    }

    @Override
    public StmtType getStmtClass() {
        return this.getStmtType();
    }

    @Override
    public StmtSubType getStmtId() {
        return this.getStmtSubType();
    }

    @Override
    public void setEndLine(int line) {
        this.setOrigEndLine(line);
    }

    @Override
    public void setLines(int lines) {
    }

    @Override
    public void setResultsType(StmtResultType resultsType) {
        this.setStmtResultType(resultsType);
    }

    @Override
    public void setRunnable(boolean isRunnable) {
        this.m_isRunnable = isRunnable;
    }

    @Override
    public void setExecutable(boolean isExecutable) {
        this.m_isExecutable = isExecutable;
    }

    @Override
    public boolean getExecutable() {
        return this.m_isExecutable;
    }

    @Override
    public void setSQLOrig(String sqlOrig) {
        this.setOrigSQL(sqlOrig);
    }

    @Override
    public void setSql(String sql) {
        this.setModifiedSQL(sql);
    }

    @Override
    public void setStartLine(int line) {
        this.setOrigStartLine(line);
    }

    @Override
    public void setStmtClass(StmtType stmtClass) {
        this.setStmtType(stmtClass);
    }

    @Override
    public void setStmtId(StmtSubType stmtId) {
        this.setStmtSubType(stmtId);
    }

    @Override
    public String getStmtProperty() {
        return this.m_stmtProperty;
    }

    public void setStmtProperty(String stmtProperty) {
        this.m_stmtProperty = stmtProperty;
    }

    @Override
    public boolean isSqlPlusSetCmd() {
        return this.getStmtType() == StmtType.G_C_SQLPLUS && this.getStmtSubType().toString().startsWith("G_S_SET");
    }

    @Override
    public boolean isCreateSQLCmd() {
        return this.getStmtType() == StmtType.G_C_SQL && this.getStmtSubType().toString().startsWith("G_S_CREATE_");
    }

    @Override
    public boolean isCreatePLSQLCmd() {
        return this.getStmtType() == StmtType.G_C_PLSQL && this.getStmtSubType().toString().startsWith("G_S_CREATE_");
    }

    @Override
    public boolean isCreateCmd() {
        return this.getStmtSubType().toString().startsWith("G_S_CREATE_");
    }

    @Override
    public Object getProperty(String key) {
        return this.m_properties.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.m_properties.put(key, value);
    }

    public void setStatementTerminator(String stmtTerminator) {
        this.m_stmtTerminator = stmtTerminator;
    }

    @Override
    public String getStatementTerminator() {
        return this.m_stmtTerminator != null ? this.m_stmtTerminator : "";
    }

    @Override
    public boolean equals(Object sqlcommand) {
        if (!(sqlcommand instanceof SQLCommand)) {
            return false;
        }
        SQLCommand sqlCommand = (SQLCommand)sqlcommand;
        return sqlCommand.getStartLine() == this.getStartLine() && sqlCommand.getEndLine() == this.getEndLine() && sqlCommand.getOrigSQL().equals(this.getOrigSQL()) && sqlCommand.getStmtType() == this.getStmtType() && sqlCommand.getStmtSubType() == this.getStmtSubType() && sqlCommand.getStmtResultType() == this.getStmtResultType();
    }

    public static boolean isNoLogExecutable(ISQLCommand cmd) {
        if (cmd == null || cmd.getStmtSubType() == null) {
            return true;
        }
        for (StmtSubType currentStmtSubType : NoLogExecutableStmtSubType) {
            if (currentStmtSubType != cmd.getStmtSubType()) continue;
            return true;
        }
        return false;
    }

    public static boolean isNonOracleExecutable(ISQLCommand cmd) {
        if (cmd == null || cmd.getStmtSubType() == null) {
            return true;
        }
        for (StmtSubType currentStmtSubType : NonOracleExecutableStmtSubType) {
            if (currentStmtSubType != cmd.getStmtSubType()) continue;
            return true;
        }
        return SQLCommand.isSHOWJDBC(cmd);
    }

    private static boolean isSHOWJDBC(ISQLCommand cmd) {
        if (cmd.getStmtSubType() == StmtSubType.G_S_SHOW) {
            try {
                String showType = cmd.getSql().trim().toLowerCase().replaceAll("^show?\\s+", "");
                if (showType != null && showType.startsWith(JDBC)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public long getTiming() {
        return this.m_time;
    }

    @Override
    public void setTiming(long elapsedTime) {
        this.m_time = elapsedTime;
    }

    @Override
    public boolean isTopLevel() {
        return this.m_topLevelCommand;
    }

    @Override
    public void setTopLevel(boolean topLevel) {
        this.m_topLevelCommand = topLevel;
    }

    public void setIsComplete(boolean complete) {
        this._isComplete = complete;
    }

    @Override
    public boolean isComplete() {
        return this._isComplete;
    }

    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public void setFail() {
        this.failed = true;
    }

    @Override
    public boolean isFail() {
        return this.failed;
    }

    public void setIsSetCompoundCmd(boolean compoundCmd) {
        this.m_setCompoundCmd = compoundCmd;
    }

    @Override
    public boolean isSetCompoundCmd() {
        return this.m_setCompoundCmd;
    }

    public void setCompoundSetcmd(String cmd) {
        this.m_compoundSetCmd = cmd;
    }

    @Override
    public String getCompoundSetcmd() {
        return this.m_compoundSetCmd;
    }

    @Override
    public String getReadableType() {
        if (this.getStmtClass() == null) {
            return OTHER;
        }
        if (this.getStmtClass() == StmtType.G_C_PLSQL) {
            return PLSQL;
        }
        if (this.getStmtClass() == StmtType.G_C_SQLPLUS) {
            return SQLPLUS;
        }
        if (this.getStmtClass() == StmtType.G_C_UNKNOWN) {
            return OTHER;
        }
        if (this.getStmtClass() == StmtType.G_C_COMMENT || this.getStmtClass() == StmtType.G_C_MULTILINECOMMENT || this.getStmtClass() == StmtType.G_C_EMPTYLINE || this.getStmtClass() == StmtType.G_C_OLDCOMMENT) {
            return IGNORE;
        }
        if (this.getStmtClass() == StmtType.G_C_USERDEFINED) {
            return SQLPLUS;
        }
        if (this.getStmtClass() == StmtType.G_C_NOT_CONNECTED) {
            return SQLPLUS;
        }
        if (this.getStmtClass() == StmtType.G_C_SCRIPT) {
            return OTHER;
        }
        if (this.getResultsType() != null && this.getStmtSubType() != null) {
            if (this.getResultsType() == StmtResultType.G_R_QUERY) {
                return QUERY;
            }
            if (this.getResultsType() == StmtResultType.G_R_DML) {
                return DML;
            }
            if (this.getResultsType() == StmtResultType.G_R_SCRIPTEDQUERY) {
                return SQLPLUS;
            }
            if (this.getStmtSubType() == StmtSubType.G_S_COMMIT || this.getStmtSubType() == StmtSubType.G_S_ROLLBACK_SQL || this.getStmtSubType() == StmtSubType.G_S_SAVEPOINT || this.getStmtSubType() == StmtSubType.G_S_SET_TRANSACTION) {
                return TRANS;
            }
            if (this.getStmtSubType() == StmtSubType.G_S_SET_ROLE) {
                return SESSION;
            }
            if (this.getStmtSubType() == StmtSubType.G_S_ALTER) {
                if (this.getOrigSQL().indexOf("SESSION") != -1) {
                    return SESSION;
                }
                if (this.getOrigSQL().indexOf("SYSTEM") != -1) {
                    return SYSTEM;
                }
                return DDL;
            }
            if (this.getStmtSubType() == StmtSubType.G_S_CALL || this.getStmtSubType() == StmtSubType.G_S_EXPLAIN || this.getStmtSubType() == StmtSubType.G_S_LOCK) {
                return DML;
            }
            if (this.getStmtSubType() == StmtSubType.G_S_JDBC) {
                return JDBC;
            }
            return DDL;
        }
        return OTHER;
    }

    @Override
    public int getdepth() {
        if (this.scriptDepth > 0) {
            return this.scriptDepth;
        }
        return 0;
    }

    @Override
    public void setDepth(int depth) {
        this.scriptDepth = depth;
    }

    @Override
    public void setBatchStatements(List<String> stmts) {
        this.batchStatements = stmts;
    }

    @Override
    public List<String> getBatchStatements() {
        return this.batchStatements;
    }

    @Override
    public String getLoweredTrimmedSQL() {
        if (this._loweredTrimmed == null) {
            this._loweredTrimmed = this.getSql().trim().toLowerCase();
        }
        return this._loweredTrimmed;
    }

    @Override
    public String getLoweredTrimmedNoWhitespaceSQL() {
        if (this._loweredTrimmedNOWS == null) {
            this._loweredTrimmedNOWS = this.getLoweredTrimmedSQL().replaceAll(" ", "");
        }
        return this._loweredTrimmedNOWS;
    }

    public static enum StmtResultType {
        G_R_QUERY,
        G_R_DML,
        G_R_THREE_WORD,
        G_R_ONE_WORD,
        G_R_PERMISSION,
        G_R_NONE,
        G_R_UNKNOWN,
        G_R_SCRIPTEDQUERY;

    }

    public static enum StmtSubType {
        G_S_UNKNOWN,
        G_S_ACCEPT,
        G_S_ALTER,
        G_S_ANALYZE,
        G_S_APPEND,
        G_S_ARCHIVE,
        G_S_ASSOCIATE,
        G_S_AT,
        G_S_ATNESTED,
        G_S_ATTRIBUTE,
        G_S_AUDIT,
        G_S_BEGIN,
        G_S_BLOCKTERMINATOR,
        G_S_BREAK,
        G_S_BTITLE,
        G_S_CALL,
        G_S_CHANGE,
        G_S_CLEAR,
        G_S_COLUMN,
        G_S_COMMENT_SQL,
        G_S_COMMIT,
        G_S_COMMENT_PLUS,
        G_S_COMPUTE,
        G_S_CONNECT,
        G_S_COPY,
        G_S_DECLARE,
        G_S_DEFINE,
        G_S_DEL_PLUS,
        G_S_DELETE,
        G_S_DESCRIBE,
        G_S_DISASSOCIATE,
        G_S_DISCONNECT,
        G_S_DROP,
        G_S_EDIT,
        G_S_EXECUTE,
        G_S_EXPAND,
        G_S_EXIT,
        G_S_EXPLAIN,
        G_S_FIND,
        G_S_FLASHBACK,
        G_S_GET,
        G_S_GRANT,
        G_S_HOST,
        G_S_HOSTALIAS,
        G_S_HELP,
        G_S_INPUT,
        G_S_INSERT,
        G_S_LIST,
        G_S_LOCK,
        G_S_MERGE,
        G_S_NEWPAGE,
        G_S_NOAUDIT,
        G_S_ORADEBUG,
        G_S_PASSWORD,
        G_S_PLSQLLABEL,
        G_S_PAUSE,
        G_S_PRINT,
        G_S_PWD,
        G_S_SET_PROPERTY,
        G_S_PROMPT,
        G_S_PURGE,
        G_S_QUIT,
        G_S_RENAME,
        G_S_RECOVER,
        G_S_REPFOOTER,
        G_S_REPHEADER,
        G_S_REVOKE,
        G_S_ROLLBACK_PLUS,
        G_S_ROLLBACK_SQL,
        G_S_RUN,
        G_S_SAVE,
        G_S_SAVEPOINT,
        G_S_SELECT,
        G_S_SHOW,
        G_S_SHUTDOWN,
        G_S_SLASH,
        G_S_SPOOL,
        G_S_SQLPLUSPREFIX,
        G_S_SQLTERMINATOR,
        G_S_START,
        G_S_STARTUP,
        G_S_STORE,
        G_S_TIMING,
        G_S_TRUNCATE,
        G_S_TOSUB,
        G_S_TTITLE,
        G_S_UNDEFINE,
        G_S_UPDATE,
        G_S_VALIDATE,
        G_S_VARIABLE,
        G_S_WHENEVER,
        G_S_WHICH,
        G_S_WITH,
        G_S_SET,
        G_S_XQUERY,
        G_S_SETLOGLEVEL,
        G_S_LOADQUERYFILE,
        G_S_SET_ARRAYSIZE,
        G_S_SET_APPINFO,
        G_S_SET_AUTOCOMMIT,
        G_S_SET_AUTOPRINT,
        G_S_SET_AUTOTRACE,
        G_S_SET_COPYCOMMIT,
        G_S_SET_CONCAT,
        G_S_SET_EMBEDDED,
        G_S_SET_ESCAPE,
        G_S_SET_EXITCOMMIT,
        G_S_SET_FEEDBACK,
        G_S_SET_OWA,
        G_S_SET_GETPAGE,
        G_S_SET_SERVEROUTPUT,
        G_S_SET_SPOOL,
        G_S_SET_TERM,
        G_S_SET_TIMING,
        G_S_SET_VERIFY,
        G_S_SET_XQUERY,
        G_S_SET_CONSTRAINT,
        G_S_SET_ROLE,
        G_S_SET_TRANSACTION,
        G_S_SET_PAUSE,
        G_S_SET_ECHO,
        G_S_SET_DEFINE,
        G_S_SET_DESCRIBE,
        G_S_SET_SCAN,
        G_S_SET_SUFFIX,
        G_S_SET_EDITFILE,
        G_S_SET_NULL,
        G_S_SET_NET,
        G_S_SET_NEW_PAGE,
        G_S_SET_NETOVERWRITE,
        G_S_SET_OBSOLETE,
        G_S_SET_UNKNOWN,
        G_S_SET_PAGESIZE,
        G_S_SET_LINESIZE,
        G_S_SET_LONG,
        G_S_CLOUDSTORAGE,
        G_S_SET_CLOUDSTORAGE,
        G_S_SET_LOAD,
        G_S_SET_LOADFORMAT,
        G_S_SET_DATAPUMP,
        G_S_SET_LONGC,
        G_S_SET_COLSEP,
        G_S_SET_SECUREDCOL,
        G_S_SET_HEADING,
        G_S_SET_HEADINGSEP,
        G_S_SET_SECURELITERALS,
        G_S_SET_TAB,
        G_S_SET_TRIMSPOOL,
        G_S_SET_TRIMOUT,
        G_S_SET_WRAP,
        G_S_SET_NUMBERWIDTH,
        G_S_SET_NUMBERFORMAT,
        G_S_CREATE_PACKAGE_HEADER,
        G_S_CREATE_PACKAGE_BODY,
        G_S_CREATE_PROCEDURE,
        G_S_CREATE_TRIGGER,
        G_S_CREATE_FUNCTION,
        G_S_CREATE_TYPE,
        G_S_CREATE_LIBRARY,
        G_S_CREATE_JAVA,
        G_S_CREATE_TABLE,
        G_S_CREATE_VIEW,
        G_S_CREATE_DATABASE,
        G_S_CREATE_CONN,
        G_S_CREATE_UNKNOWN,
        G_S_FORALLEVENTS_STMTSUBTYPE,
        G_S_FORALLSTMTS_STMTSUBTYPE,
        G_S_BEFOREAFTER_SCRIPT,
        G_S_SET_WORKSHEETNAME,
        G_S_BRIDGE,
        G_S_DOC_PLUS,
        G_S_SET_SQLPROMPT,
        G_S_OERR,
        G_S_DDL,
        G_S_CLEAR_SCREEN,
        G_S_SET_TIME,
        G_S_HISTORY,
        G_S_KEYMAP,
        G_S_ALIAS,
        G_S_NET,
        G_S_CD,
        G_S_SQLPATH,
        G_S_FORMAT,
        G_S_ADMINISTER,
        G_S_CTAS,
        G_S_SSHTUNNEL,
        G_S_SET_DDL,
        G_S_LOAD,
        G_S_UNLOAD,
        G_S_DATAPUMP,
        G_S_MIGRATEADVISOR,
        G_S_SET_SQLBL,
        G_S_SET_BLO,
        G_S_SET_CLEARSCREEN,
        G_S_SET_ENCODING,
        G_S_SCRIPT,
        G_S_SET_SQLPLUS_CLASSIC_MODE,
        G_S_SET_IGNORE_SETTING_MODE,
        G_S_SET_PRELIM,
        G_S_SET_SHOWMODE,
        G_S_SET_XMLFORMAT,
        G_S_SET_CLOSECURSOR,
        G_S_SET_SQLCOMPATABILITY,
        G_S_SET_XMLOPTIMIZATIONCHECK,
        G_S_SET_CODESCAN,
        G_S_SET_HISTORY,
        G_S_SET_HIGHLIGHTING,
        G_S_SET_STATUSBAR,
        G_S_SET_EDITOR,
        G_S_VERSION,
        G_S_SET_COLINVISIBLE,
        G_S_NLSLANG,
        G_S_JDBC,
        G_S_SET_ERROR_LOGGING,
        G_S_SET_MAXROWS,
        G_S_SET_MAXROWSSPOOLTRUNCATE,
        G_S_DRIVERS,
        G_S_DELIMITER,
        G_S_USE;

    }

    public static enum StmtType {
        G_C_UNKNOWN,
        G_C_SQL,
        G_C_PLSQL,
        G_C_SQLPLUS,
        G_C_COMMENT,
        G_C_EMPTYLINE,
        G_C_MULTILINECOMMENT,
        G_C_OLDCOMMENT,
        G_C_USERDEFINED,
        G_C_NOT_CONNECTED,
        G_C_SCRIPT,
        G_C_JDBC;

    }
}

