/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.apex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;

public class APEXExportSplitter {
    private boolean flatten = false;
    private boolean checksum = true;
    private boolean debug = false;
    private boolean update = false;
    private String baseFolder;
    private FileOutputStream updateFile;

    public void setOptions(String baseFolder, boolean flat, boolean checksum, boolean debug, boolean update) {
        this.flatten = flat;
        this.checksum = checksum;
        this.debug = debug;
        this.update = update;
        this.baseFolder = baseFolder;
    }

    private void printUpdate(String s) throws IOException {
        if (this.update) {
            if (this.updateFile == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(Calendar.getInstance().get(2));
                sb.append("-");
                sb.append(Calendar.getInstance().get(5));
                sb.append("-");
                sb.append(Calendar.getInstance().get(1));
                sb.append("-");
                sb.append(Calendar.getInstance().get(11));
                sb.append("-");
                sb.append(Calendar.getInstance().get(12));
                sb.append("-");
                sb.append(Calendar.getInstance().get(13));
                Object f = this.baseFolder + File.separator + "update-" + sb.toString() + ".sql";
                if (this.flatten) {
                    f = ((String)f).replaceAll("/", "_");
                }
                this.updateFile = new FileOutputStream(new File((String)f));
                this.updateFile.write("@init.sql \r\n".getBytes());
                this.updateFile.write("@env.sql \r\n".getBytes());
            }
            this.updateFile.write(("@" + s + " \r\n").getBytes());
        }
    }

    private void log(String s) {
        if (this.debug) {
            System.out.print(s);
        }
    }

    private static void copy(File src, File dst) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void checkFileForChanges(File file, String filename) throws IOException {
        File dest = new File(filename);
        boolean move = true;
        if (dest.exists() && this.checksum && APEXExportSplitter.getCheckSum(file) == APEXExportSplitter.getCheckSum(dest)) {
            move = false;
        }
        if (move || !this.checksum) {
            this.log("---Renaming... to " + filename + "\n");
            APEXExportSplitter.copy(file, dest);
            this.printUpdate(filename);
        }
        file.delete();
    }

    private static long getCheckSum(File file) {
        long checksum = 0L;
        try {
            CheckedInputStream cis = new CheckedInputStream(new FileInputStream(file), new Adler32());
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            checksum = cis.getChecksum().getValue();
            cis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return checksum;
    }

    public void processFile(String baseFile) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(baseFile));
        String line = null;
        File tmpFile = null;
        Path _path = Paths.get(baseFile, new String[0]);
        String fileName = _path.getFileName().toString();
        String _cwd = _path.getParent().toString();
        this.baseFolder = fileName.substring(0, fileName.indexOf("."));
        Object initFileName = "application/init.sql";
        if (this.flatten) {
            initFileName = ((String)initFileName).replaceAll("/", "_");
        }
        initFileName = this.baseFolder + "/" + (String)initFileName;
        StringBuffer runScript = new StringBuffer("@" + (String)initFileName + "\n");
        Object currentFileName = null;
        OutputStreamWriter currentWriter = null;
        StringBuffer init = new StringBuffer();
        String currentDir = "";
        HashSet<String> currentDirFiles = new HashSet<String>(100);
        while ((line = in.readLine()) != null) {
            if (line.indexOf("prompt --application") == 0 || line.indexOf("--application") == 0) {
                if (currentWriter != null) {
                    currentWriter.flush();
                    currentWriter.close();
                    this.checkFileForChanges(tmpFile, (String)currentFileName);
                }
                if (!currentDir.equals(((String)(currentFileName = line.substring(line.indexOf("--") + 2).trim().replaceAll("\\.", "").replaceAll(" ", "_"))).substring(0, ((String)currentFileName).lastIndexOf("/")))) {
                    currentDir = ((String)currentFileName).substring(0, ((String)currentFileName).lastIndexOf("/"));
                    currentDirFiles.clear();
                }
                String baseFileName = currentFileName;
                int i = 1;
                while (currentDirFiles.contains(currentFileName)) {
                    currentFileName = baseFileName + "_" + ++i;
                }
                currentDirFiles.add((String)currentFileName);
                currentFileName = (String)currentFileName + ".sql";
                if (this.flatten) {
                    currentFileName = ((String)currentFileName).replaceAll("/", "_");
                }
                currentFileName = this.baseFolder + "/" + (String)currentFileName;
                File dir = new File(((String)currentFileName).substring(0, ((String)currentFileName).lastIndexOf("/")));
                dir.mkdirs();
                runScript.append("@" + (String)currentFileName + "\n");
                tmpFile = File.createTempFile("apex", ".sql");
                this.log("--Processing:" + (String)currentFileName + "\n");
                currentWriter = new FileWriter(tmpFile);
            }
            if (currentWriter != null) {
                currentWriter.write(line + "\n");
                continue;
            }
            init.append(line + "\n");
        }
        currentWriter.flush();
        currentWriter.close();
        this.checkFileForChanges(tmpFile, (String)currentFileName);
        FileWriter file = new FileWriter(_cwd + "/" + (String)initFileName);
        file.write(init.toString());
        file.flush();
        file.close();
        String installFileName = "install.sql";
        if (this.flatten) {
            installFileName = installFileName.replaceAll("/", "_");
        }
        file = new FileWriter(_cwd + "/" + installFileName);
        file.write(runScript.toString());
        file.flush();
        file.close();
        if (this.updateFile != null) {
            this.updateFile.close();
        }
        in.close();
    }

    public LinkedHashMap<String, String> processFile2(String fileName, Clob data) throws IOException, SQLException {
        Reader is = data.getCharacterStream();
        BufferedReader in = new BufferedReader(is);
        String line = null;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        this.baseFolder = fileName.substring(0, fileName.indexOf("."));
        Object initFileName = "application/init.sql";
        if (this.flatten) {
            initFileName = ((String)initFileName).replaceAll("/", "_");
        }
        initFileName = this.baseFolder + "/" + (String)initFileName;
        StringBuffer runScript = new StringBuffer("@" + (String)initFileName + "\n");
        Object currentFileName = null;
        StringBuffer currentWriter = null;
        StringBuffer init = new StringBuffer();
        String currentDir = "";
        HashSet<String> currentDirFiles = new HashSet<String>(100);
        map.put((String)initFileName, "");
        while ((line = in.readLine()) != null) {
            if (line.indexOf("prompt --application") == 0 || line.indexOf("--application") == 0) {
                if (currentFileName != null) {
                    map.put((String)currentFileName, currentWriter.toString());
                }
                if (!currentDir.equals(((String)(currentFileName = line.substring(line.indexOf("--") + 2).trim().replaceAll("\\.", "").replaceAll(" ", "_"))).substring(0, ((String)currentFileName).lastIndexOf("/")))) {
                    currentDir = ((String)currentFileName).substring(0, ((String)currentFileName).lastIndexOf("/"));
                    currentDirFiles.clear();
                }
                String baseFileName = currentFileName;
                int i = 1;
                while (currentDirFiles.contains(currentFileName)) {
                    currentFileName = baseFileName + "_" + ++i;
                }
                currentDirFiles.add((String)currentFileName);
                currentFileName = (String)currentFileName + ".sql";
                if (this.flatten) {
                    currentFileName = ((String)currentFileName).replaceAll("/", "_");
                }
                currentFileName = this.baseFolder + "/" + (String)currentFileName;
                runScript.append("@" + ((String)currentFileName).substring(((String)currentFileName).indexOf("/") + 1) + "\n");
                currentWriter = new StringBuffer();
            }
            if (currentWriter != null) {
                currentWriter.append(line + "\n");
                continue;
            }
            init.append(line + "\n");
        }
        map.put((String)currentFileName, currentWriter.toString());
        map.put((String)initFileName, init.toString());
        in.close();
        return map;
    }

    public static void usage() {
        System.out.println("-help       : < print this syntax >");
        System.out.println("-flat       : < flat file structure >");
        System.out.println("-debug      : < print debug info >");
        System.out.println("-update     : < create update file >");
        System.out.println("-nochecksum : < don't check for changes >");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        String arg;
        int i;
        if (args.length == 0) {
            APEXExportSplitter.usage();
        }
        APEXExportSplitter s = new APEXExportSplitter();
        for (i = 0; i < args.length; ++i) {
            arg = args[i];
            if (arg.equals("-flat")) {
                s.flatten = true;
                System.out.println("Using flat structure");
                continue;
            }
            if (arg.equals("-nochecksum")) {
                s.checksum = false;
                continue;
            }
            if (arg.equals("-debug")) {
                s.debug = true;
                continue;
            }
            if (arg.equals("-update")) {
                s.update = true;
                continue;
            }
            if (!arg.equals("-help")) continue;
            APEXExportSplitter.usage();
        }
        for (i = 0; i < args.length; ++i) {
            arg = args[i];
            if (arg.indexOf("-") != -1) continue;
            try {
                System.out.println("Processing:" + arg);
                s.processFile(arg);
                continue;
            }
            catch (Exception e) {
                System.err.println("Could not process:" + arg);
                System.err.println(e.getMessage());
                if (!s.debug) continue;
                e.printStackTrace();
            }
        }
    }
}

