/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class Help
extends CommandListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Object command = (cmd.getLoweredTrimmedSQL() + " ").substring((cmd.getLoweredTrimmedSQL() + " ").indexOf(" ")).trim();
        try {
            String[] lines;
            String[] sets = ((String)command).split("\\s+");
            if (sets.length == 2 && sets[0].toLowerCase().equals("set")) {
                command = sets[0] + sets[1];
            }
            for (String line : lines = this.HelpOnOrIndex((String)command, ctx).split("\n")) {
                ctx.write(line + "\n");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    protected String highlightBold(String text) {
        return text;
    }

    private String HelpOnOrIndex(String in, ScriptRunnerContext ctx) throws Exception {
        if (in == null || in.equals("") || in.equalsIgnoreCase("help") || in.equalsIgnoreCase("index") || in.equalsIgnoreCase("all") || in.equalsIgnoreCase("?")) {
            return this.getHelpProperty("", ctx);
        }
        Object help = "";
        help = (String)help + this.getHelpProperty(in, ctx);
        return help;
    }

    private String getHelpProperty(String in, ScriptRunnerContext ctx) throws Exception {
        TreeMap<String, Supplier<String>> setHelps = new TreeMap<String, Supplier<String>>();
        TreeMap<String, Supplier<String>> showHelps = new TreeMap<String, Supplier<String>>();
        TreeMap<String, Supplier<String>> commandHelps = new TreeMap<String, Supplier<String>>();
        HashSet<String> sqlplusTags = new HashSet<String>();
        Enumeration<String> tagsEnumeration = HelpMessages.getKeys();
        if (tagsEnumeration == null) {
            throw new Exception(Messages.getString("NO_HELP_KEYS"));
        }
        ArrayList<String> tags = Collections.list(tagsEnumeration);
        for (String tag : tags) {
            String key = tag.toUpperCase();
            if (key.equals("SET")) {
                commandHelps.put(key, () -> this.buildSetHelp(() -> this.buildHelpMessageHelp("SET"), setHelps));
                continue;
            }
            if (key.startsWith("SET")) {
                setHelps.put(key, () -> this.buildHelpMessageHelp(tag));
                continue;
            }
            if (key.equals("SHOW")) {
                commandHelps.put(key, () -> this.buildShowHelp(() -> this.buildHelpMessageHelp("SHOW"), showHelps));
                continue;
            }
            if (key.startsWith("SHOW")) {
                showHelps.put(key, () -> this.buildHelpMessageHelp(tag));
                continue;
            }
            if (tag.trim().length() <= 0) continue;
            commandHelps.put(key, () -> this.buildHelpMessageHelp(tag));
        }
        for (IHelp help : CommandRegistry.getCommandsWithHelp()) {
            String tag = help.getCommand();
            String key = tag.toUpperCase();
            if (key.equals("SET")) {
                commandHelps.put(key, () -> this.buildSetHelp(() -> help.getHelp(), setHelps));
            } else if (key.startsWith("SET")) {
                setHelps.put(key, () -> help.getHelp());
            } else if (key.equals("SHOW")) {
                commandHelps.put(key, () -> this.buildShowHelp(() -> help.getHelp(), showHelps));
            } else if (key.startsWith("SHOW")) {
                showHelps.put(tag, () -> help.getHelp());
            } else if (tag.trim().length() > 0) {
                commandHelps.put(key, () -> help.getHelp());
            }
            if (help.isSqlPlus()) continue;
            sqlplusTags.add(key);
        }
        String retVal = null;
        String reqKey = in.toUpperCase();
        Supplier helpSupplier = (Supplier)commandHelps.get(reqKey);
        if (helpSupplier != null) {
            retVal = (String)helpSupplier.get();
        }
        if (retVal == null && (helpSupplier = (Supplier)setHelps.get(reqKey)) != null) {
            retVal = (String)helpSupplier.get();
        }
        if (retVal == null) {
            retVal = this.buildHelpHelp(ctx, reqKey, commandHelps, sqlplusTags);
        }
        return retVal;
    }

    private String printColumns(Collection<? extends CharSequence> items, ScriptRunnerContext ctx) {
        StringBuilder s = new StringBuilder();
        if (items == null || items.isEmpty()) {
            return "";
        }
        int width = 82;
        if (ctx.isCommandLine() && ctx.getSQLPlusConsoleReader().getWidth() > width) {
            width = ctx.getSQLPlusConsoleReader().getWidth();
        }
        int maxWidth = 0;
        for (CharSequence charSequence : items) {
            maxWidth = Math.max(maxWidth, charSequence.length());
        }
        StringBuilder buff = new StringBuilder();
        int n = width / (maxWidth += 3);
        int col = 0;
        for (CharSequence charSequence : items) {
            int i;
            String name = charSequence.toString();
            if (name.endsWith("*")) {
                name = this.highlightBold(name.replace("*", " "));
            }
            if (col < n) {
                buff.append(name);
                for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                    buff.append(' ');
                }
                ++col;
                continue;
            }
            s.append(buff.toString()).append("\n");
            buff.setLength(0);
            col = 0;
            buff.append(name);
            for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                buff.append(' ');
            }
            ++col;
        }
        if (buff.length() > 0) {
            s.append(buff.toString());
        }
        return s.toString();
    }

    private String buildSetHelp(Supplier<String> setHeaderSupplier, SortedMap<String, Supplier<String>> setHelps) {
        StringBuilder retBuff = new StringBuilder();
        retBuff.append(setHeaderSupplier.get());
        for (String mytag : setHelps.keySet()) {
            String name = mytag.replace("_", " ");
            if (!name.startsWith("SET")) continue;
            retBuff.append(" ").append(name.substring(3)).append("\n");
        }
        return retBuff.toString();
    }

    private String buildShowHelp(Supplier<String> showHeaderSupplier, SortedMap<String, Supplier<String>> showHelps) {
        StringBuilder retBuff = new StringBuilder();
        retBuff.append(showHeaderSupplier.get());
        for (String mytag : showHelps.keySet()) {
            String tagHelp = (String)((Supplier)showHelps.get(mytag)).get();
            retBuff.append("     ").append(tagHelp).append("\n");
        }
        return retBuff.toString();
    }

    private String buildHelpHelp(ScriptRunnerContext ctx, String requestedTag, SortedMap<String, Supplier<String>> commandHelps, Collection<String> sqlplusTags) {
        Object retVal = "";
        if (requestedTag != null && requestedTag.length() > 0) {
            retVal = (String)retVal + MessageFormat.format(Messages.getString("Help.ObjectNotFound"), requestedTag);
        }
        retVal = (String)retVal + Messages.getString("LIST_OF_HELP_TOPICS");
        StringBuilder retBuff = new StringBuilder();
        if (ctx.getProperty("sqlplus.classic.mode") != null && Boolean.parseBoolean(ctx.getProperty("sqlplus.classic.mode").toString())) {
            int cols = 120;
            int maxlen = 0;
            for (String item : commandHelps.keySet()) {
                if (item.length() <= maxlen) continue;
                maxlen = item.length();
            }
            int noscols = cols % (maxlen + 1);
            Object output = "";
            Object line = "";
            int col = 0;
            for (String item : commandHelps.keySet()) {
                if (col >= noscols) {
                    output = (String)output + (String)line + "\n";
                    line = "";
                    col = 0;
                }
                String pad = new String(new char[maxlen - item.length()]).replace('\u0000', ' ');
                line = (String)line + item + pad;
                ++col;
            }
            if (((String)line).length() > 0) {
                output = (String)output + (String)line + "\n";
            }
            retVal = (String)retVal + (String)output;
        } else {
            for (String mytag : commandHelps.keySet()) {
                String name = mytag.replace("_", " ");
                if (sqlplusTags.contains(mytag)) {
                    name = this.highlightBold(name);
                }
                retBuff.append("    ").append(name).append("\n");
            }
            retVal = (String)retVal + this.printColumns(commandHelps.keySet(), ctx);
            if (ctx.isCommandLine()) {
                retVal = (String)retVal;
            }
        }
        return retVal;
    }

    private String buildHelpMessageHelp(String tag) {
        String help = HelpMessages.getString(tag);
        if (this.wasError(help)) {
            help = null;
        }
        return help;
    }

    private boolean wasError(String retval) {
        return retval == null || retval.startsWith("!") && retval.endsWith("!");
    }
}

