/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;

public class OerrCommand
extends AForAllStmtsCommand
implements IHelp {
    private static final String CMD = "oerr";
    private static final String OERRVERSION = "21.3";
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_OERR;

    public OerrCommand() {
        super(s_cmdStmtSubType);
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String loweredTrimmedSQL = cmd.getLoweredTrimmedSQL();
        if (loweredTrimmedSQL.startsWith(CMD)) {
            ctx.write("\n");
            if (cmd.getLoweredTrimmedNoWhitespaceSQL().equals("oerr-v")) {
                ctx.write(OERRVERSION);
            } else {
                try {
                    Oerr oerr = new Oerr();
                    String options = loweredTrimmedSQL.substring(CMD.length());
                    if (options.length() > 0) {
                        StringTokenizer st = new StringTokenizer(options);
                        if (st.countTokens() > 2) {
                            throw new OerrException(Messages.getString("OerrCommand.1"));
                        }
                        if (st.countTokens() == 1) {
                            ctx.write(oerr.oerr(options));
                        } else {
                            ctx.write(oerr.oerr(st.nextToken(), st.nextToken()));
                        }
                    } else {
                        ctx.write(this.getHelp());
                    }
                }
                catch (OerrException oe) {
                    ctx.write(oe.getLocalizedMessage());
                }
            }
            ctx.write("\n");
            return true;
        }
        return false;
    }

    @Override
    public String getCommand() {
        return CMD.toUpperCase();
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }
}

