/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class Prompt
extends CommandListener {
    static ArrayList<IPromptListener> listeners = new ArrayList();

    public Prompt() {
        Prompt.addListener(DefaultPromptListener.getInstance());
    }

    public static void addListener(IPromptListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        for (IPromptListener listener : listeners) {
            listener.consume(conn, ctx, cmd);
        }
    }

    protected static class DefaultPromptListener
    implements IPromptListener {
        static DefaultPromptListener _instance = null;

        protected DefaultPromptListener() {
        }

        public static IPromptListener getInstance() {
            if (_instance == null) {
                _instance = new DefaultPromptListener();
            }
            return _instance;
        }

        @Override
        public void consume(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
            String promptMessage = this.getPromptMessage(cmd, ctx);
            ctx.write(promptMessage);
        }

        protected String getPromptMessage(ISQLCommand cmd, ScriptRunnerContext ctx) {
            String[] s;
            String cmdTrim = cmd.getSql().trim();
            String localSql = cmdTrim.substring((s = cmdTrim.split("\\s+"))[0].length(), cmdTrim.length()).trim();
            if (localSql.startsWith("\"") && localSql.endsWith("\"")) {
                localSql = localSql.substring(1, localSql.length() - 1);
            }
            if (cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_OLDCOMMENT)) {
                String[] lines = cmd.getSql().split("\n");
                Object document = "";
                if (ctx.isEchoOn()) {
                    int noslines;
                    if (cmd.getProperty("NUMEMPTYLIENSABOVE") != null && Integer.parseInt(cmd.getProperty("NUMEMPTYLIENSABOVE").toString()) > 0 && (noslines = Integer.parseInt(cmd.getProperty("NUMEMPTYLIENSABOVE").toString())) > 0) {
                        for (int i = 0; i < noslines; ++i) {
                            document = (String)document + ctx.getPrompt() + "\n";
                        }
                    }
                    if (lines.length > 0) {
                        document = (String)document + ctx.getPrompt() + lines[0] + "\n";
                        for (int i = 1; i < lines.length; ++i) {
                            document = (String)document + "DOC>" + lines[i] + "\n";
                        }
                    }
                } else {
                    document = (String)document + "DOC>#\n";
                }
                return document;
            }
            return localSql + "\n";
        }
    }

    public static interface IPromptListener {
        public void consume(Connection var1, ScriptRunnerContext var2, ISQLCommand var3);
    }
}

