/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4_ABORT_SCRIPT)
public class SetAutoCommit
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_AUTOCOMMIT;
    private static final String SET = "(?i:set)";
    private static final String AUTOCOMMIT = "(?i:auto(?:|c|co|com|comm|commi|commit))";
    private static final String OBJECTNAME = "(?i:set)\\s+(?i:auto(?:|c|co|com|comm|commi|commit))\\s+(on|off|imm|immediate|\\d+(\\s+|$))";
    private static final String LINE_SEPARATOR = System.getProperty(Messages.getString("SetAutoCommit.1"));

    public SetAutoCommit() {
        super(s_cmdStmtSubType);
    }

    @Override
    public void doBeginWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.putProperty("script.runner.autocommit.errorFlag", Boolean.FALSE);
    }

    @Override
    public void doEndWatcher(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return;
        }
        try {
            Long commitSetting = (Long)ctx.getProperty("script.runner.autocommit.setting");
            if (commitSetting.equals(ScriptRunnerContext.AUTOCOMMITOFF) || commitSetting.equals(new Long(0L))) {
                return;
            }
            switch (cmd.getStmtSubType()) {
                case G_S_INSERT: 
                case G_S_UPDATE: 
                case G_S_DELETE: 
                case G_S_EXECUTE: 
                case G_S_BEGIN: {
                    Long commitValue;
                    if (ctx.getProperty("script.runner.autocommit.errorFlag") != null && ((Boolean)ctx.getProperty("script.runner.autocommit.errorFlag")).booleanValue()) break;
                    if (commitSetting.equals(ScriptRunnerContext.AUTOCOMMITON)) {
                        this.doCommit(ctx);
                        return;
                    }
                    Long l = commitValue = (Long)ctx.getProperty("script.runner.autocommit.counter");
                    Long l2 = commitValue = Long.valueOf(commitValue + 1L);
                    if (commitSetting.equals(commitValue)) {
                        ctx.putProperty("script.runner.autocommit.counter", new Long(0L));
                        this.doCommit(ctx);
                    } else {
                        ctx.putProperty("script.runner.autocommit.counter", commitValue);
                    }
                    return;
                }
                case G_S_SET_AUTOCOMMIT: 
                case G_S_COMMIT: 
                case G_S_ROLLBACK_PLUS: 
                case G_S_ROLLBACK_SQL: {
                    ctx.putProperty("script.runner.autocommit.counter", new Long(0L));
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit(ScriptRunnerContext ctx) {
        Connection lockedConn = ctx.getCurrentConnection();
        if (lockedConn == null) {
            ctx.write(ScriptRunnerDbArb.getString("NOT_CONNECTED") + LINE_SEPARATOR);
            return;
        }
        boolean amILocked = false;
        try {
            amILocked = LockManager.lock(lockedConn);
            if (amILocked) {
                ctx.getCurrentConnection().commit();
                if (ctx.getFeedback() != -2) {
                    ctx.write(Messages.getString("COMMIT_COMPLETE") + LINE_SEPARATOR);
                }
            }
        }
        catch (SQLException e) {
            ctx.write(Messages.getString("COMMIT_FAILED") + LINE_SEPARATOR);
            ctx.write(e.getLocalizedMessage() + LINE_SEPARATOR);
        }
        finally {
            if (amILocked) {
                try {
                    LockManager.unlock(lockedConn);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && ctx.getProperty("script.runner.sqlplus.nolog") != null && Boolean.valueOf(ctx.getProperty("script.runner.sqlplus.nolog").equals(Boolean.TRUE)).booleanValue()) {
            return false;
        }
        String[] extra = cmd.getSql().trim().split("\\s+");
        if (cmd.getSql().toLowerCase().matches(OBJECTNAME)) {
            return this.doAutoCommitCommand(ctx, cmd, extra);
        }
        if (extra.length == 3) {
            String x = extra[2];
            if (Character.isDigit(x.charAt(0))) {
                ctx.write(Messages.getString("SetAutoCommit.2"));
                return true;
            }
            try {
                int a = Integer.parseInt(extra[2]);
                if (a >= 0) {
                    if (a <= 2000000000) return true;
                }
                ctx.write(String.valueOf(Messages.getString("SetAutoCommit.3")));
                return true;
            }
            catch (NumberFormatException e) {
                ctx.write(MessageFormat.format(Messages.getString("SetAutoCommit.4"), "autocommit", extra[2]));
                ctx.write(Messages.getString("SETAUTOUSAGE") + LINE_SEPARATOR);
                return true;
            }
        }
        if (extra.length <= 3) {
            if (extra.length >= 3) return true;
            ctx.write(Messages.getString("SetAutoCommit.13"));
            ctx.write(Messages.getString("SetAutoCommit.14"));
            return true;
        }
        try {
            int a = Integer.parseInt(extra[2]);
            String[] sArr = cmd.getSql().split(" ");
            Object firstStrs = "";
            int i = 0;
            while (true) {
                if (i >= 3) {
                    cmd.setSql(((String)firstStrs).trim());
                    cmd.setModifiedSQL(((String)firstStrs).trim());
                    this.doAutoCommitCommand(ctx, cmd, extra);
                    return true;
                }
                firstStrs = (String)firstStrs + sArr[i] + " ";
                ++i;
            }
        }
        catch (NumberFormatException e) {
            ctx.write(MessageFormat.format(Messages.getString("SetAutoCommit.10"), "autocommit", extra[2]));
            ctx.write(Messages.getString("SETAUTOUSAGE") + LINE_SEPARATOR);
            return true;
        }
    }

    private boolean doAutoCommitCommand(ScriptRunnerContext ctx, ISQLCommand cmd, String[] extra) {
        boolean displayMsg = false;
        String propertyString = (String)cmd.getProperty("prop_file_string");
        if (propertyString != null) {
            try {
                if (ctx.getCurrentConnection().getAutoCommit()) {
                    ctx.write(Messages.getString("SCRIPT_AUTOCOMMIT_FORCED_OFF_CONNECTION_AUTOCOMMIT_ON"));
                    ctx.putProperty("script.runner.autocommit.setting", ScriptRunnerContext.AUTOCOMMITOFF);
                    return true;
                }
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            propertyString = propertyString.toLowerCase().trim();
            this.setProperties(cmd, ctx, (Long)ctx.getProperty("script.runner.autocommit.setting") == -1L ? "IMMEDIATE" : "OFF", "autocommit", "script.runner.autocommit.setting");
            if (propertyString.toLowerCase().equals("imm") || propertyString.toLowerCase().equals("immediate") || propertyString.startsWith("on")) {
                this.writeShowMode(cmd, ctx, "IMMEDIATE");
                ctx.putProperty("script.runner.autocommit.setting", ScriptRunnerContext.AUTOCOMMITON);
            } else if (propertyString.toLowerCase().equals("off")) {
                this.writeShowMode(cmd, ctx, "OFF");
                ctx.putProperty("script.runner.autocommit.setting", ScriptRunnerContext.AUTOCOMMITOFF);
            } else {
                try {
                    Long l = Long.parseLong(propertyString);
                    if (l > -1L && l < 2000000001L) {
                        ctx.putProperty("script.runner.autocommit.setting", l);
                        ctx.putProperty("script.runner.autocommit.counter", 0L);
                    } else {
                        ctx.write(MessageFormat.format(Messages.getString("AUTO_COMMIT_RANGE"), String.valueOf(l)) + LINE_SEPARATOR);
                    }
                    if (extra.length > 3) {
                        if (extra[3].length() > 10) {
                            String fail = extra[3].substring(0, 10) + "...";
                            ctx.write(MessageFormat.format(Messages.getString("SETUNKNOWNOPTION_BEGINNING"), fail));
                        } else {
                            ctx.write(MessageFormat.format(Messages.getString("SETUNKNOWNOPTION"), extra[3]));
                        }
                        displayMsg = true;
                    }
                }
                catch (NumberFormatException e) {
                    if (Pattern.compile("^[A-Za-z]").matcher(propertyString).find()) {
                        if (!displayMsg) {
                            ctx.write(MessageFormat.format(Messages.getString(Messages.getString("SetAutoCommit.21")) + LINE_SEPARATOR, propertyString));
                        }
                        ctx.write(Messages.getString("SETAUTOUSAGE") + LINE_SEPARATOR);
                    } else {
                        ctx.write(Messages.getString("AUTO_COMMIT_NUMBER_FORMAT_EXCEPTION") + LINE_SEPARATOR);
                    }
                    return false;
                }
            }
        }
        return true;
    }
}

